/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningNotOnTestaccount;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.TestUtil;
import net.snowflake.client.category.TestCategoryConnection;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeBasicDataSource;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeDriver;
import org.apache.commons.codec.binary.Base64;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={TestCategoryConnection.class})
public class ConnectionIT
extends BaseJDBCTest {
    public static final int INVALID_CONNECTION_INFO_CODE = 390100;
    private static final int SESSION_CREATION_OBJECT_DOES_NOT_EXIST_NOT_AUTHORIZED = 390201;
    private static final int ROLE_IN_CONNECT_STRING_DOES_NOT_EXIST = 390189;
    public static final int BAD_REQUEST_GS_CODE = 390400;
    public static final int WAIT_FOR_TELEMETRY_REPORT_IN_MILLISECS = 5000;
    String errorMessage = null;
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testSimpleConnection() throws SQLException {
        Connection con = ConnectionIT.getConnection();
        Statement statement = con.createStatement();
        ResultSet resultSet = statement.executeQuery("show parameters");
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertFalse((boolean)con.isClosed());
        statement.close();
        con.close();
        Assert.assertTrue((boolean)con.isClosed());
        con.close();
    }

    @Test
    @Ignore
    public void test300ConnectionsWithSingleClientInstance() throws SQLException {
        int size = 300;
        Connection con = ConnectionIT.getConnection();
        String database = con.getCatalog();
        String schema = con.getSchema();
        con.createStatement().execute("create or replace table bigTable(rowNum number,rando number) as (select seq4(),uniform(1, 10, random()) from table(generator(rowcount=>10000000)) v)");
        con.createStatement().execute("create or replace table conTable(colA number)");
        ExecutorService taskRunner = Executors.newFixedThreadPool(size);
        for (int i = 0; i < size; ++i) {
            ConcurrentConnections newTask = new ConcurrentConnections();
            taskRunner.submit(newTask);
        }
        Assert.assertEquals(null, (Object)this.errorMessage);
        taskRunner.shutdownNow();
    }

    @Test
    public void testLoginTimeoutViaDataSource() throws SQLException {
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setUrl("jdbc:snowflake://fakeaccount.snowflakecomputing.com");
        ds.setUser("fakeUser");
        ds.setPassword("fakePassword");
        ds.setAccount("fakeAccount");
        ds.setLoginTimeout(10);
        long startLoginTime = System.currentTimeMillis();
        try {
            ds.getConnection();
            Assert.fail();
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
        }
        long endLoginTime = System.currentTimeMillis();
        Assert.assertTrue((endLoginTime - startLoginTime < 30000L ? 1 : 0) != 0);
    }

    @Test
    public void testProdConnectivity() throws SQLException {
        String[] deploymentUrls = new String[]{"jdbc:snowflake://sfcsupport.snowflakecomputing.com", "jdbc:snowflake://sfcsupportva.us-east-1.snowflakecomputing.com", "jdbc:snowflake://sfcsupporteu.eu-central-1.snowflakecomputing.com"};
        Properties properties = new Properties();
        properties.put("user", "fakeuser");
        properties.put("password", "fakepwd");
        properties.put("account", "fakeaccount");
        for (String url : deploymentUrls) {
            try {
                DriverManager.getConnection(url, properties);
                Assert.fail();
            }
            catch (SQLException e) {
                MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)390100));
            }
        }
    }

    @Test
    public void testSetCatalogSchema() throws Throwable {
        try (Connection connection = ConnectionIT.getConnection();){
            String db = connection.getCatalog();
            String schema = connection.getSchema();
            connection.setCatalog(db);
            connection.setSchema("PUBLIC");
            ResultSet rst = connection.createStatement().executeQuery("select current_schema()");
            Assert.assertTrue((boolean)rst.next());
            Assert.assertEquals((Object)"PUBLIC", (Object)rst.getString(1));
            Assert.assertEquals((Object)db, (Object)connection.getCatalog());
            Assert.assertEquals((Object)"PUBLIC", (Object)connection.getSchema());
            connection.setSchema(schema);
            rst = connection.createStatement().executeQuery("select current_schema()");
            Assert.assertTrue((boolean)rst.next());
            Assert.assertEquals((Object)schema, (Object)rst.getString(1));
            rst.close();
        }
    }

    @Test
    public void testDataCompletenessInLowMemory() throws Exception {
        try (Connection connection = ConnectionIT.getConnection();){
            for (int i = 0; i < 6; ++i) {
                int resultSize = 1000000 + i;
                Statement statement = connection.createStatement();
                statement.execute("ALTER SESSION SET CLIENT_MEMORY_LIMIT=10");
                ResultSet resultSet = statement.executeQuery("select randstr(80, random()) from table(generator(rowcount => " + resultSize + "))");
                int size = 0;
                while (resultSet.next()) {
                    ++size;
                }
                System.out.println("Total records: " + size);
                assert (size == resultSize);
            }
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testConnectionGetAndSetDBAndSchema() throws SQLException {
        Connection con = ConnectionIT.getConnection();
        String database = TestUtil.systemGetEnv("SNOWFLAKE_TEST_DATABASE").toUpperCase();
        String schema = TestUtil.systemGetEnv("SNOWFLAKE_TEST_SCHEMA").toUpperCase();
        Assert.assertEquals((Object)database, (Object)con.getCatalog());
        Assert.assertEquals((Object)schema, (Object)con.getSchema());
        String SECOND_DATABASE = "SECOND_DATABASE";
        String SECOND_SCHEMA = "SECOND_SCHEMA";
        Statement statement = con.createStatement();
        statement.execute(String.format("create or replace database %s", "SECOND_DATABASE"));
        statement.execute(String.format("create or replace schema %s", "SECOND_SCHEMA"));
        statement.execute(String.format("use database %s", database));
        con.setCatalog("SECOND_DATABASE");
        Assert.assertEquals((Object)"SECOND_DATABASE", (Object)con.getCatalog());
        Assert.assertEquals((Object)"PUBLIC", (Object)con.getSchema());
        con.setSchema("SECOND_SCHEMA");
        Assert.assertEquals((Object)"SECOND_SCHEMA", (Object)con.getSchema());
        statement.execute(String.format("use database %s", database));
        statement.execute(String.format("use schema %s", schema));
        Assert.assertEquals((Object)database, (Object)con.getCatalog());
        Assert.assertEquals((Object)schema, (Object)con.getSchema());
        statement.execute(String.format("drop database if exists %s", "SECOND_DATABASE"));
        con.close();
    }

    @Test
    public void testConnectionClientInfo() throws SQLException {
        try (Connection con = ConnectionIT.getConnection();){
            Properties property = con.getClientInfo();
            Assert.assertEquals((long)0L, (long)property.size());
            Properties clientInfo = new Properties();
            clientInfo.setProperty("name", "Peter");
            clientInfo.setProperty("description", "SNOWFLAKE JDBC");
            try {
                con.setClientInfo(clientInfo);
                Assert.fail((String)"setClientInfo should fail for any parameter.");
            }
            catch (SQLClientInfoException e) {
                Assert.assertEquals((Object)"22023", (Object)e.getSQLState());
                Assert.assertEquals((long)200047L, (long)e.getErrorCode());
                Assert.assertEquals((long)2L, (long)e.getFailedProperties().size());
            }
            try {
                con.setClientInfo("ApplicationName", "valueA");
                Assert.fail((String)"setClientInfo should fail for any parameter.");
            }
            catch (SQLClientInfoException e) {
                Assert.assertEquals((Object)"22023", (Object)e.getSQLState());
                Assert.assertEquals((long)200047L, (long)e.getErrorCode());
                Assert.assertEquals((long)1L, (long)e.getFailedProperties().size());
            }
        }
    }

    @Test
    public void testNetworkTimeout() throws SQLException {
        Connection con = ConnectionIT.getConnection();
        int millis = con.getNetworkTimeout();
        Assert.assertEquals((long)0L, (long)millis);
        con.setNetworkTimeout(null, 200);
        Assert.assertEquals((long)200L, (long)con.getNetworkTimeout());
        con.close();
    }

    @Test
    public void testAbort() throws SQLException {
        Connection con = ConnectionIT.getConnection();
        Assert.assertTrue((!con.isClosed() ? 1 : 0) != 0);
        con.abort(null);
        Assert.assertTrue((boolean)con.isClosed());
    }

    @Test
    public void testSetQueryTimeoutInConnectionStr() throws SQLException {
        Properties properties = new Properties();
        properties.put("queryTimeout", "5");
        Connection connection = ConnectionIT.getConnection(properties);
        Statement statement = connection.createStatement();
        try {
            statement.executeQuery("select count(*) from table(generator(timeLimit => 1000000))");
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)true);
            Assert.assertEquals((Object)"57014", (Object)e.getSQLState());
            Assert.assertEquals((Object)"SQL execution canceled", (Object)e.getMessage());
        }
        statement.close();
        connection.close();
    }

    @Test
    public void testConnectViaDataSource() throws SQLException {
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        Map<String, String> params = ConnectionIT.getConnectionParameters();
        String account = params.get("account");
        String host = params.get("host");
        String port = params.get("port");
        String user = params.get("user");
        String password = params.get("password");
        String ssl = params.get("ssl");
        String connectStr = String.format("jdbc:snowflake://%s:%s", host, port);
        ds.setUrl(connectStr);
        ds.setAccount(account);
        ds.setSsl("on".equals(ssl));
        Connection connection = ds.getConnection(user, password);
        ResultSet resultSet = connection.createStatement().executeQuery("select 1");
        resultSet.next();
        MatcherAssert.assertThat((String)"select 1", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)1));
        connection.close();
        ds = new SnowflakeBasicDataSource();
        ds.setServerName(params.get("host"));
        ds.setSsl("on".equals(ssl));
        ds.setAccount(account);
        ds.setPortNumber(Integer.parseInt(port));
        connection = ds.getConnection(params.get("user"), params.get("password"));
        resultSet = connection.createStatement().executeQuery("select 1");
        resultSet.next();
        MatcherAssert.assertThat((String)"select 1", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)1));
        connection.close();
    }

    @Test
    @Ignore
    public void testDataSourceOktaSerialization() throws Exception {
        Map<String, String> params = ConnectionIT.getConnectionParameters();
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setServerName(params.get("host"));
        ds.setSsl("on".equals(params.get("ssl")));
        ds.setAccount(params.get("account"));
        ds.setPortNumber(Integer.parseInt(params.get("port")));
        ds.setUser(params.get("ssoUser"));
        ds.setPassword(params.get("ssoPassword"));
        ds.setAuthenticator("https://snowflakecomputing.okta.com/");
        Connection con = ds.getConnection();
        ResultSet resultSet = con.createStatement().executeQuery("select 1");
        resultSet.next();
        MatcherAssert.assertThat((String)"select 1", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)1));
        File serializedFile = this.tmpFolder.newFile("serializedStuff.ser");
        FileOutputStream outputFile = new FileOutputStream(serializedFile);
        ObjectOutputStream out = new ObjectOutputStream(outputFile);
        out.writeObject(ds);
        out.close();
        outputFile.close();
        FileInputStream inputFile = new FileInputStream(serializedFile);
        ObjectInputStream in = new ObjectInputStream(inputFile);
        SnowflakeBasicDataSource ds2 = (SnowflakeBasicDataSource)in.readObject();
        in.close();
        inputFile.close();
        con = ds2.getConnection();
        resultSet = con.createStatement().executeQuery("select 1");
        resultSet.next();
        MatcherAssert.assertThat((String)"select 1", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)1));
        con.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testConnectUsingKeyPair() throws Exception {
        Map<String, String> parameters = ConnectionIT.getConnectionParameters();
        String testUser = parameters.get("user");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        keyPairGenerator.initialize(2048, random);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        Connection connection = ConnectionIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("use role accountadmin");
        String encodePublicKey = Base64.encodeBase64String((byte[])publicKey.getEncoded());
        statement.execute(String.format("alter user %s set rsa_public_key='%s'", testUser, encodePublicKey));
        connection.close();
        String uri = parameters.get("uri");
        Properties properties = new Properties();
        properties.put("account", parameters.get("account"));
        properties.put("user", testUser);
        properties.put("ssl", parameters.get("ssl"));
        properties.put("port", parameters.get("port"));
        properties.put("privateKey", privateKey);
        connection = DriverManager.getConnection(uri, properties);
        connection.close();
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setUrl(uri);
        ds.setAccount(parameters.get("account"));
        ds.setUser(parameters.get("user"));
        ds.setSsl("on".equals(parameters.get("ssl")));
        ds.setPortNumber(Integer.valueOf(parameters.get("port")).intValue());
        ds.setPrivateKey(privateKey);
        Connection con = ds.getConnection();
        con.close();
        keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey2 = keyPair.getPublic();
        PrivateKey privateKey2 = keyPair.getPrivate();
        properties.put("privateKey", privateKey2);
        try {
            DriverManager.getConnection(uri, properties);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)390144L, (long)e.getErrorCode());
        }
        connection = ConnectionIT.getConnection();
        statement = connection.createStatement();
        statement.execute("use role accountadmin");
        String encodePublicKey2 = Base64.encodeBase64String((byte[])publicKey2.getEncoded());
        statement.execute(String.format("alter user %s set rsa_public_key_2='%s'", testUser, encodePublicKey2));
        connection.close();
        connection = DriverManager.getConnection(uri, properties);
        statement = connection.createStatement();
        statement.execute("use role accountadmin");
        statement.execute(String.format("alter user %s unset rsa_public_key", testUser));
        statement.execute(String.format("alter user %s unset rsa_public_key_2", testUser));
        connection.close();
    }

    @Test
    public void testBadPrivateKey() throws Exception {
        Map<String, String> parameters = ConnectionIT.getConnectionParameters();
        String testUser = parameters.get("user");
        String uri = parameters.get("uri");
        Properties properties = new Properties();
        properties.put("account", parameters.get("account"));
        properties.put("user", testUser);
        properties.put("ssl", parameters.get("ssl"));
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA");
        PrivateKey dsaPrivateKey = keyPairGenerator.generateKeyPair().getPrivate();
        try {
            properties.put("privateKey", "bad string");
            DriverManager.getConnection(uri, properties);
            Assert.fail();
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.INVALID_PARAMETER_TYPE.getMessageCode()));
        }
        try {
            properties.put("privateKey", dsaPrivateKey);
            DriverManager.getConnection(uri, properties);
            Assert.fail();
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.INVALID_OR_UNSUPPORTED_PRIVATE_KEY.getMessageCode()));
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDifferentKeyLength() throws Exception {
        Map<String, String> parameters = ConnectionIT.getConnectionParameters();
        String testUser = parameters.get("user");
        Integer[] testCases = new Integer[]{2048, 4096, 8192};
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        for (Integer keyLength : testCases) {
            keyPairGenerator.initialize(keyLength, random);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            Connection connection = ConnectionIT.getConnection();
            Statement statement = connection.createStatement();
            statement.execute("use role accountadmin");
            String encodePublicKey = Base64.encodeBase64String((byte[])publicKey.getEncoded());
            statement.execute(String.format("alter user %s set rsa_public_key='%s'", testUser, encodePublicKey));
            connection.close();
            String uri = parameters.get("uri");
            Properties properties = new Properties();
            properties.put("account", parameters.get("account"));
            properties.put("user", testUser);
            properties.put("ssl", parameters.get("ssl"));
            properties.put("port", parameters.get("port"));
            properties.put("role", "accountadmin");
            properties.put("privateKey", privateKey);
            connection = DriverManager.getConnection(uri, properties);
            connection.createStatement().execute(String.format("alter user %s unset rsa_public_key", testUser));
            connection.close();
        }
    }

    @Test
    public void testInsecureMode() throws SQLException {
        String deploymentUrl = "jdbc:snowflake://sfcsupport.snowflakecomputing.com";
        Properties properties = new Properties();
        properties.put("user", "fakeuser");
        properties.put("password", "fakepwd");
        properties.put("account", "fakeaccount");
        properties.put("insecureMode", (Object)true);
        try {
            DriverManager.getConnection(deploymentUrl, properties);
            Assert.fail();
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)390100));
        }
        deploymentUrl = "jdbc:snowflake://sfcsupport.snowflakecomputing.com?insecureMode=true";
        properties = new Properties();
        properties.put("user", "fakeuser");
        properties.put("password", "fakepwd");
        properties.put("account", "fakeaccount");
        try {
            DriverManager.getConnection(deploymentUrl, properties);
            Assert.fail();
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)390100));
        }
    }

    @Test
    public void testClientMemoryParameters() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("CLIENT_PREFETCH_THREADS", "6");
        paramProperties.put("CLIENT_RESULT_CHUNK_SIZE", (Object)48);
        paramProperties.put("CLIENT_MEMORY_LIMIT", (Object)1000);
        Connection connection = ConnectionIT.getConnection(paramProperties);
        Enumeration<?> enums = paramProperties.propertyNames();
        while (enums.hasMoreElements()) {
            String key = (String)enums.nextElement();
            ResultSet rs = connection.createStatement().executeQuery(String.format("show parameters like '%s'", key));
            rs.next();
            String value = rs.getString("value");
            MatcherAssert.assertThat((String)key, (Object)value, (Matcher)CoreMatchers.equalTo((Object)paramProperties.get(key).toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientMemoryJvmParameters() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("CLIENT_PREFETCH_THREADS", "6");
        paramProperties.put("CLIENT_RESULT_CHUNK_SIZE", (Object)48);
        paramProperties.put("CLIENT_MEMORY_LIMIT", (Object)1000L);
        System.setProperty("net.snowflake.jdbc.clientPrefetchThreads", paramProperties.get("CLIENT_PREFETCH_THREADS").toString());
        System.setProperty("net.snowflake.jdbc.clientResultChunkSize", paramProperties.get("CLIENT_RESULT_CHUNK_SIZE").toString());
        System.setProperty("net.snowflake.jdbc.clientMemoryLimit", paramProperties.get("CLIENT_MEMORY_LIMIT").toString());
        try {
            Connection connection = ConnectionIT.getConnection();
            Enumeration<?> enums = paramProperties.propertyNames();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                ResultSet rs = connection.createStatement().executeQuery(String.format("show parameters like '%s'", key));
                rs.next();
                String value = rs.getString("value");
                MatcherAssert.assertThat((String)key, (Object)value, (Matcher)CoreMatchers.equalTo((Object)paramProperties.get(key).toString()));
            }
        }
        finally {
            System.clearProperty("net.snowflake.jdbc.clientPrefetchThreads");
            System.clearProperty("net.snowflake.jdbc.clientResultChunkSize");
            System.clearProperty("net.snowflake.jdbc.clientMemoryLimit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientMixedMemoryJvmParameters() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("CLIENT_PREFETCH_THREADS", "6");
        paramProperties.put("CLIENT_RESULT_CHUNK_SIZE", (Object)48);
        paramProperties.put("CLIENT_MEMORY_LIMIT", (Object)1000L);
        System.setProperty("net.snowflake.jdbc.clientPrefetchThreads", paramProperties.get("CLIENT_PREFETCH_THREADS").toString());
        System.setProperty("net.snowflake.jdbc.clientResultChunkSize", paramProperties.get("CLIENT_RESULT_CHUNK_SIZE").toString());
        System.setProperty("net.snowflake.jdbc.clientMemoryLimit", paramProperties.get("CLIENT_MEMORY_LIMIT").toString());
        paramProperties.put("CLIENT_PREFETCH_THREADS", "8");
        paramProperties.put("CLIENT_RESULT_CHUNK_SIZE", (Object)64);
        paramProperties.put("CLIENT_MEMORY_LIMIT", (Object)2000L);
        try {
            Connection connection = ConnectionIT.getConnection(paramProperties);
            Enumeration<?> enums = paramProperties.propertyNames();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                ResultSet rs = connection.createStatement().executeQuery(String.format("show parameters like '%s'", key));
                rs.next();
                String value = rs.getString("value");
                MatcherAssert.assertThat((String)key, (Object)value, (Matcher)CoreMatchers.equalTo((Object)paramProperties.get(key).toString()));
            }
        }
        finally {
            System.clearProperty("net.snowflake.jdbc.clientPrefetchThreads");
            System.clearProperty("net.snowflake.jdbc.clientResultChunkSize");
            System.clearProperty("net.snowflake.jdbc.clientMemoryLimit");
        }
    }

    @Test
    public void testHeartbeatFrequencyTooLarge() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY", (Object)4000);
        Connection connection = ConnectionIT.getConnection(paramProperties);
        connection.getClientInfo("CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY");
        Enumeration<?> enums = paramProperties.propertyNames();
        while (enums.hasMoreElements()) {
            String key = (String)enums.nextElement();
            ResultSet rs = connection.createStatement().executeQuery(String.format("show parameters like '%s'", key));
            rs.next();
            String value = rs.getString("value");
            MatcherAssert.assertThat((String)key, (Object)value, (Matcher)CoreMatchers.equalTo((Object)"3600"));
        }
        SFSession session = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
        Assert.assertEquals((long)3600L, (long)session.getHeartbeatFrequency());
    }

    @Test
    public void testNativeSQL() throws Throwable {
        try (Connection connection = ConnectionIT.getConnection();){
            Assert.assertEquals((Object)"select 1", (Object)connection.nativeSQL("select 1"));
        }
    }

    @Test
    public void testGetTypeMap() throws Throwable {
        try (Connection connection = ConnectionIT.getConnection();){
            Assert.assertEquals(Collections.emptyMap(), connection.getTypeMap());
        }
    }

    @Test
    public void testHolderbility() throws Throwable {
        try (Connection connection = ConnectionIT.getConnection();){
            try {
                connection.setHoldability(0);
            }
            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                // empty catch block
            }
            Assert.assertEquals((long)2L, (long)connection.getHoldability());
        }
    }

    @Test
    public void testIsValid() throws Throwable {
        try (Connection connection = ConnectionIT.getConnection();){
            Assert.assertTrue((boolean)connection.isValid(10));
            try {
                Assert.assertTrue((boolean)connection.isValid(-10));
                Assert.fail((String)"must fail");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testUnwrapper() throws Throwable {
        try (Connection connection = ConnectionIT.getConnection();){
            boolean canUnwrap = connection.isWrapperFor(SnowflakeConnectionV1.class);
            Assert.assertTrue((boolean)canUnwrap);
            if (canUnwrap) {
                SnowflakeConnectionV1 sfconnection = connection.unwrap(SnowflakeConnectionV1.class);
                sfconnection.createStatement();
            } else {
                Assert.fail((String)"should be able to unwrap");
            }
            try {
                connection.unwrap(SnowflakeDriver.class);
                Assert.fail((String)"should fail to cast");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testStatementsAndResultSetsClosedByConnection() throws SQLException {
        Connection connection = ConnectionIT.getConnection();
        Statement statement1 = connection.createStatement();
        Statement statement2 = connection.createStatement();
        ResultSet rs1 = statement2.executeQuery("select 2;");
        ResultSet rs2 = statement2.executeQuery("select 2;");
        ResultSet rs3 = statement2.executeQuery("select 2;");
        PreparedStatement statement3 = connection.prepareStatement("select 2;");
        connection.close();
        Assert.assertTrue((boolean)statement1.isClosed());
        Assert.assertTrue((boolean)statement2.isClosed());
        Assert.assertTrue((boolean)statement3.isClosed());
        Assert.assertTrue((boolean)rs1.isClosed());
        Assert.assertTrue((boolean)rs2.isClosed());
        Assert.assertTrue((boolean)rs3.isClosed());
    }

    @Test
    public void testResultSetsClosedByStatement() throws SQLException {
        Connection connection = ConnectionIT.getConnection();
        Statement statement2 = connection.createStatement();
        ResultSet rs1 = statement2.executeQuery("select 2;");
        ResultSet rs2 = statement2.executeQuery("select 2;");
        ResultSet rs3 = statement2.executeQuery("select 2;");
        PreparedStatement statement3 = connection.prepareStatement("select 2;");
        ResultSet rs4 = statement3.executeQuery();
        Assert.assertFalse((boolean)rs1.isClosed());
        Assert.assertFalse((boolean)rs2.isClosed());
        Assert.assertFalse((boolean)rs3.isClosed());
        Assert.assertFalse((boolean)rs4.isClosed());
        statement2.close();
        statement3.close();
        Assert.assertTrue((boolean)rs1.isClosed());
        Assert.assertTrue((boolean)rs2.isClosed());
        Assert.assertTrue((boolean)rs3.isClosed());
        Assert.assertTrue((boolean)rs4.isClosed());
        connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningNotOnTestaccount.class)
    public void testOKTAConnection() throws Throwable {
        Map<String, String> params = ConnectionIT.getConnectionParameters();
        Properties properties = new Properties();
        properties.put("user", params.get("ssoUser"));
        properties.put("password", params.get("ssoPassword"));
        properties.put("ssl", params.get("ssl"));
        properties.put("authenticator", "https://snowflakecomputing.okta.com/");
        DriverManager.getConnection(String.format("jdbc:snowflake://%s.reg.snowflakecomputing.com:%s/", params.get("account"), params.get("port")), properties);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningNotOnTestaccount.class)
    public void testOKTAConnectionWithOktauserParam() throws Throwable {
        Map<String, String> params = ConnectionIT.getConnectionParameters();
        Properties properties = new Properties();
        properties.put("user", "test");
        properties.put("password", params.get("ssoPassword"));
        properties.put("ssl", params.get("ssl"));
        properties.put("authenticator", String.format("https://snowflakecomputing.okta.com;oktausername=%s;", params.get("ssoUser")));
        DriverManager.getConnection(String.format("jdbc:snowflake://%s.reg.snowflakecomputing.com:%s/", params.get("account"), params.get("port")), properties);
    }

    @Test
    public void testValidateDefaultParameters() throws Throwable {
        Map<String, String> params = ConnectionIT.getConnectionParameters();
        Properties props = this.setCommonConnectionParameters(true);
        props.put("db", "NOT_EXISTS");
        try {
            DriverManager.getConnection(params.get("uri"), props);
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            Assert.assertEquals((String)"error code", (long)ex.getErrorCode(), (long)390201L);
        }
        props = this.setCommonConnectionParameters(true);
        props.put("schema", "NOT_EXISTS");
        try {
            DriverManager.getConnection(params.get("uri"), props);
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            Assert.assertEquals((String)"error code", (long)ex.getErrorCode(), (long)390201L);
        }
        props = this.setCommonConnectionParameters(true);
        props.put("warehouse", "NOT_EXISTS");
        try {
            DriverManager.getConnection(params.get("uri"), props);
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            Assert.assertEquals((String)"error code", (long)ex.getErrorCode(), (long)390201L);
        }
        props = this.setCommonConnectionParameters(true);
        props.put("role", "NOT_EXISTS");
        try {
            DriverManager.getConnection(params.get("uri"), props);
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            Assert.assertEquals((String)"error code", (long)ex.getErrorCode(), (long)390189L);
        }
    }

    @Test
    public void testNoValidateDefaultParameters() throws Throwable {
        Map<String, String> params = ConnectionIT.getConnectionParameters();
        Properties props = this.setCommonConnectionParameters(false);
        props.put("db", "NOT_EXISTS");
        DriverManager.getConnection(params.get("uri"), props);
        props = this.setCommonConnectionParameters(false);
        props.put("schema", "NOT_EXISTS");
        DriverManager.getConnection(params.get("uri"), props);
        props = this.setCommonConnectionParameters(false);
        props.put("warehouse", "NOT_EXISTS");
        DriverManager.getConnection(params.get("uri"), props);
        props = this.setCommonConnectionParameters(false);
        props.put("role", "NOT_EXISTS");
        try {
            DriverManager.getConnection(params.get("uri"), props);
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            Assert.assertEquals((String)"error code", (long)ex.getErrorCode(), (long)390189L);
        }
    }

    @Ignore
    @Test
    public void testOrgAccountUrl() throws SQLException {
        Properties props = new Properties();
        props.put("user", "admin");
        props.put("password", "Password1");
        props.put("role", "accountadmin");
        props.put("timezone", "UTC");
        Connection con = DriverManager.getConnection("jdbc:snowflake://amoghorgurl-keypairauth_test_alias.testdns.snowflakecomputing.com", props);
        con.createStatement().execute("select 1");
        con.close();
    }

    @Ignore
    @Test
    public void testOrgAccountUrlWithKeyPair() throws SQLException, NoSuchAlgorithmException {
        String uri = "jdbc:snowflake://amoghorgurl-keypairauth_test_alias.testdns.snowflakecomputing.com";
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        keyPairGenerator.initialize(2048, random);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        Properties props = new Properties();
        props.put("user", "admin");
        props.put("password", "Password1");
        props.put("role", "accountadmin");
        props.put("timezone", "UTC");
        Connection connection = DriverManager.getConnection(uri, props);
        Statement statement = connection.createStatement();
        String encodePublicKey = Base64.encodeBase64String((byte[])publicKey.getEncoded());
        statement.execute(String.format("alter user %s set rsa_public_key='%s'", "admin", encodePublicKey));
        connection.close();
        props.remove("password");
        props.put("privateKey", privateKey);
        connection = DriverManager.getConnection(uri, props);
        connection.close();
    }

    private Properties kvMap2Properties(Map<String, String> params, boolean validateDefaultParameters) {
        Properties props = new Properties();
        props.put("validateDefaultParameters", (Object)validateDefaultParameters);
        props.put("account", params.get("account"));
        props.put("ssl", params.get("ssl"));
        props.put("role", params.get("role"));
        props.put("user", params.get("user"));
        props.put("password", params.get("password"));
        props.put("db", params.get("database"));
        props.put("schema", params.get("schema"));
        props.put("warehouse", params.get("warehouse"));
        return props;
    }

    private Properties setCommonConnectionParameters(boolean validateDefaultParameters) {
        Map<String, String> params = ConnectionIT.getConnectionParameters();
        return this.kvMap2Properties(params, validateDefaultParameters);
    }

    @Test
    public void testFailOverOrgAccount() throws SQLException {
        Assume.assumeTrue((boolean)RunningOnGithubAction.isRunningOnGithubAction());
        Map<String, String> kvParams = ConnectionIT.getConnectionParameters(null, "ORG");
        Properties connProps = this.kvMap2Properties(kvParams, false);
        String uri = kvParams.get("uri");
        Connection con = DriverManager.getConnection(uri, connProps);
        con.createStatement().execute("select 1");
        con.close();
    }

    private class ConcurrentConnections
    implements Runnable {
        Connection con = null;

        ConcurrentConnections() {
        }

        @Override
        public void run() {
            try {
                this.con = AbstractDriverIT.getConnection();
                this.con.createStatement().executeQuery("select * from bigTable");
                this.con.close();
            }
            catch (SQLException ex) {
                try {
                    this.con.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                ex.printStackTrace();
            }
        }
    }
}

