/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryConnection;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.QueryStatus;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeBasicDataSource;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakePreparedStatement;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeStatement;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.common.core.ClientAuthnDTO;
import net.snowflake.common.core.ClientAuthnParameter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.AnyOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={TestCategoryConnection.class})
public class ConnectionLatestIT
extends BaseJDBCTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private boolean defaultState;

    @Before
    public void setUp() {
        TelemetryService service = TelemetryService.getInstance();
        service.updateContextForIT(ConnectionLatestIT.getConnectionParameters());
        this.defaultState = service.isEnabled();
        service.setNumOfRetryToTriggerTelemetry(3);
        TelemetryService.enable();
    }

    @After
    public void tearDown() throws InterruptedException {
        TelemetryService service = TelemetryService.getInstance();
        TimeUnit.SECONDS.sleep(5L);
        if (this.defaultState) {
            TelemetryService.enable();
        } else {
            TelemetryService.disable();
        }
        service.resetNumOfRetryToTriggerTelemetry();
    }

    @Test
    public void testDisableQueryContextCache() throws SQLException {
        Properties props = new Properties();
        props.put("disableQueryContextCache", "true");
        Connection con = ConnectionLatestIT.getConnection(props);
        Statement statement = con.createStatement();
        statement.execute("select 1");
        SFSession session = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
        Assert.assertNull((Object)session.getQueryContextDTO());
        con.close();
    }

    @Test
    public void testHeartbeatFrequencyValidValue() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY", (Object)1800);
        Connection connection = ConnectionLatestIT.getConnection(paramProperties);
        Enumeration<?> enums = paramProperties.propertyNames();
        while (enums.hasMoreElements()) {
            String key = (String)enums.nextElement();
            ResultSet rs = connection.createStatement().executeQuery(String.format("show parameters like '%s'", key));
            rs.next();
            String value = rs.getString("value");
            MatcherAssert.assertThat((String)key, (Object)value, (Matcher)CoreMatchers.equalTo((Object)paramProperties.get(key).toString()));
        }
        SFSession session = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
        Assert.assertEquals((long)1800L, (long)session.getHeartbeatFrequency());
    }

    @Test
    public void testHeartbeatFrequencyTooSmall() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY", (Object)2);
        Connection connection = ConnectionLatestIT.getConnection(paramProperties);
        Enumeration<?> enums = paramProperties.propertyNames();
        while (enums.hasMoreElements()) {
            String key = (String)enums.nextElement();
            ResultSet rs = connection.createStatement().executeQuery(String.format("show parameters like '%s'", key));
            rs.next();
            String value = rs.getString("value");
            MatcherAssert.assertThat((String)key, (Object)value, (Matcher)CoreMatchers.equalTo((Object)"900"));
        }
        SFSession session = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
        Assert.assertEquals((long)900L, (long)session.getHeartbeatFrequency());
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void putStatementNullQueryID() throws Throwable {
        Connection con = ConnectionLatestIT.getConnection();
        Statement statement = con.createStatement();
        String sourceFilePath = ConnectionLatestIT.getFullPathFileInResource("orders_100.csv");
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        statement.execute("CREATE OR REPLACE STAGE testPutGet_stage");
        String putStatement = "PUT file://" + sourceFilePath + " @testPutGet_stage";
        ResultSet resultSet = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(putStatement);
        String queryID = resultSet.unwrap(SnowflakeResultSet.class).getQueryID();
        Assert.assertTrue((boolean)Pattern.matches("[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}", queryID));
        resultSet = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("GET @testPutGet_stage 'file://" + destFolderCanonicalPath + "' parallel=8");
        queryID = resultSet.unwrap(SnowflakeResultSet.class).getQueryID();
        Assert.assertTrue((boolean)Pattern.matches("[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}", queryID));
    }

    @Test
    public void testAsyncQueryOpenAndCloseConnection() throws SQLException, IOException, InterruptedException {
        ResultSet rs;
        Connection con = ConnectionLatestIT.getConnection();
        Statement statement = con.createStatement();
        ResultSet rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 40))");
        String queryID = rs1.unwrap(SnowflakeResultSet.class).getQueryID();
        QueryStatus status = null;
        for (int retry = 0; retry < 5; ++retry) {
            Thread.sleep(100L);
            status = rs1.unwrap(SnowflakeResultSet.class).getStatus();
            if (status != QueryStatus.NO_DATA) break;
        }
        Assert.assertEquals((Object)QueryStatus.RUNNING, status);
        statement.close();
        con.close();
        Thread.sleep(70000L);
        con = ConnectionLatestIT.getConnection();
        try {
            rs = con.unwrap(SnowflakeConnection.class).createResultSet("Totally invalid query ID");
            Assert.fail((String)"Query ID should be rejected");
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"22023", (Object)e.getSQLState());
        }
        rs = con.unwrap(SnowflakeConnection.class).createResultSet(queryID);
        status = rs.unwrap(SnowflakeResultSet.class).getStatus();
        Assert.assertEquals((Object)QueryStatus.SUCCESS, (Object)status);
        Assert.assertEquals((Object)"No error reported", (Object)status.getErrorMessage());
        Assert.assertEquals((long)0L, (long)status.getErrorCode());
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(rs));
        statement = con.createStatement();
        rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from nonexistentTable");
        Thread.sleep(100L);
        status = rs1.unwrap(SnowflakeResultSet.class).getStatus();
        int counter = 0;
        while ((status == QueryStatus.NO_DATA || status == QueryStatus.RUNNING) && counter < 10) {
            Thread.sleep(100L);
            status = rs1.unwrap(SnowflakeResultSet.class).getStatus();
        }
        if (status != QueryStatus.NO_DATA) {
            Assert.assertEquals((Object)QueryStatus.FAILED_WITH_ERROR, (Object)status);
            Assert.assertEquals((long)2003L, (long)status.getErrorCode());
            Assert.assertEquals((Object)"SQL compilation error:\nObject 'NONEXISTENTTABLE' does not exist or not authorized.", (Object)status.getErrorMessage());
        }
        statement.close();
        con.close();
    }

    @Test
    public void testGetErrorMessageFromAsyncQuery() throws SQLException {
        Connection con = ConnectionLatestIT.getConnection();
        Statement statement = con.createStatement();
        ResultSet rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("bad query!");
        try {
            rs1.next();
        }
        catch (SQLException ex) {
            Assert.assertEquals((Object)"Status of query associated with resultSet is FAILED_WITH_ERROR. SQL compilation error:\nsyntax error line 1 at position 0 unexpected 'bad'. Results not generated.", (Object)ex.getMessage());
            Assert.assertEquals((Object)"SQL compilation error:\nsyntax error line 1 at position 0 unexpected 'bad'.", (Object)rs1.unwrap(SnowflakeResultSet.class).getQueryErrorMessage());
        }
        rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select 1");
        rs1.next();
        Assert.assertEquals((Object)"No error reported", (Object)rs1.unwrap(SnowflakeResultSet.class).getQueryErrorMessage());
        rs1.close();
        statement.close();
        con.close();
    }

    @Test
    public void testAsyncAndSynchronousQueries() throws SQLException {
        Connection con = ConnectionLatestIT.getConnection();
        Statement statement = con.createStatement();
        statement.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_TZ");
        statement.execute("create or replace table smallTable (colA string, colB int)");
        statement.execute("create or replace table uselessTable (colA string, colB int)");
        statement.execute("insert into smallTable values ('row1', 1), ('row2', 2), ('row3', 3)");
        statement.execute("insert into uselessTable values ('row1', 1), ('row2', 2), ('row3', 3)");
        ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from smallTable");
        ResultSet rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from uselessTable");
        ResultSet rs2 = statement.executeQuery("drop table uselessTable");
        while (rs2.next()) {
            Assert.assertEquals((Object)"USELESSTABLE successfully dropped.", (Object)rs2.getString(1));
        }
        Assert.assertEquals((long)3L, (long)this.getSizeOfResultSet(rs1));
        statement.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_LTZ");
        rs.next();
        Assert.assertEquals((Object)rs.getString(1), (Object)"row1");
        Assert.assertEquals((long)rs.getInt(2), (long)1L);
        rs.next();
        Assert.assertEquals((Object)rs.getString(1), (Object)"row2");
        Assert.assertEquals((long)rs.getInt(2), (long)2L);
        rs.next();
        Assert.assertEquals((Object)rs.getString(1), (Object)"row3");
        Assert.assertEquals((long)rs.getInt(2), (long)3L);
        statement.execute("drop table smallTable");
        statement.close();
        con.close();
    }

    public void testQueryStatusErrorMessageAndErrorCode() throws SQLException, InterruptedException {
        Connection con = ConnectionLatestIT.getConnection();
        Statement statement = con.createStatement();
        statement.execute("create or replace table testTable(colA string, colB boolean)");
        statement.execute("insert into testTable values ('test', true)");
        ResultSet rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from testTable");
        QueryStatus status = rs1.unwrap(SnowflakeResultSet.class).getStatus();
        status.setErrorMessage(QueryStatus.FAILED_WITH_ERROR.toString());
        status.setErrorCode(2003);
        Thread.sleep(300L);
        status = rs1.unwrap(SnowflakeResultSet.class).getStatus();
        Assert.assertEquals((Object)QueryStatus.SUCCESS, (Object)status);
        Assert.assertEquals((Object)"No error reported", (Object)status.getErrorMessage());
        Assert.assertEquals((long)0L, (long)status.getErrorCode());
        statement.execute("drop table if exists testTable");
        statement.close();
        con.close();
    }

    @Test
    public void testPreparedStatementAsyncQuery() throws SQLException {
        Connection con = ConnectionLatestIT.getConnection();
        con.createStatement().execute("create or replace table testTable(colA string, colB boolean)");
        PreparedStatement prepStatement = con.prepareStatement("insert into testTable values (?,?)");
        prepStatement.setInt(1, 33);
        prepStatement.setBoolean(2, true);
        ResultSet rs = prepStatement.unwrap(SnowflakePreparedStatement.class).executeAsyncQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1), (Object)"1");
        con.createStatement().execute("drop table testTable");
        prepStatement.close();
        con.close();
    }

    @Test
    public void testIsStillRunning() {
        QueryStatus[] runningStatuses = new QueryStatus[]{QueryStatus.RUNNING, QueryStatus.RESUMING_WAREHOUSE, QueryStatus.QUEUED, QueryStatus.QUEUED_REPAIRING_WAREHOUSE, QueryStatus.NO_DATA, QueryStatus.BLOCKED};
        QueryStatus[] otherStatuses = new QueryStatus[]{QueryStatus.ABORTED, QueryStatus.ABORTING, QueryStatus.SUCCESS, QueryStatus.FAILED_WITH_ERROR, QueryStatus.FAILED_WITH_INCIDENT, QueryStatus.DISCONNECTED, QueryStatus.RESTARTED};
        for (QueryStatus qs : runningStatuses) {
            Assert.assertEquals((Object)true, (Object)QueryStatus.isStillRunning((QueryStatus)qs));
        }
        for (QueryStatus qs : otherStatuses) {
            Assert.assertEquals((Object)false, (Object)QueryStatus.isStillRunning((QueryStatus)qs));
        }
    }

    @Test
    public void testIsAnError() {
        QueryStatus[] errorStatuses;
        QueryStatus[] otherStatuses = new QueryStatus[]{QueryStatus.RUNNING, QueryStatus.RESUMING_WAREHOUSE, QueryStatus.QUEUED, QueryStatus.QUEUED_REPAIRING_WAREHOUSE, QueryStatus.SUCCESS, QueryStatus.RESTARTED, QueryStatus.NO_DATA};
        for (QueryStatus qs : errorStatuses = new QueryStatus[]{QueryStatus.ABORTED, QueryStatus.ABORTING, QueryStatus.FAILED_WITH_ERROR, QueryStatus.FAILED_WITH_INCIDENT, QueryStatus.DISCONNECTED, QueryStatus.BLOCKED}) {
            Assert.assertEquals((Object)true, (Object)QueryStatus.isAnError((QueryStatus)qs));
        }
        for (QueryStatus qs : otherStatuses) {
            Assert.assertEquals((Object)false, (Object)QueryStatus.isAnError((QueryStatus)qs));
        }
    }

    public void testQueryStatuses() throws SQLException, IOException, InterruptedException {
        Connection con = ConnectionLatestIT.getConnection();
        Statement statement = con.createStatement();
        ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 5))");
        Thread.sleep(100L);
        QueryStatus status = rs.unwrap(SnowflakeResultSet.class).getStatus();
        Assert.assertEquals((Object)QueryStatus.RESUMING_WAREHOUSE, (Object)status);
        ResultSet rs1 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 60))");
        ResultSet rs2 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 60))");
        ResultSet rs3 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 60))");
        ResultSet rs4 = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 60))");
        Thread.sleep(100L);
        status = rs4.unwrap(SnowflakeResultSet.class).getStatus();
        Assert.assertEquals((Object)QueryStatus.QUEUED, (Object)status);
    }

    @Test
    public void testHttpsLoginTimeoutWithOutSSL() throws InterruptedException {
        Properties properties = new Properties();
        properties.put("account", "wrongaccount");
        properties.put("loginTimeout", "20");
        properties.put("user", "fakeuser");
        properties.put("password", "fakepassword");
        properties.put("authenticator", ClientAuthnDTO.AuthenticatorType.SNOWFLAKE.toString());
        properties.put("ssl", "off");
        int count = TelemetryService.getInstance().getEventCount();
        try {
            Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
            String host = params.get("host");
            String[] hostItems = host.split("\\.");
            String wrongUri = params.get("uri").replace("://" + hostItems[0], "://wrongaccount");
            DriverManager.getConnection(wrongUri, properties);
        }
        catch (SQLException e) {
            if (TelemetryService.getInstance().getServerDeploymentName().equals(TelemetryService.TELEMETRY_SERVER_DEPLOYMENT.DEV.getName()) || TelemetryService.getInstance().getServerDeploymentName().equals(TelemetryService.TELEMETRY_SERVER_DEPLOYMENT.REG.getName())) {
                MatcherAssert.assertThat((String)"Communication error", (Object)e.getErrorCode(), (Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)390100), CoreMatchers.equalTo((Object)390400)}));
                Thread.sleep(5000L);
                if (TelemetryService.getInstance().isDeploymentEnabled()) {
                    MatcherAssert.assertThat((String)"Telemetry should not create new event", (Object)TelemetryService.getInstance().getEventCount(), (Matcher)CoreMatchers.equalTo((Object)count));
                }
            } else {
                MatcherAssert.assertThat((String)"Communication error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
                if (TelemetryService.getInstance().isDeploymentEnabled()) {
                    MatcherAssert.assertThat((String)("Telemetry event has not been reported successfully. Error: " + TelemetryService.getInstance().getLastClientError()), (Object)TelemetryService.getInstance().getClientFailureCount(), (Matcher)CoreMatchers.equalTo((Object)0));
                }
            }
            return;
        }
        Assert.fail();
    }

    @Test
    public void testWrongHostNameTimeout() throws InterruptedException {
        long connStart = 0L;
        Properties properties = new Properties();
        properties.put("account", "testaccount");
        properties.put("loginTimeout", "20");
        properties.put("user", "fakeuser");
        properties.put("password", "fakepassword");
        properties.put("authenticator", ClientAuthnDTO.AuthenticatorType.SNOWFLAKE.toString());
        try {
            connStart = System.currentTimeMillis();
            Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
            String host = params.get("host");
            String[] hostItems = host.split("\\.");
            String wrongUri = params.get("uri").replace("." + hostItems[hostItems.length - 2] + ".", ".wronghostname.");
            DriverManager.getConnection(wrongUri, properties);
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((String)"Communication error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            long conEnd = System.currentTimeMillis();
            MatcherAssert.assertThat((String)"Login time out not taking effective", (conEnd - connStart < 60000L ? 1 : 0) != 0);
            Thread.sleep(5000L);
            if (TelemetryService.getInstance().isDeploymentEnabled()) {
                MatcherAssert.assertThat((String)("Telemetry event has not been reported successfully. Error: " + TelemetryService.getInstance().getLastClientError()), (Object)TelemetryService.getInstance().getClientFailureCount(), (Matcher)CoreMatchers.equalTo((Object)0));
            }
            return;
        }
        Assert.fail();
    }

    @Test
    public void testHttpsLoginTimeoutWithSSL() throws InterruptedException {
        long connStart = 0L;
        Properties properties = new Properties();
        properties.put("account", "wrongaccount");
        properties.put("loginTimeout", "5");
        properties.put("user", "fakeuser");
        properties.put("password", "fakepassword");
        properties.put("ssl", "on");
        try {
            connStart = System.currentTimeMillis();
            Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
            String host = params.get("host");
            String[] hostItems = host.split("\\.");
            String wrongUri = params.get("uri").replace("://" + hostItems[0], "://wrongaccount");
            DriverManager.getConnection(wrongUri, properties);
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((String)"Communication error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            long conEnd = System.currentTimeMillis();
            MatcherAssert.assertThat((String)"Login time out not taking effective", (conEnd - connStart < 60000L ? 1 : 0) != 0);
            Thread.sleep(5000L);
            if (TelemetryService.getInstance().isDeploymentEnabled()) {
                MatcherAssert.assertThat((String)("Telemetry event has not been reported successfully. Error: " + TelemetryService.getInstance().getLastClientError()), (Object)TelemetryService.getInstance().getClientFailureCount(), (Matcher)CoreMatchers.equalTo((Object)0));
            }
            return;
        }
        Assert.fail();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testKeyPairFileDataSourceSerialization() throws Exception {
        Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setServerName(params.get("host"));
        ds.setSsl("on".equals(params.get("ssl")));
        ds.setAccount(params.get("account"));
        ds.setPortNumber(Integer.parseInt(params.get("port")));
        ds.setUser(params.get("user"));
        String privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource("encrypted_rsa_key.p8");
        ds.setPrivateKeyFile(privateKeyLocation, "test");
        try (Connection con = ConnectionLatestIT.getConnection();){
            Statement statement = con.createStatement();
            statement.execute("use role accountadmin");
            String pathfile = ConnectionLatestIT.getFullPathFileInResource("encrypted_rsa_key.pub");
            String pubKey = new String(Files.readAllBytes(Paths.get(pathfile, new String[0])));
            pubKey = pubKey.replace("-----BEGIN PUBLIC KEY-----", "");
            pubKey = pubKey.replace("-----END PUBLIC KEY-----", "");
            statement.execute(String.format("alter user %s set rsa_public_key='%s'", params.get("user"), pubKey));
        }
        con = ds.getConnection();
        ResultSet resultSet = con.createStatement().executeQuery("select 1");
        resultSet.next();
        MatcherAssert.assertThat((String)"select 1", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)1));
        con.close();
        File serializedFile = this.tmpFolder.newFile("serializedStuff.ser");
        FileOutputStream outputFile = new FileOutputStream(serializedFile);
        ObjectOutputStream out = new ObjectOutputStream(outputFile);
        out.writeObject(ds);
        out.close();
        outputFile.close();
        FileInputStream inputFile = new FileInputStream(serializedFile);
        ObjectInputStream in = new ObjectInputStream(inputFile);
        SnowflakeBasicDataSource ds2 = (SnowflakeBasicDataSource)in.readObject();
        in.close();
        inputFile.close();
        con = ds2.getConnection();
        resultSet = con.createStatement().executeQuery("select 1");
        resultSet.next();
        MatcherAssert.assertThat((String)"select 1", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)1));
        con.close();
        try (Connection connection = ConnectionLatestIT.getConnection();){
            Statement statement = connection.createStatement();
            statement.execute("use role accountadmin");
            statement.execute(String.format("alter user %s unset rsa_public_key", params.get("user")));
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPrivateKeyInConnectionString() throws SQLException, IOException {
        Map<String, String> parameters = ConnectionLatestIT.getConnectionParameters();
        String testUser = parameters.get("user");
        Connection connection = ConnectionLatestIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("use role accountadmin");
        String pathfile = ConnectionLatestIT.getFullPathFileInResource("rsa_key.pub");
        String pubKey = new String(Files.readAllBytes(Paths.get(pathfile, new String[0])));
        pubKey = pubKey.replace("-----BEGIN PUBLIC KEY-----", "");
        pubKey = pubKey.replace("-----END PUBLIC KEY-----", "");
        statement.execute(String.format("alter user %s set rsa_public_key='%s'", testUser, pubKey));
        connection.close();
        String privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource("rsa_key.p8");
        String uri = parameters.get("uri") + "/?private_key_file=" + privateKeyLocation;
        Properties properties = new Properties();
        properties.put("account", parameters.get("account"));
        properties.put("user", testUser);
        properties.put("ssl", parameters.get("ssl"));
        properties.put("port", parameters.get("port"));
        connection = DriverManager.getConnection(uri, properties);
        connection.close();
        privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource("rsa_key.pem");
        uri = parameters.get("uri") + "/?private_key_file=" + privateKeyLocation;
        properties = new Properties();
        properties.put("account", parameters.get("account"));
        properties.put("user", testUser);
        properties.put("ssl", parameters.get("ssl"));
        properties.put("port", parameters.get("port"));
        properties.put("authenticator", ClientAuthnDTO.AuthenticatorType.SNOWFLAKE_JWT.toString());
        connection = DriverManager.getConnection(uri, properties);
        connection.close();
        connection = ConnectionLatestIT.getConnection();
        statement = connection.createStatement();
        statement.execute("use role accountadmin");
        pathfile = ConnectionLatestIT.getFullPathFileInResource("encrypted_rsa_key.pub");
        pubKey = new String(Files.readAllBytes(Paths.get(pathfile, new String[0])));
        pubKey = pubKey.replace("-----BEGIN PUBLIC KEY-----", "");
        pubKey = pubKey.replace("-----END PUBLIC KEY-----", "");
        statement.execute(String.format("alter user %s set rsa_public_key='%s'", testUser, pubKey));
        connection.close();
        privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource("encrypted_rsa_key.p8");
        uri = parameters.get("uri") + "/?private_key_file_pwd=test&private_key_file=" + privateKeyLocation;
        connection = DriverManager.getConnection(uri, properties);
        connection.close();
        uri = parameters.get("uri") + "/?private_key_file_pwd=wrong_password&private_key_file=" + privateKeyLocation;
        try {
            connection = DriverManager.getConnection(uri, properties);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)ErrorCode.INVALID_OR_UNSUPPORTED_PRIVATE_KEY.getMessageCode().intValue(), (long)e.getErrorCode());
        }
        connection.close();
        connection = ConnectionLatestIT.getConnection();
        statement = connection.createStatement();
        statement.execute("use role accountadmin");
        pathfile = ConnectionLatestIT.getFullPathFileInResource("rsa_key.pub");
        pubKey = new String(Files.readAllBytes(Paths.get(pathfile, new String[0])));
        pubKey = pubKey.replace("-----BEGIN PUBLIC KEY-----", "");
        pubKey = pubKey.replace("-----END PUBLIC KEY-----", "");
        statement.execute(String.format("alter user %s set rsa_public_key='%s'", testUser, pubKey));
        connection.close();
        privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource("encrypted_rsa_key.p8");
        uri = parameters.get("uri") + "/?private_key_file_pwd=test&private_key_file=" + privateKeyLocation;
        try {
            connection = DriverManager.getConnection(uri, properties);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)390144L, (long)e.getErrorCode());
        }
        connection.close();
        privateKeyLocation = ConnectionLatestIT.getFullPathFileInResource("invalid_private_key.pem");
        uri = parameters.get("uri") + "/?private_key_file=" + privateKeyLocation;
        try {
            connection = DriverManager.getConnection(uri, properties);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)ErrorCode.INVALID_OR_UNSUPPORTED_PRIVATE_KEY.getMessageCode().intValue(), (long)e.getErrorCode());
        }
        connection.close();
        connection = ConnectionLatestIT.getConnection();
        statement = connection.createStatement();
        statement.execute("use role accountadmin");
        statement.execute(String.format("alter user %s unset rsa_public_key", testUser));
        connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testBasicDataSourceSerialization() throws Exception {
        Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setServerName(params.get("host"));
        ds.setSsl("on".equals(params.get("ssl")));
        ds.setAccount(params.get("account"));
        ds.setPortNumber(Integer.parseInt(params.get("port")));
        ds.setUser(params.get("user"));
        ds.setPassword(params.get("password"));
        Connection con = ds.getConnection();
        ResultSet resultSet = con.createStatement().executeQuery("select 1");
        resultSet.next();
        MatcherAssert.assertThat((String)"select 1", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)1));
        con.close();
        File serializedFile = this.tmpFolder.newFile("serializedStuff.ser");
        FileOutputStream outputFile = new FileOutputStream(serializedFile);
        ObjectOutputStream out = new ObjectOutputStream(outputFile);
        out.writeObject(ds);
        out.close();
        outputFile.close();
        FileInputStream inputFile = new FileInputStream(serializedFile);
        ObjectInputStream in = new ObjectInputStream(inputFile);
        SnowflakeBasicDataSource ds2 = (SnowflakeBasicDataSource)in.readObject();
        in.close();
        inputFile.close();
        con = ds2.getConnection();
        resultSet = con.createStatement().executeQuery("select 1");
        resultSet.next();
        MatcherAssert.assertThat((String)"select 1", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)1));
        con.close();
    }

    private void waitForAsyncQueryDone(Connection connection, String queryID) throws Exception {
        SFSession session = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
        QueryStatus qs = session.getQueryStatus(queryID);
        while (QueryStatus.isStillRunning((QueryStatus)qs)) {
            Thread.sleep(1000L);
            qs = session.getQueryStatus(queryID);
        }
    }

    @Test
    public void testGetChildQueryIdsForAsyncSingleStatement() throws Exception {
        Connection connection = ConnectionLatestIT.getConnection();
        Connection connection2 = ConnectionLatestIT.getConnection();
        Statement statement = connection.createStatement();
        String query0 = "create or replace temporary table test_multi (cola int);";
        String query1 = "insert into test_multi VALUES (111), (222);";
        String query2 = "select cola from test_multi order by cola asc";
        ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(query0);
        String queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
        this.waitForAsyncQueryDone(connection, queryID);
        String[] queryIDs = connection.unwrap(SnowflakeConnectionV1.class).getChildQueryIds(queryID);
        assert (queryIDs.length == 1);
        rs = connection.unwrap(SnowflakeConnection.class).createResultSet(queryIDs[0]);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1), (Object)"Table TEST_MULTI successfully created.");
        Assert.assertFalse((boolean)rs.next());
        rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(query1);
        queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
        this.waitForAsyncQueryDone(connection2, queryID);
        queryIDs = connection2.unwrap(SnowflakeConnectionV1.class).getChildQueryIds(queryID);
        assert (queryIDs.length == 1);
        rs = connection2.unwrap(SnowflakeConnection.class).createResultSet(queryIDs[0]);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)2L);
        Assert.assertFalse((boolean)rs.next());
        rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(query2);
        queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
        this.waitForAsyncQueryDone(connection2, queryID);
        queryIDs = connection2.unwrap(SnowflakeConnectionV1.class).getChildQueryIds(queryID);
        assert (queryIDs.length == 1);
        rs = connection2.unwrap(SnowflakeConnection.class).createResultSet(queryIDs[0]);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)111L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)222L);
        Assert.assertFalse((boolean)rs.next());
        connection.close();
        connection2.close();
    }

    @Test
    public void testGetChildQueryIdsForAsyncMultiStatement() throws Exception {
        Connection connection = ConnectionLatestIT.getConnection();
        Statement statement = connection.createStatement();
        String multiStmtQuery = "create or replace temporary table test_multi (cola int);insert into test_multi VALUES (111), (222);select cola from test_multi order by cola asc";
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
        ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(multiStmtQuery);
        String queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
        statement.close();
        connection.close();
        connection = ConnectionLatestIT.getConnection();
        this.waitForAsyncQueryDone(connection, queryID);
        String[] queryIDs = connection.unwrap(SnowflakeConnectionV1.class).getChildQueryIds(queryID);
        assert (queryIDs.length == 3);
        rs = connection.unwrap(SnowflakeConnection.class).createResultSet(queryIDs[0]);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1), (Object)"Table TEST_MULTI successfully created.");
        Assert.assertFalse((boolean)rs.next());
        rs = connection.unwrap(SnowflakeConnection.class).createResultSet(queryIDs[1]);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)2L);
        Assert.assertFalse((boolean)rs.next());
        rs = connection.unwrap(SnowflakeConnection.class).createResultSet(queryIDs[2]);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)111L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)222L);
        Assert.assertFalse((boolean)rs.next());
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetChildQueryIdsNegativeTestQueryIsRunning() throws Exception {
        Connection connection = ConnectionLatestIT.getConnection();
        Statement statement = connection.createStatement();
        String multiStmtQuery = "select 1; call system$wait(10); select 2";
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
        ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(multiStmtQuery);
        String queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
        try {
            connection.unwrap(SnowflakeConnectionV1.class).getChildQueryIds(queryID);
            Assert.fail((String)"The getChildQueryIds() should fail because query is running");
        }
        catch (SQLException ex) {
            String msg = ex.getMessage();
            if (!msg.contains("Status of query associated with resultSet is") || !msg.contains("Results not generated.")) {
                ex.printStackTrace();
                QueryStatus qs = connection.unwrap(SnowflakeConnectionV1.class).getSfSession().getQueryStatus(queryID);
                Assert.fail((String)("Don't get expected message, query Status: " + qs + " actual message is: " + msg));
            }
        }
        finally {
            connection.createStatement().execute("select system$cancel_query('" + queryID + "')");
            statement.close();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetChildQueryIdsNegativeTestQueryFailed() throws Exception {
        Connection connection = ConnectionLatestIT.getConnection();
        Statement statement = connection.createStatement();
        String multiStmtQuery = "select 1; select to_date('not_date'); select 2";
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
        ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(multiStmtQuery);
        String queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
        try {
            this.waitForAsyncQueryDone(connection, queryID);
            connection.unwrap(SnowflakeConnectionV1.class).getChildQueryIds(queryID);
            Assert.fail((String)"The getChildQueryIds() should fail because the query fails");
        }
        catch (SQLException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Uncaught Execution of multiple statements failed on statement \"select to_date('not_date')\""));
        }
        finally {
            statement.close();
            connection.close();
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testAuthenticatorEndpointWithDashInAccountName() throws Exception {
        Map<String, String> params = ConnectionLatestIT.getConnectionParameters();
        String serverUrl = String.format("%s://%s:%s", params.get("ssl").equals("on") ? "https" : "http", params.get("host"), params.get("port"));
        HttpPost postRequest = new HttpPost(new URIBuilder(serverUrl).setPath("/session/authenticator-request").build());
        Map<String, String> data = Collections.singletonMap(ClientAuthnParameter.ACCOUNT_NAME.name(), "snowhouse-local");
        ClientAuthnDTO authnData = new ClientAuthnDTO();
        authnData.setData(data);
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        String json = mapper.writeValueAsString((Object)authnData);
        StringEntity input = new StringEntity(json, StandardCharsets.UTF_8);
        input.setContentType("application/json");
        postRequest.setEntity((HttpEntity)input);
        postRequest.addHeader("accept", "application/json");
        String theString = HttpUtil.executeGeneralRequest((HttpRequestBase)postRequest, (int)60, (int)0, (int)0, (int)0, (HttpClientSettingsKey)new HttpClientSettingsKey(null));
        JsonNode jsonNode = mapper.readTree(theString);
        Assert.assertEquals((Object)"{\"data\":null,\"code\":null,\"message\":null,\"success\":true}", (Object)jsonNode.toString());
    }

    @Test
    public void testReadOnly() throws Throwable {
        try (Connection connection = ConnectionLatestIT.getConnection();){
            connection.setReadOnly(true);
            Assert.assertEquals((Object)connection.isReadOnly(), (Object)false);
            connection.setReadOnly(false);
            connection.createStatement().execute("create or replace table readonly_test(c1 int)");
            Assert.assertFalse((boolean)connection.isReadOnly());
            connection.createStatement().execute("drop table if exists readonly_test");
        }
    }

    @Test
    public void testDownloadStreamWithFileNotFoundException() throws SQLException {
        Connection connection = ConnectionLatestIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("CREATE OR REPLACE TEMP STAGE testDownloadStream_stage");
        long startDownloadTime = System.currentTimeMillis();
        try {
            connection.unwrap(SnowflakeConnection.class).downloadStream("@testDownloadStream_stage", "/fileNotExist.gz", true);
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.S3_OPERATION_ERROR.getMessageCode()));
        }
        long endDownloadTime = System.currentTimeMillis();
        Assert.assertTrue((endDownloadTime - startDownloadTime < 400000L ? 1 : 0) != 0);
    }

    @Test
    public void testIsAsyncSession() throws SQLException, InterruptedException {
        try (Connection con = ConnectionLatestIT.getConnection();
             Statement statement = con.createStatement();){
            ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select count(*) from table(generator(timeLimit => 4))");
            Assert.assertTrue((boolean)con.unwrap(SnowflakeConnectionV1.class).getSfSession().isAsyncSession());
            Assert.assertFalse((boolean)con.unwrap(SnowflakeConnectionV1.class).getSfSession().isSafeToClose());
            TimeUnit.SECONDS.sleep(6L);
            Assert.assertTrue((boolean)con.unwrap(SnowflakeConnectionV1.class).getSfSession().isSafeToClose());
            Assert.assertFalse((boolean)con.unwrap(SnowflakeConnectionV1.class).getSfSession().isAsyncSession());
            rs.close();
        }
    }
}

