/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.net.SocketTimeoutException;
import java.security.cert.CertificateExpiredException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryConnection;
import net.snowflake.client.core.SFOCSPException;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.OCSPErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryConnection.class})
public class ConnectionWithOCSPModeIT
extends BaseJDBCTest {
    private final String testUser = "fakeuser";
    private final String testPassword = "testpassword";
    private final String testRevokedCertConnectString = "jdbc:snowflake://revoked.badssl.com/";
    private static int nameCounter = 0;

    @Before
    public void setUp() {
        SFTrustManager.deleteCache();
    }

    @After
    public void tearDown() {
        SFTrustManager.cleanTestSystemParameters();
    }

    private static synchronized String genTestConnectString() {
        String ret = "jdbc:snowflake://fakeaccount" + nameCounter + ".snowflakecomputing.com";
        ++nameCounter;
        return ret;
    }

    private static Throwable getCause(Throwable ex) {
        Throwable ex0 = ex;
        while (ex0.getCause() != null) {
            ex0 = ex0.getCause();
        }
        return ex0;
    }

    private Properties OCSPFailOpenProperties() {
        Properties properties = new Properties();
        properties.put("user", "fakeuser");
        properties.put("password", "testpassword");
        properties.put("ocspFailOpen", Boolean.TRUE.toString());
        properties.put("loginTimeout", "10");
        properties.put("tracing", "ALL");
        return properties;
    }

    private Properties OCSPFailClosedProperties() {
        Properties properties = new Properties();
        properties.put("user", "fakeuser");
        properties.put("password", "testpassword");
        properties.put("ocspFailOpen", Boolean.FALSE.toString());
        properties.put("loginTimeout", "10");
        properties.put("tracing", "ALL");
        return properties;
    }

    private Properties OCSPInsecureProperties() {
        Properties properties = new Properties();
        properties.put("user", "fakeuser");
        properties.put("password", "testpassword");
        properties.put("insecureMode", Boolean.TRUE.toString());
        properties.put("loginTimeout", "10");
        return properties;
    }

    @Test
    public void testValidityExpiredOCSPResponseFailOpen() {
        System.setProperty("SF_OCSP_TEST_INJECT_VALIDITY_ERROR", Boolean.TRUE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailOpenProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"HTTP status=403"));
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    public void testValidityExpiredOCSPResponseFailClosed() {
        System.setProperty("SF_OCSP_TEST_INJECT_VALIDITY_ERROR", Boolean.TRUE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailClosedProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            Throwable cause = ConnectionWithOCSPModeIT.getCause(ex);
            MatcherAssert.assertThat((Object)cause, (Matcher)IsInstanceOf.instanceOf(SFOCSPException.class));
            MatcherAssert.assertThat((Object)((SFOCSPException)cause).getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)OCSPErrorCode.INVALID_OCSP_RESPONSE_VALIDITY));
        }
    }

    @Test
    public void testNoOCSPResponderURLFailOpen() {
        System.setProperty("SF_OCSP_TEST_NO_OCSP_RESPONDER_URL", Boolean.TRUE.toString());
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.FALSE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailOpenProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"HTTP status=403"));
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    public void testNoOCSPResponderURLFailClosed() {
        System.setProperty("SF_OCSP_TEST_NO_OCSP_RESPONDER_URL", Boolean.TRUE.toString());
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.FALSE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailClosedProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            Throwable cause = ConnectionWithOCSPModeIT.getCause(ex);
            MatcherAssert.assertThat((Object)cause, (Matcher)IsInstanceOf.instanceOf(SFOCSPException.class));
            MatcherAssert.assertThat((Object)((SFOCSPException)cause).getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)OCSPErrorCode.NO_OCSP_URL_ATTACHED));
        }
    }

    @Test
    public void testValidityExpiredOCSPResponseInsecure() {
        System.setProperty("SF_OCSP_TEST_INJECT_VALIDITY_ERROR", Boolean.TRUE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPInsecureProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"HTTP status=403"));
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    public void testCertAttachedInvalidFailOpen() {
        System.setProperty("SF_OCSP_TEST_INVALID_SIGNING_CERT", Boolean.TRUE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailOpenProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"HTTP status=403"));
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    public void testCertAttachedInvalidFailClosed() {
        System.setProperty("SF_OCSP_TEST_INVALID_SIGNING_CERT", Boolean.TRUE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailClosedProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            Throwable cause = ConnectionWithOCSPModeIT.getCause(ex);
            MatcherAssert.assertThat((Object)cause, (Matcher)IsInstanceOf.instanceOf(SFOCSPException.class));
            MatcherAssert.assertThat((Object)((SFOCSPException)cause).getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)OCSPErrorCode.EXPIRED_OCSP_SIGNING_CERTIFICATE));
        }
    }

    @Test
    public void testUnknownOCSPCertFailOpen() {
        System.setProperty("SF_OCSP_TEST_INJECT_UNKNOWN_STATUS", Boolean.TRUE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailOpenProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"HTTP status=403"));
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    public void testUnknownOCSPCertFailClosed() {
        System.setProperty("SF_OCSP_TEST_INJECT_UNKNOWN_STATUS", Boolean.TRUE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailClosedProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            Throwable cause = ConnectionWithOCSPModeIT.getCause(ex);
            MatcherAssert.assertThat((Object)cause, (Matcher)IsInstanceOf.instanceOf(SFOCSPException.class));
            MatcherAssert.assertThat((Object)((SFOCSPException)cause).getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)OCSPErrorCode.CERTIFICATE_STATUS_UNKNOWN));
        }
    }

    @Test
    public void testOCSPCacheServerTimeoutFailOpen() {
        System.setProperty("SF_OCSP_TEST_OCSP_RESPONSE_CACHE_SERVER_TIMEOUT", "1000");
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_URL", "http://localhost:12345/hang");
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.TRUE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailOpenProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"HTTP status=403"));
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    public void testOCSPCacheServerTimeoutFailClosed() {
        System.setProperty("SF_OCSP_TEST_OCSP_RESPONSE_CACHE_SERVER_TIMEOUT", "1000");
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_URL", "http://localhost:12345/hang");
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.TRUE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailOpenProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    public void testOCSPResponderTimeoutFailOpen() {
        System.setProperty("SF_OCSP_TEST_OCSP_RESPONDER_TIMEOUT", "1000");
        System.setProperty("SF_OCSP_TEST_RESPONDER_URL", "http://localhost:12345/hang");
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.FALSE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailOpenProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"HTTP status=403"));
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testOCSPResponderTimeoutFailClosed() {
        System.setProperty("SF_OCSP_TEST_OCSP_RESPONDER_TIMEOUT", "1000");
        System.setProperty("SF_OCSP_TEST_RESPONDER_URL", "http://localhost:12345/hang");
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.FALSE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailClosedProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            Throwable cause = ConnectionWithOCSPModeIT.getCause(ex);
            MatcherAssert.assertThat((Object)cause, (Matcher)IsInstanceOf.instanceOf(SocketTimeoutException.class));
        }
    }

    @Test
    public void testOCSPResponder403FailOpen() {
        System.setProperty("SF_OCSP_TEST_RESPONDER_URL", "http://localhost:12345/403");
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.FALSE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailOpenProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"HTTP status=403"));
            Assert.assertNull((Object)ex.getCause());
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testOCSPResponder403FailClosed() {
        System.setProperty("SF_OCSP_TEST_RESPONDER_URL", "http://localhost:12345/403");
        System.setProperty("SF_OCSP_RESPONSE_CACHE_SERVER_ENABLED", Boolean.FALSE.toString());
        try {
            DriverManager.getConnection(ConnectionWithOCSPModeIT.genTestConnectString(), this.OCSPFailClosedProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
            MatcherAssert.assertThat((Object)ConnectionWithOCSPModeIT.getCause(ex).getMessage(), (Matcher)CoreMatchers.containsString((String)"StatusCode: 403"));
        }
    }

    @Test
    public void testExpiredCert() {
        try {
            DriverManager.getConnection("jdbc:snowflake://expired.badssl.com/", this.OCSPFailClosedProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ConnectionWithOCSPModeIT.getCause(ex), (Matcher)IsInstanceOf.instanceOf(CertificateExpiredException.class));
        }
    }

    @Test
    public void testWrongHost() {
        try {
            DriverManager.getConnection("jdbc:snowflake://wrong.host.badssl.com/", this.OCSPFailClosedProperties());
            Assert.fail((String)"should fail");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((Object)ex.getCause(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(SSLPeerUnverifiedException.class), IsInstanceOf.instanceOf(SSLHandshakeException.class)}));
        }
    }
}

