/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.amazonaws.Protocol;
import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.TestCase;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeDriverIT;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={TestCategoryOthers.class})
public class CustomProxyLatestIT {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    @Ignore
    public void test2ProxiesWithSameJVM() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        props.put("useProxy", (Object)true);
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "8080");
        Connection con1 = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        Statement stmt = con1.createStatement();
        ResultSet rs = stmt.executeQuery("select 1");
        rs.next();
        TestCase.assertEquals((int)1, (int)rs.getInt(1));
        props.put("proxyPort", "8081");
        Connection con2 = DriverManager.getConnection("jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com", props);
        rs = con2.createStatement().executeQuery("select 2");
        rs.next();
        TestCase.assertEquals((int)2, (int)rs.getInt(1));
        props.put("proxyPort", "8080");
        Connection con3 = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        stmt = con3.createStatement();
        rs = stmt.executeQuery("select 1");
        rs.next();
        TestCase.assertEquals((int)1, (int)rs.getInt(1));
        TestCase.assertEquals((int)2, (int)HttpUtil.httpClient.size());
        con2.close();
        con1.close();
        con3.close();
    }

    @Test
    @Ignore
    public void testTLSIssue() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        props.put("tracing", "ALL");
        props.put("useProxy", (Object)true);
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "3128");
        props.put("proxyProtocol", "https");
        Connection con1 = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        Statement stmt = con1.createStatement();
        ResultSet rs = stmt.executeQuery("select 1");
        rs.next();
        TestCase.assertEquals((int)1, (int)rs.getInt(1));
        props.put("useProxy", (Object)false);
        System.setProperty("http.useProxy", "true");
        System.setProperty("http.proxyHost", "localhost");
        System.setProperty("http.proxyPort", "3128");
        con1 = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        stmt = con1.createStatement();
        rs = stmt.executeQuery("select 1");
        rs.next();
        TestCase.assertEquals((int)1, (int)rs.getInt(1));
    }

    @Test
    @Ignore
    public void testJVMParamsWithNonProxyHostsHonored() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        props.put("tracing", "ALL");
        System.setProperty("http.useProxy", "true");
        System.setProperty("https.proxyHost", "localhost");
        System.setProperty("https.proxyPort", "3128");
        System.setProperty("http.nonProxyHosts", "*");
        Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select 1");
        rs.next();
        TestCase.assertEquals((int)1, (int)rs.getInt(1));
        con.close();
    }

    @Test
    @Ignore
    public void testTLSIssueWithConnectionStringAgainstS3() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=3128&useProxy=true&proxyProtocol=https";
        this.runProxyConnection(connectionUrl);
    }

    @Test
    @Ignore
    public void testNonProxyHostAltering() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        props.put("useProxy", (Object)true);
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "8080");
        props.put("nonProxyHosts", "*.snowflakecomputing.com");
        Connection con1 = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        Statement stmt = con1.createStatement();
        ResultSet rs = stmt.executeQuery("select 1");
        rs.next();
        TestCase.assertEquals((int)1, (int)rs.getInt(1));
        HttpUtil.httpClient.entrySet().forEach(entry -> TestCase.assertEquals((String)".foo.com|.baz.com", (String)((HttpClientSettingsKey)entry.getKey()).getNonProxyHosts()));
        props.put("nonProxyHosts", "*.snowflakecomputing.com");
        Connection con2 = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        rs = stmt.executeQuery("select 2");
        rs.next();
        TestCase.assertEquals((int)2, (int)rs.getInt(1));
        TestCase.assertEquals((int)1, (int)HttpUtil.httpClient.size());
        HttpUtil.httpClient.entrySet().forEach(entry -> TestCase.assertEquals((String)"*.snowflakecomputing.com", (String)((HttpClientSettingsKey)entry.getKey()).getNonProxyHosts()));
        con1.close();
        con2.close();
    }

    @Test
    @Ignore
    public void testSizeOfHttpClientNoProxies() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        Connection con1 = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        Statement stmt = con1.createStatement();
        ResultSet rs = stmt.executeQuery("select 1");
        rs.next();
        TestCase.assertEquals((int)1, (int)rs.getInt(1));
        props.put("useProxy", (Object)false);
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "8080");
        Connection con2 = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        TestCase.assertEquals((int)1, (int)HttpUtil.httpClient.size());
        props.put("ocspFailOpen", "false");
        Connection con3 = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        TestCase.assertEquals((int)2, (int)HttpUtil.httpClient.size());
        con1.close();
        con2.close();
        con3.close();
    }

    @Test
    @Ignore
    public void testCorrectProxySettingFromConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=8080&useProxy=true";
        this.runProxyConnection(connectionUrl);
        connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=8080&proxyUser=testuser1&proxyPassword=test&useProxy=true";
        this.runProxyConnection(connectionUrl);
    }

    @Test
    @Ignore
    public void testWrongProxyPortSettingFromConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=31281&proxyUser=testuser1&proxyPassword=test&nonProxyHosts=*.foo.com|localhost&useProxy=true";
        this.runProxyConnection(connectionUrl);
    }

    @Test
    @Ignore
    public void testWrongProxyPasswordSettingFromConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=3128&proxyUser=testuser2&proxyPassword=test111&nonProxyHosts=*.foo.com|localhost&useProxy=true";
        try {
            this.runProxyConnection(connectionUrl);
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((String)"JDBC driver encountered communication error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
        }
    }

    @Test
    @Ignore
    public void testInvalidProxyPortFromConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyUser=testuser1&proxyPassword=test&nonProxyHosts=*.foo.com|localhost&useProxy=true";
        try {
            this.runProxyConnection(connectionUrl);
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((String)"invalid proxy error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.INVALID_PROXY_PROPERTIES.getMessageCode()));
        }
    }

    @Test
    @Ignore
    public void testNonProxyHostsFromConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=31281&proxyUser=testuser1&proxyPassword=test&nonProxyHosts=*.snowflakecomputing.com|localhost&useProxy=true";
        this.runProxyConnection(connectionUrl);
    }

    @Test
    @Ignore
    public void testWrongNonProxyHostsFromConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=31281&proxyUser=testuser1&proxyPassword=test&nonProxyHosts=*.foo.com|localhost&useProxy=true";
        this.runProxyConnection(connectionUrl);
    }

    @Test
    @Ignore
    public void testUnsetJvmPropertiesForInvalidSettings() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        props.put("tracing", "ALL");
        System.setProperty("proxyHost", "localhost");
        System.setProperty("proxyPort", "3128");
        Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        TestCase.assertEquals((String)System.getProperty("proxyHost"), null);
        TestCase.assertEquals((String)System.getProperty("proxyPort"), null);
        con.close();
    }

    public void runProxyConnection(String connectionUrl) throws ClassNotFoundException, SQLException {
        Authenticator.setDefault(new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                System.out.println("RequestorType: " + (Object)((Object)this.getRequestorType()));
                System.out.println("Protocol: " + this.getRequestingProtocol().toLowerCase());
                return new PasswordAuthentication(SnowflakeUtil.systemGetProperty((String)"http.proxyUser"), SnowflakeUtil.systemGetProperty((String)"http.proxyPassword").toCharArray());
            }
        });
        System.setProperty("http.useProxy", "true");
        System.setProperty("https.proxyHost", "localhost");
        System.setProperty("https.proxyPort", "3128");
        String user = "USER";
        String passwd = "PASSWORD";
        Properties _connectionProperties = new Properties();
        _connectionProperties.put("user", user);
        _connectionProperties.put("password", passwd);
        _connectionProperties.put("role", "accountadmin");
        _connectionProperties.put("database", "SNOWHOUSE_IMPORT");
        _connectionProperties.put("schema", "DEV");
        Class.forName("net.snowflake.client.jdbc.SnowflakeDriver");
        long counter = 0L;
        Connection con = DriverManager.getConnection(connectionUrl, _connectionProperties);
        Statement stmt = con.createStatement();
        stmt.execute("use warehouse TINY_WAREHOUSE");
        stmt.execute("CREATE OR REPLACE STAGE testPutGet_stage");
        Assert.assertTrue((String)"Failed to put a file", (boolean)stmt.execute("PUT file://" + AbstractDriverIT.getFullPathFileInResource("orders_100.csv") + " @testPutGet_stage"));
        String sql = "select $1 from values(1),(3),(5),(7)";
        ResultSet res = stmt.executeQuery(sql);
        while (res.next()) {
            System.out.println("value: " + res.getInt(1));
        }
        System.out.println("OK - " + counter);
        con.close();
        ++counter;
    }

    @Test
    @Ignore
    public void testProxyConnectionWithAzure() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL";
        this.runAzureProxyConnection(connectionUrl, true, true);
    }

    @Test
    @Ignore
    public void testProxyConnectionWithAzureWithConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=8080&proxyUser=testuser1&proxyPassword=test&useProxy=true";
        this.runAzureProxyConnection(connectionUrl, false, true);
    }

    @Test
    @Ignore
    public void testProxyConnectionWithoutProxyPortOrHost() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=&proxyUser=testuser1&proxyPassword=test&useProxy=true";
        try {
            this.runAzureProxyConnection(connectionUrl, false, true);
            TestCase.fail();
        }
        catch (SQLException e) {
            TestCase.assertEquals((String)"08000", (String)e.getSQLState());
        }
        connectionUrl = "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=cheese&proxyUser=testuser1&proxyPassword=test&useProxy=true";
        try {
            this.runAzureProxyConnection(connectionUrl, false, true);
            TestCase.fail();
        }
        catch (SQLException e) {
            TestCase.assertEquals((String)"08000", (String)e.getSQLState());
        }
        connectionUrl = "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL&proxyHost=&proxyPort=3128&proxyUser=testuser1&proxyPassword=test&useProxy=true";
        try {
            this.runAzureProxyConnection(connectionUrl, false, true);
            TestCase.fail();
        }
        catch (SQLException e) {
            TestCase.assertEquals((String)"08000", (String)e.getSQLState());
        }
        connectionUrl = "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL&proxyUser=testuser1&proxyPassword=test&useProxy=true";
        try {
            this.runAzureProxyConnection(connectionUrl, false, true);
            TestCase.fail();
        }
        catch (SQLException e) {
            TestCase.assertEquals((String)"08000", (String)e.getSQLState());
        }
    }

    @Test
    @Ignore
    public void testProxyConnectionWithJVMParameters() throws SQLException, ClassNotFoundException {
        String connectionUrl = "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL";
        System.setProperty("http.useProxy", "true");
        System.setProperty("http.proxyHost", "localhost");
        System.setProperty("http.proxyPort", "8080");
        System.setProperty("http.nonProxyHosts", "*.snowflakecomputing.com");
        SnowflakeUtil.systemSetEnv((String)"NO_PROXY", (String)"*.google.com");
        this.runAzureProxyConnection(connectionUrl, false, false);
        SnowflakeUtil.systemUnsetEnv((String)"NO_PROXY");
    }

    @Test
    @Ignore
    public void testProxyConnectionWithAzureWithWrongConnectionString() throws ClassNotFoundException {
        String connectionUrl = "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=31281&proxyUser=testuser1&proxyPassword=test&nonProxyHosts=*.foo.com%7Clocalhost&useProxy=true";
        try {
            this.runAzureProxyConnection(connectionUrl, false, true);
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((String)"JDBC driver encountered communication error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
        }
    }

    @Test
    @Ignore
    public void testSetJVMProxyHttp() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        System.setProperty("http.useProxy", "true");
        System.setProperty("http.proxyHost", "localhost");
        System.setProperty("http.proxyPort", "3128");
        System.setProperty("http.nonProxyHosts", "*");
        System.setProperty("http.proxyProtocol", "http");
        Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
        HttpClientSettingsKey clientSettingsKey = sfSession.getHttpClientKey();
        TestCase.assertEquals((Object)Protocol.HTTP, (Object)clientSettingsKey.getProxyProtocol());
        con.close();
    }

    @Test
    @Ignore
    public void testSetJVMProxyHttps() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        System.setProperty("http.useProxy", "true");
        System.setProperty("https.proxyHost", "localhost");
        System.setProperty("https.proxyPort", "3128");
        System.setProperty("http.nonProxyHosts", "*");
        System.setProperty("http.proxyProtocol", "https");
        Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
        HttpClientSettingsKey clientSettingsKey = sfSession.getHttpClientKey();
        TestCase.assertEquals((Object)Protocol.HTTPS, (Object)clientSettingsKey.getProxyProtocol());
        con.close();
    }

    @Test
    @Ignore
    public void testSetJVMProxyDefaultHttps() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        System.setProperty("http.useProxy", "true");
        System.setProperty("https.proxyHost", "localhost");
        System.setProperty("https.proxyPort", "3128");
        System.setProperty("http.nonProxyHosts", "*");
        Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
        HttpClientSettingsKey clientSettingsKey = sfSession.getHttpClientKey();
        TestCase.assertEquals((Object)Protocol.HTTPS, (Object)clientSettingsKey.getProxyProtocol());
        con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAzureProxyConnection(String connectionUrl, boolean usesProperties, boolean usesIncorrectJVMProperties) throws ClassNotFoundException, SQLException {
        Authenticator.setDefault(new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                System.out.println("RequestorType: " + (Object)((Object)this.getRequestorType()));
                System.out.println("Protocol: " + this.getRequestingProtocol().toLowerCase());
                return new PasswordAuthentication(SnowflakeUtil.systemGetProperty((String)"http.proxyUser"), SnowflakeUtil.systemGetProperty((String)"http.proxyPassword").toCharArray());
            }
        });
        if (usesIncorrectJVMProperties) {
            System.setProperty("http.useProxy", "true");
            System.setProperty("http.proxyHost", "fakehost");
            System.setProperty("http.proxyPort", "8081");
            System.setProperty("https.proxyHost", "fakehost");
            System.setProperty("https.proxyPort", "8081");
        }
        String user = "USER";
        String passwd = "PASSWORD";
        Properties _connectionProperties = new Properties();
        _connectionProperties.put("user", user);
        _connectionProperties.put("password", passwd);
        _connectionProperties.put("role", "SYSADMIN");
        _connectionProperties.put("tracing", "ALL");
        if (usesProperties) {
            _connectionProperties.put("useProxy", (Object)true);
            _connectionProperties.put("proxyHost", "localhost");
            _connectionProperties.put("proxyPort", "8080");
            _connectionProperties.put("proxyUser", "testuser1");
            _connectionProperties.put("proxyPassword", "test");
        }
        Class.forName("net.snowflake.client.jdbc.SnowflakeDriver");
        String fileName = "test_copy.csv";
        Connection con = DriverManager.getConnection(connectionUrl, _connectionProperties);
        Statement stmt = con.createStatement();
        stmt.execute("create or replace warehouse MEGTEST");
        stmt.execute("use database MEGDB");
        stmt.execute("use schema MEGSCHEMA");
        stmt.execute("CREATE OR REPLACE STAGE testPutGet_stage");
        try {
            String TEST_DATA_FILE = "orders_100.csv";
            String sourceFilePath = AbstractDriverIT.getFullPathFileInResource(TEST_DATA_FILE);
            File destFolder = this.tmpFolder.newFolder();
            String destFolderCanonicalPath = destFolder.getCanonicalPath();
            String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
            Assert.assertTrue((String)"Failed to put a file", (boolean)stmt.execute("PUT file://" + sourceFilePath + " @testPutGet_stage"));
            SnowflakeDriverIT.findFile(stmt, "ls @testPutGet_stage/");
            Assert.assertTrue((String)"Failed to get a file", (boolean)stmt.execute("GET @testPutGet_stage 'file://" + destFolderCanonicalPath + "' parallel=8"));
            File downloaded = new File(destFolderCanonicalPathWithSeparator + TEST_DATA_FILE + ".gz");
            assert (downloaded.exists());
            Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + TEST_DATA_FILE + ".gz");
            p.waitFor();
            File original = new File(sourceFilePath);
            File unzipped = new File(destFolderCanonicalPathWithSeparator + TEST_DATA_FILE);
            assert (original.length() == unzipped.length());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            stmt.execute("DROP STAGE IF EXISTS testGetPut_stage");
            stmt.close();
        }
    }
}

