/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.TestUtil;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.DBMetadataResultSetMetadata;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaData;
import net.snowflake.client.jdbc.SnowflakeType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public class DatabaseMetaDataIT
extends BaseJDBCTest {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)(?:\\.\\d+)+\\s*.*");
    private static final String PI_PROCEDURE = "create or replace procedure GETPI()\n    returns float not null\n    language javascript\n    as\n    $$\n    return 3.1415926;\n    $$\n    ;";
    private static final String STPROC1_PROCEDURE = "create or replace procedure stproc1(param1 float, param2 string)\n    returns table(retval varchar)\n    language javascript\n    as\n    $$\n    var sql_command = \"Hello, world!\"\n    $$\n    ;";

    @Test
    public void testGetConnection() throws SQLException {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Assert.assertEquals((Object)connection, (Object)metaData.getConnection());
        }
    }

    @Test
    public void testDatabaseAndDriverInfo() throws SQLException {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Assert.assertEquals((long)1L, (long)metaData.getJDBCMajorVersion());
            Assert.assertEquals((long)0L, (long)metaData.getJDBCMinorVersion());
            Assert.assertEquals((Object)"Snowflake", (Object)metaData.getDatabaseProductName());
            Assert.assertEquals((Object)"Snowflake", (Object)metaData.getDriverName());
            String driverVersion = metaData.getDriverVersion();
            java.util.regex.Matcher m = VERSION_PATTERN.matcher(driverVersion);
            Assert.assertTrue((boolean)m.matches());
            int majorVersion = metaData.getDriverMajorVersion();
            int minorVersion = metaData.getDriverMinorVersion();
            Assert.assertEquals((Object)m.group(1), (Object)String.valueOf(majorVersion));
            Assert.assertEquals((Object)m.group(2), (Object)String.valueOf(minorVersion));
        }
    }

    @Test
    public void testGetCatalogs() throws SQLException {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Assert.assertEquals((Object)".", (Object)metaData.getCatalogSeparator());
            Assert.assertEquals((Object)"database", (Object)metaData.getCatalogTerm());
            ResultSet resultSet = metaData.getCatalogs();
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_CATALOGS);
            Assert.assertTrue((boolean)resultSet.isBeforeFirst());
            int cnt = 0;
            HashSet<String> allVisibleDatabases = new HashSet<String>();
            while (resultSet.next()) {
                allVisibleDatabases.add(resultSet.getString(1));
                if (cnt == 0) {
                    Assert.assertTrue((boolean)resultSet.isFirst());
                }
                ++cnt;
                try {
                    resultSet.isLast();
                    Assert.fail((String)"No isLast support for query based metadata");
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                    // empty catch block
                }
                try {
                    resultSet.isAfterLast();
                    Assert.fail((String)"No isAfterLast support for query based metadata");
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {}
            }
            Assert.assertThat((Object)cnt, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
            try {
                Assert.assertTrue((boolean)resultSet.isAfterLast());
                Assert.fail((String)"The result set is automatically closed when all rows are fetched.");
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)ErrorCode.RESULTSET_ALREADY_CLOSED.getMessageCode().intValue(), (long)ex.getErrorCode());
            }
            try {
                resultSet.isAfterLast();
                Assert.fail((String)"No isAfterLast support for query based metadata");
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)ErrorCode.RESULTSET_ALREADY_CLOSED.getMessageCode().intValue(), (long)ex.getErrorCode());
            }
            resultSet.close();
            resultSet.next();
            List<String> allAccessibleDatabases = this.getInfoBySQL("select database_name from information_schema.databases");
            Assert.assertTrue((boolean)allVisibleDatabases.containsAll(allAccessibleDatabases));
        }
    }

    @Test
    public void testGetSchemas() throws Throwable {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Assert.assertEquals((Object)"schema", (Object)metaData.getSchemaTerm());
            ResultSet resultSet = metaData.getSchemas();
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_SCHEMAS);
            HashSet<String> schemas = new HashSet<String>();
            while (resultSet.next()) {
                schemas.add(resultSet.getString(1));
            }
            resultSet.close();
            Assert.assertThat((Object)schemas.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
            HashSet<String> schemasInDb = new HashSet<String>();
            resultSet = metaData.getSchemas(connection.getCatalog(), "%");
            while (resultSet.next()) {
                schemasInDb.add(resultSet.getString(1));
            }
            Assert.assertThat((Object)schemasInDb.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
            Assert.assertThat((Object)schemas.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(schemasInDb.size())));
            Assert.assertTrue((boolean)schemas.containsAll(schemasInDb));
            Assert.assertTrue((boolean)schemas.contains(connection.getSchema()));
        }
        connection = DatabaseMetaDataIT.getConnection();
        try {
            Statement statement = connection.createStatement();
            statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
            DatabaseMetaData metaData = connection.getMetaData();
            Assert.assertEquals((Object)"schema", (Object)metaData.getSchemaTerm());
            ResultSet resultSet = metaData.getSchemas();
            HashSet<String> schemas = new HashSet<String>();
            while (resultSet.next()) {
                schemas.add(resultSet.getString(1));
            }
            Assert.assertThat((Object)schemas.size(), (Matcher)Matchers.equalTo((Object)1));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testGetTableTypes() throws Throwable {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getTableTypes();
            HashSet<String> types = new HashSet<String>();
            while (resultSet.next()) {
                types.add(resultSet.getString(1));
            }
            Assert.assertEquals((long)2L, (long)types.size());
            Assert.assertTrue((boolean)types.contains("TABLE"));
            Assert.assertTrue((boolean)types.contains("VIEW"));
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetTables() throws Throwable {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable = "T0";
            String targetView = "V0";
            connection.createStatement().execute("create or replace table T0(C1 int)");
            connection.createStatement().execute("create or replace view V0 as select 1 as C");
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getTables(database, schema, "%", new String[]{"TABLE"});
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_TABLES);
            HashSet<String> tables = new HashSet<String>();
            while (resultSet.next()) {
                tables.add(resultSet.getString(3));
            }
            Assert.assertTrue((boolean)tables.contains("T0"));
            resultSet = metaData.getTables(database, schema, "T0", new String[]{"TABLE"});
            tables = new HashSet();
            while (resultSet.next()) {
                tables.add(resultSet.getString(3));
            }
            Assert.assertEquals((Object)"T0", tables.iterator().next());
            resultSet = metaData.getTables(database, schema, "%", new String[]{"VIEW"});
            HashSet<String> views = new HashSet<String>();
            while (resultSet.next()) {
                views.add(resultSet.getString(3));
            }
            Assert.assertTrue((boolean)views.contains("V0"));
            resultSet = metaData.getTablePrivileges(database, schema, "T0");
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
            connection.createStatement().execute("drop table if exists T0");
            connection.createStatement().execute("drop view if exists V0");
        }
    }

    @Test
    public void testGetPrimarykeys() throws Throwable {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable = "T0";
            connection.createStatement().execute("create or replace table T0(C1 int primary key, C2 string)");
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getPrimaryKeys(database, schema, "T0");
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_PRIMARY_KEYS);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString("TABLE_NAME"));
            Assert.assertEquals((Object)"C1", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("KEY_SEQ"));
            Assert.assertNotEquals((Object)"", (Object)resultSet.getString("PK_NAME"));
            connection.createStatement().execute("drop table if exists T0");
        }
    }

    static void verifyResultSetMetaDataColumns(ResultSet resultSet, DBMetadataResultSetMetadata metadata) throws SQLException {
        int numCol = metadata.getColumnNames().size();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((long)numCol, (long)resultSetMetaData.getColumnCount());
        for (int col = 1; col <= numCol; ++col) {
            List colNames = metadata.getColumnNames();
            List colTypeNames = metadata.getColumnTypeNames();
            List colTypes = metadata.getColumnTypes();
            Assert.assertEquals((Object)"", (Object)resultSetMetaData.getCatalogName(col));
            Assert.assertEquals((Object)"", (Object)resultSetMetaData.getSchemaName(col));
            Assert.assertEquals((Object)"T", (Object)resultSetMetaData.getTableName(col));
            Assert.assertEquals(colNames.get(col - 1), (Object)resultSetMetaData.getColumnName(col));
            Assert.assertEquals(colNames.get(col - 1), (Object)resultSetMetaData.getColumnLabel(col));
            Assert.assertEquals((Object)SnowflakeType.javaTypeToClassName((int)resultSetMetaData.getColumnType(col)), (Object)resultSetMetaData.getColumnClassName(col));
            Assert.assertEquals((long)25L, (long)resultSetMetaData.getColumnDisplaySize(col));
            Assert.assertEquals((long)((Integer)colTypes.get(col - 1)).intValue(), (long)resultSetMetaData.getColumnType(col));
            Assert.assertEquals(colTypeNames.get(col - 1), (Object)resultSetMetaData.getColumnTypeName(col));
            Assert.assertEquals((long)9L, (long)resultSetMetaData.getPrecision(col));
            Assert.assertEquals((long)9L, (long)resultSetMetaData.getScale(col));
            Assert.assertEquals((Object)SnowflakeType.isJavaTypeSigned((int)resultSetMetaData.getColumnType(col)), (Object)resultSetMetaData.isSigned(col));
            Assert.assertFalse((boolean)resultSetMetaData.isAutoIncrement(col));
            Assert.assertFalse((boolean)resultSetMetaData.isCurrency(col));
            Assert.assertTrue((boolean)resultSetMetaData.isReadOnly(col));
            Assert.assertTrue((boolean)resultSetMetaData.isSearchable(col));
            Assert.assertFalse((boolean)resultSetMetaData.isWritable(col));
            Assert.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(col));
            Assert.assertEquals((long)2L, (long)resultSetMetaData.isNullable(col));
        }
    }

    @Test
    public void testGetImportedKeys() throws Throwable {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable1 = "T0";
            String targetTable2 = "T1";
            connection.createStatement().execute("create or replace table T0(C1 int primary key, C2 string)");
            connection.createStatement().execute("create or replace table T1(C1 int primary key, C2 string, C3 int references T0)");
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getImportedKeys(database, schema, "T1");
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_FOREIGN_KEYS);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("PKTABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("PKTABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString("PKTABLE_NAME"));
            Assert.assertEquals((Object)"C1", (Object)resultSet.getString("PKCOLUMN_NAME"));
            Assert.assertEquals((Object)database, (Object)resultSet.getString("FKTABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("FKTABLE_SCHEM"));
            Assert.assertEquals((Object)"T1", (Object)resultSet.getString("FKTABLE_NAME"));
            Assert.assertEquals((Object)"C3", (Object)resultSet.getString("FKCOLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("KEY_SEQ"));
            Assert.assertNotEquals((Object)"", (Object)resultSet.getString("PK_NAME"));
            Assert.assertNotEquals((Object)"", (Object)resultSet.getString("FK_NAME"));
            Assert.assertEquals((long)3L, (long)resultSet.getShort("UPDATE_RULE"));
            Assert.assertEquals((long)3L, (long)resultSet.getShort("DELETE_RULE"));
            Assert.assertEquals((long)7L, (long)resultSet.getShort("DEFERRABILITY"));
            connection.createStatement().execute("drop table if exists T0");
            connection.createStatement().execute("drop table if exists T1");
        }
    }

    @Test
    public void testGetExportedKeys() throws Throwable {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable1 = "T0";
            String targetTable2 = "T1";
            connection.createStatement().execute("create or replace table T0(C1 int primary key, C2 string)");
            connection.createStatement().execute("create or replace table T1(C1 int primary key, C2 string, C3 int references T0)");
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getExportedKeys(database, schema, "T0");
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_FOREIGN_KEYS);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("PKTABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("PKTABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString("PKTABLE_NAME"));
            Assert.assertEquals((Object)"C1", (Object)resultSet.getString("PKCOLUMN_NAME"));
            Assert.assertEquals((Object)database, (Object)resultSet.getString("FKTABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("FKTABLE_SCHEM"));
            Assert.assertEquals((Object)"T1", (Object)resultSet.getString("FKTABLE_NAME"));
            Assert.assertEquals((Object)"C3", (Object)resultSet.getString("FKCOLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("KEY_SEQ"));
            Assert.assertNotEquals((Object)"", (Object)resultSet.getString("PK_NAME"));
            Assert.assertNotEquals((Object)"", (Object)resultSet.getString("FK_NAME"));
            Assert.assertEquals((long)3L, (long)resultSet.getShort("UPDATE_RULE"));
            Assert.assertEquals((long)3L, (long)resultSet.getShort("DELETE_RULE"));
            Assert.assertEquals((long)7L, (long)resultSet.getShort("DEFERRABILITY"));
            connection.createStatement().execute("drop table if exists T0");
            connection.createStatement().execute("drop table if exists T1");
        }
    }

    @Test
    public void testGetCrossReferences() throws Throwable {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable1 = "T0";
            String targetTable2 = "T1";
            connection.createStatement().execute("create or replace table T0(C1 int primary key, C2 string)");
            connection.createStatement().execute("create or replace table T1(C1 int primary key, C2 string, C3 int references T0)");
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getCrossReference(database, schema, "T0", database, schema, "T1");
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_FOREIGN_KEYS);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("PKTABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("PKTABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString("PKTABLE_NAME"));
            Assert.assertEquals((Object)"C1", (Object)resultSet.getString("PKCOLUMN_NAME"));
            Assert.assertEquals((Object)database, (Object)resultSet.getString("FKTABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("FKTABLE_SCHEM"));
            Assert.assertEquals((Object)"T1", (Object)resultSet.getString("FKTABLE_NAME"));
            Assert.assertEquals((Object)"C3", (Object)resultSet.getString("FKCOLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("KEY_SEQ"));
            Assert.assertNotEquals((Object)"", (Object)resultSet.getString("PK_NAME"));
            Assert.assertNotEquals((Object)"", (Object)resultSet.getString("FK_NAME"));
            Assert.assertEquals((long)3L, (long)resultSet.getShort("UPDATE_RULE"));
            Assert.assertEquals((long)3L, (long)resultSet.getShort("DELETE_RULE"));
            Assert.assertEquals((long)7L, (long)resultSet.getShort("DEFERRABILITY"));
            connection.createStatement().execute("drop table if exists T0");
            connection.createStatement().execute("drop table if exists T1");
        }
    }

    @Test
    public void testGetObjectsDoesNotExists() throws Throwable {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable = "T0";
            String targetView = "V0";
            connection.createStatement().execute("create or replace table T0(C1 int)");
            connection.createStatement().execute("create or replace view V0 as select 1 as C");
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getTables(database, schema, "%", null);
            Assert.assertTrue((this.getSizeOfResultSet(resultSet) > 0 ? 1 : 0) != 0);
            resultSet = metaData.getTables(database, schema, "%", new String[]{"INVALID_TYPE"});
            Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(resultSet));
            resultSet = metaData.getSchemas("DB_NOT_EXIST", "SCHEMA_NOT_EXIST");
            Assert.assertFalse((boolean)resultSet.next());
            Assert.assertTrue((boolean)resultSet.isClosed());
            resultSet = metaData.getTables("DB_NOT_EXIST", "SCHEMA_NOT_EXIST", "%", null);
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metaData.getTables(database, "SCHEMA\\_NOT\\_EXIST", "%", null);
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metaData.getColumns("DB_NOT_EXIST", "SCHEMA_NOT_EXIST", "%", "%");
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metaData.getColumns(database, "SCHEMA\\_NOT\\_EXIST", "%", "%");
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metaData.getColumns(database, schema, "TBL\\_NOT\\_EXIST", "%");
            Assert.assertFalse((boolean)resultSet.next());
            connection.createStatement().execute("drop table if exists T0");
            connection.createStatement().execute("drop view if exists V0");
        }
    }

    @Test
    public void testTypeInfo() throws SQLException {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getTypeInfo();
            resultSet.next();
            Assert.assertEquals((Object)"NUMBER", (Object)resultSet.getString(1));
            resultSet.next();
            Assert.assertEquals((Object)"INTEGER", (Object)resultSet.getString(1));
            resultSet.next();
            Assert.assertEquals((Object)"DOUBLE", (Object)resultSet.getString(1));
            resultSet.next();
            Assert.assertEquals((Object)"VARCHAR", (Object)resultSet.getString(1));
            resultSet.next();
            Assert.assertEquals((Object)"DATE", (Object)resultSet.getString(1));
            resultSet.next();
            Assert.assertEquals((Object)"TIME", (Object)resultSet.getString(1));
            resultSet.next();
            Assert.assertEquals((Object)"TIMESTAMP", (Object)resultSet.getString(1));
            resultSet.next();
            Assert.assertEquals((Object)"BOOLEAN", (Object)resultSet.getString(1));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    @Test
    public void testProcedure() throws Throwable {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Assert.assertEquals((Object)"procedure", (Object)metaData.getProcedureTerm());
            Assert.assertTrue((boolean)metaData.supportsStoredProcedures());
            ResultSet resultSet = metaData.getProcedureColumns("%", "%", "%", "%");
            Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(resultSet));
            resultSet = metaData.getProcedures("%", "%", "%");
            Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(resultSet));
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetTablePrivileges() throws Exception {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            connection.createStatement().execute("create or replace table PRIVTEST(colA string, colB number, colC timestamp)");
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getTablePrivileges(database, schema, "PRIVTEST");
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_TABLE_PRIVILEGES);
            resultSet.next();
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"PRIVTEST", (Object)resultSet.getString("TABLE_NAME"));
            Assert.assertEquals((Object)"SYSADMIN", (Object)resultSet.getString("GRANTOR"));
            Assert.assertEquals((Object)"SYSADMIN", (Object)resultSet.getString("GRANTEE"));
            Assert.assertEquals((Object)"OWNERSHIP", (Object)resultSet.getString("PRIVILEGE"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_GRANTABLE"));
            connection.createStatement().execute("grant select on table PRIVTEST to role securityadmin");
            resultSet = metaData.getTablePrivileges(database, schema, "PRIVTEST");
            resultSet.next();
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"PRIVTEST", (Object)resultSet.getString("TABLE_NAME"));
            Assert.assertEquals((Object)"SYSADMIN", (Object)resultSet.getString("GRANTOR"));
            Assert.assertEquals((Object)"SYSADMIN", (Object)resultSet.getString("GRANTEE"));
            Assert.assertEquals((Object)"OWNERSHIP", (Object)resultSet.getString("PRIVILEGE"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_GRANTABLE"));
            resultSet.next();
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"PRIVTEST", (Object)resultSet.getString("TABLE_NAME"));
            Assert.assertEquals((Object)"SYSADMIN", (Object)resultSet.getString("GRANTOR"));
            Assert.assertEquals((Object)"SECURITYADMIN", (Object)resultSet.getString("GRANTEE"));
            Assert.assertEquals((Object)"SELECT", (Object)resultSet.getString("PRIVILEGE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GRANTABLE"));
            resultSet = metaData.getTablePrivileges(null, null, null);
            Assert.assertEquals((long)7L, (long)resultSet.getMetaData().getColumnCount());
            Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(resultSet));
            connection.createStatement().execute("drop table if exists PRIVTEST");
        }
    }

    @Test
    public void testGetProcedures() throws SQLException {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            connection.createStatement().execute(PI_PROCEDURE);
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getProcedures(database, schema, "GETPI");
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_PROCEDURES);
            resultSet.next();
            Assert.assertEquals((Object)"GETPI", (Object)resultSet.getString("PROCEDURE_NAME"));
            Assert.assertEquals((Object)database, (Object)resultSet.getString("PROCEDURE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("PROCEDURE_SCHEM"));
            Assert.assertEquals((Object)"GETPI", (Object)resultSet.getString("PROCEDURE_NAME"));
            Assert.assertEquals((Object)"user-defined procedure", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)2L, (long)resultSet.getShort("PROCEDURE_TYPE"));
            Assert.assertEquals((Object)"GETPI() RETURN FLOAT", (Object)resultSet.getString("SPECIFIC_NAME"));
            connection.createStatement().execute("drop procedure if exists GETPI()");
        }
    }

    @Test
    public void testDatabaseMetadata() throws SQLException {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            String dbVersion = metaData.getDatabaseProductVersion();
            java.util.regex.Matcher m = VERSION_PATTERN.matcher(dbVersion);
            Assert.assertTrue((boolean)m.matches());
            int majorVersion = metaData.getDatabaseMajorVersion();
            int minorVersion = metaData.getDatabaseMinorVersion();
            Assert.assertEquals((Object)m.group(1), (Object)String.valueOf(majorVersion));
            Assert.assertEquals((Object)m.group(2), (Object)String.valueOf(minorVersion));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)metaData.getSQLKeywords()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)metaData.getNumericFunctions()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)metaData.getStringFunctions()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)metaData.getSystemFunctions()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)metaData.getTimeDateFunctions()));
            Assert.assertEquals((Object)"\\", (Object)metaData.getSearchStringEscape());
            Assert.assertTrue((boolean)metaData.getURL().startsWith("jdbc:snowflake://"));
            Assert.assertFalse((boolean)metaData.allProceduresAreCallable());
            Assert.assertTrue((boolean)metaData.allTablesAreSelectable());
            Assert.assertTrue((boolean)metaData.dataDefinitionCausesTransactionCommit());
            Assert.assertFalse((boolean)metaData.dataDefinitionIgnoredInTransactions());
            Assert.assertFalse((boolean)metaData.deletesAreDetected(1));
            Assert.assertTrue((boolean)metaData.doesMaxRowSizeIncludeBlobs());
            Assert.assertTrue((boolean)metaData.supportsTransactions());
            Assert.assertEquals((long)2L, (long)metaData.getDefaultTransactionIsolation());
            Assert.assertEquals((Object)"$", (Object)metaData.getExtraNameCharacters());
            Assert.assertEquals((Object)"\"", (Object)metaData.getIdentifierQuoteString());
            Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(metaData.getIndexInfo(null, null, null, true, true)));
            Assert.assertEquals((long)0x800000L, (long)metaData.getMaxBinaryLiteralLength());
            Assert.assertEquals((long)255L, (long)metaData.getMaxCatalogNameLength());
            Assert.assertEquals((long)0x1000000L, (long)metaData.getMaxCharLiteralLength());
            Assert.assertEquals((long)255L, (long)metaData.getMaxColumnNameLength());
            Assert.assertEquals((long)0L, (long)metaData.getMaxColumnsInGroupBy());
            Assert.assertEquals((long)0L, (long)metaData.getMaxColumnsInIndex());
            Assert.assertEquals((long)0L, (long)metaData.getMaxColumnsInOrderBy());
            Assert.assertEquals((long)0L, (long)metaData.getMaxColumnsInSelect());
            Assert.assertEquals((long)0L, (long)metaData.getMaxColumnsInTable());
            Assert.assertEquals((long)0L, (long)metaData.getMaxConnections());
            Assert.assertEquals((long)0L, (long)metaData.getMaxCursorNameLength());
            Assert.assertEquals((long)0L, (long)metaData.getMaxIndexLength());
            Assert.assertEquals((long)0L, (long)metaData.getMaxProcedureNameLength());
            Assert.assertEquals((long)0L, (long)metaData.getMaxRowSize());
            Assert.assertEquals((long)255L, (long)metaData.getMaxSchemaNameLength());
            Assert.assertEquals((long)0L, (long)metaData.getMaxStatementLength());
            Assert.assertEquals((long)0L, (long)metaData.getMaxStatements());
            Assert.assertEquals((long)255L, (long)metaData.getMaxTableNameLength());
            Assert.assertEquals((long)0L, (long)metaData.getMaxTablesInSelect());
            Assert.assertEquals((long)255L, (long)metaData.getMaxUserNameLength());
            Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(metaData.getTablePrivileges(null, null, null)));
            Assert.assertEquals((Object)TestUtil.systemGetEnv("SNOWFLAKE_TEST_USER"), (Object)metaData.getUserName());
            Assert.assertFalse((boolean)metaData.insertsAreDetected(1));
            Assert.assertTrue((boolean)metaData.isCatalogAtStart());
            Assert.assertFalse((boolean)metaData.isReadOnly());
            Assert.assertTrue((boolean)metaData.nullPlusNonNullIsNull());
            Assert.assertFalse((boolean)metaData.nullsAreSortedAtEnd());
            Assert.assertFalse((boolean)metaData.nullsAreSortedAtStart());
            Assert.assertTrue((boolean)metaData.nullsAreSortedHigh());
            Assert.assertFalse((boolean)metaData.nullsAreSortedLow());
            Assert.assertFalse((boolean)metaData.othersDeletesAreVisible(1));
            Assert.assertFalse((boolean)metaData.othersInsertsAreVisible(1));
            Assert.assertFalse((boolean)metaData.othersUpdatesAreVisible(1));
            Assert.assertFalse((boolean)metaData.ownDeletesAreVisible(1));
            Assert.assertFalse((boolean)metaData.ownInsertsAreVisible(1));
            Assert.assertFalse((boolean)metaData.ownUpdatesAreVisible(1004));
            Assert.assertFalse((boolean)metaData.storesLowerCaseIdentifiers());
            Assert.assertFalse((boolean)metaData.storesLowerCaseQuotedIdentifiers());
            Assert.assertFalse((boolean)metaData.storesMixedCaseIdentifiers());
            Assert.assertTrue((boolean)metaData.storesMixedCaseQuotedIdentifiers());
            Assert.assertTrue((boolean)metaData.storesUpperCaseIdentifiers());
            Assert.assertFalse((boolean)metaData.storesUpperCaseQuotedIdentifiers());
            Assert.assertTrue((boolean)metaData.supportsAlterTableWithAddColumn());
            Assert.assertTrue((boolean)metaData.supportsAlterTableWithDropColumn());
            Assert.assertTrue((boolean)metaData.supportsANSI92EntryLevelSQL());
            Assert.assertFalse((boolean)metaData.supportsANSI92FullSQL());
            Assert.assertFalse((boolean)metaData.supportsANSI92IntermediateSQL());
            Assert.assertTrue((boolean)metaData.supportsBatchUpdates());
            Assert.assertTrue((boolean)metaData.supportsCatalogsInDataManipulation());
            Assert.assertFalse((boolean)metaData.supportsCatalogsInIndexDefinitions());
            Assert.assertFalse((boolean)metaData.supportsCatalogsInPrivilegeDefinitions());
            Assert.assertFalse((boolean)metaData.supportsCatalogsInProcedureCalls());
            Assert.assertTrue((boolean)metaData.supportsCatalogsInTableDefinitions());
            Assert.assertTrue((boolean)metaData.supportsColumnAliasing());
            Assert.assertFalse((boolean)metaData.supportsConvert());
            Assert.assertFalse((boolean)metaData.supportsConvert(1, 2));
            Assert.assertFalse((boolean)metaData.supportsCoreSQLGrammar());
            Assert.assertTrue((boolean)metaData.supportsCorrelatedSubqueries());
            Assert.assertTrue((boolean)metaData.supportsDataDefinitionAndDataManipulationTransactions());
            Assert.assertFalse((boolean)metaData.supportsDataManipulationTransactionsOnly());
            Assert.assertFalse((boolean)metaData.supportsDifferentTableCorrelationNames());
            Assert.assertTrue((boolean)metaData.supportsExpressionsInOrderBy());
            Assert.assertFalse((boolean)metaData.supportsExtendedSQLGrammar());
            Assert.assertTrue((boolean)metaData.supportsFullOuterJoins());
            Assert.assertFalse((boolean)metaData.supportsGetGeneratedKeys());
            Assert.assertTrue((boolean)metaData.supportsGroupBy());
            Assert.assertTrue((boolean)metaData.supportsGroupByBeyondSelect());
            Assert.assertFalse((boolean)metaData.supportsGroupByUnrelated());
            Assert.assertFalse((boolean)metaData.supportsIntegrityEnhancementFacility());
            Assert.assertFalse((boolean)metaData.supportsLikeEscapeClause());
            Assert.assertTrue((boolean)metaData.supportsLimitedOuterJoins());
            Assert.assertFalse((boolean)metaData.supportsMinimumSQLGrammar());
            Assert.assertFalse((boolean)metaData.supportsMixedCaseIdentifiers());
            Assert.assertTrue((boolean)metaData.supportsMixedCaseQuotedIdentifiers());
            Assert.assertFalse((boolean)metaData.supportsMultipleOpenResults());
            Assert.assertFalse((boolean)metaData.supportsMultipleResultSets());
            Assert.assertTrue((boolean)metaData.supportsMultipleTransactions());
            Assert.assertFalse((boolean)metaData.supportsNamedParameters());
            Assert.assertTrue((boolean)metaData.supportsNonNullableColumns());
            Assert.assertFalse((boolean)metaData.supportsOpenCursorsAcrossCommit());
            Assert.assertFalse((boolean)metaData.supportsOpenCursorsAcrossRollback());
            Assert.assertFalse((boolean)metaData.supportsOpenStatementsAcrossCommit());
            Assert.assertFalse((boolean)metaData.supportsOpenStatementsAcrossRollback());
            Assert.assertTrue((boolean)metaData.supportsOrderByUnrelated());
            Assert.assertTrue((boolean)metaData.supportsOuterJoins());
            Assert.assertFalse((boolean)metaData.supportsPositionedDelete());
            Assert.assertFalse((boolean)metaData.supportsPositionedUpdate());
            Assert.assertTrue((boolean)metaData.supportsResultSetConcurrency(1003, 1007));
            Assert.assertFalse((boolean)metaData.supportsResultSetConcurrency(1004, 1007));
            Assert.assertTrue((boolean)metaData.supportsResultSetType(1003));
            Assert.assertTrue((boolean)metaData.supportsResultSetHoldability(2));
            Assert.assertFalse((boolean)metaData.supportsResultSetHoldability(1));
            Assert.assertEquals((long)2L, (long)metaData.getResultSetHoldability());
            Assert.assertFalse((boolean)metaData.supportsSavepoints());
            Assert.assertTrue((boolean)metaData.supportsSchemasInDataManipulation());
            Assert.assertFalse((boolean)metaData.supportsSchemasInIndexDefinitions());
            Assert.assertFalse((boolean)metaData.supportsSchemasInPrivilegeDefinitions());
            Assert.assertFalse((boolean)metaData.supportsSchemasInProcedureCalls());
            Assert.assertTrue((boolean)metaData.supportsSchemasInTableDefinitions());
            Assert.assertFalse((boolean)metaData.supportsSelectForUpdate());
            Assert.assertFalse((boolean)metaData.supportsStatementPooling());
            Assert.assertTrue((boolean)metaData.supportsStoredFunctionsUsingCallSyntax());
            Assert.assertTrue((boolean)metaData.supportsSubqueriesInComparisons());
            Assert.assertTrue((boolean)metaData.supportsSubqueriesInExists());
            Assert.assertTrue((boolean)metaData.supportsSubqueriesInIns());
            Assert.assertFalse((boolean)metaData.supportsSubqueriesInQuantifieds());
            Assert.assertTrue((boolean)metaData.supportsTableCorrelationNames());
            Assert.assertTrue((boolean)metaData.supportsTransactionIsolationLevel(2));
            Assert.assertFalse((boolean)metaData.supportsTransactionIsolationLevel(4));
            Assert.assertFalse((boolean)metaData.supportsTransactionIsolationLevel(8));
            Assert.assertFalse((boolean)metaData.supportsTransactionIsolationLevel(1));
            Assert.assertTrue((boolean)metaData.supportsUnion());
            Assert.assertTrue((boolean)metaData.supportsUnionAll());
            Assert.assertFalse((boolean)metaData.updatesAreDetected(1));
            Assert.assertFalse((boolean)metaData.usesLocalFilePerTable());
            Assert.assertFalse((boolean)metaData.usesLocalFiles());
        }
    }

    @Test
    public void testOtherEmptyTables() throws Throwable {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getIndexInfo(null, null, null, true, true);
            Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(resultSet));
            resultSet = metaData.getUDTs(null, null, null, new int[0]);
            Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(resultSet));
        }
    }

    @Test
    public void testFeatureNotSupportedException() throws Throwable {
        try (Connection connection = DatabaseMetaDataIT.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            this.expectFeatureNotSupportedException(() -> metaData.getBestRowIdentifier(null, null, null, 0, true));
            this.expectFeatureNotSupportedException(() -> metaData.getVersionColumns(null, null, null));
            this.expectFeatureNotSupportedException(() -> metaData.getSuperTypes(null, null, null));
            this.expectFeatureNotSupportedException(() -> metaData.getSuperTables(null, null, null));
            this.expectFeatureNotSupportedException(() -> metaData.getAttributes(null, null, null, null));
            this.expectFeatureNotSupportedException(metaData::getRowIdLifetime);
            this.expectFeatureNotSupportedException(metaData::autoCommitFailureClosesAllResultSets);
            this.expectFeatureNotSupportedException(metaData::getClientInfoProperties);
            this.expectFeatureNotSupportedException(() -> metaData.getPseudoColumns(null, null, null, null));
            this.expectFeatureNotSupportedException(metaData::generatedKeyAlwaysReturned);
            this.expectFeatureNotSupportedException(() -> metaData.isWrapperFor(SnowflakeDatabaseMetaData.class));
        }
    }
}

