/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.DBMetadataResultSetMetadata;
import net.snowflake.client.jdbc.DatabaseMetaDataIT;
import net.snowflake.client.jdbc.ErrorCode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public class DatabaseMetaDataInternalIT
extends BaseJDBCTest {
    private Connection connection;
    private Statement statement;
    private DatabaseMetaData databaseMetaData;
    private ResultSet resultSet;
    private static final String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    @Before
    public void setUp() throws SQLException {
        try (Connection con = DatabaseMetaDataInternalIT.getConnection();){
            DatabaseMetaDataInternalIT.initMetaData(con);
        }
    }

    static void initMetaData(Connection con) throws SQLException {
        try (Statement st = con.createStatement();){
            st.execute("create or replace database JDBC_DB1");
            st.execute("create or replace schema JDBC_SCHEMA11");
            st.execute("create or replace table JDBC_TBL111(colA string, colB decimal, colC timestamp)");
            st.execute("create or replace schema TEST_CTX");
            st.execute("create or replace table JDBC_A (colA string, colB decimal, colC number PRIMARY KEY);");
            st.execute("create or replace table JDBC_B (colA string, colB decimal, colC number FOREIGN KEY REFERENCES JDBC_A(colC));");
            st.execute("create or replace schema JDBC_SCHEMA12");
            st.execute("create or replace table JDBC_TBL121(colA varchar)");
            st.execute("create or replace table JDBC_TBL122(colA NUMBER(20, 2) AUTOINCREMENT comment 'cmt colA', colB NUMBER(20, 2) DEFAULT(3) NOT NULL, colC NUMBER(20,2) IDENTITY(20, 2))");
            st.execute("create or replace database JDBC_DB2");
            st.execute("create or replace schema JDBC_SCHEMA21");
            st.execute("create or replace table JDBC_TBL211(colA string)");
            st.execute("create or replace table JDBC_BIN(bin1 binary, bin2 binary(100))");
        }
    }

    @After
    public void tearDown() throws SQLException {
        try (Connection con = DatabaseMetaDataInternalIT.getConnection();){
            DatabaseMetaDataInternalIT.endMetaData(con);
        }
    }

    static void endMetaData(Connection con) throws SQLException {
        try (Statement st = con.createStatement();){
            st.execute("drop database if exists JDBC_DB1");
            st.execute("drop database if exists JDBC_DB2");
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetColumn() throws SQLException {
        String getAllColumnsCount = "select count(*) from db.information_schema.columns";
        this.connection = DatabaseMetaDataInternalIT.getConnection();
        this.statement = this.connection.createStatement();
        this.databaseMetaData = this.connection.getMetaData();
        this.resultSet = this.databaseMetaData.getColumns(null, null, null, null);
        Assert.assertEquals((long)this.getAllObjectCountInDBViaInforSchema(getAllColumnsCount), (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getColumns(null, "JDBC_SCHEMA11", null, null);
        Assert.assertEquals((long)3L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getColumns(null, "JDBC_SCH_MA11", null, null);
        Assert.assertEquals((long)3L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getColumns(null, "JDBC%", null, null);
        Assert.assertEquals((long)10L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getColumns(null, "JDBC_SCHEMA1_", null, null);
        Assert.assertEquals((long)7L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getColumns(null, "JDBC_SCHEMA21", "JDBC_BIN", "BIN1");
        this.resultSet.next();
        Assert.assertEquals((long)0x800000L, (long)this.resultSet.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)1L, (long)(this.getSizeOfResultSet(this.resultSet) + 1));
        this.resultSet = this.databaseMetaData.getColumns(null, "JDBC_SCHEMA21", "JDBC_BIN", "BIN2");
        this.resultSet.next();
        Assert.assertEquals((long)100L, (long)this.resultSet.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)1L, (long)(this.getSizeOfResultSet(this.resultSet) + 1));
        this.resultSet = this.databaseMetaData.getColumns("JDBC_DB1", "JDBC_SCHEMA12", "JDBC_TBL122", "COLA");
        this.resultSet.next();
        Assert.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString("TABLE_CAT"));
        Assert.assertEquals((Object)"JDBC_SCHEMA12", (Object)this.resultSet.getString("TABLE_SCHEM"));
        Assert.assertEquals((Object)"JDBC_TBL122", (Object)this.resultSet.getString("TABLE_NAME"));
        Assert.assertEquals((Object)"COLA", (Object)this.resultSet.getString("COLUMN_NAME"));
        Assert.assertEquals((long)3L, (long)this.resultSet.getInt("DATA_TYPE"));
        Assert.assertEquals((Object)"NUMBER", (Object)this.resultSet.getString("TYPE_NAME"));
        Assert.assertEquals((Object)"20", (Object)this.resultSet.getString("COLUMN_SIZE"));
        Assert.assertEquals((Object)"2", (Object)this.resultSet.getString("DECIMAL_DIGITS"));
        Assert.assertEquals((long)1L, (long)this.resultSet.getInt("NULLABLE"));
        Assert.assertEquals((Object)"cmt colA", (Object)this.resultSet.getString("REMARKS"));
        Assert.assertEquals(null, (Object)this.resultSet.getString("COLUMN_DEF"));
        Assert.assertEquals((Object)"YES", (Object)this.resultSet.getString("IS_NULLABLE"));
        Assert.assertEquals((Object)"YES", (Object)this.resultSet.getString("IS_AUTOINCREMENT"));
        this.resultSet.close();
        this.resultSet = this.databaseMetaData.getColumns("JDBC_DB1", "JDBC_SCHEMA12", "JDBC_TBL122", "COLB");
        this.resultSet.next();
        Assert.assertEquals((long)0L, (long)this.resultSet.getInt(11));
        Assert.assertEquals((Object)"3", (Object)this.resultSet.getString(13));
        Assert.assertEquals((Object)"NO", (Object)this.resultSet.getString(23));
        this.resultSet.close();
        this.resultSet = this.databaseMetaData.getColumns("JDBC_DB1", "JDBC_SCHEMA1_", null, "COL_");
        this.resultSet = this.databaseMetaData.getColumns("JDBC_DB1", "JDBC_SCHEMA12", "JDBC_TBL122", "COLC");
        this.resultSet.next();
        Assert.assertEquals(null, (Object)this.resultSet.getString(13));
        Assert.assertEquals((Object)"YES", (Object)this.resultSet.getString(23));
        this.statement.execute("create or replace table \"@@specialchartable$1234\"(colA int)");
        this.resultSet = this.databaseMetaData.getColumns(null, null, "@@specialchartable$%", null);
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet.close();
        this.resultSet.next();
        this.connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetFunctions() throws SQLException {
        this.connection = DatabaseMetaDataInternalIT.getConnection();
        this.statement = this.connection.createStatement();
        this.statement.execute("create or replace function JDBC_DB1.JDBC_SCHEMA11.JDBCFUNCTEST111 (a number, b number) RETURNS NUMBER COMMENT='multiply numbers' as 'a*b'");
        this.statement.execute("create or replace function JDBC_DB1.JDBC_SCHEMA12.JDBCFUNCTEST121 (a number, b number) RETURNS NUMBER COMMENT='multiply numbers' as 'a*b'");
        this.statement.execute("create or replace function JDBC_DB1.JDBC_SCHEMA12.JDBCFUNCTEST122 (a number, b number) RETURNS NUMBER COMMENT='multiply numbers' as 'a*b'");
        this.statement.execute("create or replace function JDBC_DB2.JDBC_SCHEMA21.JDBCFUNCTEST211 (a number, b number) RETURNS NUMBER COMMENT='multiply numbers' as 'a*b'");
        this.statement.execute("create or replace function JDBC_DB2.JDBC_SCHEMA21.JDBCFUNCTEST212 () RETURNS TABLE(colA varchar) as 'select COLA from JDBC_DB2.JDBC_SCHEMA21.JDBC_TBL211'");
        this.databaseMetaData = this.connection.getMetaData();
        this.resultSet = this.databaseMetaData.getFunctions("JDBC_DB1", "JDBC_SCHEMA11", "JDBCFUNCTEST111");
        DatabaseMetaDataIT.verifyResultSetMetaDataColumns(this.resultSet, DBMetadataResultSetMetadata.GET_FUNCTIONS);
        this.resultSet.next();
        Assert.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString("FUNCTION_CAT"));
        Assert.assertEquals((Object)"JDBC_SCHEMA11", (Object)this.resultSet.getString("FUNCTION_SCHEM"));
        Assert.assertEquals((Object)"JDBCFUNCTEST111", (Object)this.resultSet.getString("FUNCTION_NAME"));
        Assert.assertEquals((Object)"multiply numbers", (Object)this.resultSet.getString("REMARKS"));
        Assert.assertEquals((long)1L, (long)this.resultSet.getInt("FUNCTION_TYPE"));
        Assert.assertEquals((Object)"JDBCFUNCTEST111", (Object)this.resultSet.getString("SPECIFIC_NAME"));
        Assert.assertFalse((boolean)this.resultSet.next());
        this.resultSet = this.databaseMetaData.getFunctions("JDBC_DB2", "JDBC_SCHEMA21", "JDBCFUNCTEST212");
        this.resultSet.next();
        Assert.assertEquals((long)2L, (long)this.resultSet.getInt("FUNCTION_TYPE"));
        Assert.assertFalse((boolean)this.resultSet.next());
        this.resultSet = this.databaseMetaData.getFunctions(null, null, "AND");
        this.resultSet.next();
        Assert.assertEquals((Object)"", (Object)this.resultSet.getString("FUNCTION_CAT"));
        Assert.assertEquals((Object)"", (Object)this.resultSet.getString("FUNCTION_SCHEM"));
        Assert.assertEquals((Object)"AND", (Object)this.resultSet.getString("FUNCTION_NAME"));
        Assert.assertEquals((long)1L, (long)this.resultSet.getInt("FUNCTION_TYPE"));
        Assert.assertEquals((Object)"AND", (Object)this.resultSet.getString("SPECIFIC_NAME"));
        Assert.assertFalse((boolean)this.resultSet.next());
        this.resultSet = this.databaseMetaData.getFunctions(null, null, "JDBCFUNCTEST%");
        Assert.assertEquals((long)5L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getFunctions(null, "JDBC_SCHEMA1_", "_DBCFUNCTEST%");
        Assert.assertEquals((long)3L, (long)this.getSizeOfResultSet(this.resultSet));
        try {
            this.resultSet = this.databaseMetaData.getFunctions("JDBC_DB3", "JDBC_SCHEMA1_", "_DBCFUNCTEST%");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)2003L, (long)e.getErrorCode());
        }
        this.resultSet = this.databaseMetaData.getFunctions("JDBC_DB1", "JDBC_SCHEMA__", "_DBCFUNCTEST%");
        Assert.assertEquals((long)3L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getFunctions("JDBC_DB1", "JDBC_SCHEMA1_", "_DBCFUNCTEST11_");
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getFunctions("JDBC_DB1", null, "_DBCFUNCTEST11_");
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet.close();
        this.resultSet.next();
        this.statement.close();
        this.connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetSchema() throws SQLException {
        String getSchemaCount = "select count(*) from db.information_schema.schemata";
        this.connection = DatabaseMetaDataInternalIT.getConnection();
        this.databaseMetaData = this.connection.getMetaData();
        Assert.assertEquals((Object)"schema", (Object)this.databaseMetaData.getSchemaTerm());
        this.resultSet = this.databaseMetaData.getSchemas();
        Assert.assertEquals((long)this.getAllObjectCountInDBViaInforSchema(getSchemaCount), (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getSchemas(null, null);
        Assert.assertEquals((long)this.getAllObjectCountInDBViaInforSchema(getSchemaCount), (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getSchemas("JDBC_DB1", "%");
        this.resultSet.next();
        Assert.assertEquals((Object)"INFORMATION_SCHEMA", (Object)this.resultSet.getString(1));
        Assert.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString(2));
        this.resultSet.next();
        Assert.assertEquals((Object)"JDBC_SCHEMA11", (Object)this.resultSet.getString(1));
        Assert.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString(2));
        this.resultSet.next();
        Assert.assertEquals((Object)"JDBC_SCHEMA12", (Object)this.resultSet.getString(1));
        Assert.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString(2));
        this.resultSet.next();
        Assert.assertEquals((Object)"PUBLIC", (Object)this.resultSet.getString(1));
        Assert.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString(2));
        this.resultSet = this.databaseMetaData.getSchemas("JDBC_DB1", "JDBC%");
        Assert.assertEquals((long)2L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet.close();
        this.resultSet.next();
        this.connection.close();
    }

    @Test
    @Ignore
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetTablesReusingCachedResults() throws SQLException {
        Connection snowflakeConnection = DatabaseMetaDataInternalIT.getSnowflakeAdminConnection();
        Statement snowflake = snowflakeConnection.createStatement();
        snowflake.execute("alter system set OVERRIDE_USE_CACHED_RESULT = true;");
        this.connection = DatabaseMetaDataInternalIT.getConnection();
        this.databaseMetaData = this.connection.getMetaData();
        Statement stmt = this.connection.createStatement();
        stmt.execute("select system$drop_result_reuse_cache();");
        stmt.execute("alter session set USE_CACHED_RESULT = true;");
        stmt.execute("alter session set USE_CACHED_SHOW_RESULT = true;");
        String accountName = this.getAccountName(stmt);
        long accountId = this.getAccountId(stmt, accountName);
        String dbname = "JDBC_DSHOW";
        String schemaname = "SSHOW_" + DatabaseMetaDataInternalIT.randomAlphaNumeric(6);
        stmt.execute("create or replace database " + dbname);
        stmt.execute("create or replace schema " + schemaname);
        stmt.execute("use schema " + dbname + "." + schemaname);
        stmt.execute("create table show1(c1 number);");
        long oldNumCacheRes = this.getNumCachedResults(stmt, accountId);
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        long newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assert.assertEquals((long)1L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assert.assertEquals((long)0L, (long)(newNumCacheRes - oldNumCacheRes));
        stmt.execute("create table show2(c2 number);");
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assert.assertEquals((long)1L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assert.assertEquals((long)0L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        stmt.execute("alter table show2 rename to show3");
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assert.assertEquals((long)1L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assert.assertEquals((long)0L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        stmt.execute("alter table show3 set comment = 'show3'");
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assert.assertEquals((long)1L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assert.assertEquals((long)0L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        stmt.execute("insert into show3 values (3),(4)");
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assert.assertEquals((long)0L, (long)(newNumCacheRes - oldNumCacheRes));
        stmt.execute("drop table show1");
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assert.assertEquals((long)1L, (long)(newNumCacheRes - oldNumCacheRes));
        oldNumCacheRes = newNumCacheRes;
        this.resultSet = this.databaseMetaData.getTables(dbname, null, null, null);
        newNumCacheRes = this.getNumCachedResults(stmt, accountId);
        Assert.assertEquals((long)0L, (long)(newNumCacheRes - oldNumCacheRes));
        stmt.execute("drop database if exists " + dbname);
        stmt.execute("alter session set USE_CACHED_RESULT = default;");
        snowflake.execute("alter system set OVERRIDE_USE_CACHED_RESULT = true;");
        stmt.execute("alter session set USE_CACHED_SHOW_RESULT = default;");
        stmt.close();
        snowflake.close();
        snowflakeConnection.close();
        this.connection.close();
    }

    private long getNumCachedResults(Statement stmt, long accountId) throws SQLException {
        String query = "select count($1:\"JobResultDPO:share\")\nfrom table(dposcan('\n  {\n    \"slices\" : [{\"name\" : \"JobResultDPO:share\"}],\n    \"ranges\" : [\n            {\"name\" : \"accountId\", \"value\" : %d}\n          ]\n   }'));";
        stmt.execute(String.format(query, accountId));
        this.resultSet = stmt.getResultSet();
        Assert.assertTrue((boolean)this.resultSet.next());
        return this.resultSet.getLong(1);
    }

    public static String randomAlphaNumeric(int count) {
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    private String getAccountName(Statement stmt) throws SQLException {
        stmt.execute("select current_account_locator()");
        this.resultSet = stmt.getResultSet();
        Assert.assertTrue((boolean)this.resultSet.next());
        return this.resultSet.getString(1);
    }

    private long getAccountId(Statement stmt, String accountName) throws SQLException {
        stmt.execute("select to_number($1:\"AccountDPO:active_by_name\":id) as id\nfrom table(dposcan('\n  {\n    \"slices\" : [{\"name\" : \"AccountDPO:active_by_name\"}],\n    \"ranges\" : [\n            {\"name\": \"name\", \"value\": \"" + accountName + "\"}\n          ]\n   }'));");
        this.resultSet = stmt.getResultSet();
        Assert.assertTrue((boolean)this.resultSet.next());
        return this.resultSet.getLong(1);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetTables() throws SQLException {
        String getAllTable = "select count(*) from db.information_schema.tables";
        String getAllBaseTable = "select count(*) from db.information_schema.tables where table_type = 'BASE TABLE'";
        String getAllView = "select count(*) from db.information_schema.tables where table_type = 'VIEW'";
        this.connection = DatabaseMetaDataInternalIT.getConnection();
        Statement stmt = this.connection.createStatement();
        stmt.execute("alter session set ENABLE_DRIVER_TERSE_SHOW = true;");
        stmt.execute("alter session set qa_mode = false;");
        this.databaseMetaData = this.connection.getMetaData();
        try {
            this.resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"ALIAS"});
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), (Object)e.getSQLState());
            Assert.assertEquals((long)ErrorCode.FEATURE_UNSUPPORTED.getMessageCode().intValue(), (long)e.getErrorCode());
        }
        this.resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"SYSTEM_TABLE"});
        Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getTables(null, null, null, null);
        Assert.assertEquals((long)this.getAllObjectCountInDBViaInforSchema(getAllTable), (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"VIEW", "SYSTEM_TABLE"});
        Assert.assertEquals((long)this.getAllObjectCountInDBViaInforSchema(getAllView), (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"TABLE", "SYSTEM_TABLE"});
        Assert.assertEquals((long)this.getAllObjectCountInDBViaInforSchema(getAllBaseTable), (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"TABLE", "VIEW", "SYSTEM_TABLE"});
        Assert.assertEquals((long)this.getAllObjectCountInDBViaInforSchema(getAllTable), (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"TABLE", "VIEW"});
        Assert.assertEquals((long)this.getAllObjectCountInDBViaInforSchema(getAllTable), (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"TABLE"});
        Assert.assertEquals((long)this.getAllObjectCountInDBViaInforSchema(getAllBaseTable), (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"VIEW"});
        Assert.assertEquals((long)this.getAllObjectCountInDBViaInforSchema(getAllView), (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getTables("JDBC_DB1", "JDBC_SCHEMA11", null, new String[]{"TABLE"});
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getTables("JDBC_DB1", "JDBC\\_SCHEMA11", "%", new String[]{"TABLE"});
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet = this.databaseMetaData.getTables("JDBC_DB1", "JDBC%", null, new String[]{"TABLE"});
        Assert.assertEquals((long)3L, (long)this.getSizeOfResultSet(this.resultSet));
        stmt.execute("alter session set ENABLE_KEY_VALUE_TABLE = false;");
        this.resultSet = this.databaseMetaData.getTables("JDBC_DB1", "JDBC_SCH%", "J_BC_TBL122", new String[]{"TABLE"});
        this.resultSet.next();
        Assert.assertEquals((Object)"JDBC_DB1", (Object)this.resultSet.getString(1));
        Assert.assertEquals((Object)"JDBC_SCHEMA12", (Object)this.resultSet.getString(2));
        Assert.assertEquals((Object)"JDBC_TBL122", (Object)this.resultSet.getString(3));
        Assert.assertEquals((Object)"TABLE", (Object)this.resultSet.getString(4));
        Assert.assertEquals((Object)"", (Object)this.resultSet.getString(5));
        stmt.execute("alter session unset ENABLE_KEY_VALUE_TABLE;");
        this.resultSet = this.databaseMetaData.getTables("JDBC_DB1", null, "JDBC_TBL211", new String[]{"TABLE"});
        Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(this.resultSet));
        this.resultSet.close();
        this.resultSet.next();
        this.resultSet = this.databaseMetaData.getTableTypes();
        this.resultSet.next();
        Assert.assertEquals((Object)"TABLE", (Object)this.resultSet.getString(1));
        this.resultSet.next();
        Assert.assertEquals((Object)"VIEW", (Object)this.resultSet.getString(1));
        this.resultSet.close();
        this.resultSet.next();
        stmt.execute("alter session set ENABLE_DRIVER_TERSE_SHOW = default;");
        stmt.close();
        this.connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetMetaDataUseConnectionCtx() throws SQLException {
        Connection connection = DatabaseMetaDataInternalIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("use database JDBC_DB1");
        statement.execute("use schema JDBC_SCHEMA11");
        statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getSchemas(null, null);
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
        resultSet = databaseMetaData.getTables(null, null, null, null);
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
        statement.execute("use schema JDBC_SCHEMA12");
        resultSet = databaseMetaData.getTables(null, null, null, null);
        Assert.assertEquals((long)2L, (long)this.getSizeOfResultSet(resultSet));
        resultSet = databaseMetaData.getColumns(null, null, null, null);
        Assert.assertEquals((long)4L, (long)this.getSizeOfResultSet(resultSet));
        statement.execute("use schema TEST_CTX");
        resultSet = databaseMetaData.getPrimaryKeys(null, null, null);
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
        resultSet = databaseMetaData.getImportedKeys(null, null, null);
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
        resultSet = databaseMetaData.getExportedKeys(null, null, null);
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
        resultSet = databaseMetaData.getCrossReference(null, null, null, null, null, null);
        Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
    }

    private int getAllObjectCountInDBViaInforSchema(String SQLCmdTemplate) throws SQLException {
        int objectCount = 0;
        Connection con = DatabaseMetaDataInternalIT.getConnection();
        Statement st = con.createStatement();
        st.execute("alter session set ENABLE_BUILTIN_SCHEMAS = true");
        ResultSet dbNameRS = st.executeQuery("select database_name from information_schema.databases");
        while (dbNameRS.next()) {
            String databaseName = dbNameRS.getString(1);
            String execSQLCmd = SQLCmdTemplate.replaceAll("db", databaseName);
            ResultSet object = st.executeQuery(execSQLCmd);
            object.next();
            objectCount += object.getInt(1);
        }
        return objectCount;
    }
}

