/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.DatabaseMetaDataInternalIT;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public class DatabaseMetaDataInternalLatestIT
extends BaseJDBCTest {
    @Before
    public void setUp() throws Exception {
        try (Connection con = DatabaseMetaDataInternalLatestIT.getConnection();){
            DatabaseMetaDataInternalIT.initMetaData(con);
        }
    }

    @After
    public void tearDown() throws Exception {
        try (Connection con = DatabaseMetaDataInternalLatestIT.getConnection();){
            DatabaseMetaDataInternalIT.endMetaData(con);
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetMetaDataUseConnectionCtx() throws SQLException {
        Connection connection = DatabaseMetaDataInternalLatestIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("use database JDBC_DB1");
        statement.execute("use schema JDBC_SCHEMA11");
        statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, null, null, null);
        resultSet.next();
        Assert.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString(1));
        Assert.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString(2));
        resultSet = databaseMetaData.getColumns(null, null, null, null);
        resultSet.next();
        Assert.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString(1));
        Assert.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString(2));
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetFunctionColumns() throws SQLException {
        try (Connection connection = DatabaseMetaDataInternalLatestIT.getConnection();){
            Statement statement = connection.createStatement();
            statement.execute("create or replace function JDBC_DB1.JDBC_SCHEMA11.FUNC111 (a number, b number) RETURNS NUMBER COMMENT='multiply numbers' as 'a*b'");
            statement.execute("create or replace table JDBC_DB1.JDBC_SCHEMA11.BIN_TABLE(bin1 binary, bin2 binary(100), sharedCol decimal)");
            statement.execute("create or replace function JDBC_DB1.JDBC_SCHEMA11.FUNC112 () RETURNS TABLE(colA string, colB decimal, bin2 binary, sharedCol decimal) COMMENT= 'returns table of 4 columns' as 'select JDBC_DB1.JDBC_SCHEMA11.JDBC_TBL111.colA, JDBC_DB1.JDBC_SCHEMA11.JDBC_TBL111.colB, JDBC_DB1.JDBC_SCHEMA11.BIN_TABLE.bin2, JDBC_DB1.JDBC_SCHEMA11.BIN_TABLE.sharedCol from JDBC_DB1.JDBC_SCHEMA11.JDBC_TBL111 inner join JDBC_DB1.JDBC_SCHEMA11.BIN_TABLE on JDBC_DB1.JDBC_SCHEMA11.JDBC_TBL111.colB = JDBC_DB1.JDBC_SCHEMA11.BIN_TABLE.sharedCol'");
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getFunctionColumns("JDBC_DB1", "JDBC_SCHEMA11", "FUNC111", "%");
            resultSet.next();
            Assert.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC111", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)4L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER(38,0)", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"multiply numbers", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC111(NUMBER, NUMBER) RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
            resultSet.next();
            Assert.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC111", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"A", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"multiply numbers", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC111(NUMBER, NUMBER) RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
            resultSet.next();
            Assert.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC111", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"B", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"multiply numbers", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC111(NUMBER, NUMBER) RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = databaseMetaData.getFunctionColumns("JDBC_DB1", "JDBC_SCHEMA11", "FUNC112", "%");
            resultSet.next();
            Assert.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"COLA", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)5L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)12L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"VARCHAR", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0x1000000L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
            resultSet.next();
            Assert.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"COLB", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)5L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
            resultSet.next();
            Assert.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"BIN2", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)5L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)-2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"BINARY", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0x800000L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)3L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
            resultSet.next();
            Assert.assertEquals((Object)"JDBC_DB1", (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)"JDBC_SCHEMA11", (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"SHAREDCOL", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)5L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)4L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
            resultSet = databaseMetaData.getFunctionColumns("%", "%", "%", "%");
            Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(resultSet));
            resultSet.close();
            statement.close();
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetTablesRaceCondition() throws SQLException, ExecutionException, InterruptedException {
        try (Connection connection = DatabaseMetaDataInternalLatestIT.getConnection();){
            int i;
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ExecutorService executorService = Executors.newFixedThreadPool(10);
            ArrayList futures = new ArrayList();
            for (i = 0; i < 10; ++i) {
                futures.add(executorService.submit(() -> {
                    try {
                        databaseMetaData.getTables(database, schema, null, null);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }));
            }
            executorService.shutdown();
            for (i = 0; i < 10; ++i) {
                ((Future)futures.get(i)).get();
            }
        }
    }
}

