/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.DBMetadataResultSetMetadata;
import net.snowflake.client.jdbc.DatabaseMetaDataIT;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaData;
import net.snowflake.client.jdbc.SnowflakeStatement;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public class DatabaseMetaDataLatestIT
extends BaseJDBCTest {
    private static final String TEST_PROC = "create or replace procedure testproc(param1 float, param2 string)\n    returns varchar\n    language javascript\n    as\n    $$\n    var sql_command = \"Hello, world!\"\n    $$\n    ;";
    private static final String PI_PROCEDURE = "create or replace procedure GETPI()\n    returns float not null\n    language javascript\n    as\n    $$\n    return 3.1415926;\n    $$\n    ;";
    private static final String MESSAGE_PROCEDURE = "create or replace procedure MESSAGE_PROC(message varchar)\n    returns varchar not null\n    language javascript\n    as\n    $$\n    return message;\n    $$\n    ;";

    public void createDoubleQuotedSchemaAndCatalog(Statement statement) throws SQLException {
        statement.execute("create or replace database \"dbwith\"\"quotes\"");
        statement.execute("create or replace schema \"dbwith\"\"quotes\".\"schemawith\"\"quotes\"");
    }

    @Test
    public void testUseConnectionCtx() throws SQLException {
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();){
            connection.createStatement().execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
            String schema = connection.getSchema();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            connection.createStatement().execute("create or replace schema TEST_CTX");
            connection.createStatement().execute("create or replace table CTX_TBL_A (colA string, colB decimal, colC number PRIMARY KEY);");
            connection.createStatement().execute("create or replace table CTX_TBL_B (colA string, colB decimal, colC number FOREIGN KEY REFERENCES CTX_TBL_A (colC));");
            connection.createStatement().execute("create or replace table CTX_TBL_C (colA string, colB decimal, colC number, colD int, colE timestamp, colF string, colG number);");
            connection.createStatement().execute("use schema " + schema);
            connection.createStatement().execute("create or replace table CTX_TBL_D (colA string, colB decimal, colC number PRIMARY KEY);");
            connection.createStatement().execute("create or replace table CTX_TBL_E (colA string, colB decimal, colC number FOREIGN KEY REFERENCES CTX_TBL_D (colC));");
            connection.createStatement().execute("create or replace table CTX_TBL_F (colA string, colB decimal, colC number, colD int, colE timestamp, colF string, colG number);");
            connection.createStatement().execute("use schema TEST_CTX");
            ResultSet resultSet = databaseMetaData.getSchemas(null, null);
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
            resultSet = databaseMetaData.getTables(null, null, null, null);
            Assert.assertEquals((long)3L, (long)this.getSizeOfResultSet(resultSet));
            resultSet = databaseMetaData.getColumns(null, null, null, null);
            Assert.assertEquals((long)13L, (long)this.getSizeOfResultSet(resultSet));
            resultSet = databaseMetaData.getPrimaryKeys(null, null, null);
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
            resultSet = databaseMetaData.getImportedKeys(null, null, null);
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
            resultSet = databaseMetaData.getExportedKeys(null, null, null);
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
            resultSet = databaseMetaData.getCrossReference(null, null, null, null, null, null);
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
            connection.createStatement().execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=false");
            databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getSchemas(null, null);
            Assert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
            resultSet = databaseMetaData.getTables(null, null, null, null);
            Assert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(6)));
            resultSet = databaseMetaData.getColumns(null, null, null, null);
            Assert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(26)));
            resultSet = databaseMetaData.getPrimaryKeys(null, null, null);
            Assert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
            resultSet = databaseMetaData.getImportedKeys(null, null, null);
            Assert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
            resultSet = databaseMetaData.getExportedKeys(null, null, null);
            Assert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
            resultSet = databaseMetaData.getCrossReference(null, null, null, null, null, null);
            Assert.assertThat((Object)this.getSizeOfResultSet(resultSet), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        }
    }

    @Test
    public void testDoubleQuotedDatabaseAndSchema() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = con.createStatement();
            String database = con.getCatalog();
            String querySchema = "TEST\\_SCHEMA\\_\"WITH\\_QUOTES\"";
            String queryTable = "TESTTABLE\\_\"WITH\\_QUOTES\"";
            statement.execute("create or replace schema \"TEST_SCHEMA_\"\"WITH_QUOTES\"\"\"");
            statement.execute("create or replace table \"TESTTABLE_\"\"WITH_QUOTES\"\"\" (AMOUNT number, \"COL_\"\"QUOTED\"\"\" string)");
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet rs = metaData.getTables(database, querySchema, queryTable, null);
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(rs));
            rs = metaData.getColumns(database, querySchema, queryTable, null);
            Assert.assertEquals((long)2L, (long)this.getSizeOfResultSet(rs));
            rs = metaData.getColumns(database, querySchema, queryTable, "COL\\_\"QUOTED\"");
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(rs));
            rs = metaData.getSchemas(database, querySchema);
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(rs));
            rs.close();
            statement.close();
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDoubleQuotedDatabaseInGetSchemas() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = con.createStatement();
            statement.execute("create or replace database \"\"\"quoteddb\"\"\"");
            statement.execute("create or replace database \"unquoteddb\"");
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet rs = metaData.getSchemas("\"quoteddb\"", null);
            Assert.assertEquals((long)2L, (long)this.getSizeOfResultSet(rs));
            rs = metaData.getSchemas("quoteddb", null);
            Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(rs));
            rs = metaData.getSchemas("unquoteddb", null);
            Assert.assertEquals((long)2L, (long)this.getSizeOfResultSet(rs));
            rs = metaData.getSchemas("\"unquoteddb\"", null);
            Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(rs));
            rs.close();
            statement.close();
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDoubleQuotedDatabaseInGetTables() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = con.createStatement();
            this.createDoubleQuotedSchemaAndCatalog(statement);
            statement.execute("create or replace table \"dbwith\"\"quotes\".\"schemawith\"\"quotes\".\"testtable\" (col1 string, col2 string)");
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet rs = metaData.getTables("dbwith\"quotes", "schemawith\"quotes", null, null);
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(rs));
            rs.close();
            statement.close();
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDoubleQuotedDatabaseInGetColumns() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = con.createStatement();
            this.createDoubleQuotedSchemaAndCatalog(statement);
            statement.execute("create or replace table \"dbwith\"\"quotes\".\"schemawith\"\"quotes\".\"testtable\"  (col1 string, col2 string)");
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet rs = metaData.getColumns("dbwith\"quotes", "schemawith\"quotes", null, null);
            Assert.assertEquals((long)2L, (long)this.getSizeOfResultSet(rs));
            rs.close();
            statement.close();
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDoubleQuotedDatabaseforGetPrimaryKeysAndForeignKeys() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = con.createStatement();
            this.createDoubleQuotedSchemaAndCatalog(statement);
            statement.execute("create or replace table \"dbwith\"\"quotes\".\"schemawith\"\"quotes\".\"test1\"  (col1 integer not null, col2 integer not null, constraint pkey_1 primary key (col1, col2) not enforced)");
            statement.execute("create or replace table \"dbwith\"\"quotes\".\"schemawith\"\"quotes\".\"test2\" (col_a integer not null, col_b integer not null, constraint fkey_1 foreign key (col_a, col_b) references \"test1\" (col1, col2) not enforced)");
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet rs = metaData.getPrimaryKeys("dbwith\"quotes", "schemawith\"quotes", null);
            Assert.assertEquals((long)2L, (long)this.getSizeOfResultSet(rs));
            rs = metaData.getImportedKeys("dbwith\"quotes", "schemawith\"quotes", null);
            Assert.assertEquals((long)2L, (long)this.getSizeOfResultSet(rs));
            rs.close();
            statement.close();
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDoubleQuotedDatabaseInGetProcedures() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = con.createStatement();
            this.createDoubleQuotedSchemaAndCatalog(statement);
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
            statement.execute("USE DATABASE \"dbwith\"\"quotes\"; USE SCHEMA \"schemawith\"\"quotes\"; create or replace procedure testproc(param1 float, param2 string)\n    returns varchar\n    language javascript\n    as\n    $$\n    var sql_command = \"Hello, world!\"\n    $$\n    ;");
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet rs = metaData.getProcedures("dbwith\"quotes", null, "TESTPROC");
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(rs));
            rs.close();
            statement.close();
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDoubleQuotedDatabaseInGetTablePrivileges() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = con.createStatement();
            this.createDoubleQuotedSchemaAndCatalog(statement);
            statement.execute("create or replace table \"dbwith\"\"quotes\".\"schemawith\"\"quotes\".\"testtable\" (col1 string, col2 string)");
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet rs = metaData.getTablePrivileges("dbwith\"quotes", null, "%");
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(rs));
            rs.close();
            statement.close();
        }
    }

    @Test
    public void testGetFunctionSqlInjectionProtection() throws Throwable {
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();){
            connection.createStatement().execute("alter session set MULTI_STATEMENT_COUNT=0");
            DatabaseMetaData metaData = connection.getMetaData();
            String schemaSqlInection = "%' in database testwh; select 11 as bar; show databases like '%";
            ResultSet resultSet = metaData.getSchemas(null, schemaSqlInection);
            Assert.assertFalse((boolean)resultSet.next());
            String columnSqlInjection = "%' in schema testschema; show columns like '%";
            resultSet = metaData.getColumns(null, null, null, columnSqlInjection);
            Assert.assertFalse((boolean)resultSet.next());
            String functionSqlInjection = "%' in account snowflake; show functions like '%";
            resultSet = metaData.getColumns(null, null, null, functionSqlInjection);
            Assert.assertFalse((boolean)resultSet.next());
            connection.createStatement().execute("alter session unset MULTI_STATEMENT_COUNT");
        }
    }

    @Test
    public void testGetProcedureColumnsWildcards() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = con.createStatement();
            String database = con.getCatalog();
            String schema1 = "SCH1";
            String schema2 = "SCH2";
            statement.execute("create or replace schema " + schema1);
            statement.execute(TEST_PROC);
            statement.execute("create or replace schema " + schema2);
            statement.execute(TEST_PROC);
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet rs = metaData.getProcedureColumns(database, "SCH_", "TESTPROC", "PARAM1");
            Assert.assertEquals((long)4L, (long)this.getSizeOfResultSet(rs));
            rs.close();
            statement.close();
        }
    }

    @Test
    public void testGetFunctions() throws SQLException {
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();){
            DatabaseMetaData metadata = connection.getMetaData();
            String supportedStringFuncs = metadata.getStringFunctions();
            Assert.assertEquals((Object)"ASCII,BIT_LENGTH,CHAR,CONCAT,INSERT,LCASE,LEFT,LENGTH,LPAD,LOCATE,LTRIM,OCTET_LENGTH,PARSE_IP,PARSE_URL,REPEAT,REVERSE,REPLACE,RPAD,RTRIMMED_LENGTH,SPACE,SPLIT,SPLIT_PART,SPLIT_TO_TABLE,STRTOK,STRTOK_TO_ARRAY,STRTOK_SPLIT_TO_TABLE,TRANSLATE,TRIM,UNICODE,UUID_STRING,INITCAP,LOWER,UPPER,REGEXP,REGEXP_COUNT,REGEXP_INSTR,REGEXP_LIKE,REGEXP_REPLACE,REGEXP_SUBSTR,RLIKE,CHARINDEX,CONTAINS,EDITDISTANCE,ENDSWITH,ILIKE,ILIKE ANY,LIKE,LIKE ALL,LIKE ANY,POSITION,REPLACE,RIGHT,STARTSWITH,SUBSTRING,COMPRESS,DECOMPRESS_BINARY,DECOMPRESS_STRING,BASE64_DECODE_BINARY,BASE64_DECODE_STRING,BASE64_ENCODE,HEX_DECODE_BINARY,HEX_DECODE_STRING,HEX_ENCODE,TRY_BASE64_DECODE_BINARY,TRY_BASE64_DECODE_STRING,TRY_HEX_DECODE_BINARY,TRY_HEX_DECODE_STRING,MD_5,MD5_HEX,MD5_BINARY,SHA1,SHA1_HEX,SHA2,SHA1_BINARY,SHA2_HEX,SHA2_BINARY, HASH,HASH_AGG,COLLATE,COLLATION", (Object)supportedStringFuncs);
            String supportedNumberFuncs = metadata.getNumericFunctions();
            Assert.assertEquals((Object)"ABS,ACOS,ASIN,ATAN,ATAN2,CBRT,CEILING,COS,COT,DEGREES,EXP,FACTORIAL,FLOOR,HAVERSINE,LN,LOG,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,SQUARE,TAN,TRUNCATE", (Object)supportedNumberFuncs);
            String supportedSystemFuncs = metadata.getSystemFunctions();
            Assert.assertEquals((Object)"DATABASE,IFNULL,USER", (Object)supportedSystemFuncs);
        }
    }

    @Test
    public void testGetStringValueFromColumnDef() throws SQLException {
        Map<String, String> params = DatabaseMetaDataLatestIT.getConnectionParameters();
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        properties.put("stringsQuotedForColumnDef", "true");
        Connection connection = DriverManager.getConnection(params.get("uri"), properties);
        String database = connection.getCatalog();
        String schema = connection.getSchema();
        String targetTable = "T0";
        connection.createStatement().execute("create or replace table T0(C1 string, C2 string default '', C3 string default 'apples', C4 string default '\"apples\"', C5 int, C6 int default 5, C7 string default '''', C8 string default '''apples''''', C9  string default '%')");
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet resultSet = metaData.getColumns(database, schema, "T0", "%");
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"''", (Object)resultSet.getString("COLUMN_DEF"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"'apples'", (Object)resultSet.getString("COLUMN_DEF"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"'\"apples\"'", (Object)resultSet.getString("COLUMN_DEF"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"5", (Object)resultSet.getString("COLUMN_DEF"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"''''", (Object)resultSet.getString("COLUMN_DEF"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"'''apples'''''", (Object)resultSet.getString("COLUMN_DEF"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"'%'", (Object)resultSet.getString("COLUMN_DEF"));
    }

    @Test
    public void testGetColumnsNullable() throws Throwable {
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable = "T0";
            connection.createStatement().execute("create or replace table T0(C1 int, C2 varchar(100), C3 string default '', C4 number(18,4), C5 double, C6 boolean, C7 date not null, C8 time, C9 timestamp_ntz(7), C10 binary,C11 variant, C12 timestamp_ltz(8), C13 timestamp_tz(3))");
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getColumns(database, schema, "T0", "%");
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_COLUMNS);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertTrue((boolean)resultSet.getBoolean("NULLABLE"));
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testSessionDatabaseParameter() throws Throwable {
        String altdb = "ALTERNATEDB";
        String altschema1 = "ALTERNATESCHEMA1";
        String altschema2 = "ALTERNATESCHEMA2";
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = connection.createStatement();
            String catalog = connection.getCatalog();
            String schema = connection.getSchema();
            statement.execute("create or replace database " + altdb);
            statement.execute("create or replace schema " + altschema1);
            statement.execute("create or replace schema " + altschema2);
            statement.execute("create or replace table " + altdb + "." + altschema1 + ".testtable1 (colA string, colB number)");
            statement.execute("create or replace table " + altdb + "." + altschema2 + ".testtable2 (colA string, colB number)");
            statement.execute("create or replace table " + catalog + "." + schema + ".testtable3 (colA string, colB number)");
            statement.execute("use database " + altdb);
            statement.execute("use schema " + altschema1);
            statement.execute("ALTER SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
            statement.execute("ALTER SESSION set CLIENT_METADATA_USE_SESSION_DATABASE=true");
            DatabaseMetaData metadata = connection.getMetaData();
            ResultSet resultSet = metadata.getColumns(null, null, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metadata.getColumns(null, altschema2, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metadata.getColumns(altdb, null, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metadata.getColumns(altdb, altschema2, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            statement.execute("ALTER SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=false");
            metadata = connection.getMetaData();
            resultSet = metadata.getColumns(null, null, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metadata.getColumns(null, altschema2, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metadata.getColumns(altdb, null, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metadata.getColumns(altdb, altschema2, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            statement.execute("ALTER SESSION set CLIENT_METADATA_USE_SESSION_DATABASE=false");
            metadata = connection.getMetaData();
            resultSet = metadata.getColumns(null, null, "TESTTABLE_", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metadata.getColumns(null, altschema2, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metadata.getColumns(altdb, null, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metadata.getColumns(altdb, altschema2, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            statement.execute("ALTER SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
            metadata = connection.getMetaData();
            resultSet = metadata.getColumns(null, null, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metadata.getColumns(null, altschema2, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metadata.getColumns(altdb, null, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema1, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metadata.getColumns(altdb, altschema2, "%", "COLA");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)altschema2, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertFalse((boolean)resultSet.next());
            statement.execute("use database " + catalog);
            statement.execute("drop schema " + altdb + "." + altschema1);
            statement.execute("drop schema " + altdb + "." + altschema2);
            statement.execute("drop database " + altdb);
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetFunctionColumns() throws Exception {
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            connection.createStatement().execute("create or replace table FuncColTest (colA int, colB string, colC number);");
            connection.createStatement().execute("INSERT INTO FuncColTest VALUES (4, 'Hello', 6);");
            connection.createStatement().execute("INSERT INTO FuncColTest VALUES (8, 'World', 10);");
            connection.createStatement().execute("create or replace function total_rows_in_table() returns number as 'select count(*) from FuncColTest';");
            connection.createStatement().execute("create or replace function FUNC111 (a number, b number) RETURNS NUMBER COMMENT='multiply numbers' as 'a*b'");
            connection.createStatement().execute("create or replace table BIN_TABLE(bin1 binary, bin2 binary(100), sharedCol decimal)");
            connection.createStatement().execute("create or replace table JDBC_TBL111(colA string, colB decimal, colC timestamp)");
            connection.createStatement().execute("create or replace function FUNC112 () RETURNS TABLE(colA string, colB decimal, bin2 binary, sharedCol decimal) COMMENT= 'returns table of 4 columns' as 'select JDBC_TBL111.colA, JDBC_TBL111.colB, BIN_TABLE.bin2, BIN_TABLE.sharedCol from JDBC_TBL111 inner join BIN_TABLE on JDBC_TBL111.colB =BIN_TABLE.sharedCol'");
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getFunctionColumns(database, schema, "FUNC111", "%");
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_FUNCTION_COLUMNS);
            resultSet.next();
            Assert.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC111", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)4L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER(38,0)", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"multiply numbers", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC111(NUMBER, NUMBER) RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
            resultSet.next();
            Assert.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC111", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"A", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"multiply numbers", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC111(NUMBER, NUMBER) RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
            resultSet.next();
            Assert.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC111", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"B", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"multiply numbers", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC111(NUMBER, NUMBER) RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metaData.getFunctionColumns(database, schema, "FUNC112", "%");
            resultSet.next();
            Assert.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"COLA", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)5L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)12L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"VARCHAR", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0x1000000L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
            resultSet.next();
            Assert.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"COLB", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)5L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
            resultSet.next();
            Assert.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"BIN2", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)5L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)-2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"BINARY", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0x800000L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)3L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
            resultSet.next();
            Assert.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"FUNC112", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"SHAREDCOL", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)5L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"returns table of 4 columns", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)4L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"FUNC112() RETURN TABLE (COLA VARCHAR, COLB NUMBER, BIN2 BINARY, SHAREDCOL NUMBER)", (Object)resultSet.getString("SPECIFIC_NAME"));
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metaData.getFunctionColumns("%", "%", "%", "%");
            Assert.assertFalse((boolean)resultSet.next());
            resultSet = metaData.getFunctionColumns(database, schema, "total_rows_in_table%", "%");
            Assert.assertEquals((long)17L, (long)resultSet.getMetaData().getColumnCount());
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
            resultSet = metaData.getFunctionColumns(database, schema, "total_rows_in_table%", "%");
            resultSet.next();
            Assert.assertEquals((Object)database, (Object)resultSet.getString("FUNCTION_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("FUNCTION_SCHEM"));
            Assert.assertEquals((Object)"TOTAL_ROWS_IN_TABLE", (Object)resultSet.getString("FUNCTION_NAME"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)4L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER(38,0)", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"user-defined function", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"TOTAL_ROWS_IN_TABLE() RETURN NUMBER", (Object)resultSet.getString("SPECIFIC_NAME"));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    @Test
    public void testHandlingSpecialChars() throws SQLException {
        Connection connection = DatabaseMetaDataLatestIT.getConnection();
        String database = connection.getCatalog();
        String schema = connection.getSchema();
        DatabaseMetaData metaData = connection.getMetaData();
        Statement statement = connection.createStatement();
        String escapeChar = metaData.getSearchStringEscape();
        statement.execute("create or replace table \"TEST\\1\\_1\" (\"C%1\" integer,\"C\\1\\\\11\" integer)");
        statement.execute("INSERT INTO \"TEST\\1\\_1\" (\"C%1\",\"C\\1\\\\11\") VALUES (0,0)");
        statement.execute("create or replace schema \"SPECIAL%_\\SCHEMA\"");
        statement.execute("create or replace table \"SPECIAL%_\\SCHEMA\".\"TEST_1_1\" ( \"RNUM\" integer not null, \"C21\" integer,\"C11\" integer,\"C%1\" integer,\"C\\1\\\\11\" integer , primary key (\"RNUM\"))");
        statement.execute("INSERT INTO \"TEST_1_1\" (RNUM,C21,C11,\"C%1\",\"C\\1\\\\11\") VALUES (0,0,0,0,0)");
        String escapedTable1 = "TEST" + escapeChar + "\\1" + escapeChar + "\\" + escapeChar + "_1";
        ResultSet resultSet = metaData.getColumns(database, schema, escapedTable1, null);
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"C%1", (Object)resultSet.getString("COLUMN_NAME"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"C\\1\\\\11", (Object)resultSet.getString("COLUMN_NAME"));
        Assert.assertFalse((boolean)resultSet.next());
        String partiallyEscapedTable1 = "TEST" + escapeChar + "\\1" + escapeChar + "\\_1";
        resultSet = metaData.getColumns(database, schema, partiallyEscapedTable1, null);
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"C%1", (Object)resultSet.getString("COLUMN_NAME"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"C\\1\\\\11", (Object)resultSet.getString("COLUMN_NAME"));
        Assert.assertFalse((boolean)resultSet.next());
        String escapedTable2 = "TEST" + escapeChar + "_1" + escapeChar + "_1";
        String escapedSchema = "SPECIAL%" + escapeChar + "_" + escapeChar + "\\SCHEMA";
        resultSet = metaData.getColumns(database, escapedSchema, escapedTable2, null);
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"RNUM", (Object)resultSet.getString("COLUMN_NAME"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"C21", (Object)resultSet.getString("COLUMN_NAME"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"C11", (Object)resultSet.getString("COLUMN_NAME"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"C%1", (Object)resultSet.getString("COLUMN_NAME"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"C\\1\\\\11", (Object)resultSet.getString("COLUMN_NAME"));
        Assert.assertFalse((boolean)resultSet.next());
        statement.execute("create or replace table " + schema + ".\"TABLE_A\" (colA string)");
        statement.execute("create or replace table " + schema + ".\"TABLE_B\" (colB number)");
        String escapedTable = "TABLE" + escapeChar + "__";
        resultSet = metaData.getColumns(database, schema, escapedTable, null);
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"COLA", (Object)resultSet.getString("COLUMN_NAME"));
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"COLB", (Object)resultSet.getString("COLUMN_NAME"));
        Assert.assertFalse((boolean)resultSet.next());
        resultSet = metaData.getColumns(database, schema, escapedTable, "COLB");
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"COLB", (Object)resultSet.getString("COLUMN_NAME"));
        Assert.assertFalse((boolean)resultSet.next());
        statement.execute("create or replace table " + schema + ".\"special%table\" (colA string)");
        resultSet = metaData.getColumns(database, schema, "special" + escapeChar + "%table", null);
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((Object)"COLA", (Object)resultSet.getString("COLUMN_NAME"));
    }

    @Test
    public void testUnderscoreInSchemaNamePatternForPrimaryAndForeignKeys() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = con.createStatement();
            String database = con.getCatalog();
            statement.execute("create or replace schema TEST_SCHEMA");
            statement.execute("use schema TEST_SCHEMA");
            statement.execute("create or replace table PK_TEST (c1 int PRIMARY KEY, c2 VARCHAR(10))");
            statement.execute("create or replace table FK_TEST (c1 int REFERENCES PK_TEST(c1), c2 VARCHAR(10))");
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet rs = metaData.getPrimaryKeys(database, "TEST\\_SCHEMA", null);
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(rs));
            rs = metaData.getImportedKeys(database, "TEST\\_SCHEMA", null);
            Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(rs));
            rs.close();
            statement.close();
        }
    }

    @Test
    public void testTimestampWithTimezoneDataType() throws Exception {
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = connection.createStatement();
            statement.executeQuery("create or replace table ts_test(ts timestamp_tz)");
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getColumns(database, schema, "TS_TEST", "TS");
            resultSet.next();
            Assert.assertEquals((Object)resultSet.getObject("DATA_TYPE"), (Object)2014);
            SFBaseSession baseSession = connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession();
            Field field = SFBaseSession.class.getDeclaredField("enableReturnTimestampWithTimeZone");
            field.setAccessible(true);
            field.set(baseSession, false);
            metaData = connection.getMetaData();
            resultSet = metaData.getColumns(database, schema, "TS_TEST", "TS");
            resultSet.next();
            Assert.assertEquals((Object)resultSet.getObject("DATA_TYPE"), (Object)93);
        }
    }

    @Test
    public void testGetColumns() throws Throwable {
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable = "T0";
            connection.createStatement().execute("create or replace table T0(C1 int, C2 varchar(100), C3 string default '', C4 number(18,4), C5 double, C6 boolean, C7 date not null, C8 time, C9 timestamp_ntz(7), C10 binary,C11 variant, C12 timestamp_ltz(8), C13 timestamp_tz(3))");
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getColumns(database, schema, "T0", "%");
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_COLUMNS);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C1", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)-5L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C2", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)12L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"VARCHAR", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)100L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)100L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)2L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C3", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)12L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"VARCHAR", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)0x1000000L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0x1000000L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)3L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C4", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)3L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)18L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)4L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)4L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C5", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)8L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"DOUBLE", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)5L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C6", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)16L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"BOOLEAN", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)6L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C7", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)91L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"DATE", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)7L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C8", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)92L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"TIME", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)9L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)8L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C9", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)93L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"TIMESTAMPNTZ", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)7L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)9L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C10", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)-2L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"BINARY", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)0x800000L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C11", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)12L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"VARIANT", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)11L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C12", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)93L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"TIMESTAMPLTZ", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)8L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)12L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"T0", (Object)resultSet.getString(3));
            Assert.assertEquals((Object)"C13", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)2014L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"TIMESTAMPTZ", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("COLUMN_SIZE"));
            Assert.assertEquals((long)3L, (long)resultSet.getInt("DECIMAL_DIGITS"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NUM_PREC_RADIX"));
            Assert.assertEquals((long)1L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)13L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"YES", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_CATALOG"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_SCHEMA"));
            Assert.assertNull((Object)resultSet.getString("SCOPE_TABLE"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SOURCE_DATA_TYPE"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_AUTOINCREMENT"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GENERATEDCOLUMN"));
            connection.createStatement().execute("create or replace table T0(C1 string, C2 string default '', C3 string default 'apples', C4 string default '\"apples\"', C5 int, C6 int default 5, C7 string default '''', C8 string default '''apples''''', C9  string default '%')");
            metaData = connection.getMetaData();
            resultSet = metaData.getColumns(database, schema, "T0", "%");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"", (Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"apples", (Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"\"apples\"", (Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"5", (Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"'", (Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"'apples''", (Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"%", (Object)resultSet.getString("COLUMN_DEF"));
            try {
                resultSet.getString("INVALID_COLUMN");
                Assert.fail((String)"must fail");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            resultSet = metaData.getColumnPrivileges(database, schema, "T0", "C1");
            Assert.assertEquals((long)0L, (long)super.getSizeOfResultSet(resultSet));
            connection.createStatement().execute("drop table if exists T0");
        }
    }

    @Test
    public void testGetStreams() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            String database = con.getCatalog();
            String schema = con.getSchema();
            String owner = con.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().getRole();
            String targetStream = "S0";
            String targetTable = "T0";
            String tableName = database + "." + schema + "." + "T0";
            Statement statement = con.createStatement();
            statement.execute("create or replace table T0(C1 int)");
            statement.execute("create or replace stream S0 on table T0");
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet resultSet = metaData.unwrap(SnowflakeDatabaseMetaData.class).getStreams(database, schema, "%");
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_STREAMS);
            HashSet<String> streams = new HashSet<String>();
            while (resultSet.next()) {
                streams.add(resultSet.getString(1));
            }
            Assert.assertTrue((boolean)streams.contains("S0"));
            resultSet = metaData.unwrap(SnowflakeDatabaseMetaData.class).getStreams(database, schema, "S0");
            resultSet.next();
            Assert.assertEquals((Object)"S0", (Object)resultSet.getString(1));
            Assert.assertEquals((Object)database, (Object)resultSet.getString(2));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString(3));
            Assert.assertEquals((Object)owner, (Object)resultSet.getString(4));
            Assert.assertEquals((Object)"", (Object)resultSet.getString(5));
            Assert.assertEquals((Object)tableName, (Object)resultSet.getString(6));
            Assert.assertEquals((Object)"Table", (Object)resultSet.getString(7));
            Assert.assertEquals((Object)tableName, (Object)resultSet.getString(8));
            Assert.assertEquals((Object)"DELTA", (Object)resultSet.getString(9));
            Assert.assertEquals((Object)"false", (Object)resultSet.getString(10));
            Assert.assertEquals((Object)"DEFAULT", (Object)resultSet.getString(11));
            con.createStatement().execute("drop table if exists T0");
            con.createStatement().execute("drop stream if exists S0");
            resultSet.close();
            statement.close();
        }
    }

    @Test
    @Ignore
    public void testGetProceduresWithReaderAccount() throws SQLException {
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();){
            DatabaseMetaData metadata = connection.getMetaData();
            ResultSet rs = metadata.getProcedures(null, null, null);
            Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(rs));
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetProcedureColumns() throws Exception {
        try (Connection connection = DatabaseMetaDataLatestIT.getConnection();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            connection.createStatement().execute(PI_PROCEDURE);
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getProcedureColumns(database, schema, "GETPI", "%");
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_PROCEDURE_COLUMNS);
            resultSet.next();
            Assert.assertEquals((Object)database, (Object)resultSet.getString("PROCEDURE_CAT"));
            Assert.assertEquals((Object)schema, (Object)resultSet.getString("PROCEDURE_SCHEM"));
            Assert.assertEquals((Object)"GETPI", (Object)resultSet.getString("PROCEDURE_NAME"));
            Assert.assertEquals((Object)"", (Object)resultSet.getString("COLUMN_NAME"));
            Assert.assertEquals((long)5L, (long)resultSet.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)6L, (long)resultSet.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"FLOAT", (Object)resultSet.getString("TYPE_NAME"));
            Assert.assertEquals((long)38L, (long)resultSet.getInt("PRECISION"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getShort("SCALE"));
            Assert.assertEquals((long)10L, (long)resultSet.getInt("RADIX"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("NULLABLE"));
            Assert.assertEquals((Object)"user-defined procedure", (Object)resultSet.getString("REMARKS"));
            Assert.assertNull((Object)resultSet.getString("COLUMN_DEF"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("SQL_DATA_TYPE"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("SQL_DATETIME_SUB"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("CHAR_OCTET_LENGTH"));
            Assert.assertEquals((long)0L, (long)resultSet.getInt("ORDINAL_POSITION"));
            Assert.assertEquals((Object)"NO", (Object)resultSet.getString("IS_NULLABLE"));
            Assert.assertEquals((Object)"GETPI() RETURN FLOAT", (Object)resultSet.getString("SPECIFIC_NAME"));
            connection.createStatement().execute("drop procedure if exists GETPI()");
        }
    }

    @Test
    public void testGetProcedureColumnsReturnsResultSet() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = con.createStatement();
            statement.execute("create or replace table testtable (id int, name varchar(20), address varchar(20));");
            statement.execute("create or replace procedure PROCTEST()\nreturns table (\"id\" number(38,0), \"name\" varchar(20), \"address\" varchar(20))\nlanguage sql\nexecute as owner\nas 'declare\n    res resultset default (select * from testtable);\n  begin\n    return table(res);\n  end';");
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet res = metaData.getProcedureColumns(con.getCatalog(), null, "PROCTEST", "%");
            res.next();
            Assert.assertEquals((Object)"PROCTEST", (Object)res.getString("PROCEDURE_NAME"));
            Assert.assertEquals((Object)"id", (Object)res.getString("COLUMN_NAME"));
            Assert.assertEquals((long)3L, (long)res.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)2L, (long)res.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"NUMBER", (Object)res.getString("TYPE_NAME"));
            Assert.assertEquals((long)1L, (long)res.getInt("ORDINAL_POSITION"));
            res.next();
            Assert.assertEquals((Object)"name", (Object)res.getString("COLUMN_NAME"));
            Assert.assertEquals((long)3L, (long)res.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)12L, (long)res.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"VARCHAR", (Object)res.getString("TYPE_NAME"));
            Assert.assertEquals((long)2L, (long)res.getInt("ORDINAL_POSITION"));
            res.next();
            Assert.assertEquals((Object)"address", (Object)res.getString("COLUMN_NAME"));
            Assert.assertEquals((long)3L, (long)res.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)12L, (long)res.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"VARCHAR", (Object)res.getString("TYPE_NAME"));
            Assert.assertEquals((long)3L, (long)res.getInt("ORDINAL_POSITION"));
            res.close();
            statement.execute("drop table if exists testtable");
            statement.close();
        }
    }

    @Test
    public void testGetProcedureColumnsReturnsValue() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = con.createStatement();
            DatabaseMetaData metaData = con.getMetaData();
            statement.execute(PI_PROCEDURE);
            ResultSet res = metaData.getProcedureColumns(con.getCatalog(), null, "GETPI", "%");
            res.next();
            Assert.assertEquals((Object)"GETPI", (Object)res.getString("PROCEDURE_NAME"));
            Assert.assertEquals((Object)"", (Object)res.getString("COLUMN_NAME"));
            Assert.assertEquals((long)5L, (long)res.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)6L, (long)res.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"FLOAT", (Object)res.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)res.getInt("ORDINAL_POSITION"));
            statement.execute(MESSAGE_PROCEDURE);
            res = metaData.getProcedureColumns(con.getCatalog(), null, "MESSAGE_PROC", "%");
            res.next();
            Assert.assertEquals((Object)"MESSAGE_PROC", (Object)res.getString("PROCEDURE_NAME"));
            Assert.assertEquals((Object)"", (Object)res.getString("COLUMN_NAME"));
            Assert.assertEquals((long)5L, (long)res.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)12L, (long)res.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"VARCHAR", (Object)res.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)res.getInt("ORDINAL_POSITION"));
            res.next();
            Assert.assertEquals((Object)"MESSAGE", (Object)res.getString("COLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)res.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)12L, (long)res.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"VARCHAR", (Object)res.getString("TYPE_NAME"));
            Assert.assertEquals((long)1L, (long)res.getInt("ORDINAL_POSITION"));
            res.close();
            statement.close();
        }
    }

    @Test
    public void testGetProcedureColumnsReturnsNull() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            Statement statement = con.createStatement();
            DatabaseMetaData metaData = con.getMetaData();
            statement.execute("create or replace table testtable (id int, name varchar(20), address varchar(20));");
            statement.execute("create or replace procedure insertproc() \nreturns varchar \nlanguage javascript as \n'var sqlcommand = \n`insert into testtable (id, name, address) values (1, \\'Tom\\', \\'Pacific Avenue\\');` \nsnowflake.execute({sqlText: sqlcommand}); \n';");
            ResultSet res = metaData.getProcedureColumns(con.getCatalog(), null, "INSERTPROC", "%");
            res.next();
            Assert.assertEquals((Object)"INSERTPROC", (Object)res.getString("PROCEDURE_NAME"));
            Assert.assertEquals((Object)"", (Object)res.getString("COLUMN_NAME"));
            Assert.assertEquals((long)5L, (long)res.getInt("COLUMN_TYPE"));
            Assert.assertEquals((long)12L, (long)res.getInt("DATA_TYPE"));
            Assert.assertEquals((Object)"VARCHAR", (Object)res.getString("TYPE_NAME"));
            Assert.assertEquals((long)0L, (long)res.getInt("ORDINAL_POSITION"));
        }
    }

    @Test
    public void testUpdateLocatorsCopyUnsupported() throws SQLException {
        try (Connection con = DatabaseMetaDataLatestIT.getConnection();){
            DatabaseMetaData metaData = con.getMetaData();
            Assert.assertFalse((boolean)metaData.locatorsUpdateCopy());
        }
    }
}

