/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaDataResultSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public class DatabaseMetaDataResultsetIT
extends BaseJDBCTest {
    private static final int columnCount = 9;
    private static final int INT_DATA = 1;
    private static final String TEXT_DATA = "TEST";
    private static final String EPOCH_DATE = "1970-01-01";
    private static final double DOUBLE_DATA = 9.5555555;
    private static final double DELTA = 1.0E-4;
    private static final long NOW = System.currentTimeMillis();
    private static final Time TIME_DATA = new Time(NOW);
    private static final Timestamp TIMESTAMP_DATA = new Timestamp(NOW);
    private static final boolean BOOLEAN_DATA = true;
    private static final BigDecimal DECIMAL_DATA = new BigDecimal(0.01);
    private static final long BIGINT_DATA = 10100000L;
    private static final List<String> columnNames = Arrays.asList("int", "text", "date", "double", "time", "timestamp", "bool", "decimal", "bigint");
    private static final List<String> columnTypeNames = Arrays.asList("INTEGER", "TEXT", "DATA", "DOUBLE", "TIME", "TIMESTAMP", "BOOLEAN", "DECIMAL", "BIGINT");
    private static final List<Integer> columnTypes = Arrays.asList(4, 12, 91, 8, 92, 93, 16, 3, -5);
    private static final Object[][] rows = new Object[][]{{1, "TEST", Date.valueOf("1970-01-01"), 9.5555555, TIME_DATA, TIMESTAMP_DATA, true, DECIMAL_DATA, 10100000L}, {0, null, null, 0, null, null, false, null, 0}};

    @Test
    public void testRowIndex() throws SQLException {
        ResultSet resultSet = this.getResultSet(false);
        Assert.assertEquals((long)9L, (long)resultSet.getMetaData().getColumnCount());
        Assert.assertEquals((long)-1L, (long)resultSet.getRow());
        Assert.assertTrue((boolean)resultSet.isBeforeFirst());
        Assert.assertFalse((boolean)resultSet.isFirst());
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((long)0L, (long)resultSet.getRow());
        Assert.assertFalse((boolean)resultSet.isBeforeFirst());
        Assert.assertTrue((boolean)resultSet.isFirst());
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((long)1L, (long)resultSet.getRow());
        Assert.assertTrue((boolean)resultSet.isLast());
        Assert.assertFalse((boolean)resultSet.isAfterLast());
        Assert.assertFalse((boolean)resultSet.next());
        Assert.assertEquals((long)2L, (long)resultSet.getRow());
        Assert.assertFalse((boolean)resultSet.isLast());
        Assert.assertTrue((boolean)resultSet.isAfterLast());
    }

    private ResultSet getResultSet(boolean doNext) throws SQLException {
        Connection con = DatabaseMetaDataResultsetIT.getConnection();
        Statement st = con.createStatement();
        SnowflakeDatabaseMetaDataResultSet resultSet = new SnowflakeDatabaseMetaDataResultSet(columnNames, columnTypeNames, columnTypes, rows, st);
        if (doNext) {
            resultSet.next();
        }
        return resultSet;
    }

    @Test
    public void testGetInt() throws SQLException {
        ResultSet resultSet = this.getResultSet(true);
        Assert.assertEquals((long)1L, (long)resultSet.getInt("int"));
    }

    @Test
    public void testGetString() throws SQLException {
        ResultSet resultSet = this.getResultSet(true);
        Assert.assertEquals((Object)TEXT_DATA, (Object)resultSet.getString("text"));
    }

    @Test
    public void testGetDate() throws SQLException {
        ResultSet resultSet = this.getResultSet(true);
        Assert.assertEquals((Object)Date.valueOf(EPOCH_DATE), (Object)resultSet.getDate("date"));
    }

    @Test
    public void testGetDouble() throws SQLException {
        ResultSet resultSet = this.getResultSet(true);
        Assert.assertEquals((double)9.5555555, (double)resultSet.getDouble("double"), (double)1.0E-4);
    }

    @Test
    public void testGetTime() throws SQLException {
        ResultSet resultSet = this.getResultSet(true);
        Assert.assertEquals((Object)TIME_DATA, (Object)resultSet.getTime("time"));
    }

    @Test
    public void testGetTimestamp() throws SQLException {
        ResultSet resultSet = this.getResultSet(true);
        Assert.assertEquals((Object)TIMESTAMP_DATA, (Object)resultSet.getTimestamp("timestamp"));
    }

    @Test
    public void testGetBoolean() throws SQLException {
        ResultSet resultSet = this.getResultSet(true);
        Assert.assertEquals((Object)true, (Object)resultSet.getBoolean("bool"));
    }

    @Test
    public void testGetObject() throws SQLException {
        ResultSet resultSet = this.getResultSet(true);
        Assert.assertEquals((Object)1, (Object)resultSet.getObject(1));
        Assert.assertEquals((Object)TEXT_DATA, (Object)resultSet.getObject(2));
        Assert.assertEquals((Object)Date.valueOf(EPOCH_DATE), (Object)resultSet.getObject(3));
        Assert.assertEquals((Object)9.5555555, (Object)resultSet.getObject(4));
        Assert.assertEquals((Object)TIME_DATA, (Object)resultSet.getObject(5));
        Assert.assertEquals((Object)TIMESTAMP_DATA, (Object)resultSet.getObject(6));
        Assert.assertEquals((Object)true, (Object)resultSet.getObject(7));
        Assert.assertEquals((Object)DECIMAL_DATA, (Object)resultSet.getObject(8));
        Assert.assertEquals((Object)10100000L, (Object)resultSet.getObject(9));
    }
}

