/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferConfig;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileUploaderExpandFileNamesTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testProcessFileNames() throws Exception {
        this.folder.newFile("TestFileA");
        this.folder.newFile("TestFileB");
        String folderName = this.folder.getRoot().getCanonicalPath();
        System.setProperty("user.dir", folderName);
        System.setProperty("user.home", folderName);
        String[] locations = new String[]{folderName + "/Tes*Fil*A", folderName + "/TestFil?B", "~/TestFileC", "TestFileD", folderName + "/TestFileE~"};
        Set files = SnowflakeFileTransferAgent.expandFileNames((String[])locations);
        Assert.assertTrue((boolean)files.contains(folderName + "/TestFileA"));
        Assert.assertTrue((boolean)files.contains(folderName + "/TestFileB"));
        Assert.assertTrue((boolean)files.contains(folderName + "/TestFileC"));
        Assert.assertTrue((boolean)files.contains(folderName + "/TestFileD"));
        Assert.assertTrue((boolean)files.contains(folderName + "/TestFileE~"));
    }

    @Test
    public void testProcessFileNamesException() {
        SnowflakeFileTransferAgent.setInjectedFileTransferException((Throwable)new Exception());
        String[] locations = new String[]{"/Tes*Fil*A", "/TestFil?B", "~/TestFileC", "TestFileD"};
        try {
            SnowflakeFileTransferAgent.expandFileNames((String[])locations);
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)200007L, (long)err.getErrorCode());
            Assert.assertEquals((Object)"22000", (Object)err.getSQLState());
        }
        SnowflakeFileTransferAgent.setInjectedFileTransferException(null);
    }

    @Test
    public void testSnowflakeFileTransferConfig() throws Exception {
        SnowflakeFileTransferMetadataV1 metadata = new SnowflakeFileTransferMetadataV1("dummy_presigned_url", null, null, null, null, null, null);
        SnowflakeFileTransferConfig.Builder builder = SnowflakeFileTransferConfig.Builder.newInstance();
        int throwCount = 0;
        int expectedThrowCount = 3;
        try {
            builder.build();
        }
        catch (IllegalArgumentException ex) {
            ++throwCount;
        }
        builder.setSnowflakeFileTransferMetadata((SnowflakeFileTransferMetadata)metadata);
        try {
            builder.build();
        }
        catch (IllegalArgumentException ex) {
            ++throwCount;
        }
        InputStream input = new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        };
        builder.setUploadStream(input);
        try {
            builder.build();
        }
        catch (IllegalArgumentException ex) {
            ++throwCount;
        }
        builder.setOcspMode(OCSPMode.FAIL_CLOSED);
        builder.setRequireCompress(false);
        builder.setNetworkTimeoutInMilli(12345);
        builder.setPrefix("dummy_prefix");
        Properties props = new Properties();
        builder.setProxyProperties(props);
        builder.setDestFileName("dummy_dest_file_name");
        SnowflakeFileTransferConfig config = builder.build();
        assert (config.getSnowflakeFileTransferMetadata() == metadata);
        assert (config.getUploadStream() == input);
        assert (config.getOcspMode() == OCSPMode.FAIL_CLOSED);
        assert (!config.getRequireCompress());
        assert (config.getNetworkTimeoutInMilli() == 12345);
        assert (config.getProxyProperties() == props);
        assert (config.getPrefix().equals("dummy_prefix"));
        assert (config.getDestFileName().equals("dummy_dest_file_name"));
        Assert.assertEquals((long)expectedThrowCount, (long)throwCount);
    }
}

