/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.FileUploaderPrepIT;
import net.snowflake.client.jdbc.SFBaseFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferConfig;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.S3StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeGCSClient;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageClientFactory;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public class FileUploaderLatestIT
extends FileUploaderPrepIT {
    private static final String OBJ_META_STAGE = "testObjMeta";
    private ObjectMapper mapper = new ObjectMapper();
    private static final String PUT_COMMAND = "put file:///dummy/path/file2.gz @testStage";

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetS3StageDataWithS3Session() throws SQLException {
        Connection con = FileUploaderLatestIT.getConnection("s3testaccount");
        SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
        sfSession.setUseRegionalS3EndpointsForPresignedURL(true);
        StageInfo stageInfo = SnowflakeFileTransferAgent.getStageInfo((JsonNode)this.exampleS3JsonNode, (SFSession)sfSession);
        Assert.assertEquals((Object)StageInfo.StageType.S3, (Object)stageInfo.getStageType());
        Assert.assertEquals((Object)true, (Object)stageInfo.getUseS3RegionalUrl());
        sfSession.setUseRegionalS3EndpointsForPresignedURL(false);
        stageInfo = SnowflakeFileTransferAgent.getStageInfo((JsonNode)this.exampleS3JsonNode, (SFSession)sfSession);
        Assert.assertEquals((Object)StageInfo.StageType.S3, (Object)stageInfo.getStageType());
        Assert.assertEquals((Object)false, (Object)stageInfo.getUseS3RegionalUrl());
        con.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetS3StageDataWithAzureSession() throws SQLException {
        Connection con = FileUploaderLatestIT.getConnection("azureaccount");
        SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
        sfSession.setUseRegionalS3EndpointsForPresignedURL(true);
        StageInfo stageInfo = SnowflakeFileTransferAgent.getStageInfo((JsonNode)this.exampleAzureJsonNode, (SFSession)sfSession);
        Assert.assertEquals((Object)StageInfo.StageType.AZURE, (Object)stageInfo.getStageType());
        Assert.assertEquals((Object)"EXAMPLE_LOCATION/", (Object)stageInfo.getLocation());
        Assert.assertEquals((Object)false, (Object)stageInfo.getUseS3RegionalUrl());
        con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetObjectMetadataWithGCS() throws Exception {
        Connection connection = null;
        try {
            Properties paramProperties = new Properties();
            paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
            connection = FileUploaderLatestIT.getConnection("gcpaccount", paramProperties);
            Statement statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE STAGE testObjMeta");
            String sourceFilePath = FileUploaderLatestIT.getFullPathFileInResource("orders_100.csv");
            String putCommand = "PUT file://" + sourceFilePath + " @" + OBJ_META_STAGE;
            statement.execute(putCommand);
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
            StageInfo info = sfAgent.getStageInfo();
            SnowflakeGCSClient client = SnowflakeGCSClient.createSnowflakeGCSClient((StageInfo)info, (RemoteStoreFileEncryptionMaterial)((RemoteStoreFileEncryptionMaterial)sfAgent.getEncryptionMaterial().get(0)), (SFSession)sfSession);
            String location = info.getLocation();
            int idx = location.indexOf(47);
            String remoteStageLocation = location.substring(0, idx);
            String path = location.substring(idx + 1) + "orders_100.csv" + ".gz";
            StorageObjectMetadata metadata = client.getObjectMetadata(remoteStageLocation, path);
            Assert.assertEquals((Object)"gzip", (Object)metadata.getContentEncoding());
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists testObjMeta");
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetObjectMetadataFileNotFoundWithGCS() throws Exception {
        Connection connection = null;
        try {
            Properties paramProperties = new Properties();
            paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
            connection = FileUploaderLatestIT.getConnection("gcpaccount", paramProperties);
            Statement statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE STAGE testObjMeta");
            String sourceFilePath = FileUploaderLatestIT.getFullPathFileInResource("orders_100.csv");
            String putCommand = "PUT file://" + sourceFilePath + " @" + OBJ_META_STAGE;
            statement.execute(putCommand);
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
            StageInfo info = sfAgent.getStageInfo();
            SnowflakeGCSClient client = SnowflakeGCSClient.createSnowflakeGCSClient((StageInfo)info, (RemoteStoreFileEncryptionMaterial)((RemoteStoreFileEncryptionMaterial)sfAgent.getEncryptionMaterial().get(0)), (SFSession)sfSession);
            String location = info.getLocation();
            int idx = location.indexOf(47);
            String remoteStageLocation = location.substring(0, idx);
            String path = location.substring(idx + 1) + "wrong_file.csv.gz";
            client.getObjectMetadata(remoteStageLocation, path);
            Assert.fail((String)"should raise exception");
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Wrong type of exception. Message: " + ex.getMessage()), (boolean)(ex instanceof StorageProviderException));
            Assert.assertTrue((boolean)ex.getMessage().matches(".*Blob.*not found in bucket.*"));
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists testObjMeta");
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetObjectMetadataStorageExceptionWithGCS() throws Exception {
        Connection connection = null;
        try {
            Properties paramProperties = new Properties();
            paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
            connection = FileUploaderLatestIT.getConnection("gcpaccount", paramProperties);
            Statement statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE STAGE testObjMeta");
            String sourceFilePath = FileUploaderLatestIT.getFullPathFileInResource("orders_100.csv");
            String putCommand = "PUT file://" + sourceFilePath + " @" + OBJ_META_STAGE;
            statement.execute(putCommand);
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
            StageInfo info = sfAgent.getStageInfo();
            SnowflakeGCSClient client = SnowflakeGCSClient.createSnowflakeGCSClient((StageInfo)info, (RemoteStoreFileEncryptionMaterial)((RemoteStoreFileEncryptionMaterial)sfAgent.getEncryptionMaterial().get(0)), (SFSession)sfSession);
            String location = info.getLocation();
            int idx = location.indexOf(47);
            String remoteStageLocation = location.substring(0, idx);
            client.getObjectMetadata(remoteStageLocation, "");
            Assert.fail((String)"should raise exception");
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Wrong type of exception. Message: " + ex.getMessage()), (boolean)(ex instanceof StorageProviderException));
            Assert.assertTrue((boolean)ex.getMessage().matches(".*Permission.*denied.*"));
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists testObjMeta");
                connection.close();
            }
        }
    }

    @Test
    public void testGetFileTransferCommandType() throws SQLException {
        Connection con = FileUploaderLatestIT.getConnection();
        Statement statement = con.createStatement();
        statement.execute("CREATE OR REPLACE STAGE testStage");
        SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
        SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(PUT_COMMAND, sfSession, new SFStatement(sfSession));
        Assert.assertEquals((Object)SFBaseFileTransferAgent.CommandType.UPLOAD, (Object)sfAgent.getCommandType());
        statement.execute("drop stage if exists testStage");
        con.close();
    }

    @Test
    public void testNullCommand() throws SQLException {
        Connection con = FileUploaderLatestIT.getConnection();
        Statement statement = con.createStatement();
        statement.execute("create or replace stage testStage");
        SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
        try {
            SnowflakeFileTransferAgent snowflakeFileTransferAgent = new SnowflakeFileTransferAgent(null, sfSession, new SFStatement(sfSession));
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assert.assertTrue((boolean)err.getMessage().contains("JDBC driver internal error: Missing sql for statement execution"));
        }
        statement.execute("drop stage if exists testStage");
        con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressStreamWithGzipException() throws Exception {
        Connection con = null;
        SnowflakeFileTransferAgent.setInjectedFileTransferException((Throwable)new NoSuchAlgorithmException());
        try {
            con = FileUploaderLatestIT.getConnection();
            Statement statement = con.createStatement();
            statement.execute("create or replace stage testStage");
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(PUT_COMMAND, sfSession, new SFStatement(sfSession));
            List metadataList = sfAgent.getFileTransferMetadatas();
            SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
            String srcPath = FileUploaderLatestIT.getFullPathFileInResource("orders_100.csv");
            FileInputStream inputStream = new FileInputStream(srcPath);
            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata((SnowflakeFileTransferMetadata)metadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(PUT_COMMAND).build());
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assert.assertTrue((boolean)err.getMessage().contains("JDBC driver internal error: error encountered for compression"));
        }
        finally {
            if (con != null) {
                con.createStatement().execute("DROP STAGE if exists testStage");
                con.close();
            }
        }
        SnowflakeFileTransferAgent.setInjectedFileTransferException(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressStreamWithGzipNoDigestException() throws Exception {
        Connection con = null;
        SnowflakeFileTransferAgent.setInjectedFileTransferException((Throwable)new IOException());
        try {
            con = FileUploaderLatestIT.getConnection();
            Statement statement = con.createStatement();
            statement.execute("create or replace stage testStage");
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(PUT_COMMAND, sfSession, new SFStatement(sfSession));
            List metadataList = sfAgent.getFileTransferMetadatas();
            SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
            metadata.setEncryptionMaterial(null, null, null);
            String srcPath = FileUploaderLatestIT.getFullPathFileInResource("orders_100.csv");
            FileInputStream inputStream = new FileInputStream(srcPath);
            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata((SnowflakeFileTransferMetadata)metadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(PUT_COMMAND).build());
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assert.assertTrue((boolean)err.getMessage().contains("JDBC driver internal error: error encountered for compression"));
        }
        finally {
            if (con != null) {
                con.createStatement().execute("DROP STAGE if exists testStage");
                con.close();
            }
        }
        SnowflakeFileTransferAgent.setInjectedFileTransferException(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadWithoutConnectionException() throws Exception {
        Connection con = null;
        SnowflakeFileTransferAgent.setInjectedFileTransferException((Throwable)new Exception("Exception encountered during file upload: failed to push to remote store"));
        try {
            con = FileUploaderLatestIT.getConnection();
            Statement statement = con.createStatement();
            statement.execute("create or replace stage testStage");
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(PUT_COMMAND, sfSession, new SFStatement(sfSession));
            List metadataList = sfAgent.getFileTransferMetadatas();
            SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
            String srcPath = FileUploaderLatestIT.getFullPathFileInResource("orders_100.csv");
            FileInputStream inputStream = new FileInputStream(srcPath);
            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata((SnowflakeFileTransferMetadata)metadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(PUT_COMMAND).build());
        }
        catch (Exception err) {
            Assert.assertTrue((boolean)err.getMessage().contains("Exception encountered during file upload: failed to push to remote store"));
        }
        finally {
            if (con != null) {
                con.createStatement().execute("DROP STAGE if exists testStage");
                con.close();
            }
        }
        SnowflakeFileTransferAgent.setInjectedFileTransferException(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitFileMetadataFileNotFound() throws Exception {
        Connection con = null;
        try {
            con = FileUploaderLatestIT.getConnection();
            Statement statement = con.createStatement();
            statement.execute("create or replace stage testStage");
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(PUT_COMMAND, sfSession, new SFStatement(sfSession));
            sfAgent.execute();
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)200008L, (long)err.getErrorCode());
        }
        finally {
            if (con != null) {
                con.createStatement().execute("DROP STAGE if exists testStage");
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitFileMetadataFileIsDirectory() throws Exception {
        Connection con = null;
        try {
            con = FileUploaderLatestIT.getConnection();
            Statement statement = con.createStatement();
            statement.execute("create or replace stage testStage");
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String srcPath = FileUploaderLatestIT.getFullPathFileInResource("");
            String command = "put file://" + srcPath + " @testStage";
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(command, sfSession, new SFStatement(sfSession));
            sfAgent.execute();
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)200009L, (long)err.getErrorCode());
        }
        finally {
            if (con != null) {
                con.createStatement().execute("DROP STAGE if exists testStage");
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompareAndSkipFilesException() throws Exception {
        Connection con = null;
        SnowflakeFileTransferAgent.setInjectedFileTransferException((Throwable)new NoSuchAlgorithmException());
        try {
            con = FileUploaderLatestIT.getConnection();
            Statement statement = con.createStatement();
            statement.execute("create or replace stage testStage");
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String command = "PUT file://" + FileUploaderLatestIT.getFullPathFileInResource("orders_100.csv") + " @testStage";
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(command, sfSession, new SFStatement(sfSession));
            sfAgent.execute();
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assert.assertTrue((boolean)err.getMessage().contains("Error reading:"));
        }
        finally {
            if (con != null) {
                con.createStatement().execute("DROP STAGE if exists testStage");
                con.close();
            }
        }
        SnowflakeFileTransferAgent.setInjectedFileTransferException(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParseCommandException() throws SQLException {
        Connection con = null;
        SnowflakeFileTransferAgent.setInjectedFileTransferException((Throwable)new SnowflakeSQLException("invalid data"));
        try {
            con = FileUploaderLatestIT.getConnection();
            Statement statement = con.createStatement();
            statement.execute("create or replace stage testStage");
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            SnowflakeFileTransferAgent snowflakeFileTransferAgent = new SnowflakeFileTransferAgent(PUT_COMMAND, sfSession, new SFStatement(sfSession));
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assert.assertTrue((boolean)err.getMessage().contains("Failed to parse the locations"));
        }
        finally {
            if (con != null) {
                con.createStatement().execute("DROP STAGE if exists testStage");
                con.close();
            }
        }
        SnowflakeFileTransferAgent.setInjectedFileTransferException(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPopulateStatusRowsWithSortOn() throws Exception {
        Connection con = null;
        try {
            con = FileUploaderLatestIT.getConnection();
            Statement statement = con.createStatement();
            statement.execute("create or replace stage testStage");
            statement.execute("set-sf-property sort on");
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String command = "PUT file://" + FileUploaderLatestIT.getFullPathFileInResource("") + "/orders_10*.csv @testStage";
            SnowflakeFileTransferAgent sfAgent1 = new SnowflakeFileTransferAgent(command, sfSession, new SFStatement(sfSession));
            sfAgent1.execute();
            Assert.assertEquals((long)2L, (long)sfAgent1.statusRows.size());
            Assert.assertEquals((Object)"orders_100.csv", (Object)sfAgent1.getNextRow().get(0).toString());
            String getCommand = "GET @testStage file:///tmp";
            SnowflakeFileTransferAgent sfAgent2 = new SnowflakeFileTransferAgent(getCommand, sfSession, new SFStatement(sfSession));
            sfAgent2.execute();
            Assert.assertEquals((long)2L, (long)sfAgent2.statusRows.size());
            Assert.assertEquals((Object)"orders_100.csv.gz", (Object)sfAgent2.getNextRow().get(0).toString());
        }
        finally {
            if (con != null) {
                con.createStatement().execute("DROP STAGE if exists testStage");
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListObjectsStorageException() throws Exception {
        Connection con = null;
        SnowflakeFileTransferAgent.setInjectedFileTransferException((Throwable)new StorageProviderException(new Exception("could not list objects")));
        try {
            con = FileUploaderLatestIT.getConnection();
            Statement statement = con.createStatement();
            statement.execute("create or replace stage testStage");
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String command = "PUT file://" + FileUploaderLatestIT.getFullPathFileInResource("orders_100.csv") + " @testStage";
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(command, sfSession, new SFStatement(sfSession));
            sfAgent.execute();
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)200016L, (long)err.getErrorCode());
            Assert.assertTrue((boolean)err.getMessage().contains("Encountered exception during listObjects"));
        }
        finally {
            if (con != null) {
                con.createStatement().execute("DROP STAGE if exists testStage");
                con.close();
            }
        }
        SnowflakeFileTransferAgent.setInjectedFileTransferException(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadStreamInterruptedException() throws IOException, SQLException {
        String DEST_PREFIX = TEST_UUID + "/testUploadStream";
        SnowflakeFileTransferAgent.setInjectedFileTransferException((Throwable)new InterruptedException());
        Connection connection = null;
        Statement statement = null;
        try {
            connection = FileUploaderLatestIT.getConnection();
            statement = connection.createStatement();
            FileBackedOutputStream outputStream = new FileBackedOutputStream(1000000);
            outputStream.write("hello".getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            connection.unwrap(SnowflakeConnection.class).uploadStream("~", DEST_PREFIX, outputStream.asByteSource().openStream(), "hello.txt", false);
        }
        catch (SnowflakeSQLLoggedException err) {
            Assert.assertEquals((long)200003L, (long)err.getErrorCode());
        }
        finally {
            if (statement != null) {
                statement.execute("rm @~/" + DEST_PREFIX);
                statement.close();
            }
            this.closeSQLObjects(statement, connection);
        }
        SnowflakeFileTransferAgent.setInjectedFileTransferException(null);
    }

    @Test
    public void testFileTransferStageInfo() throws SQLException {
        Connection con = FileUploaderLatestIT.getConnection();
        Statement statement = con.createStatement();
        statement.execute("CREATE OR REPLACE STAGE testStage");
        SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
        SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(PUT_COMMAND, sfSession, new SFStatement(sfSession));
        StageInfo stageInfo = sfAgent.getStageInfo();
        Assert.assertEquals((Object)sfAgent.getStageCredentials(), (Object)stageInfo.getCredentials());
        Assert.assertEquals((Object)sfAgent.getStageLocation(), (Object)stageInfo.getLocation());
        statement.execute("drop stage if exists testStage");
        con.close();
    }

    @Test
    public void testFileTransferMappingFromSourceFile() throws SQLException {
        Connection con = FileUploaderLatestIT.getConnection();
        Statement statement = con.createStatement();
        statement.execute("CREATE OR REPLACE STAGE testStage");
        SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
        String command = "PUT file://" + FileUploaderLatestIT.getFullPathFileInResource("") + "/orders_10*.csv @testStage";
        SnowflakeFileTransferAgent sfAgent1 = new SnowflakeFileTransferAgent(command, sfSession, new SFStatement(sfSession));
        sfAgent1.execute();
        SnowflakeFileTransferAgent sfAgent2 = new SnowflakeFileTransferAgent("GET @testStage file:///tmp/", sfSession, new SFStatement(sfSession));
        Assert.assertEquals((long)2L, (long)sfAgent2.getSrcToMaterialsMap().size());
        Assert.assertEquals((long)2L, (long)sfAgent2.getSrcToPresignedUrlMap().size());
        statement.execute("drop stage if exists testStage");
        con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadFileCallableFileNotFound() throws Exception {
        SnowflakeFileTransferAgent.setInjectedFileTransferException((Throwable)new FileNotFoundException("file does not exist"));
        Connection connection = null;
        Statement statement = null;
        try {
            connection = FileUploaderLatestIT.getConnection();
            statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE STAGE testStage");
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String command = "PUT file://" + FileUploaderLatestIT.getFullPathFileInResource("orders_100.csv") + " @testStage";
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(command, sfSession, new SFStatement(sfSession));
            sfAgent.execute();
        }
        catch (Exception err) {
            Assert.assertEquals((Object)err.getCause(), (Object)CoreMatchers.instanceOf(FileNotFoundException.class));
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists testStage");
                connection.close();
            }
        }
        SnowflakeFileTransferAgent.setInjectedFileTransferException(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadFileStreamWithNoOverwrite() throws Exception {
        Connection connection = null;
        try {
            connection = FileUploaderLatestIT.getConnection();
            Statement statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE STAGE testStage");
            this.uploadFileToStageUsingStream(connection, false);
            ResultSet resultSet = statement.executeQuery("LIST @testStage");
            resultSet.next();
            String expectedValue = resultSet.getString("last_modified");
            Thread.sleep(1000L);
            this.uploadFileToStageUsingStream(connection, false);
            resultSet = statement.executeQuery("LIST @testStage");
            resultSet.next();
            String actualValue = resultSet.getString("last_modified");
            Assert.assertTrue((boolean)expectedValue.equals(actualValue));
        }
        catch (Exception e) {
            Assert.fail((String)("testUploadFileStreamWithNoOverwrite failed " + e.getMessage()));
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists testStage");
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadFileStreamWithOverwrite() throws Exception {
        Connection connection = null;
        try {
            connection = FileUploaderLatestIT.getConnection();
            Statement statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE STAGE testStage");
            this.uploadFileToStageUsingStream(connection, true);
            ResultSet resultSet = statement.executeQuery("LIST @testStage");
            resultSet.next();
            String expectedValue = resultSet.getString("last_modified");
            Thread.sleep(1000L);
            this.uploadFileToStageUsingStream(connection, true);
            resultSet = statement.executeQuery("LIST @testStage");
            resultSet.next();
            String actualValue = resultSet.getString("last_modified");
            Assert.assertFalse((boolean)expectedValue.equals(actualValue));
        }
        catch (Exception e) {
            Assert.fail((String)("testUploadFileStreamWithNoOverwrite failed " + e.getMessage()));
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists testStage");
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetS3StorageObjectMetadata() throws Throwable {
        Connection connection = null;
        try {
            connection = FileUploaderLatestIT.getConnection("s3testaccount");
            Statement statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE STAGE testObjMeta");
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String putCommand = "put file:///dummy/path/file1.gz @testObjMeta";
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
            List metadata = sfAgent.getFileTransferMetadatas();
            String srcPath = FileUploaderLatestIT.getFullPathFileInResource("orders_100.csv");
            for (SnowflakeFileTransferMetadata oneMetadata : metadata) {
                FileInputStream inputStream = new FileInputStream(srcPath);
                SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand).build());
                SnowflakeStorageClient client = StorageClientFactory.getFactory().createClient(((SnowflakeFileTransferMetadataV1)oneMetadata).getStageInfo(), 1, null, null);
                String location = ((SnowflakeFileTransferMetadataV1)oneMetadata).getStageInfo().getLocation();
                int idx = location.indexOf(47);
                String remoteStageLocation = location.substring(0, idx);
                String path = location.substring(idx + 1) + "file1.gz";
                StorageObjectMetadata meta = client.getObjectMetadata(remoteStageLocation, path);
                ObjectMetadata s3Meta = new ObjectMetadata();
                s3Meta.setContentLength(meta.getContentLength());
                s3Meta.setContentEncoding(meta.getContentEncoding());
                s3Meta.setUserMetadata(meta.getUserMetadata());
                S3StorageObjectMetadata s3Metadata = new S3StorageObjectMetadata(s3Meta);
                RemoteStoreFileEncryptionMaterial encMat = (RemoteStoreFileEncryptionMaterial)sfAgent.getEncryptionMaterial().get(0);
                Map matDesc = (Map)this.mapper.readValue((String)s3Metadata.getUserMetadata().get("x-amz-matdesc"), Map.class);
                Assert.assertEquals((Object)encMat.getQueryId(), matDesc.get("queryId"));
                Assert.assertEquals((Object)encMat.getSmkId().toString(), matDesc.get("smkId"));
                Assert.assertEquals((long)1360L, (long)s3Metadata.getContentLength());
                Assert.assertEquals((Object)"gzip", (Object)s3Metadata.getContentEncoding());
            }
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists testObjMeta");
                connection.close();
            }
        }
    }

    private void uploadFileToStageUsingStream(Connection connection, boolean overwrite) throws Exception {
        SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
        String sourceFilePath = FileUploaderLatestIT.getFullPathFileInResource("orders_100.csv");
        String putCommand = "PUT file://" + sourceFilePath + " @testStage";
        if (overwrite) {
            putCommand = putCommand + " overwrite=true";
        }
        SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
        InputStream is = Files.newInputStream(Paths.get(sourceFilePath, new String[0]), new OpenOption[0]);
        sfAgent.setSourceStream(is);
        sfAgent.setDestFileNameForStreamSource("test_file");
        sfAgent.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadFileWithTildeInFolderName() throws SQLException, IOException {
        Path topDataDir;
        Writer writer;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block6: {
            connection = null;
            statement = null;
            resultSet = null;
            writer = null;
            topDataDir = null;
            try {
                topDataDir = Files.createTempDirectory("testPutFileTilde", new FileAttribute[0]);
                topDataDir.toFile().deleteOnExit();
                Path subDir = Files.createDirectories(Paths.get(topDataDir.toString(), "snowflake~"), new FileAttribute[0]);
                File dataFile = new File(subDir.toFile(), "test.txt");
                writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(dataFile.getCanonicalPath(), new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));
                writer.write("1,test1");
                writer.close();
                connection = FileUploaderLatestIT.getConnection();
                statement = connection.createStatement();
                statement.execute("create or replace stage testStage");
                String sql = String.format("PUT 'file://%s' @testStage", dataFile.getCanonicalPath());
                sql = sql.replaceAll("\\\\", "\\\\\\\\");
                resultSet = statement.executeQuery(sql);
                while (resultSet.next()) {
                    Assert.assertEquals((Object)"UPLOADED", (Object)resultSet.getString("status"));
                }
                if (connection == null) break block6;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    connection.createStatement().execute("drop stage if exists testStage");
                }
                this.closeSQLObjects(resultSet, statement, connection);
                if (writer != null) {
                    writer.close();
                }
                FileUtils.deleteDirectory((File)topDataDir.toFile());
                throw throwable;
            }
            connection.createStatement().execute("drop stage if exists testStage");
        }
        this.closeSQLObjects(resultSet, statement, connection);
        if (writer != null) {
            writer.close();
        }
        FileUtils.deleteDirectory((File)topDataDir.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadWithTildeInPath() throws SQLException, IOException {
        Path subDir;
        Writer writer;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block6: {
            connection = null;
            statement = null;
            resultSet = null;
            writer = null;
            subDir = null;
            try {
                String homeDir = SnowflakeUtil.systemGetProperty((String)"user.home");
                subDir = Files.createDirectories(Paths.get(homeDir, "snowflake"), new FileAttribute[0]);
                File dataFile = new File(subDir.toFile(), "test.txt");
                writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(dataFile.getCanonicalPath(), new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));
                writer.write("1,test1");
                writer.close();
                connection = FileUploaderLatestIT.getConnection();
                statement = connection.createStatement();
                statement.execute("create or replace stage testStage");
                resultSet = statement.executeQuery("PUT 'file://~/snowflake/test.txt' @testStage");
                while (resultSet.next()) {
                    Assert.assertEquals((Object)"UPLOADED", (Object)resultSet.getString("status"));
                }
                if (connection == null) break block6;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    connection.createStatement().execute("drop stage if exists testStage");
                }
                this.closeSQLObjects(resultSet, statement, connection);
                if (writer != null) {
                    writer.close();
                }
                FileUtils.deleteDirectory((File)subDir.toFile());
                throw throwable;
            }
            connection.createStatement().execute("drop stage if exists testStage");
        }
        this.closeSQLObjects(resultSet, statement, connection);
        if (writer != null) {
            writer.close();
        }
        FileUtils.deleteDirectory((File)subDir.toFile());
    }
}

