/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.common.core.FileCompressionType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FileUploaderMimeTypeToCompressionTypeTest {
    private final String mimeType;
    private final FileCompressionType mimeSubType;

    public FileUploaderMimeTypeToCompressionTypeTest(String mimeType, FileCompressionType mimeSubType) {
        this.mimeType = mimeType;
        this.mimeSubType = mimeSubType;
    }

    @Parameterized.Parameters(name="mimeType={0}, mimeSubType={1}")
    public static Collection primeNumbers() {
        return Arrays.asList({"text/", null}, {"text/csv", null}, {"snowflake/orc", FileCompressionType.ORC}, {"snowflake/orc;p=1", FileCompressionType.ORC}, {"snowflake/parquet", FileCompressionType.PARQUET}, {"application/zlib", FileCompressionType.DEFLATE}, {"application/x-bzip2", FileCompressionType.BZIP2}, {"application/zstd", FileCompressionType.ZSTD}, {"application/x-brotli", FileCompressionType.BROTLI}, {"application/x-lzip", FileCompressionType.LZIP}, {"application/x-lzma", FileCompressionType.LZMA}, {"application/x-xz", FileCompressionType.XZ}, {"application/x-compress", FileCompressionType.COMPRESS}, {"application/x-gzip", FileCompressionType.GZIP});
    }

    @Test
    public void testMimeTypeToCompressionType() throws Throwable {
        Optional foundCompType = SnowflakeFileTransferAgent.mimeTypeToCompressionType((String)this.mimeType);
        if (foundCompType.isPresent()) {
            Assert.assertEquals((Object)this.mimeSubType, foundCompType.get());
        } else {
            Assert.assertEquals((Object)this.mimeSubType, null);
        }
    }
}

