/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileUploaderPrepIT;
import net.snowflake.client.jdbc.SFBaseFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import org.junit.Assert;
import org.junit.Test;

public class FileUploaderSessionlessTest
extends FileUploaderPrepIT {
    private ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testGetEncryptionMaterialMissing() throws Exception {
        JsonNode modifiedNode = this.exampleS3JsonNode.deepCopy();
        ObjectNode foo = (ObjectNode)modifiedNode.path("data");
        foo.remove("encryptionMaterial");
        List encryptionMaterials = SnowflakeFileTransferAgent.getEncryptionMaterial((SFBaseFileTransferAgent.CommandType)SFBaseFileTransferAgent.CommandType.UPLOAD, (JsonNode)modifiedNode);
        Assert.assertEquals((long)1L, (long)encryptionMaterials.size());
        Assert.assertNull(encryptionMaterials.get(0));
    }

    @Test
    public void testGetEncryptionMaterial() throws Exception {
        ArrayList<RemoteStoreFileEncryptionMaterial> expected = new ArrayList<RemoteStoreFileEncryptionMaterial>();
        RemoteStoreFileEncryptionMaterial content = new RemoteStoreFileEncryptionMaterial("EXAMPLE_QUERY_STAGE_MASTER_KEY", "EXAMPLE_QUERY_ID", Long.valueOf(123L));
        expected.add(content);
        for (JsonNode exampleNode : this.exampleNodes) {
            List encryptionMaterials = SnowflakeFileTransferAgent.getEncryptionMaterial((SFBaseFileTransferAgent.CommandType)SFBaseFileTransferAgent.CommandType.UPLOAD, (JsonNode)exampleNode);
            Assert.assertEquals((long)1L, (long)encryptionMaterials.size());
            Assert.assertEquals((Object)((RemoteStoreFileEncryptionMaterial)expected.get(0)).getQueryStageMasterKey(), (Object)((RemoteStoreFileEncryptionMaterial)encryptionMaterials.get(0)).getQueryStageMasterKey());
            Assert.assertEquals((Object)((RemoteStoreFileEncryptionMaterial)expected.get(0)).getQueryId(), (Object)((RemoteStoreFileEncryptionMaterial)encryptionMaterials.get(0)).getQueryId());
            Assert.assertEquals((Object)((RemoteStoreFileEncryptionMaterial)expected.get(0)).getSmkId(), (Object)((RemoteStoreFileEncryptionMaterial)encryptionMaterials.get(0)).getSmkId());
        }
    }

    @Test
    public void testGetS3StageData() throws Exception {
        StageInfo stageInfo = SnowflakeFileTransferAgent.getStageInfo((JsonNode)this.exampleS3JsonNode, null);
        HashMap<String, String> expectedCreds = new HashMap<String, String>();
        expectedCreds.put("AWS_ID", "EXAMPLE_AWS_ID");
        expectedCreds.put("AWS_KEY", "EXAMPLE_AWS_KEY");
        expectedCreds.put("AWS_KEY_ID", "EXAMPLE_AWS_KEY_ID");
        expectedCreds.put("AWS_SECRET_KEY", "EXAMPLE_AWS_SECRET_KEY");
        expectedCreds.put("AWS_TOKEN", "EXAMPLE_AWS_TOKEN");
        Assert.assertEquals((Object)StageInfo.StageType.S3, (Object)stageInfo.getStageType());
        Assert.assertEquals((Object)"stage/location/foo/", (Object)stageInfo.getLocation());
        Assert.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assert.assertEquals((Object)"us-west-2", (Object)stageInfo.getRegion());
        Assert.assertEquals((Object)"null", (Object)stageInfo.getEndPoint());
        Assert.assertEquals(null, (Object)stageInfo.getStorageAccount());
        Assert.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
        Assert.assertEquals((Object)true, (Object)stageInfo.getUseS3RegionalUrl());
    }

    @Test
    public void testGetS3StageDataWithStageEndpoint() throws Exception {
        StageInfo stageInfo = SnowflakeFileTransferAgent.getStageInfo((JsonNode)this.exampleS3StageEndpointJsonNode, null);
        HashMap<String, String> expectedCreds = new HashMap<String, String>();
        expectedCreds.put("AWS_ID", "EXAMPLE_AWS_ID");
        expectedCreds.put("AWS_KEY", "EXAMPLE_AWS_KEY");
        expectedCreds.put("AWS_KEY_ID", "EXAMPLE_AWS_KEY_ID");
        expectedCreds.put("AWS_SECRET_KEY", "EXAMPLE_AWS_SECRET_KEY");
        expectedCreds.put("AWS_TOKEN", "EXAMPLE_AWS_TOKEN");
        Assert.assertEquals((Object)StageInfo.StageType.S3, (Object)stageInfo.getStageType());
        Assert.assertEquals((Object)"stage/location/foo/", (Object)stageInfo.getLocation());
        Assert.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assert.assertEquals((Object)"us-west-2", (Object)stageInfo.getRegion());
        Assert.assertEquals((Object)"s3-fips.us-east-1.amazonaws.com", (Object)stageInfo.getEndPoint());
        Assert.assertEquals(null, (Object)stageInfo.getStorageAccount());
        Assert.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
    }

    @Test
    public void testGetAzureStageData() throws Exception {
        StageInfo stageInfo = SnowflakeFileTransferAgent.getStageInfo((JsonNode)this.exampleAzureJsonNode, null);
        HashMap<String, String> expectedCreds = new HashMap<String, String>();
        expectedCreds.put("AZURE_SAS_TOKEN", "EXAMPLE_AZURE_SAS_TOKEN");
        Assert.assertEquals((Object)StageInfo.StageType.AZURE, (Object)stageInfo.getStageType());
        Assert.assertEquals((Object)"EXAMPLE_LOCATION/", (Object)stageInfo.getLocation());
        Assert.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assert.assertEquals((Object)"westus", (Object)stageInfo.getRegion());
        Assert.assertEquals((Object)"blob.core.windows.net", (Object)stageInfo.getEndPoint());
        Assert.assertEquals((Object)"EXAMPLE_STORAGE_ACCOUNT", (Object)stageInfo.getStorageAccount());
        Assert.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
    }

    @Test
    public void testGetGCSStageData() throws Exception {
        StageInfo stageInfo = SnowflakeFileTransferAgent.getStageInfo((JsonNode)this.exampleGCSJsonNode, null);
        HashMap expectedCreds = new HashMap();
        Assert.assertEquals((Object)StageInfo.StageType.GCS, (Object)stageInfo.getStageType());
        Assert.assertEquals((Object)"foo/tables/9224/", (Object)stageInfo.getLocation());
        Assert.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assert.assertEquals((Object)"US-WEST1", (Object)stageInfo.getRegion());
        Assert.assertEquals(null, (Object)stageInfo.getEndPoint());
        Assert.assertEquals(null, (Object)stageInfo.getStorageAccount());
        Assert.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
    }

    @Test
    public void testGetFileTransferMetadatasS3() throws Exception {
        List metadataList = SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)this.exampleS3JsonNode);
        Assert.assertEquals((long)1L, (long)metadataList.size());
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
        StageInfo stageInfo = metadata.getStageInfo();
        HashMap<String, String> expectedCreds = new HashMap<String, String>();
        expectedCreds.put("AWS_ID", "EXAMPLE_AWS_ID");
        expectedCreds.put("AWS_KEY", "EXAMPLE_AWS_KEY");
        expectedCreds.put("AWS_KEY_ID", "EXAMPLE_AWS_KEY_ID");
        expectedCreds.put("AWS_SECRET_KEY", "EXAMPLE_AWS_SECRET_KEY");
        expectedCreds.put("AWS_TOKEN", "EXAMPLE_AWS_TOKEN");
        Assert.assertEquals((Object)StageInfo.StageType.S3, (Object)stageInfo.getStageType());
        Assert.assertEquals((Object)"stage/location/foo/", (Object)stageInfo.getLocation());
        Assert.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assert.assertEquals((Object)"us-west-2", (Object)stageInfo.getRegion());
        Assert.assertEquals((Object)"null", (Object)stageInfo.getEndPoint());
        Assert.assertEquals(null, (Object)stageInfo.getStorageAccount());
        Assert.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
        Assert.assertEquals((Object)"EXAMPLE_QUERY_ID", (Object)metadata.getEncryptionMaterial().getQueryId());
        Assert.assertEquals((Object)"EXAMPLE_QUERY_STAGE_MASTER_KEY", (Object)metadata.getEncryptionMaterial().getQueryStageMasterKey());
        Assert.assertEquals((long)123L, (long)metadata.getEncryptionMaterial().getSmkId());
        Assert.assertEquals((Object)SFBaseFileTransferAgent.CommandType.UPLOAD, (Object)metadata.getCommandType());
        Assert.assertNull((Object)metadata.getPresignedUrl());
        Assert.assertEquals((Object)"orders_100.csv", (Object)metadata.getPresignedUrlFileName());
    }

    @Test
    public void testGetFileTransferMetadatasS3MissingEncryption() throws Exception {
        JsonNode modifiedNode = this.exampleS3JsonNode.deepCopy();
        ObjectNode foo = (ObjectNode)modifiedNode.path("data");
        foo.remove("encryptionMaterial");
        List metadataList = SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)modifiedNode);
        Assert.assertEquals((long)1L, (long)metadataList.size());
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
        StageInfo stageInfo = metadata.getStageInfo();
        HashMap<String, String> expectedCreds = new HashMap<String, String>();
        expectedCreds.put("AWS_ID", "EXAMPLE_AWS_ID");
        expectedCreds.put("AWS_KEY", "EXAMPLE_AWS_KEY");
        expectedCreds.put("AWS_KEY_ID", "EXAMPLE_AWS_KEY_ID");
        expectedCreds.put("AWS_SECRET_KEY", "EXAMPLE_AWS_SECRET_KEY");
        expectedCreds.put("AWS_TOKEN", "EXAMPLE_AWS_TOKEN");
        Assert.assertEquals((Object)StageInfo.StageType.S3, (Object)stageInfo.getStageType());
        Assert.assertEquals((Object)"stage/location/foo/", (Object)stageInfo.getLocation());
        Assert.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assert.assertEquals((Object)"us-west-2", (Object)stageInfo.getRegion());
        Assert.assertEquals((Object)"null", (Object)stageInfo.getEndPoint());
        Assert.assertEquals(null, (Object)stageInfo.getStorageAccount());
        Assert.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
        Assert.assertNull((Object)metadata.getEncryptionMaterial().getQueryId());
        Assert.assertNull((Object)metadata.getEncryptionMaterial().getQueryStageMasterKey());
        Assert.assertNull((Object)metadata.getEncryptionMaterial().getSmkId());
        Assert.assertEquals((Object)SFBaseFileTransferAgent.CommandType.UPLOAD, (Object)metadata.getCommandType());
        Assert.assertNull((Object)metadata.getPresignedUrl());
        Assert.assertEquals((Object)"orders_100.csv", (Object)metadata.getPresignedUrlFileName());
    }

    @Test
    public void testGetFileTransferMetadatasAzure() throws Exception {
        List metadataList = SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)this.exampleAzureJsonNode);
        Assert.assertEquals((long)1L, (long)metadataList.size());
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
        StageInfo stageInfo = metadata.getStageInfo();
        HashMap<String, String> expectedCreds = new HashMap<String, String>();
        expectedCreds.put("AZURE_SAS_TOKEN", "EXAMPLE_AZURE_SAS_TOKEN");
        Assert.assertEquals((Object)StageInfo.StageType.AZURE, (Object)stageInfo.getStageType());
        Assert.assertEquals((Object)"EXAMPLE_LOCATION/", (Object)stageInfo.getLocation());
        Assert.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assert.assertEquals((Object)"westus", (Object)stageInfo.getRegion());
        Assert.assertEquals((Object)"blob.core.windows.net", (Object)stageInfo.getEndPoint());
        Assert.assertEquals((Object)"EXAMPLE_STORAGE_ACCOUNT", (Object)stageInfo.getStorageAccount());
        Assert.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
        Assert.assertEquals((Object)"EXAMPLE_QUERY_ID", (Object)metadata.getEncryptionMaterial().getQueryId());
        Assert.assertEquals((Object)"EXAMPLE_QUERY_STAGE_MASTER_KEY", (Object)metadata.getEncryptionMaterial().getQueryStageMasterKey());
        Assert.assertEquals((long)123L, (long)metadata.getEncryptionMaterial().getSmkId());
        Assert.assertEquals((Object)SFBaseFileTransferAgent.CommandType.UPLOAD, (Object)metadata.getCommandType());
        Assert.assertNull((Object)metadata.getPresignedUrl());
        Assert.assertEquals((Object)"orders_100.csv", (Object)metadata.getPresignedUrlFileName());
    }

    @Test
    public void testGetFileTransferMetadatasGCS() throws Exception {
        List metadataList = SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)this.exampleGCSJsonNode);
        Assert.assertEquals((long)1L, (long)metadataList.size());
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
        StageInfo stageInfo = metadata.getStageInfo();
        HashMap expectedCreds = new HashMap();
        Assert.assertEquals((Object)StageInfo.StageType.GCS, (Object)stageInfo.getStageType());
        Assert.assertEquals((Object)"foo/tables/9224/", (Object)stageInfo.getLocation());
        Assert.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assert.assertEquals((Object)"US-WEST1", (Object)stageInfo.getRegion());
        Assert.assertEquals(null, (Object)stageInfo.getEndPoint());
        Assert.assertEquals(null, (Object)stageInfo.getStorageAccount());
        Assert.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
        Assert.assertEquals((Object)"EXAMPLE_QUERY_ID", (Object)metadata.getEncryptionMaterial().getQueryId());
        Assert.assertEquals((Object)"EXAMPLE_QUERY_STAGE_MASTER_KEY", (Object)metadata.getEncryptionMaterial().getQueryStageMasterKey());
        Assert.assertEquals((long)123L, (long)metadata.getEncryptionMaterial().getSmkId());
        Assert.assertEquals((Object)SFBaseFileTransferAgent.CommandType.UPLOAD, (Object)metadata.getCommandType());
        Assert.assertEquals((Object)"EXAMPLE_PRESIGNED_URL", (Object)metadata.getPresignedUrl());
        Assert.assertEquals((Object)"orders_100.csv", (Object)metadata.getPresignedUrlFileName());
    }

    @Test
    public void testGetFileTransferMetadatasUploadError() throws Exception {
        JsonNode downloadNode = this.mapper.readTree("{\"data\": {\"command\": \"DOWNLOAD\"}}");
        try {
            SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)downloadNode);
            Assert.assertTrue((boolean)false);
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assert.assertEquals((Object)"JDBC driver internal error: This API only supports PUT commands.", (Object)err.getMessage());
        }
    }

    @Test
    public void testGetFileTransferMetadatasEncryptionMaterialError() throws Exception {
        JsonNode garbageNode = this.mapper.readTree("{\"data\": {\"src_locations\": [1, 2]}}");
        try {
            SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)garbageNode);
            Assert.assertTrue((boolean)false);
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assert.assertTrue((boolean)err.getMessage().contains("JDBC driver internal error: Failed to parse the credentials"));
        }
    }

    @Test
    public void testGetFileTransferMetadatasUnsupportedLocationError() throws Exception {
        JsonNode modifiedNode = this.exampleS3JsonNode.deepCopy();
        ObjectNode foo = (ObjectNode)modifiedNode.path("data").path("stageInfo");
        foo.put("locationType", "LOCAL_FS");
        try {
            SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)modifiedNode);
            Assert.assertTrue((boolean)false);
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assert.assertTrue((boolean)err.getMessage().contains("JDBC driver internal error: This API only supports"));
        }
    }

    @Test
    public void testGetFileTransferMetadatasSrcLocationsArrayError() throws JsonProcessingException {
        JsonNode garbageNode = this.mapper.readTree("{\"data\": {\"src_locations\": \"abc\"}}");
        try {
            SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)garbageNode);
            Assert.assertTrue((boolean)false);
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assert.assertTrue((boolean)err.getMessage().contains("JDBC driver internal error: src_locations must be an array"));
        }
    }

    @Test
    public void testGetFileMetadatasEncryptionMaterialsException() {
        JsonNode modifiedNode = this.exampleS3JsonNode.deepCopy();
        ObjectNode foo = (ObjectNode)modifiedNode.path("data");
        foo.put("encryptionMaterial", "[1, 2, 3]]");
        try {
            SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)modifiedNode);
            Assert.assertTrue((boolean)false);
        }
        catch (SnowflakeSQLException err) {
            Assert.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assert.assertTrue((boolean)err.getMessage().contains("Failed to parse encryptionMaterial"));
        }
    }
}

