/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GCPLargeResult
extends BaseJDBCTest {
    private final String queryResultFormat;

    @Parameterized.Parameters(name="format={0}")
    public static Object[][] data() {
        return new Object[][]{{"JSON"}, {"ARROW"}};
    }

    public GCPLargeResult(String queryResultFormat) {
        this.queryResultFormat = queryResultFormat;
    }

    Connection init() throws SQLException {
        Connection conn = BaseJDBCTest.getConnection("gcpaccount");
        try (Statement stmt = conn.createStatement();){
            stmt.execute("alter session set jdbc_query_result_format = '" + this.queryResultFormat + "'");
        }
        return conn;
    }

    @Test
    public void testLargeResultSetGCP() throws Throwable {
        try (Connection con = this.init();){
            PreparedStatement stmt = con.prepareStatement("select seq8(), randstr(1000, random()) from table(generator(rowcount=>1000))");
            stmt.setMaxRows(999);
            ResultSet rset = stmt.executeQuery();
            int cnt = 0;
            while (rset.next()) {
                ++cnt;
            }
            Assert.assertEquals((long)cnt, (long)999L);
        }
    }
}

