/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.core.QueryStatus;
import net.snowflake.client.jdbc.HeartbeatIT;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeStatement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public class HeartbeatAsyncLatestIT
extends HeartbeatIT {
    private static Logger logger = Logger.getLogger(HeartbeatAsyncLatestIT.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void submitQuery(boolean useKeepAliveSession, int queryIdx) throws SQLException, InterruptedException {
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            Properties sessionParams = new Properties();
            sessionParams.put("CLIENT_SESSION_KEEP_ALIVE", useKeepAliveSession ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            connection = HeartbeatAsyncLatestIT.getConnection(sessionParams);
            Statement stmt = connection.createStatement();
            resultSet = stmt.unwrap(SnowflakeStatement.class).executeAsyncQuery("SELECT count(*) FROM TABLE(generator(timeLimit => 5))");
            Thread.sleep(61000L);
            QueryStatus qs = resultSet.unwrap(SnowflakeResultSet.class).getStatus();
            int MAX_RETRY = 20;
            for (int retry = 0; QueryStatus.isStillRunning((QueryStatus)qs) && retry < MAX_RETRY; ++retry) {
                Thread.sleep(3000L);
                qs = resultSet.unwrap(SnowflakeResultSet.class).getStatus();
            }
            Assert.assertEquals((Object)QueryStatus.SUCCESS, (Object)qs);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.next());
            logger.fine("Query " + queryIdx + " passed ");
        }
        finally {
            resultSet.close();
            connection.close();
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testAsynchronousQuerySuccess() throws Exception {
        this.testSuccess();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testAsynchronousQueryFailure() throws Exception {
        this.testFailure();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testIsValidWithInvalidSession() throws Exception {
        try (Connection connection = null;){
            connection = HeartbeatAsyncLatestIT.getConnection();
            Assert.assertTrue((boolean)connection.isValid(5));
            Thread.sleep(61000L);
            Assert.assertFalse((boolean)connection.isValid(5));
        }
    }
}

