/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.snowflake.client.category.TestCategoryConnection;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.QueryContextDTO;
import net.snowflake.client.core.QueryStatus;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFBaseStatement;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFJsonResultSet;
import net.snowflake.client.core.SFPreparedStatementMetaData;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.JsonResultChunk;
import net.snowflake.client.jdbc.SFBaseFileTransferAgent;
import net.snowflake.client.jdbc.SFConnectionHandler;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeResultSetV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.common.core.SnowflakeDateTimeFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryConnection.class})
public class MockConnectionTest
extends BaseJDBCTest {
    private static final String testTableName = "test_custom_conn_table";

    private static SFResultSetMetaData getRSMDFromResponse(JsonNode rootNode, SFBaseSession sfSession) throws SnowflakeSQLException {
        String queryId = rootNode.path("data").path("queryId").asText();
        Map parameters = SessionUtil.getCommonParams((JsonNode)rootNode.path("data").path("parameters"));
        String sqlTimestampFormat = (String)ResultUtil.effectiveParamValue((Map)parameters, (String)"TIMESTAMP_OUTPUT_FORMAT");
        SnowflakeDateTimeFormat ntzFormat = ResultUtil.specializedFormatter((Map)parameters, (String)"timestamp_ntz", (String)"TIMESTAMP_NTZ_OUTPUT_FORMAT", (String)sqlTimestampFormat);
        SnowflakeDateTimeFormat ltzFormat = ResultUtil.specializedFormatter((Map)parameters, (String)"timestamp_ltz", (String)"TIMESTAMP_LTZ_OUTPUT_FORMAT", (String)sqlTimestampFormat);
        SnowflakeDateTimeFormat tzFormat = ResultUtil.specializedFormatter((Map)parameters, (String)"timestamp_tz", (String)"TIMESTAMP_TZ_OUTPUT_FORMAT", (String)sqlTimestampFormat);
        String sqlDateFormat = (String)ResultUtil.effectiveParamValue((Map)parameters, (String)"DATE_OUTPUT_FORMAT");
        SnowflakeDateTimeFormat dateFormatter = SnowflakeDateTimeFormat.fromSqlFormat((String)Objects.requireNonNull(sqlDateFormat));
        String sqlTimeFormat = (String)ResultUtil.effectiveParamValue((Map)parameters, (String)"TIME_OUTPUT_FORMAT");
        SnowflakeDateTimeFormat timeFormatter = SnowflakeDateTimeFormat.fromSqlFormat((String)Objects.requireNonNull(sqlTimeFormat));
        ArrayList<SnowflakeColumnMetadata> resultColumnMetadata = new ArrayList<SnowflakeColumnMetadata>();
        int columnCount = rootNode.path("data").path("rowtype").size();
        for (int i = 0; i < columnCount; ++i) {
            JsonNode colNode = rootNode.path("data").path("rowtype").path(i);
            SnowflakeColumnMetadata columnMetadata = SnowflakeUtil.extractColumnMetadata((JsonNode)colNode, (boolean)sfSession.isJdbcTreatDecimalAsInt(), (SFBaseSession)sfSession);
            resultColumnMetadata.add(columnMetadata);
        }
        return new SFResultSetMetaData(resultColumnMetadata, queryId, sfSession, false, ntzFormat, ltzFormat, tzFormat, dateFormatter, timeFormatter);
    }

    private static ObjectNode getJsonFromDataType(DataType dataType) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode type = mapper.createObjectNode();
        if (dataType == DataType.INT) {
            type.put("name", "someIntColumn");
            type.put("database", "");
            type.put("schema", "");
            type.put("table", "");
            type.put("scale", 0);
            type.put("precision", 18);
            type.put("type", "fixed");
            type.put("length", (Integer)null);
            type.put("byteLength", (Integer)null);
            type.put("nullable", true);
            type.put("collation", (String)null);
        } else if (dataType == DataType.STRING) {
            type.put("name", "someStringColumn");
            type.put("database", "");
            type.put("schema", "");
            type.put("table", "");
            type.put("scale", (Integer)null);
            type.put("precision", (Integer)null);
            type.put("length", 0x1000000);
            type.put("type", "text");
            type.put("byteLength", 0x1000000);
            type.put("nullable", true);
            type.put("collation", (String)null);
        }
        return type;
    }

    public Connection initMockConnection(SFConnectionHandler implementation) throws SQLException {
        return new SnowflakeConnectionV1(implementation);
    }

    @Test
    public void testMockResponse() throws SQLException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rawResponse = mapper.readTree("{\n   \"data\":{\n      \"parameters\":[\n         {\n            \"name\":\"TIMESTAMP_OUTPUT_FORMAT\",\n            \"value\":\"DY, DD MON YYYY HH24:MI:SS TZHTZM\"\n         },\n         {\n            \"name\":\"TIME_OUTPUT_FORMAT\",\n            \"value\":\"HH24:MI:SS\"\n         },\n         {\n            \"name\":\"TIMESTAMP_TZ_OUTPUT_FORMAT\",\n            \"value\":\"\"\n         },\n         {\n            \"name\":\"TIMESTAMP_NTZ_OUTPUT_FORMAT\",\n            \"value\":\"\"\n         },\n         {\n            \"name\":\"DATE_OUTPUT_FORMAT\",\n            \"value\":\"YYYY-MM-DD\"\n         },\n         {\n            \"name\":\"TIMESTAMP_LTZ_OUTPUT_FORMAT\",\n            \"value\":\"\"\n         }\n      ],\n      \"rowtype\":[\n         {\n            \"name\":\"COLA\",\n            \"database\":\"TESTDB\",\n            \"schema\":\"TESTSCHEMA\",\n            \"table\":\"TEST_CUSTOM_CONN_TABLE\",\n            \"scale\":null,\n            \"precision\":null,\n            \"length\":16777216,\n            \"type\":\"text\",\n            \"byteLength\":16777216,\n            \"nullable\":true,\n            \"collation\":null\n         },\n         {\n            \"name\":\"COLB\",\n            \"database\":\"TESTDB\",\n            \"schema\":\"TESTSCHEMA\",\n            \"table\":\"TEST_CUSTOM_CONN_TABLE\",\n            \"scale\":0,\n            \"precision\":38,\n            \"length\":null,\n            \"type\":\"fixed\",\n            \"byteLength\":null,\n            \"nullable\":true,\n            \"collation\":null\n         }\n      ],\n      \"rowset\":[\n         [\n            \"rowOne\",\n            \"1\"\n         ],\n         [\n            \"rowTwo\",\n            \"2\"\n         ]\n      ],\n      \"total\":2,\n      \"returned\":2,\n      \"queryId\":\"0199922f-015a-7715-0000-0014000123ca\",\n      \"databaseProvider\":null,\n      \"finalDatabaseName\":\"TESTDB\",\n      \"finalSchemaName\":\"TESTSCHEMA\",\n      \"finalWarehouseName\":\"DEV\",\n      \"finalRoleName\":\"SYSADMIN\",\n      \"numberOfBinds\":0,\n      \"arrayBindSupported\":false,\n      \"statementTypeId\":4096,\n      \"version\":1,\n      \"sendResultTime\":1610498856446,\n      \"queryResultFormat\":\"json\"\n   },\n   \"code\":null,\n   \"message\":null,\n   \"success\":true\n}");
        MockSnowflakeConnectionImpl mockImpl = new MockSnowflakeConnectionImpl(rawResponse);
        Connection mockConnection = this.initMockConnection(mockImpl);
        ResultSet fakeResultSet = mockConnection.prepareStatement("select count(*) from test_custom_conn_table").executeQuery();
        fakeResultSet.next();
        String val = fakeResultSet.getString(1);
        Assert.assertEquals((String)"colA value from the mock connection was not what was expected", (Object)"rowOne", (Object)val);
        mockConnection.close();
    }

    @Test
    public void testErrorHandlingWithLoggedExceptions() throws SQLException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode ignoredResponse = mapper.readTree("{}");
        MockSnowflakeConnectionImpl mockImpl = new MockSnowflakeConnectionImpl(ignoredResponse);
        Connection mockConnection = this.initMockConnection(mockImpl);
        MockSnowflakeSFSession mockSession = (MockSnowflakeSFSession)((SnowflakeConnectionV1)mockConnection).getSFBaseSession();
        ArrayList<Pair> errors = new ArrayList<Pair>();
        errors.add(new Pair("12345", "message1"));
        errors.add(new Pair("56789", "message2"));
        errors.add(new Pair("43", "foo"));
        errors.add(new Pair("9", "bar"));
        for (Pair err2 : errors) {
            try {
                throw new SnowflakeSQLLoggedException((SFBaseSession)mockSession, err2.first, err2.second);
            }
            catch (SQLException sQLException) {
            }
        }
        List<String> loggedErrors = mockSession.getErrorsEncountered();
        Assert.assertEquals((long)loggedErrors.size(), (long)errors.size());
        List expectedErrorMessages = errors.stream().map(err -> err.second + "_" + err.first).collect(Collectors.toList());
        List<Pair> zippedList = IntStream.range(0, Math.min(loggedErrors.size(), expectedErrorMessages.size())).mapToObj(i -> new Pair((String)expectedErrorMessages.get(i), (String)loggedErrors.get(i))).collect(Collectors.toList());
        zippedList.forEach(err -> Assert.assertEquals((Object)err.first, (Object)err.second));
        mockConnection.close();
    }

    @Test
    public void testMockedResponseWithRows() throws SQLException {
        List<DataType> dataTypes = Arrays.asList(DataType.INT, DataType.INT, DataType.INT);
        List<Object> row1 = Arrays.asList(1, 2, null);
        List<Object> row2 = Arrays.asList(4, null, 6);
        List<List<Object>> rowsToTest = Arrays.asList(row1, row2);
        JsonNode responseWithRows = this.createDummyResponseWithRows(rowsToTest, dataTypes);
        MockSnowflakeConnectionImpl mockImpl = new MockSnowflakeConnectionImpl(responseWithRows);
        Connection mockConnection = this.initMockConnection(mockImpl);
        ResultSet fakeResultSet = mockConnection.prepareStatement("select * from fakeTable").executeQuery();
        this.compareResultSets(fakeResultSet, rowsToTest, dataTypes);
        mockConnection.close();
        dataTypes = Arrays.asList(DataType.STRING, DataType.STRING);
        row1 = Arrays.asList("hi", "bye");
        row2 = Arrays.asList(null, "snowflake");
        List<Object> row3 = Arrays.asList("is", "great");
        rowsToTest = Arrays.asList(row1, row2, row3);
        responseWithRows = this.createDummyResponseWithRows(rowsToTest, dataTypes);
        mockImpl = new MockSnowflakeConnectionImpl(responseWithRows);
        mockConnection = this.initMockConnection(mockImpl);
        fakeResultSet = mockConnection.prepareStatement("select * from fakeTable").executeQuery();
        this.compareResultSets(fakeResultSet, rowsToTest, dataTypes);
        mockConnection.close();
        dataTypes = Arrays.asList(DataType.STRING, DataType.INT);
        row1 = Arrays.asList("foo", 2);
        row2 = Arrays.asList("bar", 4);
        row3 = Arrays.asList("baz", null);
        rowsToTest = Arrays.asList(row1, row2, row3);
        responseWithRows = this.createDummyResponseWithRows(rowsToTest, dataTypes);
        mockImpl = new MockSnowflakeConnectionImpl(responseWithRows);
        mockConnection = this.initMockConnection(mockImpl);
        fakeResultSet = mockConnection.prepareStatement("select * from fakeTable").executeQuery();
        this.compareResultSets(fakeResultSet, rowsToTest, dataTypes);
        mockConnection.close();
    }

    @Test
    public void testMockTransferAgent() throws SQLException, IOException {
        MockSnowflakeConnectionImpl mockImpl = new MockSnowflakeConnectionImpl();
        SnowflakeConnection mockConnection = (SnowflakeConnection)this.initMockConnection(mockImpl).unwrap(SnowflakeConnectionV1.class);
        byte[] inputBytes1 = new byte[]{0, 1, 2};
        ByteArrayInputStream uploadStream1 = new ByteArrayInputStream(inputBytes1);
        mockConnection.uploadStream("@fakeStage", "", (InputStream)uploadStream1, "file1", false);
        InputStream downloadStream1 = mockConnection.downloadStream("@fakeStage", "file1", false);
        byte[] outputBytes1 = new byte[downloadStream1.available()];
        downloadStream1.read(outputBytes1);
        Assert.assertArrayEquals((String)"downloaded bytes not what was expected", (byte[])outputBytes1, (byte[])inputBytes1);
    }

    private JsonNode createDummyResponseWithRows(List<List<Object>> rows, List<DataType> dataTypes) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        ObjectNode dataNode = rootNode.putObject("data");
        this.createResultSetMetadataResponse(dataNode, dataTypes);
        this.createRowsetJson(dataNode, rows, dataTypes);
        return rootNode;
    }

    private void createResultSetMetadataResponse(ObjectNode dataNode, List<DataType> dataTypes) {
        ArrayNode parameters = dataNode.putArray("parameters");
        parameters.add((JsonNode)this.createParameterJson("TIME_OUTPUT_FORMAT", "HH24:MI:SS"));
        parameters.add((JsonNode)this.createParameterJson("DATE_OUTPUT_FORMAT", "YYYY-MM-DD"));
        parameters.add((JsonNode)this.createParameterJson("TIMESTAMP_OUTPUT_FORMAT", "DY, DD MON YYYY HH24:MI:SS TZHTZM"));
        parameters.add((JsonNode)this.createParameterJson("TIMESTAMP_LTZ_OUTPUT_FORMAT", ""));
        parameters.add((JsonNode)this.createParameterJson("TIMESTAMP_NTZ_OUTPUT_FORMAT", ""));
        parameters.add((JsonNode)this.createParameterJson("TIMESTAMP_TZ_OUTPUT_FORMAT", ""));
        dataNode.put("queryId", "81998ae8-01e5-e08d-0000-10140001201a");
        ArrayNode rowType = dataNode.putArray("rowtype");
        for (DataType type : dataTypes) {
            rowType.add((JsonNode)MockConnectionTest.getJsonFromDataType(type));
        }
    }

    private ObjectNode createParameterJson(String parameterName, String parameterValue) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode parameterObject = mapper.createObjectNode();
        parameterObject.put("name", parameterName);
        parameterObject.put("value", parameterValue);
        return parameterObject;
    }

    private void createRowsetJson(ObjectNode dataNode, List<List<Object>> rows, List<DataType> dataTypes) {
        ArrayNode rowsetNode = dataNode.putArray("rowset");
        if (rows == null || rows.isEmpty()) {
            return;
        }
        for (List<Object> row : rows) {
            Iterator<Object> rowData = row.iterator();
            ArrayNode rowJson = rowsetNode.addArray();
            for (DataType type : dataTypes) {
                if (type == DataType.INT) {
                    rowJson.add((Integer)rowData.next());
                    continue;
                }
                if (type != DataType.STRING) continue;
                rowJson.add((String)rowData.next());
            }
        }
    }

    private void compareResultSets(ResultSet resultSet, List<List<Object>> expectedRows, List<DataType> dataTypes) throws SQLException {
        if (expectedRows == null || expectedRows.size() == 0) {
            Assert.assertFalse((boolean)resultSet.next());
            return;
        }
        int numRows = expectedRows.size();
        int resultSetRows = 0;
        Iterator<List<Object>> rowIterator = expectedRows.iterator();
        while (resultSet.next() && rowIterator.hasNext()) {
            List<Object> expectedRow = rowIterator.next();
            int columnIdx = 0;
            for (DataType type : dataTypes) {
                Object expected = expectedRow.get(columnIdx);
                ++columnIdx;
                if (type == DataType.INT) {
                    if (expected == null) {
                        expected = 0;
                    }
                    int actual = resultSet.getInt(columnIdx);
                    Assert.assertEquals((Object)expected, (Object)actual);
                    continue;
                }
                if (type != DataType.STRING) continue;
                String actual = resultSet.getString(columnIdx);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            ++resultSetRows;
        }
        while (resultSet.next()) {
            ++resultSetRows;
        }
        Assert.assertEquals((String)"row-count was not what was expected", (long)numRows, (long)resultSetRows);
    }

    public static class MockSnowflakeConnectionImpl
    implements SFConnectionHandler {
        JsonNode jsonResponse;
        MockSnowflakeSFSession session;
        private Map<String, byte[]> fileMap = new HashMap<String, byte[]>();

        public MockSnowflakeConnectionImpl() {
            this.session = new MockSnowflakeSFSession(this);
        }

        public MockSnowflakeConnectionImpl(JsonNode jsonResponse) {
            this();
            this.jsonResponse = jsonResponse;
        }

        public boolean supportsAsyncQuery() {
            return false;
        }

        public void initializeConnection(String url, Properties info) throws SQLException {
        }

        public SFBaseSession getSFSession() {
            return this.session;
        }

        public SFBaseStatement getSFStatement() {
            return new MockedSFBaseStatement(this.jsonResponse, this.session);
        }

        public ResultSet createResultSet(String queryID, Statement statement) throws SQLException {
            return null;
        }

        public SnowflakeBaseResultSet createResultSet(SFBaseResultSet resultSet, Statement statement) throws SQLException {
            return new SnowflakeResultSetV1(resultSet, statement);
        }

        public SnowflakeBaseResultSet createAsyncResultSet(SFBaseResultSet resultSet, Statement statement) throws SQLException {
            return null;
        }

        public SFBaseFileTransferAgent getFileTransferAgent(String command, SFBaseStatement statement) throws SQLNonTransientConnectionException, SnowflakeSQLException {
            SFBaseFileTransferAgent.CommandType commandType = command.substring(0, 3).equalsIgnoreCase("PUT") ? SFBaseFileTransferAgent.CommandType.UPLOAD : SFBaseFileTransferAgent.CommandType.DOWNLOAD;
            return new MockSFFileTransferAgent(this.fileMap, "fileName", commandType);
        }
    }

    private static class MockSFFileTransferAgent
    extends SFBaseFileTransferAgent {
        private final String filePath;
        private final Map<String, byte[]> fileMap;

        public MockSFFileTransferAgent(Map<String, byte[]> fileMap, String filePath, SFBaseFileTransferAgent.CommandType commandType) {
            this.filePath = filePath;
            this.fileMap = fileMap;
            this.commandType = commandType;
        }

        public boolean execute() throws SQLException {
            if (this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD) {
                try {
                    byte[] fileBytes = new byte[this.sourceStream.available()];
                    this.sourceStream.read(fileBytes);
                    this.fileMap.put("fileName", fileBytes);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        public InputStream downloadStream(String fileName) throws SnowflakeSQLException {
            if (this.commandType == SFBaseFileTransferAgent.CommandType.DOWNLOAD) {
                byte[] bytes = this.fileMap.get("fileName");
                return new ByteArrayInputStream(bytes);
            }
            return null;
        }
    }

    public static class MockSnowflakeSFSession
    extends SFBaseSession {
        private final List<String> errorsEncountered = new ArrayList<String>();

        protected MockSnowflakeSFSession(SFConnectionHandler sfConnectionHandler) {
            super(sfConnectionHandler);
        }

        public List<String> getErrorsEncountered() {
            return this.errorsEncountered;
        }

        public boolean isSafeToClose() {
            return false;
        }

        public List<DriverPropertyInfo> checkProperties() {
            return null;
        }

        public void close() {
        }

        public QueryStatus getQueryStatus(String queryID) {
            return null;
        }

        public Telemetry getTelemetryClient() {
            return new Telemetry(){

                public void addLogToBatch(TelemetryData log) {
                }

                public void close() {
                }

                public Future<Boolean> sendBatchAsync() {
                    return null;
                }

                public void postProcess(String queryId, String sqlState, int vendorCode, Throwable ex) {
                    errorsEncountered.add(ex.getMessage() + "_" + sqlState);
                }
            };
        }

        public void callHeartBeat(int timeout) throws SFException, SQLException {
        }

        public List<SFException> getSqlWarnings() {
            return null;
        }

        public void clearSqlWarnings() {
        }

        public int getNetworkTimeoutInMilli() {
            return 0;
        }

        public int getAuthTimeout() {
            return 0;
        }

        public int getMaxHttpRetries() {
            return 7;
        }

        public SnowflakeConnectString getSnowflakeConnectionString() {
            return null;
        }

        public boolean isAsyncSession() {
            return false;
        }

        public void setQueryContext(String queryContext) {
        }

        public QueryContextDTO getQueryContextDTO() {
            return null;
        }
    }

    private static class MockJsonResultSet
    extends SFJsonResultSet {
        JsonNode resultJson;
        int currentRowIdx = -1;
        int rowCount;

        public MockJsonResultSet(JsonNode mockedJsonResponse, MockSnowflakeSFSession sfSession) throws SnowflakeSQLException {
            this.setSession(sfSession);
            this.resultJson = mockedJsonResponse.path("data").path("rowset");
            this.resultSetMetaData = MockConnectionTest.getRSMDFromResponse(mockedJsonResponse, this.session);
            this.rowCount = this.resultJson.size();
        }

        public boolean next() {
            ++this.currentRowIdx;
            return this.currentRowIdx < this.rowCount;
        }

        protected Object getObjectInternal(int columnIndex) {
            return JsonResultChunk.extractCell((JsonNode)this.resultJson, (int)this.currentRowIdx, (int)(columnIndex - 1));
        }

        public boolean isLast() {
            return this.currentRowIdx + 1 == this.rowCount;
        }

        public boolean isAfterLast() {
            return this.currentRowIdx >= this.rowCount;
        }

        public SFStatementType getStatementType() {
            return null;
        }

        public void setStatementType(SFStatementType statementType) {
        }

        public String getQueryId() {
            return null;
        }
    }

    private static class MockedSFBaseStatement
    extends SFBaseStatement {
        JsonNode mockedResponse;
        MockSnowflakeSFSession sfSession;

        MockedSFBaseStatement(JsonNode mockedResponse, MockSnowflakeSFSession session) {
            this.mockedResponse = mockedResponse;
            this.sfSession = session;
        }

        public void addProperty(String propertyName, Object propertyValue) {
        }

        public SFPreparedStatementMetaData describe(String sql) {
            return null;
        }

        public SFBaseResultSet execute(String sql, Map<String, ParameterBindingDTO> parametersBinding, SFBaseStatement.CallingMethod caller, ExecTimeTelemetryData execTimeData) throws SQLException, SFException {
            return new MockJsonResultSet(this.mockedResponse, this.sfSession);
        }

        public SFBaseResultSet asyncExecute(String sql, Map<String, ParameterBindingDTO> parametersBinding, SFBaseStatement.CallingMethod caller, ExecTimeTelemetryData execTimeData) throws SQLException, SFException {
            return null;
        }

        public void close() {
        }

        public void cancel() {
        }

        public void executeSetProperty(String sql) {
        }

        public boolean hasChildren() {
            return false;
        }

        public SFBaseSession getSFBaseSession() {
            return this.sfSession;
        }

        public boolean getMoreResults(int current) {
            return false;
        }

        public long getConservativeMemoryLimit() {
            return 0L;
        }

        public int getConservativePrefetchThreads() {
            return 0;
        }

        public SFBaseResultSet getResultSet() {
            return null;
        }

        public String[] getChildQueryIds(String queryID) throws SQLException {
            throw new SQLFeatureNotSupportedException("MockedSFBaseStatement.getChildQueryIds");
        }
    }

    private static enum DataType {
        INT,
        STRING;

    }

    private static class Pair {
        String first;
        String second;

        Pair(String first, String second) {
            this.first = first;
            this.second = second;
        }
    }
}

