/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryStatement;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeStatement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryStatement.class})
public class MultiStatementIT
extends BaseJDBCTest {
    protected static String queryResultFormat = "json";

    public static Connection getConnection() throws SQLException {
        Connection conn = BaseJDBCTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        stmt.close();
        return conn;
    }

    @Test
    public void testMultiStmtExecuteUpdateFail() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        String multiStmtQuery = "select 1;\ncreate or replace temporary table test_multi (cola int);\ninsert into test_multi VALUES (1), (2);\nselect cola from test_multi order by cola asc";
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)4);
        try {
            statement.executeUpdate(multiStmtQuery);
            Assert.fail((String)"executeUpdate should have failed because the first statement yields a result set");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.UPDATE_FIRST_RESULT_NOT_UPDATE_COUNT.getMessageCode()));
        }
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtExecuteQueryFail() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        String multiStmtQuery = "create or replace temporary table test_multi (cola int);\ninsert into test_multi VALUES (1), (2);\nselect cola from test_multi order by cola asc";
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
        try {
            statement.executeQuery(multiStmtQuery);
            Assert.fail((String)"executeQuery should have failed because the first statement yields an update count");
        }
        catch (SQLException ex) {
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.QUERY_FIRST_RESULT_NOT_RESULT_SET.getMessageCode()));
        }
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtSetUnset() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("set testvar = 1; select 1");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        ResultSet rs = statement.executeQuery("select $testvar");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        try {
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("unset testvar; select $testvar");
            Assert.fail((String)"Expected a failure");
        }
        catch (SQLException ex) {
            Assert.assertEquals((Object)"P0000", (Object)ex.getSQLState());
        }
        try {
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            statement.execute("select $testvar");
            Assert.fail((String)"Expected a failure");
        }
        catch (SQLException ex) {
            Assert.assertEquals((Object)"02000", (Object)ex.getSQLState());
        }
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtParseError() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("set testvar = 1");
        try {
            statement.execute("garbage text; set testvar = 2");
            Assert.fail((String)"Expected a compiler error to be thrown");
        }
        catch (SQLException ex) {
            Assert.assertEquals((Object)"42000", (Object)ex.getSQLState());
        }
        ResultSet rs = statement.executeQuery("select $testvar");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtExecError() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        try {
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
            statement.execute("set testvar = 1; select nonexistent_column from nonexistent_table; set testvar = 2");
            Assert.fail((String)"Expected an execution error to be thrown");
        }
        catch (SQLException ex) {
            Assert.assertEquals((Object)"P0000", (Object)ex.getSQLState());
        }
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        ResultSet rs = statement.executeQuery("select $testvar");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtTempTable() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        String entry = "success";
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("create or replace temporary table test_multi (cola string); insert into test_multi values ('" + entry + "')");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        ResultSet rs = statement.executeQuery("select * from test_multi");
        rs.next();
        Assert.assertEquals((Object)entry, (Object)rs.getString(1));
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtUseStmt() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        SFSession session = statement.getConnection().unwrap(SnowflakeConnectionV1.class).getSfSession();
        String originalSchema = session.getSchema();
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("use schema public; select 1");
        Assert.assertEquals((Object)"PUBLIC", (Object)session.getSchema());
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        ResultSet rs = statement.executeQuery("select current_schema()");
        rs.next();
        Assert.assertEquals((Object)"PUBLIC", (Object)rs.getString(1));
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute(String.format("use schema %s; select 1", originalSchema));
        session = statement.getConnection().unwrap(SnowflakeConnectionV1.class).getSfSession();
        Assert.assertEquals((Object)originalSchema, (Object)session.getSchema());
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        rs = statement.executeQuery("select current_schema()");
        rs.next();
        Assert.assertEquals((Object)originalSchema, (Object)rs.getString(1));
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtAlterSessionParams() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        SFSession session = statement.getConnection().unwrap(SnowflakeConnectionV1.class).getSfSession();
        String param = "AUTOCOMMIT";
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("alter session set " + param + "=false; select 1");
        Assert.assertFalse((boolean)session.getAutoCommit());
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("alter session set " + param + "=true; select 1");
        Assert.assertTrue((boolean)session.getAutoCommit());
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtMultiLine() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("select 1;\nselect 2");
        statement.execute("select \n 1; select 2");
        statement.execute("select \r\n 1; select 2");
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtQuotes() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("create or replace temporary table \"test_multi\" (cola string); select * from \"test_multi\"");
        statement.execute("create or replace temporary table `test_multi` (cola string); select * from `test_multi`");
        statement.execute("select 'str'; select 'str2'");
        statement.execute("select '\\` backticks'; select '\\\\` more `backticks`'");
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtCommitRollback() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_multi (cola string)");
        statement.execute("begin");
        statement.execute("insert into test_multi values ('abc')");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("insert into test_multi values ('def'); commit");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        statement.execute("rollback");
        ResultSet rs = statement.executeQuery("select count(*) from test_multi");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        statement.execute("create or replace table test_multi (cola string)");
        statement.execute("begin");
        statement.execute("insert into test_multi values ('abc')");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("insert into test_multi values ('def'); rollback");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        statement.execute("commit");
        rs = statement.executeQuery("select count(*) from test_multi");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        statement.execute("create or replace table test_multi (cola string)");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("begin; insert into test_multi values ('abc')");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        statement.execute("insert into test_multi values ('def')");
        statement.execute("commit");
        rs = statement.executeQuery("select count(*) from test_multi");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        statement.execute("create or replace table test_multi (cola string)");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("begin; insert into test_multi values ('abc')");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        statement.execute("insert into test_multi values ('def')");
        statement.execute("rollback");
        rs = statement.executeQuery("select count(*) from test_multi");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtCommitRollbackNoAutocommit() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_multi (cola string)");
        statement.execute("insert into test_multi values ('abc')");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("insert into test_multi values ('def'); commit");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        statement.execute("rollback");
        ResultSet rs = statement.executeQuery("select count(*) from test_multi");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        statement.execute("create or replace table test_multi (cola string)");
        statement.execute("insert into test_multi values ('abc')");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("insert into test_multi values ('def'); rollback");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        statement.execute("commit");
        rs = statement.executeQuery("select count(*) from test_multi");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        statement.execute("create or replace table test_multi (cola string)");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("insert into test_multi values ('abc'); insert into test_multi values ('def')");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        statement.execute("commit");
        rs = statement.executeQuery("select count(*) from test_multi");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        statement.execute("create or replace table test_multi (cola string)");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        statement.execute("insert into test_multi values ('abc'); insert into test_multi values ('def')");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        statement.execute("rollback");
        rs = statement.executeQuery("select count(*) from test_multi");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtLarge() throws SQLException {
        int i;
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        StringBuilder multiStmtBuilder = new StringBuilder();
        String query = "SELECT %d;";
        for (i = 0; i < 100; ++i) {
            multiStmtBuilder.append(String.format(query, i));
        }
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)100);
        Assert.assertTrue((boolean)statement.execute(multiStmtBuilder.toString()));
        for (i = 0; i < 100; ++i) {
            ResultSet rs = statement.getResultSet();
            Assert.assertNotNull((Object)rs);
            Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)i, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            if (i != 99) {
                Assert.assertTrue((boolean)statement.getMoreResults());
                continue;
            }
            Assert.assertFalse((boolean)statement.getMoreResults());
        }
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtCountNotMatch() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        try {
            statement.execute("select 1; select 2; select 3");
            Assert.fail();
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)8));
        }
        try {
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
            statement.execute("select 1");
            Assert.fail();
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)8));
        }
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)0);
        statement.execute("select 1; select 2; select 3");
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testInvalidParameterCount() throws SQLException {
        Connection connection = MultiStatementIT.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery("select current_account_locator()");
        rs.next();
        String accountName = rs.getString(1);
        rs = statement.executeQuery("select current_user()");
        rs.next();
        String userName = rs.getString(1);
        String[] testSuites = new String[]{String.format("alter account %s set multi_statement_count = 20", accountName), String.format("alter account %s set multi_statement_count = -1", accountName), String.format("alter user %s set multi_statement_count = 20", userName), String.format("alter user %s set multi_statement_count = -1", userName), "alter session set multi_statement_count = -1"};
        int[] expectedErrorCodes = new int[]{1008, 1008, 1006, 1006, 1008};
        statement.execute("use role accountadmin");
        for (int i = 0; i < testSuites.length; ++i) {
            try {
                statement.execute(testSuites[i]);
                Assert.fail();
                continue;
            }
            catch (SQLException e) {
                MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)expectedErrorCodes[i]));
            }
        }
    }
}

