/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.category.TestCategoryStatement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeStatement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryStatement.class})
public class MultiStatementLatestIT
extends BaseJDBCTest {
    protected static String queryResultFormat = "json";

    public static Connection getConnection() throws SQLException {
        Connection conn = BaseJDBCTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        stmt.close();
        return conn;
    }

    @Test
    public void testMultiStmtExecute() throws SQLException {
        Connection connection = MultiStatementLatestIT.getConnection();
        Statement statement = connection.createStatement();
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
        String multiStmtQuery = "create or replace temporary table test_multi (cola int);\ninsert into test_multi VALUES (1), (2);\nselect cola from test_multi order by cola asc";
        boolean hasResultSet = statement.execute(multiStmtQuery);
        Assert.assertFalse((boolean)hasResultSet);
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
        Assert.assertTrue((boolean)statement.getMoreResults());
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)2L, (long)statement.getUpdateCount());
        Assert.assertTrue((boolean)statement.getMoreResults());
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        ResultSet rs = statement.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        Assert.assertFalse((boolean)statement.getMoreResults());
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtTransaction() throws SQLException {
        Connection connection = MultiStatementLatestIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_multi_txn(c1 number, c2 string) as select 10, 'z'");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)4);
        String multiStmtQuery = "begin;\ndelete from test_multi_txn;\ninsert into test_multi_txn values (1, 'a'), (2, 'b');\ncommit";
        boolean hasResultSet = statement.execute(multiStmtQuery);
        Assert.assertFalse((boolean)hasResultSet);
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
        Assert.assertTrue((boolean)statement.getMoreResults());
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)1L, (long)statement.getUpdateCount());
        Assert.assertTrue((boolean)statement.getMoreResults());
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)2L, (long)statement.getUpdateCount());
        Assert.assertFalse((boolean)statement.getMoreResults());
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
        Assert.assertFalse((boolean)statement.getMoreResults());
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        statement.execute("drop table if exists test_multi_txn");
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtExecuteUpdate() throws SQLException {
        Connection connection = MultiStatementLatestIT.getConnection();
        Statement statement = connection.createStatement();
        String multiStmtQuery = "create or replace temporary table test_multi (cola int);\ninsert into test_multi VALUES (1), (2);\nselect cola from test_multi order by cola asc";
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
        int rowCount = statement.executeUpdate(multiStmtQuery);
        Assert.assertEquals((long)0L, (long)rowCount);
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
        Assert.assertTrue((boolean)statement.getMoreResults());
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)2L, (long)statement.getUpdateCount());
        Assert.assertTrue((boolean)statement.getMoreResults());
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        ResultSet rs = statement.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        Assert.assertFalse((boolean)statement.getMoreResults());
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtTransactionRollback() throws SQLException {
        Connection connection = MultiStatementLatestIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_multi_txn_rb(c1 number, c2 string) as select 10, 'z'");
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)4);
        String multiStmtQuery = "begin;\ndelete from test_multi_txn_rb;\nrollback;\nselect count(*) from test_multi_txn_rb";
        boolean hasResultSet = statement.execute(multiStmtQuery);
        Assert.assertFalse((boolean)hasResultSet);
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
        Assert.assertTrue((boolean)statement.getMoreResults());
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)1L, (long)statement.getUpdateCount());
        Assert.assertTrue((boolean)statement.getMoreResults());
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
        Assert.assertTrue((boolean)statement.getMoreResults());
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        ResultSet rs = statement.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        Assert.assertFalse((boolean)statement.getMoreResults());
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
        statement.execute("drop table if exists test_multi_txn_rb");
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtExecuteQuery() throws SQLException {
        Connection connection = MultiStatementLatestIT.getConnection();
        Statement statement = connection.createStatement();
        String multiStmtQuery = "select 1;\ncreate or replace temporary table test_multi (cola int);\ninsert into test_multi VALUES (1), (2);\nselect cola from test_multi order by cola asc";
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)4);
        ResultSet rs = statement.executeQuery(multiStmtQuery);
        Assert.assertNotNull((Object)rs);
        Assert.assertNotNull((Object)statement.getResultSet());
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        Assert.assertTrue((boolean)statement.getMoreResults());
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)0L, (long)statement.getUpdateCount());
        Assert.assertTrue((boolean)statement.getMoreResults());
        Assert.assertNull((Object)statement.getResultSet());
        Assert.assertEquals((long)2L, (long)statement.getUpdateCount());
        Assert.assertTrue((boolean)statement.getMoreResults());
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        rs = statement.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        Assert.assertFalse((boolean)statement.getMoreResults());
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        statement.close();
        connection.close();
    }

    @Test
    public void testMultiStmtUpdateCount() throws SQLException {
        Connection connection = MultiStatementLatestIT.getConnection();
        Statement statement = connection.createStatement();
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
        boolean isResultSet = statement.execute("CREATE OR REPLACE TEMPORARY TABLE TABLIST AS SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME LIKE 'K%' ORDER BY TABLE_SCHEMA, TABLE_NAME; SELECT * FROM TABLIST JOIN INFORMATION_SCHEMA.COLUMNS ON COLUMNS.TABLE_SCHEMA = TABLIST.TABLE_SCHEMA AND COLUMNS.TABLE_NAME = TABLIST.TABLE_NAME;");
        Assert.assertEquals((Object)isResultSet, (Object)false);
        int statementUpdateCount = statement.getUpdateCount();
        Assert.assertEquals((long)statementUpdateCount, (long)0L);
        isResultSet = statement.getMoreResults();
        Assert.assertEquals((Object)isResultSet, (Object)true);
        statementUpdateCount = statement.getUpdateCount();
        Assert.assertEquals((long)statementUpdateCount, (long)-1L);
        statement.close();
        connection.close();
    }

    @Test
    public void testAnonymousBlocksUse() throws SQLException {
        Connection connection = MultiStatementLatestIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table tab758262(c1 number)");
        int multistatementcount = 2;
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)multistatementcount);
        String multiStmtQuery = "begin\ninsert into tab758262 values (1);\nreturn 'done';\nend;\nselect * from tab758262;";
        statement.execute(multiStmtQuery);
        for (int i = 0; i < multistatementcount - 1; ++i) {
            Assert.assertTrue((boolean)statement.getMoreResults());
        }
        ResultSet rs = statement.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        multiStmtQuery = "insert into tab758262 values (25), (26);\nbegin\ninsert into tab758262 values (27);\nreturn 'done';\nend;\nselect * from tab758262;";
        multistatementcount = 3;
        statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)multistatementcount);
        statement.execute(multiStmtQuery);
        for (int i = 0; i < multistatementcount - 1; ++i) {
            Assert.assertTrue((boolean)statement.getMoreResults());
        }
        rs = statement.getResultSet();
        Assert.assertEquals((long)4L, (long)this.getSizeOfResultSet(rs));
        rs.close();
        statement.close();
        connection.close();
    }
}

