/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.TestUtil;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public class OpenGroupCLIFuncIT
extends BaseJDBCTest {
    public static Connection getConnection() throws SQLException {
        Connection connection = AbstractDriverIT.getConnection();
        try (Statement statement = connection.createStatement();){
            statement.execute("alter session set TIMEZONE='America/Los_Angeles',TIMESTAMP_TYPE_MAPPING='TIMESTAMP_LTZ',TIMESTAMP_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_TZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_LTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_NTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM'");
        }
        return connection;
    }

    @Test
    public void testStringFunction() throws SQLException {
        try (Connection connection = OpenGroupCLIFuncIT.getConnection();){
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn ASCII('snowflake')}", "115");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn CHAR(115)}", "s");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn CONCAT('snow', 'flake')}", "snowflake");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn INSERT('snowflake', 2, 3, 'insert')}", "sinsertflake");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn LCASE('SNOWflake')}", "snowflake");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn LEFT('snowflake', 4)}", "snow");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn LENGTH('  snowflake  ')}", "11");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn LOCATE('str', 'strstrstr', 2)}", "4");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn LTRIM('  snowflake  ')}", "snowflake  ");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn REPEAT('snow', 3)}", "snowsnowsnow");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn REPLACE('snowssnowsn', 'sn', 'aa')}", "aaowsaaowaa");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn RIGHT('snowflake', 5)}", "flake");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn RTRIM('  snowflake  ')}", "  snowflake");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn SPACE(4)}", "    ");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn SUBSTRING('snowflake', 2, 3)}", "now");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn UCASE('snowflake')}", "SNOWFLAKE");
        }
    }

    @Test
    public void testDateTimeFunction() throws SQLException {
        try (Connection connection = OpenGroupCLIFuncIT.getConnection();){
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn DAYNAME('2016-5-25')}", "Wed");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn DAYOFMONTH(to_date('2016-5-25'))}", "25");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn DAYOFWEEK(to_date('2016-5-25'))}", "3");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn DAYOFYEAR(to_date('2016-5-25'))}", "146");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn HOUR(to_timestamp('2016-5-25 12:34:56.789789'))}", "12");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn MINUTE(to_timestamp('2016-5-25 12:34:56.789789'))}", "34");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn MONTH(to_date('2016-5-25'))}", "5");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn MONTHNAME(to_date('2016-5-25'))}", "May");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn QUARTER(to_date('2016-5-25'))}", "2");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn SECOND(to_timestamp('2016-5-25 12:34:56.789789'))}", "56");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn TIMESTAMPADD(SQL_TSI_FRAC_SECOND, 1000, to_timestamp('2016-5-25 12:34:56.789789'))}", "Wed, 25 May 2016 12:34:56 -0700");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn TIMESTAMPADD(SQL_TSI_SECOND, 1, to_timestamp('2016-5-25 12:34:56.789789'))}", "Wed, 25 May 2016 12:34:57 -0700");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn TIMESTAMPADD(SQL_TSI_MINUTE, 1, to_timestamp('2016-5-25 12:34:56.789789'))}", "Wed, 25 May 2016 12:35:56 -0700");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn TIMESTAMPADD(SQL_TSI_HOUR, 1, to_timestamp('2016-5-25 12:34:56.789789'))}", "Wed, 25 May 2016 13:34:56 -0700");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn TIMESTAMPADD(SQL_TSI_DAY, 1, to_timestamp('2016-5-25 12:34:56.789789'))}", "Thu, 26 May 2016 12:34:56 -0700");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn TIMESTAMPADD(SQL_TSI_MONTH, 1, to_timestamp('2016-5-25 12:34:56.789789'))}", "Sat, 25 Jun 2016 12:34:56 -0700");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn TIMESTAMPADD(SQL_TSI_QUARTER, 1, to_timestamp('2016-5-25 12:34:56.789789'))}", "Thu, 25 Aug 2016 12:34:56 -0700");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn TIMESTAMPADD(SQL_TSI_YEAR, 1, to_timestamp('2016-5-25 12:34:56.789789'))}", "Thu, 25 May 2017 12:34:56 -0700");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn TIMESTAMPDIFF(SQL_TSI_SECOND, to_timestamp('2016-5-25 12:34:56.789789'), to_timestamp('2016-5-25 12:34:57.789789'))}", "1");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn WEEK(to_timestamp('2016-5-25 12:34:56.789789'))}", "21");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn YEAR(to_timestamp('2016-5-25 12:34:56.789789'))}", "2016");
        }
    }

    @Test
    public void testSystemFunctions() throws SQLException {
        try (Connection connection = OpenGroupCLIFuncIT.getConnection();){
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn DATABASE()}", connection.getCatalog());
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn IFNULL(NULL, 1)}", "1");
            OpenGroupCLIFuncIT.testFunction(connection, "select {fn USER()}", TestUtil.systemGetEnv("SNOWFLAKE_TEST_USER").toUpperCase());
        }
    }

    static void testFunction(Connection connection, String sql, String expected) throws SQLException {
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)expected, (Object)resultSet.getString(1));
        }
    }
}

