/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.category.TestCategoryStatement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryStatement.class})
public class PreparedMultiStmtIT
extends BaseJDBCTest {
    protected static String queryResultFormat = "json";

    public static Connection getConnection() throws SQLException {
        Connection conn = BaseJDBCTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        stmt.close();
        return conn;
    }

    @Test
    public void testExecuteUpdateCount() throws Exception {
        SnowflakeConnectionV1 connection = (SnowflakeConnectionV1)PreparedMultiStmtIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("alter session set MULTI_STATEMENT_COUNT=0");
        statement.execute("create or replace table test_multi_bind(c1 number)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into test_multi_bind(c1) values(?); insert into test_multi_bind values (?), (?)");
        MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)3));
        preparedStatement.setInt(1, 20);
        preparedStatement.setInt(2, 30);
        preparedStatement.setInt(3, 40);
        int rowCount = preparedStatement.executeUpdate();
        MatcherAssert.assertThat((Object)rowCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)preparedStatement.getResultSet(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)preparedStatement.getUpdateCount(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)preparedStatement.getMoreResults(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)preparedStatement.getUpdateCount(), (Matcher)CoreMatchers.is((Object)2));
        ResultSet resultSet = statement.executeQuery("select c1 from test_multi_bind order by c1 asc");
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)20));
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)30));
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)40));
        statement.execute("drop table if exists test_multi_bind");
        preparedStatement.close();
        connection.close();
    }

    @Test
    public void testExecuteLessBindings() throws Exception {
        SnowflakeConnectionV1 connection = (SnowflakeConnectionV1)PreparedMultiStmtIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("alter session set MULTI_STATEMENT_COUNT=0");
        statement.execute("create or replace table test_multi_bind(c1 number)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into test_multi_bind(c1) values(?); insert into test_multi_bind values (?), (?)");
        MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)3));
        preparedStatement.setInt(1, 20);
        preparedStatement.setInt(2, 30);
        try {
            preparedStatement.executeUpdate();
            Assert.fail();
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)100132));
        }
        statement.execute("drop table if exists test_multi_bind");
        preparedStatement.close();
        connection.close();
    }

    @Test
    public void testExecuteMoreBindings() throws Exception {
        SnowflakeConnectionV1 connection = (SnowflakeConnectionV1)PreparedMultiStmtIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("alter session set MULTI_STATEMENT_COUNT=0");
        statement.execute("create or replace table test_multi_bind(c1 number)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into test_multi_bind(c1) values(?); insert into test_multi_bind values (?), (?)");
        MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)3));
        preparedStatement.setInt(1, 20);
        preparedStatement.setInt(2, 30);
        preparedStatement.setInt(3, 40);
        preparedStatement.setInt(4, 50);
        int rowCount = preparedStatement.executeUpdate();
        MatcherAssert.assertThat((Object)rowCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)preparedStatement.getResultSet(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)preparedStatement.getUpdateCount(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)preparedStatement.getMoreResults(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)preparedStatement.getUpdateCount(), (Matcher)CoreMatchers.is((Object)2));
        ResultSet resultSet = statement.executeQuery("select c1 from test_multi_bind order by c1 asc");
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)20));
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)30));
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)40));
        statement.execute("drop table if exists test_multi_bind");
        preparedStatement.close();
        connection.close();
    }

    @Test
    public void testExecuteQueryBindings() throws Exception {
        SnowflakeConnectionV1 connection = (SnowflakeConnectionV1)PreparedMultiStmtIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("alter session set MULTI_STATEMENT_COUNT=0");
        PreparedStatement preparedStatement = connection.prepareStatement("select ?; select ?, ?; select ?, ?, ?");
        MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)6));
        preparedStatement.setInt(1, 10);
        preparedStatement.setInt(2, 20);
        preparedStatement.setInt(3, 30);
        preparedStatement.setInt(4, 40);
        preparedStatement.setInt(5, 50);
        preparedStatement.setInt(6, 60);
        ResultSet resultSet = preparedStatement.executeQuery();
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)preparedStatement.getMoreResults(), (Matcher)CoreMatchers.is((Object)true));
        resultSet = preparedStatement.getResultSet();
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)20));
        MatcherAssert.assertThat((Object)resultSet.getInt(2), (Matcher)CoreMatchers.is((Object)30));
        MatcherAssert.assertThat((Object)preparedStatement.getMoreResults(), (Matcher)CoreMatchers.is((Object)true));
        resultSet = preparedStatement.getResultSet();
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)40));
        MatcherAssert.assertThat((Object)resultSet.getInt(2), (Matcher)CoreMatchers.is((Object)50));
        MatcherAssert.assertThat((Object)resultSet.getInt(3), (Matcher)CoreMatchers.is((Object)60));
        preparedStatement.close();
        connection.close();
    }

    @Test
    public void testExecuteQueryNoBindings() throws Exception {
        SnowflakeConnectionV1 connection = (SnowflakeConnectionV1)PreparedMultiStmtIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("alter session set MULTI_STATEMENT_COUNT=0");
        PreparedStatement preparedStatement = connection.prepareStatement("select 10; select 20, 30; select 40, 50, 60");
        MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)0));
        ResultSet resultSet = preparedStatement.executeQuery();
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)preparedStatement.getMoreResults(), (Matcher)CoreMatchers.is((Object)true));
        resultSet = preparedStatement.getResultSet();
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)20));
        MatcherAssert.assertThat((Object)resultSet.getInt(2), (Matcher)CoreMatchers.is((Object)30));
        MatcherAssert.assertThat((Object)preparedStatement.getMoreResults(), (Matcher)CoreMatchers.is((Object)true));
        resultSet = preparedStatement.getResultSet();
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)40));
        MatcherAssert.assertThat((Object)resultSet.getInt(2), (Matcher)CoreMatchers.is((Object)50));
        MatcherAssert.assertThat((Object)resultSet.getInt(3), (Matcher)CoreMatchers.is((Object)60));
        preparedStatement.close();
        connection.close();
    }
}

