/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.After;
import org.junit.Before;

abstract class PreparedStatement0IT
extends BaseJDBCTest {
    private final String queryResultFormat;
    final String insertSQL = "insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)";
    final String selectAllSQL = "select * from TEST_PREPST";
    final String updateSQL = "update TEST_PREPST set COLC = 'newString' where ID = ?";
    final String deleteSQL = "delete from TEST_PREPST where ID = ?";
    final String selectSQL = "select * from TEST_PREPST where ID = ?";
    final String createTableSQL = "create or replace table test_prepst(id INTEGER, colA DOUBLE, colB FLOAT, colC String,  colD NUMBER, col INTEGER)";
    final String deleteTableSQL = "drop table if exists TEST_PREPST";
    final String enableCacheReuse = "alter session set USE_CACHED_RESULT=true";
    final String tableFuncSQL = "select 1 from table(generator(rowCount => ?))";

    Connection init() throws SQLException {
        Connection conn = BaseJDBCTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("alter session set jdbc_query_result_format = '" + this.queryResultFormat + "'");
        stmt.close();
        return conn;
    }

    @Before
    public void setUp() throws SQLException {
        try (Connection con = this.init();){
            con.createStatement().execute("create or replace table test_prepst(id INTEGER, colA DOUBLE, colB FLOAT, colC String,  colD NUMBER, col INTEGER)");
        }
    }

    @After
    public void tearDown() throws SQLException {
        try (Connection con = this.init();){
            con.createStatement().execute("drop table if exists TEST_PREPST");
        }
    }

    PreparedStatement0IT(String queryResultFormat) {
        this.queryResultFormat = queryResultFormat;
    }
}

