/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryStatement;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.PreparedStatement0IT;
import net.snowflake.client.jdbc.SnowflakePreparedStatement;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryStatement.class})
public class PreparedStatement1IT
extends PreparedStatement0IT {
    public PreparedStatement1IT() {
        super("json");
    }

    PreparedStatement1IT(String queryFormat) {
        super(queryFormat);
    }

    @Test
    public void testGetParameterMetaData() throws SQLException {
        try (Connection connection = this.init();){
            try (PreparedStatement preparedStatement = connection.prepareStatement("update TEST_PREPST set COLC = 'newString' where ID = ?");){
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)1));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterType(1), (Matcher)CoreMatchers.is((Object)12));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getPrecision(1), (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getScale(1), (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().isNullable(1), (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterTypeName(1), (Matcher)CoreMatchers.is((Object)"text"));
            }
            preparedStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");
            try {
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)6));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterType(1), (Matcher)CoreMatchers.is((Object)12));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterTypeName(1), (Matcher)CoreMatchers.is((Object)"text"));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterType(6), (Matcher)CoreMatchers.is((Object)12));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterTypeName(6), (Matcher)CoreMatchers.is((Object)"text"));
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            preparedStatement = connection.prepareStatement("select * from TEST_PREPST");
            try {
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)0));
                try {
                    preparedStatement.getParameterMetaData().getParameterType(3);
                    Assert.fail((String)"An exception should have been thrown");
                }
                catch (SQLException e) {
                    MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.getMessageCode()));
                }
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    @Test
    public void testInsertStageArrayBind() throws SQLException {
        try (Connection connection = this.init();){
            connection.createStatement().execute("create or replace table testStageArrayBind(c1 integer)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into testStageArrayBind values (?)");){
                for (int i = 0; i < 70000; ++i) {
                    prepStatement.setInt(1, i);
                    prepStatement.addBatch();
                }
                prepStatement.executeBatch();
                try (Statement statement = connection.createStatement();
                     ResultSet resultSet = statement.executeQuery("select * from testStageArrayBind order by c1 asc");){
                    int count = 0;
                    while (resultSet.next()) {
                        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)count));
                        ++count;
                    }
                }
            }
        }
    }

    static void bindOneParamSet(PreparedStatement prepst, int id, double colA, float colB, String colC, long colD, short colE) throws SQLException {
        prepst.setInt(1, id);
        prepst.setDouble(2, colA);
        prepst.setFloat(3, colB);
        prepst.setString(4, colC);
        prepst.setLong(5, colD);
        prepst.setShort(6, colE);
    }

    @Test
    public void testPrepareStatementWithKeys() throws SQLException {
        try (Connection connection = this.init();){
            connection.createStatement().execute("create or replace table test_prepst(id INTEGER, colA DOUBLE, colB FLOAT, colC String,  colD NUMBER, col INTEGER)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)", 2);){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                prepStatement.executeBatch();
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
                }
            }
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testInsertBatch() throws SQLException {
        try (Connection connection = this.init();){
            connection.createStatement().execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 0");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                int[] countResult = prepStatement.executeBatch();
                Assert.assertEquals((long)1L, (long)countResult[0]);
                Assert.assertEquals((long)1L, (long)countResult[1]);
                Assert.assertEquals((long)2L, (long)prepStatement.getUpdateCount());
                Assert.assertEquals((long)2L, (long)prepStatement.getLargeUpdateCount());
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    Assert.assertEquals((long)2L, (long)this.getSizeOfResultSet(resultSet));
                }
            }
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testInsertBatchStage() throws SQLException {
        try (Connection connection = this.init();){
            connection.createStatement().execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 12");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                int[] countResult = prepStatement.executeBatch();
                Assert.assertEquals((long)1L, (long)countResult[0]);
                Assert.assertEquals((long)1L, (long)countResult[1]);
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    Assert.assertEquals((long)2L, (long)this.getSizeOfResultSet(resultSet));
                }
            }
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testInsertBatchStageMultipleTimes() throws SQLException {
        try (Connection connection = this.init();){
            connection.createStatement().execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 6");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                int[] countResult = prepStatement.executeBatch();
                Assert.assertEquals((long)1L, (long)countResult.length);
                Assert.assertEquals((long)1L, (long)countResult[0]);
                Assert.assertEquals((long)1L, (long)prepStatement.getUpdateCount());
                Assert.assertEquals((long)1L, (long)prepStatement.getLargeUpdateCount());
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                countResult = prepStatement.executeBatch();
                Assert.assertEquals((long)1L, (long)countResult.length);
                Assert.assertEquals((long)1L, (long)countResult[0]);
                Assert.assertEquals((long)1L, (long)prepStatement.getUpdateCount());
                Assert.assertEquals((long)1L, (long)prepStatement.getLargeUpdateCount());
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    Assert.assertEquals((long)2L, (long)this.getSizeOfResultSet(resultSet));
                }
            }
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testStageBatchNull() throws SQLException {
        try (Connection connection = this.init();){
            int[] thresholds;
            for (int threshold : thresholds = new int[]{0, 6}) {
                connection.createStatement().execute("DELETE FROM TEST_PREPST WHERE 1=1");
                connection.createStatement().execute(String.format("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = %d", threshold));
                try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                    prepStatement.setNull(1, 4);
                    prepStatement.setNull(2, 8);
                    prepStatement.setNull(3, 6);
                    prepStatement.setNull(4, 12);
                    prepStatement.setNull(5, 2);
                    prepStatement.setNull(6, 4);
                    prepStatement.addBatch();
                    int[] countResult = prepStatement.executeBatch();
                    Assert.assertEquals((long)1L, (long)countResult.length);
                    Assert.assertEquals((long)1L, (long)countResult[0]);
                }
                try (ResultSet resultSet = connection.createStatement().executeQuery("SELECT * FROM TEST_PREPST");){
                    resultSet.next();
                    String errorMessage = "Column should be null (" + (threshold > 0 ? "stage" : "non-stage") + ")";
                    resultSet.getInt(1);
                    Assert.assertTrue((String)errorMessage, (boolean)resultSet.wasNull());
                    resultSet.getDouble(2);
                    Assert.assertTrue((String)errorMessage, (boolean)resultSet.wasNull());
                    resultSet.getFloat(3);
                    Assert.assertTrue((String)errorMessage, (boolean)resultSet.wasNull());
                    resultSet.getString(4);
                    Assert.assertTrue((String)errorMessage, (boolean)resultSet.wasNull());
                    resultSet.getLong(5);
                    Assert.assertTrue((String)errorMessage, (boolean)resultSet.wasNull());
                    resultSet.getShort(6);
                    Assert.assertTrue((String)errorMessage, (boolean)resultSet.wasNull());
                }
            }
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testStageString() throws SQLException {
        try (Connection connection = this.init();){
            int[] thresholds = new int[]{0, 6};
            String[] rows = new String[]{null, "", "\"", ",", "\n", "\r\n", "\"\"", "null", "\\\n", "\",", "\\\",\\\""};
            for (int threshold : thresholds) {
                connection.createStatement().execute("DELETE FROM TEST_PREPST WHERE 1=1");
                connection.createStatement().execute(String.format("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = %d", threshold));
                try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                    for (int i = 0; i < rows.length; ++i) {
                        PreparedStatement1IT.bindOneParamSet(prepStatement, i, 0.0, 0.0f, rows[i], 0L, (short)0);
                        prepStatement.addBatch();
                    }
                    prepStatement.executeBatch();
                    try (ResultSet resultSet = connection.createStatement().executeQuery("SELECT colC FROM TEST_PREPST ORDER BY id ASC");){
                        String errorMessage = "Strings should match (" + (threshold > 0 ? "stage" : "non-stage") + ")";
                        for (String row : rows) {
                            resultSet.next();
                            Assert.assertEquals((String)errorMessage, (Object)row, (Object)resultSet.getString(1));
                        }
                    }
                }
            }
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testIncorrectTypes() throws SQLException {
        try (Connection connection = this.init();){
            int[] thresholds;
            for (int threshold : thresholds = new int[]{0, 6}) {
                connection.createStatement().execute("DELETE FROM TEST_PREPST WHERE 1=1");
                connection.createStatement().execute(String.format("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = %d", threshold));
                try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                    prepStatement.setString(1, "notAnInt");
                    prepStatement.setDouble(2, 0.0);
                    prepStatement.setFloat(3, 0.0f);
                    prepStatement.setString(4, "");
                    prepStatement.setLong(5, 0L);
                    prepStatement.setShort(6, (short)0);
                    prepStatement.addBatch();
                    try {
                        prepStatement.executeBatch();
                        Assert.fail((String)"An exception should have been thrown");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testStageBatchTimestamps() throws SQLException {
        try (Connection connection = this.init();){
            Timestamp tsEpoch = new Timestamp(0L);
            Timestamp tsEpochMinusOneSec = new Timestamp(-1000L);
            Timestamp tsPast = new Timestamp(-2208988800100L);
            Timestamp tsFuture = new Timestamp(32503680000000L);
            Timestamp tsNow = new Timestamp(System.currentTimeMillis());
            Timestamp tsArbitrary = new Timestamp(862056000000L);
            Timestamp[] timestamps = new Timestamp[]{tsEpochMinusOneSec, tsEpoch, tsPast, tsFuture, tsNow, tsArbitrary, null};
            String[] tsTypes = new String[]{"TIMESTAMP_LTZ", "TIMESTAMP_NTZ"};
            try {
                for (String tsType : tsTypes) {
                    connection.createStatement().execute("ALTER SESSION SET TIMESTAMP_TYPE_MAPPING = " + tsType);
                    connection.createStatement().execute("ALTER SESSION SET CLIENT_TIMESTAMP_TYPE_MAPPING = " + tsType);
                    connection.createStatement().execute("CREATE OR REPLACE TABLE test_prepst_ts (id INTEGER, tz TIMESTAMP)");
                    try (PreparedStatement prepStatement = connection.prepareStatement("INSERT INTO test_prepst_ts(id, tz) VALUES(?,?)");){
                        int i;
                        int i2;
                        int res2;
                        int[] countResult;
                        connection.createStatement().executeQuery("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 0");
                        for (int i3 = 0; i3 < timestamps.length; ++i3) {
                            prepStatement.setInt(1, i3);
                            prepStatement.setTimestamp(2, timestamps[i3]);
                            prepStatement.addBatch();
                        }
                        for (int res2 : countResult = prepStatement.executeBatch()) {
                            Assert.assertEquals((long)1L, (long)res2);
                        }
                        Timestamp[] nonStageResult = new Timestamp[timestamps.length];
                        ResultSet rsNonStage = connection.createStatement().executeQuery("SELECT * FROM test_prepst_ts ORDER BY id ASC");
                        for (i2 = 0; i2 < nonStageResult.length; ++i2) {
                            rsNonStage.next();
                            nonStageResult[i2] = rsNonStage.getTimestamp(2);
                        }
                        connection.createStatement().execute("DELETE FROM test_prepst_ts WHERE 1=1");
                        connection.createStatement().execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
                        for (i2 = 0; i2 < timestamps.length; ++i2) {
                            prepStatement.setInt(1, i2);
                            prepStatement.setTimestamp(2, timestamps[i2]);
                            prepStatement.addBatch();
                        }
                        int[] i4 = countResult = prepStatement.executeBatch();
                        res2 = i4.length;
                        for (int j = 0; j < res2; ++j) {
                            int res3 = i4[j];
                            Assert.assertEquals((long)1L, (long)res3);
                        }
                        Timestamp[] stageResult = new Timestamp[timestamps.length];
                        ResultSet rsStage = connection.createStatement().executeQuery("SELECT * FROM test_prepst_ts ORDER BY id ASC");
                        for (i = 0; i < stageResult.length; ++i) {
                            rsStage.next();
                            stageResult[i] = rsStage.getTimestamp(2);
                        }
                        for (i = 0; i < timestamps.length; ++i) {
                            Assert.assertEquals((String)("Stage binding timestamp should match non-stage binding timestamp (" + tsType + ")"), (Object)nonStageResult[i], (Object)stageResult[i]);
                        }
                    }
                }
            }
            finally {
                connection.createStatement().execute("DROP TABLE IF EXISTS test_prepst_ts");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testStageBatchTimes() throws SQLException {
        try (Connection connection = this.init();){
            Time tMidnight = new Time(0L);
            Time tNeg = new Time(-1L);
            Time tPos = new Time(1L);
            Time tNow = new Time(System.currentTimeMillis());
            Time tNoon = new Time(43200000L);
            Time[] times = new Time[]{tMidnight, tNeg, tPos, tNow, tNoon, null};
            try {
                connection.createStatement().execute("CREATE OR REPLACE TABLE test_prepst_time (id INTEGER, tod TIME)");
                try (PreparedStatement prepStatement = connection.prepareStatement("INSERT INTO test_prepst_time(id, tod) VALUES(?,?)");){
                    int i;
                    int i2;
                    int[] countResult;
                    connection.createStatement().execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 0");
                    for (int i3 = 0; i3 < times.length; ++i3) {
                        prepStatement.setInt(1, i3);
                        prepStatement.setTime(2, times[i3]);
                        prepStatement.addBatch();
                    }
                    for (int res : countResult = prepStatement.executeBatch()) {
                        Assert.assertEquals((long)1L, (long)res);
                    }
                    Time[] nonStageResult = new Time[times.length];
                    ResultSet rsNonStage = connection.createStatement().executeQuery("SELECT * FROM test_prepst_time ORDER BY id ASC");
                    for (i2 = 0; i2 < nonStageResult.length; ++i2) {
                        rsNonStage.next();
                        nonStageResult[i2] = rsNonStage.getTime(2);
                    }
                    connection.createStatement().execute("DELETE FROM test_prepst_time WHERE 1=1");
                    connection.createStatement().execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
                    for (i2 = 0; i2 < times.length; ++i2) {
                        prepStatement.setInt(1, i2);
                        prepStatement.setTime(2, times[i2]);
                        prepStatement.addBatch();
                    }
                    for (int res : countResult = prepStatement.executeBatch()) {
                        Assert.assertEquals((long)1L, (long)res);
                    }
                    Time[] stageResult = new Time[times.length];
                    ResultSet rsStage = connection.createStatement().executeQuery("SELECT * FROM test_prepst_time ORDER BY id ASC");
                    for (i = 0; i < stageResult.length; ++i) {
                        rsStage.next();
                        stageResult[i] = rsStage.getTime(2);
                    }
                    for (i = 0; i < times.length; ++i) {
                        Assert.assertEquals((String)"Stage binding time should match non-stage binding time", (Object)nonStageResult[i], (Object)stageResult[i]);
                    }
                }
            }
            finally {
                connection.createStatement().execute("DROP TABLE IF EXISTS test_prepst_time");
            }
        }
    }

    @Test
    public void testClearParameters() throws SQLException {
        try (Connection connection = this.init();
             PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
            PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
            prepStatement.clearParameters();
            int parameterSize = ((SnowflakePreparedStatementV1)prepStatement).getParameterBindings().size();
            MatcherAssert.assertThat((Object)parameterSize, (Matcher)CoreMatchers.is((Object)0));
            PreparedStatement1IT.bindOneParamSet(prepStatement, 3, 1.22, 1.2f, "hello", 12222L, (short)1);
            prepStatement.executeUpdate();
            try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                resultSet.next();
                Assert.assertEquals((long)3L, (long)resultSet.getInt(1));
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
    }

    @Test
    public void testClearBatch() throws SQLException {
        try (Connection connection = this.init();
             PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
            PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
            prepStatement.addBatch();
            PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
            prepStatement.addBatch();
            prepStatement.clearBatch();
            int batchSize = ((SnowflakePreparedStatementV1)prepStatement).getBatchParameterBindings().size();
            MatcherAssert.assertThat((Object)batchSize, (Matcher)CoreMatchers.is((Object)0));
            PreparedStatement1IT.bindOneParamSet(prepStatement, 3, 1.22, 1.2f, "hello", 12222L, (short)1);
            prepStatement.addBatch();
            prepStatement.executeBatch();
            batchSize = ((SnowflakePreparedStatementV1)prepStatement).getBatchParameterBindings().size();
            MatcherAssert.assertThat((Object)batchSize, (Matcher)CoreMatchers.is((Object)0));
            try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                resultSet.next();
                Assert.assertEquals((long)3L, (long)resultSet.getInt(1));
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
    }

    @Test
    public void testInsertOneRow() throws SQLException {
        try (Connection connection = this.init();){
            connection.createStatement().execute("CREATE OR REPLACE TABLE test_prepst_date (id INTEGER, d DATE)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                Assert.assertEquals((long)1L, (long)prepStatement.executeUpdate());
            }
            try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
            }
            prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");
            try {
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                Assert.assertFalse((boolean)prepStatement.execute());
                Assert.assertEquals((long)1L, (long)prepStatement.getUpdateCount());
                Assert.assertEquals((long)1L, (long)prepStatement.getLargeUpdateCount());
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    @Test
    public void testUpdateOneRow() throws SQLException {
        try (Connection connection = this.init();){
            connection.createStatement().execute("CREATE OR REPLACE TABLE test_prepst_date (id INTEGER, d DATE)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                prepStatement.executeBatch();
            }
            prepStatement = connection.prepareStatement("update TEST_PREPST set COLC = 'newString' where ID = ?");
            try {
                prepStatement.setInt(1, 1);
                int count = prepStatement.executeUpdate();
                Assert.assertEquals((long)1L, (long)count);
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    resultSet.next();
                    Assert.assertEquals((Object)"newString", (Object)resultSet.getString(4));
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
            prepStatement = connection.prepareStatement("update TEST_PREPST set COLC = 'newString' where ID = ?");
            try {
                prepStatement.setInt(1, 2);
                Assert.assertFalse((boolean)prepStatement.execute());
                Assert.assertEquals((long)1L, (long)prepStatement.getUpdateCount());
                Assert.assertEquals((long)1L, (long)prepStatement.getLargeUpdateCount());
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    resultSet.next();
                    resultSet.next();
                    Assert.assertEquals((Object)"newString", (Object)resultSet.getString(4));
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    @Test
    public void testDeleteOneRow() throws SQLException {
        try (Connection connection = this.init();){
            String qid1;
            connection.createStatement().execute("CREATE OR REPLACE TABLE test_prepst_date (id INTEGER, d DATE)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                prepStatement.executeBatch();
            }
            try (PreparedStatement prepStatement = connection.prepareStatement("delete from TEST_PREPST where ID = ?");){
                prepStatement.setInt(1, 1);
                int count = prepStatement.executeUpdate();
                Assert.assertEquals((long)1L, (long)count);
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
                }
                Assert.assertTrue((boolean)prepStatement.isWrapperFor(SnowflakePreparedStatement.class));
                qid1 = prepStatement.unwrap(SnowflakePreparedStatement.class).getQueryID();
                Assert.assertNotNull((Object)qid1);
            }
            prepStatement = connection.prepareStatement("delete from TEST_PREPST where ID = ?");
            try {
                prepStatement.setInt(1, 2);
                Assert.assertFalse((boolean)prepStatement.execute());
                Assert.assertEquals((long)1L, (long)prepStatement.getUpdateCount());
                Assert.assertEquals((long)1L, (long)prepStatement.getLargeUpdateCount());
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    Assert.assertEquals((long)0L, (long)this.getSizeOfResultSet(resultSet));
                    Assert.assertTrue((boolean)prepStatement.isWrapperFor(SnowflakePreparedStatement.class));
                    String qid2 = prepStatement.unwrap(SnowflakePreparedStatement.class).getQueryID();
                    Assert.assertNotNull((Object)qid2);
                    Assert.assertNotEquals((Object)qid1, (Object)qid2);
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    @Test
    public void testSelectOneRow() throws SQLException {
        try (Connection connection = this.init();){
            ResultSet resultSet;
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                prepStatement.executeBatch();
            }
            prepStatement = connection.prepareStatement("select * from TEST_PREPST where ID = ?");
            try {
                prepStatement.setInt(1, 2);
                resultSet = prepStatement.executeQuery();
                try {
                    Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
            prepStatement = connection.prepareStatement("select * from TEST_PREPST where ID = ?");
            try {
                prepStatement.setInt(1, 2);
                Assert.assertTrue((boolean)prepStatement.execute());
                resultSet = prepStatement.getResultSet();
                try {
                    Assert.assertEquals((long)1L, (long)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    @Test
    public void testUpdateBatch() throws SQLException {
        try (Connection connection = this.init();){
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                prepStatement.executeBatch();
            }
            prepStatement = connection.prepareStatement("update TEST_PREPST set COLC = 'newString' where ID = ?");
            try {
                prepStatement.setInt(1, 1);
                prepStatement.addBatch();
                prepStatement.setInt(1, 2);
                prepStatement.addBatch();
                prepStatement.setInt(1, 3);
                prepStatement.addBatch();
                int[] counts = prepStatement.executeBatch();
                MatcherAssert.assertThat((Object)counts[0], (Matcher)CoreMatchers.is((Object)1));
                MatcherAssert.assertThat((Object)counts[1], (Matcher)CoreMatchers.is((Object)1));
                MatcherAssert.assertThat((Object)counts[2], (Matcher)CoreMatchers.is((Object)0));
                Assert.assertEquals((long)0L, (long)prepStatement.getUpdateCount());
                Assert.assertEquals((long)0L, (long)prepStatement.getLargeUpdateCount());
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    resultSet.next();
                    MatcherAssert.assertThat((Object)resultSet.getString(4), (Matcher)CoreMatchers.is((Object)"newString"));
                    resultSet.next();
                    MatcherAssert.assertThat((Object)resultSet.getString(4), (Matcher)CoreMatchers.is((Object)"newString"));
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    @Test
    public void testBatchInsertWithCacheEnabled() throws SQLException {
        try (Connection connection = this.init();){
            connection.createStatement().execute("alter session set USE_CACHED_RESULT=true");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)1);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)2);
                prepStatement.addBatch();
                int[] countResult = prepStatement.executeBatch();
                Assert.assertEquals((long)1L, (long)countResult[0]);
                Assert.assertEquals((long)1L, (long)countResult[1]);
                prepStatement.clearBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 3, 3.3333, 3.2f, "test3", 1221221123131L, (short)3);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 4, 4.4444, 4.2f, "test4", 1221221123131L, (short)4);
                prepStatement.addBatch();
                countResult = prepStatement.executeBatch();
                Assert.assertEquals((long)1L, (long)countResult[0]);
                Assert.assertEquals((long)1L, (long)countResult[1]);
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    resultSet.next();
                    Assert.assertEquals((long)1L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)2L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)3L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)4L, (long)resultSet.getInt(1));
                    Assert.assertFalse((boolean)resultSet.next());
                }
            }
        }
    }

    @Test
    @Ignore
    public void manualTestForPreparedStatementLogging() throws SQLException {
        Map<String, String> params = PreparedStatement1IT.getConnectionParameters();
        Properties props = new Properties();
        String uri = params.get("uri");
        props.put("account", params.get("account"));
        props.put("ssl", params.get("ssl"));
        props.put("database", params.get("database"));
        props.put("schema", params.get("schema"));
        props.put("user", params.get("user"));
        props.put("password", params.get("password"));
        props.put("tracing", "info");
        Connection con = DriverManager.getConnection(uri, props);
        con.createStatement().executeUpdate("alter session set CLIENT_ENABLE_LOG_INFO_STATEMENT_PARAMETERS=true");
        con.createStatement().execute("create or replace table test_prepst(id INTEGER, colA DOUBLE, colB FLOAT, colC String,  colD NUMBER, col INTEGER)");
        PreparedStatement prepStatement = con.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)", 2);
        PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
        prepStatement.addBatch();
        prepStatement.executeBatch();
        con.createStatement().executeUpdate("alter session set CLIENT_ENABLE_LOG_INFO_STATEMENT_PARAMETERS=false");
        con.close();
    }
}

