/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryStatement;
import net.snowflake.client.jdbc.PreparedStatement0IT;
import net.snowflake.client.jdbc.PreparedStatement1IT;
import net.snowflake.client.jdbc.SnowflakePreparedStatement;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryStatement.class})
public class PreparedStatement2LatestIT
extends PreparedStatement0IT {
    public PreparedStatement2LatestIT() {
        super("json");
    }

    PreparedStatement2LatestIT(String queryFormat) {
        super(queryFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrepareUDTF() throws Exception {
        try (Connection connection = this.init();){
            try {
                connection.createStatement().execute("create or replace table employee(id number, address text)");
                connection.createStatement().execute("create or replace function employee_detail(sid number, addr text)\n returns table(id number, address text)\nLANGUAGE SQL\nas\n$$\nselect *\nfrom employee\nwhere  id=sid\n$$;");
                try (PreparedStatement prepStatement = connection.prepareStatement("select * from table(employee_detail(?, ?))");){
                    prepStatement.setInt(1, 1);
                    prepStatement.setString(2, "abc");
                    prepStatement.execute();
                }
                prepStatement = connection.prepareStatement("select * from table(employee_detail(?, 'abc'))");
                try {
                    prepStatement.setInt(1, 1);
                    prepStatement.execute();
                }
                finally {
                    if (prepStatement != null) {
                        prepStatement.close();
                    }
                }
                try {
                    prepStatement = connection.prepareStatement("select * from table(employee_detail(?, 123))");
                    try {
                        prepStatement.setInt(1, 1);
                        prepStatement.execute();
                        Assert.fail();
                    }
                    finally {
                        if (prepStatement != null) {
                            prepStatement.close();
                        }
                    }
                }
                catch (SQLException e) {
                    Assert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)1044));
                }
                connection.createStatement().execute("create or replace function employee_detail(name text , addr text)\n returns table(id number)\nLANGUAGE SQL\nas\n$$\nselect id\nfrom employee\n$$;");
                prepStatement = connection.prepareStatement("select * from table(employee_detail(?, 'abc'))");
                try {
                    prepStatement.setInt(1, 1);
                    prepStatement.execute();
                }
                finally {
                    if (prepStatement != null) {
                        prepStatement.close();
                    }
                }
            }
            finally {
                connection.createStatement().execute("drop function if exists employee_detail(number, text)");
                connection.createStatement().execute("drop function if exists employee_detail(text, text)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectWithBinding() throws Throwable {
        try (Connection connection = this.init();){
            connection.createStatement().execute("create or replace table TESTNULL(created_time timestamp_ntz, mid int)");
            try {
                PreparedStatement ps = connection.prepareStatement("SELECT 1 FROM TESTNULL WHERE CREATED_TIME = TO_TIMESTAMP(?, 3) and MID = ?");
                ps.setObject(1, 0);
                ps.setObject(2, null);
                ResultSet rs = ps.executeQuery();
                Assert.assertFalse((boolean)rs.next());
                rs.close();
                ps.close();
                ps = connection.prepareStatement("SELECT 1 FROM TESTNULL WHERE CREATED_TIME = TO_TIMESTAMP(?::NUMBER, 3) and MID = ?");
                ps.setObject(1, 0);
                ps.setObject(2, null);
                rs = ps.executeQuery();
                Assert.assertFalse((boolean)rs.next());
                rs.close();
                ps.close();
            }
            finally {
                connection.createStatement().execute("drop table if exists TESTNULL");
            }
        }
    }

    @Test
    public void testLimitBind() throws SQLException {
        try (Connection connection = this.init();){
            String stmtStr = "select seq4() from table(generator(rowcount=>100)) limit ?";
            try (PreparedStatement prepStatement = connection.prepareStatement(stmtStr);){
                prepStatement.setInt(1, 10);
                prepStatement.executeQuery();
            }
        }
    }

    @Test
    public void testConstOptLimitBind() throws SQLException {
        try (Connection connection = this.init();){
            String stmtStr = "select 1 limit ? offset ?";
            try (PreparedStatement prepStatement = connection.prepareStatement(stmtStr);){
                prepStatement.setInt(1, 10);
                prepStatement.setInt(2, 0);
                try (ResultSet resultSet = prepStatement.executeQuery();){
                    resultSet.next();
                    MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)1));
                    MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
                }
            }
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testTableFuncBindInput() throws SQLException {
        try (Connection connection = this.init();
             PreparedStatement prepStatement = connection.prepareStatement("select 1 from table(generator(rowCount => ?))");){
            prepStatement.setInt(1, 2);
            try (ResultSet resultSet = prepStatement.executeQuery();){
                Assert.assertEquals((long)2L, (long)this.getSizeOfResultSet(resultSet));
            }
        }
    }

    @Test
    public void testExecuteLargeBatch() throws SQLException {
        try (Connection con = this.init();
             Statement statement = con.createStatement();){
            statement.execute("create or replace table mytab(id int)");
            try (PreparedStatement pstatement = con.prepareStatement("insert into mytab(id) values (?)");){
                pstatement.setLong(1, 4L);
                pstatement.addBatch();
                pstatement.setLong(1, 5L);
                pstatement.addBatch();
                pstatement.setLong(1, 6L);
                pstatement.addBatch();
                pstatement.executeLargeBatch();
                con.commit();
                try (ResultSet resultSet = statement.executeQuery("select * from mytab");){
                    resultSet.next();
                    Assert.assertEquals((long)4L, (long)resultSet.getInt(1));
                }
                statement.execute("drop table if exists mytab");
            }
        }
    }

    @Test
    public void testRemoveExtraDescribeCalls() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_uuid_with_bind(c1 number)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into test_uuid_with_bind values (?)");
        preparedStatement.setInt(1, 5);
        Assert.assertEquals((long)1L, (long)preparedStatement.executeUpdate());
        String queryId1 = preparedStatement.unwrap(SnowflakePreparedStatement.class).getQueryID();
        String queryId2 = preparedStatement.getMetaData().unwrap(SnowflakeResultSetMetaData.class).getQueryID();
        Assert.assertEquals((Object)queryId1, (Object)queryId2);
        preparedStatement.addBatch();
        preparedStatement = connection.prepareStatement("select * from test_uuid_with_bind where c1 = ?");
        Assert.assertFalse((boolean)preparedStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
        preparedStatement.setInt(1, 5);
        ResultSet resultSet = preparedStatement.executeQuery();
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        queryId1 = preparedStatement.unwrap(SnowflakePreparedStatement.class).getQueryID();
        queryId2 = preparedStatement.getMetaData().unwrap(SnowflakeResultSetMetaData.class).getQueryID();
        String queryId3 = resultSet.unwrap(SnowflakeResultSet.class).getQueryID();
        Assert.assertEquals((Object)queryId1, (Object)queryId2);
        Assert.assertEquals((Object)queryId1, (Object)queryId3);
        resultSet.close();
        preparedStatement.close();
        statement.execute("drop table if exists test_uuid_with_bind");
        connection.close();
    }

    @Test
    public void testRemoveExtraDescribeCallsSanityCheck() throws SQLException {
        Connection connection = this.init();
        PreparedStatement preparedStatement = connection.prepareStatement("create or replace table test_uuid_with_bind(c1 number, c2 string)");
        preparedStatement.execute();
        String queryId1 = preparedStatement.unwrap(SnowflakePreparedStatement.class).getQueryID();
        preparedStatement = connection.prepareStatement("insert into test_uuid_with_bind values (?, ?)");
        Assert.assertFalse((boolean)preparedStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
        preparedStatement.setInt(1, 5);
        preparedStatement.setString(2, "hello");
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 7);
        preparedStatement.setString(2, "hello1");
        preparedStatement.addBatch();
        String queryId2 = preparedStatement.getMetaData().unwrap(SnowflakeResultSetMetaData.class).getQueryID();
        Assert.assertNotEquals((Object)queryId1, (Object)queryId2);
        preparedStatement.executeBatch();
        String queryId3 = preparedStatement.unwrap(SnowflakePreparedStatement.class).getQueryID();
        Assert.assertNotEquals((Object)queryId2, (Object)queryId3);
        String queryId4 = preparedStatement.getMetaData().unwrap(SnowflakeResultSetMetaData.class).getQueryID();
        Assert.assertEquals((Object)queryId2, (Object)queryId4);
        connection.createStatement().execute("drop table if exists test_uuid_with_bind");
        preparedStatement.close();
        connection.close();
    }

    @Test
    public void testAlreadyDescribedMultipleResults() throws SQLException {
        Connection connection = this.init();
        PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");
        PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
        prepStatement.execute();
        Assert.assertTrue((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
        prepStatement = connection.prepareStatement("select * from TEST_PREPST where ID = ?");
        Assert.assertFalse((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
        prepStatement.setInt(1, 1);
        ResultSet rs = prepStatement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
        prepStatement = connection.prepareStatement("select * from TEST_PREPST");
        Assert.assertFalse((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
        rs = prepStatement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
    }

    @Test
    public void testConsecutiveBatchInsertError() throws SQLException {
        try (Connection connection = this.init();){
            int i;
            connection.createStatement().execute("create or replace table testStageArrayBind(c1 integer, c2 string)");
            PreparedStatement prepStatement = connection.prepareStatement("insert into testStageArrayBind values (?, ?)");
            Assert.assertFalse((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
            Assert.assertFalse((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isArrayBindSupported());
            for (i = 0; i < 35000; ++i) {
                prepStatement.setInt(1, i);
                prepStatement.setString(2, "test" + i);
                prepStatement.addBatch();
            }
            prepStatement.executeBatch();
            Assert.assertTrue((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isArrayBindSupported());
            for (i = 0; i < 35000; ++i) {
                prepStatement.setInt(1, i);
                prepStatement.setString(2, "test" + i);
                prepStatement.addBatch();
            }
            prepStatement.executeBatch();
            Assert.assertTrue((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isArrayBindSupported());
        }
    }
}

