/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryStatement;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={TestCategoryStatement.class})
public class PreparedStatementLargeUpdateLatestIT
extends BaseJDBCTest {
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testLargeUpdate() throws Throwable {
        try (Connection con = PreparedStatementLargeUpdateLatestIT.getConnection();){
            long expectedUpdateRows = 0x80000009L;
            con.createStatement().execute("create or replace table  test_large_update(c1 boolean)");
            PreparedStatement st = con.prepareStatement("insert into test_large_update select true from table(generator(rowcount=>" + expectedUpdateRows + "))");
            PreparedStatement spyp = (PreparedStatement)Mockito.spy((Object)st);
            ((SnowflakePreparedStatementV1)Mockito.doReturn((Object)expectedUpdateRows).when((Object)((SnowflakePreparedStatementV1)spyp))).executeUpdateInternal((String)Mockito.any(String.class), (Map)Mockito.any(Map.class), ((Boolean)Mockito.any(Boolean.TYPE)).booleanValue(), (ExecTimeTelemetryData)Mockito.any(ExecTimeTelemetryData.class));
            long updatedRows = spyp.executeLargeUpdate();
            Assert.assertEquals((long)expectedUpdateRows, (long)updatedRows);
            con.createStatement().execute("drop table if exists test_large_update");
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testExecuteLargeBatchOverIntMax() throws SQLException {
        try (Connection connection = PreparedStatementLargeUpdateLatestIT.getConnection();){
            connection.createStatement().execute("create or replace table over_int_table (val string, id int)");
            PreparedStatement pstmt = connection.prepareStatement("UPDATE over_int_table SET ID=200");
            PreparedStatement spyp = (PreparedStatement)Mockito.spy((Object)pstmt);
            long numRows = 0x80000009L;
            ((SnowflakePreparedStatementV1)Mockito.doReturn((Object)numRows).when((Object)((SnowflakePreparedStatementV1)spyp))).executeUpdateInternal((String)Mockito.any(String.class), (Map)Mockito.any(Map.class), ((Boolean)Mockito.any(Boolean.TYPE)).booleanValue(), (ExecTimeTelemetryData)Mockito.any(ExecTimeTelemetryData.class));
            pstmt.addBatch();
            long[] queryResult = spyp.executeLargeBatch();
            Assert.assertEquals((long)1L, (long)queryResult.length);
            Assert.assertEquals((long)numRows, (long)queryResult[0]);
            connection.createStatement().execute("drop table if exists over_int_table");
        }
    }
}

