/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import net.snowflake.client.TestUtil;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={TestCategoryOthers.class})
public class PutFileWithSpaceIncludedIT
extends BaseJDBCTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    @Ignore
    public void putFileWithSpaceIncluded() throws Exception {
        TarArchiveEntry tarEntry;
        String AWS_SECRET_KEY = TestUtil.systemGetEnv("AWS_SECRET_ACCESS_KEY");
        String AWS_KEY_ID = TestUtil.systemGetEnv("AWS_ACCESS_KEY_ID");
        String SF_AWS_USER_BUCKET = TestUtil.systemGetEnv("SF_AWS_USER_BUCKET");
        if (SF_AWS_USER_BUCKET == null) {
            String userName = TestUtil.systemGetEnv("USERNAME");
            Assert.assertNotNull((Object)userName);
            SF_AWS_USER_BUCKET = "sfc-dev1-regression/" + userName + "/snow-13400";
        }
        Assert.assertNotNull((Object)AWS_SECRET_KEY);
        Assert.assertNotNull((Object)AWS_KEY_ID);
        File dataFolder = this.tmpFolder.newFolder();
        String tarFile = PutFileWithSpaceIncludedIT.getFullPathFileInResource("snow-13400.tar");
        FileInputStream fis = new FileInputStream(tarFile);
        TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)fis);
        while ((tarEntry = tis.getNextTarEntry()) != null) {
            File outputFile = new File(dataFolder, tarEntry.getName());
            FileOutputStream fos = new FileOutputStream(outputFile);
            IOUtils.copy((InputStream)tis, (OutputStream)fos);
            fos.close();
        }
        try (Connection con = PutFileWithSpaceIncludedIT.getConnection();){
            con.createStatement().execute("create or replace stage snow13400 url='s3://" + SF_AWS_USER_BUCKET + "/snow13400'credentials=(AWS_KEY_ID='" + AWS_KEY_ID + "' AWS_SECRET_KEY='" + AWS_SECRET_KEY + "')");
            ResultSet resultSet = con.createStatement().executeQuery("put file://" + dataFolder.getCanonicalPath() + "/* @snow13400 auto_compress=false");
            int cnt = 0;
            while (resultSet.next()) {
                ++cnt;
            }
            Assert.assertEquals((long)cnt, (long)1L);
            con.createStatement().execute("create or replace table snow13400(a string)");
            con.createStatement().execute("copy into snow13400 from @snow13400");
            resultSet = con.createStatement().executeQuery("select * from snow13400");
            cnt = 0;
            String output = null;
            while (resultSet.next()) {
                output = resultSet.getString(1);
                ++cnt;
            }
            Assert.assertEquals((long)cnt, (long)1L);
            Assert.assertEquals((Object)output, (Object)"hello");
            con.createStatement().execute("rm @snow13400");
            con.createStatement().execute("drop stage if exists snow13400");
            con.createStatement().execute("drop table if exists snow13400");
        }
    }
}

