/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.category.TestCategoryOthers;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public class PutUnescapeBackslashIT
extends AbstractDriverIT {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutFileUnescapeBackslashes() throws Exception {
        Path topDataDir;
        Writer writer;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block6: {
            String remoteSubDir = "testPut";
            String testDataFileName = "testdata.txt";
            connection = null;
            statement = null;
            resultSet = null;
            writer = null;
            topDataDir = null;
            try {
                topDataDir = Files.createTempDirectory("testPutFileUnescapeBackslashes", new FileAttribute[0]);
                topDataDir.toFile().deleteOnExit();
                Path subDir = Files.createDirectories(Paths.get(topDataDir.toString(), "test dir\\\\3"), new FileAttribute[0]);
                File dataFile = new File(subDir.toFile(), testDataFileName);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dataFile.getCanonicalPath()), "UTF-8"));
                writer.write("1,test1");
                writer.close();
                connection = PutUnescapeBackslashIT.getConnection();
                statement = connection.createStatement();
                String sql = String.format("PUT 'file://%s' @~/%s/", dataFile.getCanonicalPath(), remoteSubDir);
                sql = sql.replaceAll("\\\\", "\\\\\\\\");
                statement.execute(sql);
                resultSet = connection.createStatement().executeQuery(String.format("LS @~/%s/", remoteSubDir));
                while (resultSet.next()) {
                    MatcherAssert.assertThat((String)"File name doesn't match", (Object)resultSet.getString(1), (Matcher)CoreMatchers.startsWith((String)String.format("%s/%s", remoteSubDir, testDataFileName)));
                }
                if (connection == null) break block6;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    connection.createStatement().execute(String.format("RM @~/%s", remoteSubDir));
                }
                this.closeSQLObjects(resultSet, statement, connection);
                if (writer != null) {
                    writer.close();
                }
                FileUtils.deleteDirectory((File)topDataDir.toFile());
                throw throwable;
            }
            connection.createStatement().execute(String.format("RM @~/%s", remoteSubDir));
        }
        this.closeSQLObjects(resultSet, statement, connection);
        if (writer != null) {
            writer.close();
        }
        FileUtils.deleteDirectory((File)topDataDir.toFile());
    }
}

