/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.RestRequest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class RestRequestTest {
    static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 300000;

    private CloseableHttpResponse retryResponse() {
        StatusLine retryStatusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)retryStatusLine.getStatusCode()).thenReturn((Object)503);
        CloseableHttpResponse retryResponse = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)retryResponse.getStatusLine()).thenReturn((Object)retryStatusLine);
        return retryResponse;
    }

    private CloseableHttpResponse successResponse() {
        StatusLine successStatusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)successStatusLine.getStatusCode()).thenReturn((Object)200);
        CloseableHttpResponse successResponse = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)successResponse.getStatusLine()).thenReturn((Object)successStatusLine);
        return successResponse;
    }

    private CloseableHttpResponse socketTimeoutResponse() throws SocketTimeoutException {
        StatusLine successStatusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)successStatusLine.getStatusCode()).thenThrow(new Throwable[]{new SocketTimeoutException("Read timed out")});
        CloseableHttpResponse successResponse = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)successStatusLine.getStatusCode()).thenThrow(new Throwable[]{new SocketTimeoutException("Read timed out")});
        return successResponse;
    }

    private void execute(CloseableHttpClient client, String uri, int retryTimeout, int authTimeout, int socketTimeout, boolean includeRetryParameters, boolean noRetry) throws IOException, SnowflakeSQLException {
        this.execute(client, uri, retryTimeout, authTimeout, socketTimeout, includeRetryParameters, noRetry, 0);
    }

    private void execute(CloseableHttpClient client, String uri, int retryTimeout, int authTimeout, int socketTimeout, boolean includeRetryParameters, boolean noRetry, int maxRetries) throws IOException, SnowflakeSQLException {
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(300000);
        RequestConfig defaultRequestConfig = builder.build();
        HttpUtil util = new HttpUtil();
        HttpUtil.setRequestConfig((RequestConfig)defaultRequestConfig);
        RestRequest.execute((CloseableHttpClient)client, (HttpRequestBase)new HttpGet(uri), (long)retryTimeout, (long)authTimeout, (int)socketTimeout, (int)maxRetries, (int)0, (AtomicBoolean)new AtomicBoolean(false), (boolean)false, (boolean)includeRetryParameters, (boolean)true, (boolean)true, (boolean)noRetry, (ExecTimeTelemetryData)new ExecTimeTelemetryData());
    }

    @Test
    public void testRetryParamsInRequest() throws IOException, SnowflakeSQLException {
        CloseableHttpClient client = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        Mockito.when((Object)client.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenAnswer((Answer)new Answer<CloseableHttpResponse>(){
            int callCount = 0;

            public CloseableHttpResponse answer(InvocationOnMock invocation) throws Throwable {
                HttpUriRequest arg = (HttpUriRequest)invocation.getArguments()[0];
                String params = arg.getURI().getQuery();
                if (this.callCount == 0) {
                    Assert.assertFalse((boolean)params.contains("retryCount="));
                    Assert.assertFalse((boolean)params.contains("retryReason="));
                    Assert.assertFalse((boolean)params.contains("clientStartTime="));
                    Assert.assertTrue((boolean)params.contains("request_guid="));
                } else {
                    Assert.assertTrue((boolean)params.contains("retryCount=" + this.callCount));
                    Assert.assertTrue((boolean)params.contains("retryReason=503"));
                    Assert.assertTrue((boolean)params.contains("clientStartTime="));
                    Assert.assertTrue((boolean)params.contains("request_guid="));
                }
                ++this.callCount;
                if (this.callCount >= 3) {
                    return RestRequestTest.this.successResponse();
                }
                return RestRequestTest.this.retryResponse();
            }
        });
        this.execute(client, "fakeurl.com/?requestId=abcd-1234", 0, 0, 0, true, false);
    }

    @Test
    public void testRetryNoParamsInRequest() throws IOException, SnowflakeSQLException {
        CloseableHttpClient client = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        Mockito.when((Object)client.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenAnswer((Answer)new Answer<CloseableHttpResponse>(){
            int callCount = 0;

            public CloseableHttpResponse answer(InvocationOnMock invocation) throws Throwable {
                HttpUriRequest arg = (HttpUriRequest)invocation.getArguments()[0];
                String params = arg.getURI().getQuery();
                Assert.assertFalse((boolean)params.contains("retryCount="));
                Assert.assertFalse((boolean)params.contains("retryReason="));
                Assert.assertFalse((boolean)params.contains("clientStartTime="));
                Assert.assertTrue((boolean)params.contains("request_guid="));
                ++this.callCount;
                if (this.callCount >= 3) {
                    return RestRequestTest.this.successResponse();
                }
                return RestRequestTest.this.retryResponse();
            }
        });
        this.execute(client, "fakeurl.com/?requestId=abcd-1234", 0, 0, 0, false, false);
    }

    private CloseableHttpResponse anyStatusCodeResponse(int statusCode) {
        StatusLine successStatusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)successStatusLine.getStatusCode()).thenReturn((Object)statusCode);
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)successStatusLine);
        return response;
    }

    @Test
    public void testIsNonRetryableHTTPCode() throws Exception {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            public int statusCode;
            public boolean retryHTTP403;
            public boolean result;

            TestCase(int statusCode, boolean retryHTTP403, boolean result) {
                this.statusCode = statusCode;
                this.retryHTTP403 = retryHTTP403;
                this.result = result;
            }
        }
        testCases.add(new TestCase(100, false, true));
        testCases.add(new TestCase(101, false, true));
        testCases.add(new TestCase(103, false, true));
        testCases.add(new TestCase(200, false, true));
        testCases.add(new TestCase(201, false, true));
        testCases.add(new TestCase(202, false, true));
        testCases.add(new TestCase(203, false, true));
        testCases.add(new TestCase(204, false, true));
        testCases.add(new TestCase(205, false, true));
        testCases.add(new TestCase(206, false, true));
        testCases.add(new TestCase(300, false, true));
        testCases.add(new TestCase(301, false, true));
        testCases.add(new TestCase(302, false, true));
        testCases.add(new TestCase(303, false, true));
        testCases.add(new TestCase(304, false, true));
        testCases.add(new TestCase(307, false, true));
        testCases.add(new TestCase(308, false, true));
        testCases.add(new TestCase(400, false, true));
        testCases.add(new TestCase(401, false, true));
        testCases.add(new TestCase(403, false, true));
        testCases.add(new TestCase(404, false, true));
        testCases.add(new TestCase(405, false, true));
        testCases.add(new TestCase(406, false, true));
        testCases.add(new TestCase(407, false, true));
        testCases.add(new TestCase(408, false, false));
        testCases.add(new TestCase(410, false, true));
        testCases.add(new TestCase(411, false, true));
        testCases.add(new TestCase(412, false, true));
        testCases.add(new TestCase(413, false, true));
        testCases.add(new TestCase(414, false, true));
        testCases.add(new TestCase(415, false, true));
        testCases.add(new TestCase(416, false, true));
        testCases.add(new TestCase(417, false, true));
        testCases.add(new TestCase(418, false, true));
        testCases.add(new TestCase(425, false, true));
        testCases.add(new TestCase(426, false, true));
        testCases.add(new TestCase(428, false, true));
        testCases.add(new TestCase(429, false, false));
        testCases.add(new TestCase(431, false, true));
        testCases.add(new TestCase(451, false, true));
        testCases.add(new TestCase(500, false, false));
        testCases.add(new TestCase(501, false, false));
        testCases.add(new TestCase(502, false, false));
        testCases.add(new TestCase(503, false, false));
        testCases.add(new TestCase(504, false, false));
        testCases.add(new TestCase(505, false, false));
        testCases.add(new TestCase(506, false, false));
        testCases.add(new TestCase(507, false, false));
        testCases.add(new TestCase(508, false, false));
        testCases.add(new TestCase(509, false, false));
        testCases.add(new TestCase(510, false, false));
        testCases.add(new TestCase(511, false, false));
        testCases.add(new TestCase(100, true, true));
        testCases.add(new TestCase(101, true, true));
        testCases.add(new TestCase(103, true, true));
        testCases.add(new TestCase(200, true, true));
        testCases.add(new TestCase(201, true, true));
        testCases.add(new TestCase(202, true, true));
        testCases.add(new TestCase(203, true, true));
        testCases.add(new TestCase(204, true, true));
        testCases.add(new TestCase(205, true, true));
        testCases.add(new TestCase(206, true, true));
        testCases.add(new TestCase(300, true, true));
        testCases.add(new TestCase(301, true, true));
        testCases.add(new TestCase(302, true, true));
        testCases.add(new TestCase(303, true, true));
        testCases.add(new TestCase(304, true, true));
        testCases.add(new TestCase(307, true, true));
        testCases.add(new TestCase(308, true, true));
        testCases.add(new TestCase(400, true, true));
        testCases.add(new TestCase(401, true, true));
        testCases.add(new TestCase(403, true, false));
        testCases.add(new TestCase(404, true, true));
        testCases.add(new TestCase(405, true, true));
        testCases.add(new TestCase(406, true, true));
        testCases.add(new TestCase(407, true, true));
        testCases.add(new TestCase(408, true, false));
        testCases.add(new TestCase(410, true, true));
        testCases.add(new TestCase(411, true, true));
        testCases.add(new TestCase(412, true, true));
        testCases.add(new TestCase(413, true, true));
        testCases.add(new TestCase(414, true, true));
        testCases.add(new TestCase(415, true, true));
        testCases.add(new TestCase(416, true, true));
        testCases.add(new TestCase(417, true, true));
        testCases.add(new TestCase(418, true, true));
        testCases.add(new TestCase(425, true, true));
        testCases.add(new TestCase(426, true, true));
        testCases.add(new TestCase(428, true, true));
        testCases.add(new TestCase(429, true, false));
        testCases.add(new TestCase(431, true, true));
        testCases.add(new TestCase(451, true, true));
        testCases.add(new TestCase(500, true, false));
        testCases.add(new TestCase(501, true, false));
        testCases.add(new TestCase(502, true, false));
        testCases.add(new TestCase(503, true, false));
        testCases.add(new TestCase(504, true, false));
        testCases.add(new TestCase(505, true, false));
        testCases.add(new TestCase(506, true, false));
        testCases.add(new TestCase(507, true, false));
        testCases.add(new TestCase(508, true, false));
        testCases.add(new TestCase(509, true, false));
        testCases.add(new TestCase(510, true, false));
        testCases.add(new TestCase(511, true, false));
        for (TestCase t : testCases) {
            if (t.result) {
                Assert.assertTrue((String)String.format("Result must be true but false: HTTP Code: %d, RetryHTTP403: %s", t.statusCode, t.retryHTTP403), (boolean)RestRequest.isNonRetryableHTTPCode((CloseableHttpResponse)this.anyStatusCodeResponse(t.statusCode), (boolean)t.retryHTTP403));
                continue;
            }
            Assert.assertFalse((String)String.format("Result must be false but true: HTTP Code: %d, RetryHTTP403: %s", t.statusCode, t.retryHTTP403), (boolean)RestRequest.isNonRetryableHTTPCode((CloseableHttpResponse)this.anyStatusCodeResponse(t.statusCode), (boolean)t.retryHTTP403));
        }
    }

    @Test
    public void testExceptionAuthBasedTimeout() throws IOException {
        CloseableHttpClient client = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        Mockito.when((Object)client.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenAnswer(invocation -> this.retryResponse());
        try {
            this.execute(client, "login-request.com/?requestId=abcd-1234", 2, 1, 30000, true, false);
        }
        catch (SnowflakeSQLException ex) {
            MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.AUTHENTICATOR_REQUEST_TIMEOUT.getMessageCode()));
        }
    }

    @Test
    public void testNoRetry() throws IOException, SnowflakeSQLException {
        boolean telemetryEnabled = TelemetryService.getInstance().isEnabled();
        try {
            TelemetryService.disable();
            CloseableHttpClient client = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
            Mockito.when((Object)client.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenAnswer((Answer)new Answer<CloseableHttpResponse>(){
                int callCount = 0;

                public CloseableHttpResponse answer(InvocationOnMock invocation) throws Throwable {
                    ++this.callCount;
                    if (this.callCount <= 1) {
                        return RestRequestTest.this.retryResponse();
                    }
                    Assert.fail((String)"No retry should happen when noRetry = true");
                    return RestRequestTest.this.successResponse();
                }
            });
            this.execute(client, "fakeurl.com/?requestId=abcd-1234", 0, 0, 0, true, true);
        }
        finally {
            if (telemetryEnabled) {
                TelemetryService.enable();
            } else {
                TelemetryService.disable();
            }
        }
    }

    @Test
    public void testRetryParametersWithSocketTimeout() throws IOException, SnowflakeSQLException {
        CloseableHttpClient client = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        Mockito.when((Object)client.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenAnswer((Answer)new Answer<CloseableHttpResponse>(){
            int callCount = 0;

            public CloseableHttpResponse answer(InvocationOnMock invocation) throws Throwable {
                HttpUriRequest arg = (HttpUriRequest)invocation.getArguments()[0];
                String params = arg.getURI().getQuery();
                if (this.callCount == 0) {
                    Assert.assertFalse((boolean)params.contains("retryCount="));
                    Assert.assertFalse((boolean)params.contains("retryReason="));
                    Assert.assertFalse((boolean)params.contains("clientStartTime="));
                    Assert.assertTrue((boolean)params.contains("request_guid="));
                } else {
                    Assert.assertTrue((boolean)params.contains("retryCount=" + this.callCount));
                    Assert.assertTrue((boolean)params.contains("retryReason=0"));
                    Assert.assertTrue((boolean)params.contains("clientStartTime="));
                    Assert.assertTrue((boolean)params.contains("request_guid="));
                }
                ++this.callCount;
                if (this.callCount >= 2) {
                    return RestRequestTest.this.successResponse();
                }
                return RestRequestTest.this.socketTimeoutResponse();
            }
        });
        this.execute(client, "fakeurl.com/?requestId=abcd-1234", 0, 0, 0, true, false);
    }

    @Test(expected=SnowflakeSQLException.class)
    public void testMaxRetriesExceeded() throws IOException, SnowflakeSQLException {
        boolean telemetryEnabled = TelemetryService.getInstance().isEnabled();
        CloseableHttpClient client = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        Mockito.when((Object)client.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenAnswer((Answer)new Answer<CloseableHttpResponse>(){
            int callCount = 0;

            public CloseableHttpResponse answer(InvocationOnMock invocation) throws Throwable {
                ++this.callCount;
                if (this.callCount >= 4) {
                    return RestRequestTest.this.successResponse();
                }
                return RestRequestTest.this.socketTimeoutResponse();
            }
        });
        try {
            TelemetryService.disable();
            this.execute(client, "fakeurl.com/?requestId=abcd-1234", 0, 0, 0, true, false, 1);
            Assert.fail((String)"testMaxRetries");
        }
        finally {
            if (telemetryEnabled) {
                TelemetryService.enable();
            } else {
                TelemetryService.disable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxRetriesWithSuccessfulResponse() throws IOException {
        boolean telemetryEnabled = TelemetryService.getInstance().isEnabled();
        CloseableHttpClient client = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        Mockito.when((Object)client.execute((HttpUriRequest)Mockito.any(HttpUriRequest.class))).thenAnswer((Answer)new Answer<CloseableHttpResponse>(){
            int callCount = 0;

            public CloseableHttpResponse answer(InvocationOnMock invocation) throws Throwable {
                ++this.callCount;
                if (this.callCount >= 3) {
                    return RestRequestTest.this.successResponse();
                }
                return RestRequestTest.this.socketTimeoutResponse();
            }
        });
        try {
            TelemetryService.disable();
            this.execute(client, "fakeurl.com/?requestId=abcd-1234", 0, 0, 0, true, false, 4);
        }
        catch (SnowflakeSQLException e) {
            Assert.fail((String)"testMaxRetriesWithSuccessfulResponse");
        }
        finally {
            if (telemetryEnabled) {
                TelemetryService.enable();
            } else {
                TelemetryService.disable();
            }
        }
    }
}

