/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.jdbc.JsonResultChunk;
import net.snowflake.client.jdbc.ResultJsonParserV2;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.apache.commons.text.StringEscapeUtils;
import org.junit.Assert;
import org.junit.Test;

public class ResultJsonParserV2Test {
    @Test
    public void simpleTest() throws SnowflakeSQLException {
        SFBaseSession session = null;
        String simple = "[\"1\", \"1.01\"],[null, null],[\"2\", \"0.13\"],[\"\", \"\"],[\"\\\"escape\\\"\", \"\\\"escape\\\"\"],[\"\\u2605\", \"\\u263A\\u263A\"],[\"\\ud841\\udf0e\", \"\\ud841\\udf31\\ud841\\udf79\"],[\"{\\\"date\\\" : \\\"2017-04-28\\\",\\\"dealership\\\" : \\\"Tindel Toyota\\\"}\", \"[1,2,3,4,5]\"]";
        byte[] data = simple.getBytes(StandardCharsets.UTF_8);
        JsonResultChunk chunk = new JsonResultChunk("", 8, 2, data.length, session);
        ResultJsonParserV2 jp = new ResultJsonParserV2();
        jp.startParsing(chunk, session);
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        jp.continueParsing(byteBuffer, session);
        byte[] remaining = new byte[byteBuffer.remaining()];
        byteBuffer.get(remaining);
        jp.endParsing(ByteBuffer.wrap(remaining), session);
        Assert.assertEquals((Object)"1", (Object)chunk.getCell(0, 0).toString());
        Assert.assertEquals((Object)"1.01", (Object)chunk.getCell(0, 1).toString());
        Assert.assertNull((Object)chunk.getCell(1, 0));
        Assert.assertNull((Object)chunk.getCell(1, 1));
        Assert.assertEquals((Object)"2", (Object)chunk.getCell(2, 0).toString());
        Assert.assertEquals((Object)"0.13", (Object)chunk.getCell(2, 1).toString());
        Assert.assertEquals((Object)"", (Object)chunk.getCell(3, 0).toString());
        Assert.assertEquals((Object)"", (Object)chunk.getCell(3, 1).toString());
        Assert.assertEquals((Object)"\"escape\"", (Object)chunk.getCell(4, 0).toString());
        Assert.assertEquals((Object)"\"escape\"", (Object)chunk.getCell(4, 1).toString());
        Assert.assertEquals((Object)"\u2605", (Object)chunk.getCell(5, 0).toString());
        Assert.assertEquals((Object)"\u263a\u263a", (Object)chunk.getCell(5, 1).toString());
        Assert.assertEquals((Object)"\ud841\udf0e", (Object)chunk.getCell(6, 0).toString());
        Assert.assertEquals((Object)"\ud841\udf31\ud841\udf79", (Object)chunk.getCell(6, 1).toString());
        Assert.assertEquals((Object)"{\"date\" : \"2017-04-28\",\"dealership\" : \"Tindel Toyota\"}", (Object)chunk.getCell(7, 0).toString());
        Assert.assertEquals((Object)"[1,2,3,4,5]", (Object)chunk.getCell(7, 1).toString());
    }

    @Test
    public void simpleStreamingTest() throws SnowflakeSQLException {
        SFBaseSession session = null;
        String simple = "[\"1\", \"1.01\"],[null, null],[\"2\", \"0.13\"],[\"\", \"\"],[\"\\\"escape\\\"\", \"\\\"escape\\\"\"],[\"\u263a\u263a\", \"\u263a\u263a\u263a\"], [\"\\ud841\\udf0e\", \"\\ud841\\udf31\\ud841\\udf79\"],[\"{\\\"date\\\" : \\\"2017-04-28\\\",\\\"dealership\\\" : \\\"Tindel Toyota\\\"}\", \"[1,2,3,4,5]\"]";
        byte[] data = simple.getBytes(StandardCharsets.UTF_8);
        JsonResultChunk chunk = new JsonResultChunk("", 8, 2, data.length, session);
        ResultJsonParserV2 jp = new ResultJsonParserV2();
        jp.startParsing(chunk, session);
        int len = 15;
        Buffer byteBuffer = null;
        for (int i = 0; i < data.length; i += len) {
            if (i + len < data.length) {
                byteBuffer = ByteBuffer.wrap(data, i, len);
                jp.continueParsing((ByteBuffer)byteBuffer, session);
                continue;
            }
            byteBuffer = ByteBuffer.wrap(data, i, data.length - i);
            jp.continueParsing((ByteBuffer)byteBuffer, session);
        }
        byte[] remaining = new byte[byteBuffer.remaining()];
        ((ByteBuffer)byteBuffer).get(remaining);
        jp.endParsing(ByteBuffer.wrap(remaining), session);
        Assert.assertEquals((Object)"1", (Object)chunk.getCell(0, 0).toString());
        Assert.assertEquals((Object)"1.01", (Object)chunk.getCell(0, 1).toString());
        Assert.assertNull((Object)chunk.getCell(1, 0));
        Assert.assertNull((Object)chunk.getCell(1, 1));
        Assert.assertEquals((Object)"2", (Object)chunk.getCell(2, 0).toString());
        Assert.assertEquals((Object)"0.13", (Object)chunk.getCell(2, 1).toString());
        Assert.assertEquals((Object)"", (Object)chunk.getCell(3, 0).toString());
        Assert.assertEquals((Object)"", (Object)chunk.getCell(3, 1).toString());
        Assert.assertEquals((Object)"\"escape\"", (Object)chunk.getCell(4, 0).toString());
        Assert.assertEquals((Object)"\"escape\"", (Object)chunk.getCell(4, 1).toString());
        Assert.assertEquals((Object)"\u263a\u263a", (Object)chunk.getCell(5, 0).toString());
        Assert.assertEquals((Object)"\u263a\u263a\u263a", (Object)chunk.getCell(5, 1).toString());
        Assert.assertEquals((Object)"\ud841\udf0e", (Object)chunk.getCell(6, 0).toString());
        Assert.assertEquals((Object)"\ud841\udf31\ud841\udf79", (Object)chunk.getCell(6, 1).toString());
        Assert.assertEquals((Object)"{\"date\" : \"2017-04-28\",\"dealership\" : \"Tindel Toyota\"}", (Object)chunk.getCell(7, 0).toString());
        Assert.assertEquals((Object)"[1,2,3,4,5]", (Object)chunk.getCell(7, 1).toString());
    }

    @Test
    public void LargestColumnTest() throws SnowflakeSQLException {
        SFBaseSession session = null;
        StringBuilder sb = new StringBuilder();
        StringBuilder a = new StringBuilder();
        for (int i = 0; i < 0x1000000; ++i) {
            a.append("a");
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 0x1000000; ++i) {
            b.append("b");
        }
        StringBuilder c = new StringBuilder();
        for (int i = 0; i < 0x1000000; ++i) {
            c.append("c");
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < 0xFFFFFB; i += 6) {
            s.append("\\u263A");
        }
        sb.append("[\"").append((CharSequence)a).append("\",\"").append((CharSequence)b).append("\"],[\"").append((CharSequence)c).append("\",\"").append((CharSequence)s).append("\"]");
        byte[] data = sb.toString().getBytes(StandardCharsets.UTF_8);
        JsonResultChunk chunk = new JsonResultChunk("", 2, 2, data.length, session);
        ResultJsonParserV2 jp = new ResultJsonParserV2();
        jp.startParsing(chunk, session);
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        jp.continueParsing(byteBuffer, session);
        byte[] remaining = new byte[byteBuffer.remaining()];
        byteBuffer.get(remaining);
        jp.endParsing(ByteBuffer.wrap(remaining), session);
        Assert.assertEquals((Object)a.toString(), (Object)chunk.getCell(0, 0).toString());
        Assert.assertEquals((Object)b.toString(), (Object)chunk.getCell(0, 1).toString());
        Assert.assertEquals((Object)c.toString(), (Object)chunk.getCell(1, 0).toString());
        Assert.assertEquals((Object)StringEscapeUtils.unescapeJava((String)s.toString()), (Object)chunk.getCell(1, 1).toString());
    }

    @Test
    public void testAsciiSequential() throws SnowflakeSQLException {
        SFBaseSession session = null;
        String ascii = "[\"\\u0000\\u0000\\u0000\"]";
        byte[] data = ascii.getBytes(StandardCharsets.UTF_8);
        JsonResultChunk chunk = new JsonResultChunk("", 1, 1, data.length, session);
        ResultJsonParserV2 jp = new ResultJsonParserV2();
        jp.startParsing(chunk, session);
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, 0, 14);
        jp.continueParsing(byteBuffer, session);
        byteBuffer = ByteBuffer.wrap(data, 9, 13);
        jp.continueParsing(byteBuffer, session);
        byteBuffer = ByteBuffer.wrap(data, 15, 7);
        jp.continueParsing(byteBuffer, session);
        byte[] remaining = new byte[byteBuffer.remaining()];
        byteBuffer.get(remaining);
        jp.endParsing(ByteBuffer.wrap(remaining), session);
        Assert.assertEquals((Object)"00 00 00 ", (Object)ResultJsonParserV2Test.stringToHex(chunk.getCell(0, 0).toString()));
    }

    @Test
    public void testAsciiCharacter() throws SnowflakeSQLException {
        SFBaseSession session = null;
        String ascii = "[\"\\u0003\u00e4\\u0000\"]";
        byte[] data = ascii.getBytes(StandardCharsets.UTF_8);
        JsonResultChunk chunk = new JsonResultChunk("", 1, 1, data.length, session);
        ResultJsonParserV2 jp = new ResultJsonParserV2();
        jp.startParsing(chunk, session);
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, 0, data.length);
        jp.continueParsing(byteBuffer, session);
        int position = byteBuffer.position();
        byteBuffer = ByteBuffer.wrap(data, position, data.length - position);
        jp.continueParsing(byteBuffer, session);
        byte[] remaining = new byte[byteBuffer.remaining()];
        byteBuffer.get(remaining);
        jp.endParsing(ByteBuffer.wrap(remaining), session);
        Assert.assertEquals((Object)"03 C3 A4 00 ", (Object)ResultJsonParserV2Test.stringToHex(chunk.getCell(0, 0).toString()));
    }

    public static String stringToHex(String input) {
        byte[] byteArray = input.getBytes(StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        char[] hexBytes = new char[2];
        for (int i = 0; i < byteArray.length; ++i) {
            hexBytes[0] = Character.forDigit(byteArray[i] >> 4 & 0xF, 16);
            hexBytes[1] = Character.forDigit(byteArray[i] & 0xF, 16);
            sb.append(hexBytes);
            sb.append(" ");
        }
        return sb.toString().toUpperCase();
    }
}

