/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.After;
import org.junit.Before;

abstract class ResultSetArrowForce0MultiTimeZone
extends BaseJDBCTest {
    protected final String queryResultFormat;
    protected final String tz;
    private TimeZone origTz;

    static List<Object[]> testData() {
        String[] timeZones = new String[]{"UTC", "America/New_York", "MEZ"};
        String[] queryFormats = new String[]{"json", "arrow"};
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (String queryFormat : queryFormats) {
            for (String timeZone : timeZones) {
                ret.add(new Object[]{queryFormat, timeZone});
            }
        }
        return ret;
    }

    ResultSetArrowForce0MultiTimeZone(String queryResultFormat, String timeZone) {
        this.queryResultFormat = queryResultFormat;
        this.tz = timeZone;
    }

    @Before
    public void setUp() {
        this.origTz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone(this.tz));
    }

    @After
    public void tearDown() {
        TimeZone.setDefault(this.origTz);
    }

    Connection init(String table, String column, String values) throws SQLException {
        Connection con = BaseJDBCTest.getConnection();
        try (Statement statement = con.createStatement();){
            statement.execute("alter session set TIMEZONE='America/Los_Angeles',TIMESTAMP_TYPE_MAPPING='TIMESTAMP_LTZ',TIMESTAMP_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_TZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_LTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_NTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM'");
        }
        con.createStatement().execute("alter session set jdbc_query_result_format = '" + this.queryResultFormat + "'");
        con.createStatement().execute("create or replace table " + table + " " + column);
        con.createStatement().execute("insert into " + table + " values " + values);
        return con;
    }

    protected void finish(String table, Connection con) throws SQLException {
        con.createStatement().execute("drop table " + table);
        con.close();
        System.clearProperty("user.timezone");
    }
}

