/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.TimeZone;
import net.snowflake.client.category.TestCategoryArrow;
import net.snowflake.client.jdbc.ResultSetArrowForce0MultiTimeZone;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={TestCategoryArrow.class})
public class ResultSetArrowForceLTZMultiTimeZoneIT
extends ResultSetArrowForce0MultiTimeZone {
    @Parameterized.Parameters(name="format={0}, tz={1}")
    public static Collection<Object[]> data() {
        return ResultSetArrowForce0MultiTimeZone.testData();
    }

    public ResultSetArrowForceLTZMultiTimeZoneIT(String queryResultFormat, String timeZone) {
        super(queryResultFormat, timeZone);
    }

    @Test
    public void testTimestampLTZ() throws SQLException {
        for (int scale = 0; scale <= 9; ++scale) {
            this.testTimestampLTZWithScale(scale);
        }
    }

    private void testTimestampLTZWithScale(int scale) throws SQLException {
        Object[] cases = new String[]{"2017-01-01 12:00:00 Z", "2014-01-02 16:00:00 Z", "2014-01-02 12:34:56 Z", "1970-01-01 00:00:00 Z", "1970-01-01 00:00:01 Z", "1969-12-31 11:59:59 Z", "0000-01-01 00:00:01 Z", "0001-12-31 11:59:59 Z"};
        long[] times = new long[]{1483272000000L, 1388678400000L, 1388666096000L, 0L, 1000L, -43201000L, -62167391999000L, -62104276801000L};
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getDefault());
        String table = "test_arrow_ts_ltz";
        String column = "(a timestamp_ltz(" + scale + "))";
        String values = "('" + StringUtils.join((Object[])cases, (String)"'),('") + "'), (null)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from " + table);
        int i = 0;
        while (i < cases.length) {
            rs.next();
            Assert.assertEquals((long)times[i++], (long)rs.getTimestamp(1).getTime());
            Assert.assertEquals((long)0L, (long)rs.getTimestamp(1).getNanos());
        }
        rs.next();
        Assert.assertNull((Object)rs.getString(1));
        this.finish(table, con);
    }

    @Test
    public void testTimestampLTZOutputFormat() throws SQLException {
        String weekday;
        int i;
        Object[] cases = new String[]{"2017-01-01 12:00:00 Z", "2014-01-02 16:00:00 Z", "2014-01-02 12:34:56 Z"};
        long[] times = new long[]{1483272000000L, 1388678400000L, 1388666096000L};
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getDefault());
        String table = "test_arrow_ts_ltz";
        String column = "(a timestamp_ltz)";
        String values = "('" + StringUtils.join((Object[])cases, (String)"'),('") + "')";
        Connection con = this.init(table, column, values);
        Statement statement = con.createStatement();
        ResultSet rs = statement.executeQuery("select * from " + table);
        for (i = 0; i < cases.length; ++i) {
            rs.next();
            Assert.assertEquals((long)times[i], (long)rs.getTimestamp(1).getTime());
            weekday = rs.getString(1).split(",")[0];
            Assert.assertEquals((long)3L, (long)weekday.length());
        }
        statement.execute("alter session set TIMESTAMP_LTZ_OUTPUT_FORMAT='YYYY-MM-DD HH24:MI:SS TZH:TZM'");
        rs = statement.executeQuery("select * from " + table);
        for (i = 0; i < cases.length; ++i) {
            rs.next();
            Assert.assertEquals((long)times[i], (long)rs.getTimestamp(1).getTime());
            String year = rs.getString(1).split("-")[0];
            Assert.assertEquals((long)4L, (long)year.length());
        }
        statement.execute("alter session unset TIMESTAMP_LTZ_OUTPUT_FORMAT");
        rs = statement.executeQuery("select * from " + table);
        for (i = 0; i < cases.length; ++i) {
            rs.next();
            Assert.assertEquals((long)times[i], (long)rs.getTimestamp(1).getTime());
            weekday = rs.getString(1).split(",")[0];
            Assert.assertEquals((long)3L, (long)weekday.length());
        }
        statement.execute("alter session set TIMESTAMP_LTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM'");
        rs = statement.executeQuery("select * from " + table);
        for (i = 0; i < cases.length; ++i) {
            rs.next();
            Assert.assertEquals((long)times[i], (long)rs.getTimestamp(1).getTime());
            weekday = rs.getString(1).split(",")[0];
            Assert.assertEquals((long)3L, (long)weekday.length());
        }
        this.finish(table, con);
    }

    @Test
    public void testTimestampLTZWithNulls() throws SQLException {
        Object[] cases = new String[]{"2017-01-01 12:00:00 Z", "2014-01-02 16:00:00 Z", "2014-01-02 12:34:56 Z", "1970-01-01 00:00:00 Z", "1970-01-01 00:00:01 Z", "1969-12-31 11:59:59 Z", "0000-01-01 00:00:01 Z", "0001-12-31 11:59:59 Z"};
        long[] times = new long[]{1483272000000L, 1388678400000L, 1388666096000L, 0L, 1000L, -43201000L, -62167391999000L, -62104276801000L};
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getDefault());
        String table = "test_arrow_ts_ltz";
        String column = "(a timestamp_ltz)";
        String values = "('" + StringUtils.join((Object[])cases, (String)"'), (null),('") + "')";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from " + table);
        for (int i = 0; i < 2 * cases.length - 1; ++i) {
            rs.next();
            if (i % 2 != 0) {
                Assert.assertNull((Object)rs.getTimestamp(1));
                continue;
            }
            Assert.assertEquals((long)times[i / 2], (long)rs.getTimestamp(1).getTime());
            Assert.assertEquals((long)0L, (long)rs.getTimestamp(1).getNanos());
        }
        this.finish(table, con);
    }

    @Test
    public void testTimestampLTZWithNanos() throws SQLException {
        Object[] cases = new String[]{"2017-01-01 12:00:00.123456789", "2014-01-02 16:00:00.000000001", "2014-01-02 12:34:56.1", "1969-12-31 23:59:59.000000001", "1970-01-01 00:00:00.123412423", "1970-01-01 00:00:01.000001", "1969-12-31 11:59:59.001", "0001-12-31 11:59:59.11"};
        long[] times = new long[]{1483272000123L, 1388678400000L, 1388666096100L, -1000L, 123L, 1000L, -43200999L, -62104276800890L};
        int[] nanos = new int[]{123456789, 1, 100000000, 1, 123412423, 1000, 1000000, 110000000};
        String table = "test_arrow_ts_ltz";
        String column = "(a timestamp_ltz)";
        String values = "('" + StringUtils.join((Object[])cases, (String)" Z'),('") + " Z'), (null)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from " + table);
        int i = 0;
        while (i < cases.length) {
            rs.next();
            Assert.assertEquals((long)times[i], (long)rs.getTimestamp(1).getTime());
            Assert.assertEquals((long)nanos[i++], (long)rs.getTimestamp(1).getNanos());
        }
        rs.next();
        Assert.assertNull((Object)rs.getString(1));
        this.finish(table, con);
    }
}

