/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.snowflake.client.category.TestCategoryResultSet;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.jdbc.SnowflakeStatement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryResultSet.class})
public class ResultSetAsyncIT
extends BaseJDBCTest {
    @Test
    public void testAsyncResultSetFunctionsWithNewSession() throws SQLException {
        Connection connection = ResultSetAsyncIT.getConnection();
        Map<String, String> params = ResultSetAsyncIT.getConnectionParameters();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_rsmd(colA number(20, 5), colB string)");
        statement.execute("insert into test_rsmd values(1.00, 'str'),(2.00, 'str2')");
        String createTableSql = "select * from test_rsmd";
        ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(createTableSql);
        String queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
        statement.execute("drop table if exists test_rsmd");
        rs.close();
        statement.close();
        connection.close();
        connection = ResultSetAsyncIT.getConnection();
        ResultSet resultSet = connection.unwrap(SnowflakeConnection.class).createResultSet(queryID);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((Object)"", (Object)resultSetMetaData.getCatalogName(1).toUpperCase());
        Assert.assertEquals((Object)"", (Object)resultSetMetaData.getSchemaName(1).toUpperCase());
        Assert.assertEquals((Object)"", (Object)resultSetMetaData.getTableName(1));
        Assert.assertEquals((Object)String.class.getName(), (Object)resultSetMetaData.getColumnClassName(2));
        Assert.assertEquals((long)2L, (long)resultSetMetaData.getColumnCount());
        Assert.assertEquals((long)22L, (long)resultSetMetaData.getColumnDisplaySize(1));
        Assert.assertEquals((Object)"COLA", (Object)resultSetMetaData.getColumnLabel(1));
        Assert.assertEquals((Object)"COLA", (Object)resultSetMetaData.getColumnName(1));
        Assert.assertEquals((long)3L, (long)resultSetMetaData.getColumnType(1));
        Assert.assertEquals((Object)"NUMBER", (Object)resultSetMetaData.getColumnTypeName(1));
        Assert.assertEquals((long)20L, (long)resultSetMetaData.getPrecision(1));
        Assert.assertEquals((long)5L, (long)resultSetMetaData.getScale(1));
        Assert.assertFalse((boolean)resultSetMetaData.isAutoIncrement(1));
        Assert.assertFalse((boolean)resultSetMetaData.isCaseSensitive(1));
        Assert.assertFalse((boolean)resultSetMetaData.isCurrency(1));
        Assert.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(1));
        Assert.assertEquals((long)1L, (long)resultSetMetaData.isNullable(1));
        Assert.assertTrue((boolean)resultSetMetaData.isReadOnly(1));
        Assert.assertTrue((boolean)resultSetMetaData.isSearchable(1));
        Assert.assertTrue((boolean)resultSetMetaData.isSigned(1));
        SnowflakeResultSetMetaData secretMetaData = resultSetMetaData.unwrap(SnowflakeResultSetMetaData.class);
        List colNames = secretMetaData.getColumnNames();
        Assert.assertEquals((Object)"COLA", colNames.get(0));
        Assert.assertEquals((Object)"COLB", colNames.get(1));
        Assert.assertEquals((long)3L, (long)secretMetaData.getInternalColumnType(1));
        Assert.assertEquals((long)12L, (long)secretMetaData.getInternalColumnType(2));
        Assert.assertTrue((boolean)Pattern.matches("[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}", secretMetaData.getQueryID()));
        Assert.assertEquals((Object)secretMetaData.getQueryID(), (Object)resultSet.unwrap(SnowflakeResultSet.class).getQueryID());
        resultSet.close();
        statement.close();
        connection.close();
    }

    @Test
    public void testResultSetMetadata() throws SQLException {
        Connection connection = ResultSetAsyncIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_rsmd(colA number(20, 5), colB string)");
        statement.execute("insert into test_rsmd values(1.00, 'str'),(2.00, 'str2')");
        ResultSet resultSet = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from test_rsmd");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((Object)"", (Object)resultSetMetaData.getCatalogName(1).toUpperCase());
        Assert.assertEquals((Object)"", (Object)resultSetMetaData.getSchemaName(1).toUpperCase());
        Assert.assertEquals((Object)"", (Object)resultSetMetaData.getTableName(1));
        Assert.assertEquals((Object)String.class.getName(), (Object)resultSetMetaData.getColumnClassName(2));
        Assert.assertEquals((long)2L, (long)resultSetMetaData.getColumnCount());
        Assert.assertEquals((long)22L, (long)resultSetMetaData.getColumnDisplaySize(1));
        Assert.assertEquals((Object)"COLA", (Object)resultSetMetaData.getColumnLabel(1));
        Assert.assertEquals((Object)"COLA", (Object)resultSetMetaData.getColumnName(1));
        Assert.assertEquals((long)3L, (long)resultSetMetaData.getColumnType(1));
        Assert.assertEquals((Object)"NUMBER", (Object)resultSetMetaData.getColumnTypeName(1));
        Assert.assertEquals((long)20L, (long)resultSetMetaData.getPrecision(1));
        Assert.assertEquals((long)5L, (long)resultSetMetaData.getScale(1));
        Assert.assertFalse((boolean)resultSetMetaData.isAutoIncrement(1));
        Assert.assertFalse((boolean)resultSetMetaData.isCaseSensitive(1));
        Assert.assertFalse((boolean)resultSetMetaData.isCurrency(1));
        Assert.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(1));
        Assert.assertEquals((long)1L, (long)resultSetMetaData.isNullable(1));
        Assert.assertTrue((boolean)resultSetMetaData.isReadOnly(1));
        Assert.assertTrue((boolean)resultSetMetaData.isSearchable(1));
        Assert.assertTrue((boolean)resultSetMetaData.isSigned(1));
        SnowflakeResultSetMetaData secretMetaData = resultSetMetaData.unwrap(SnowflakeResultSetMetaData.class);
        List colNames = secretMetaData.getColumnNames();
        Assert.assertEquals((Object)"COLA", colNames.get(0));
        Assert.assertEquals((Object)"COLB", colNames.get(1));
        Assert.assertEquals((long)3L, (long)secretMetaData.getInternalColumnType(1));
        Assert.assertEquals((long)12L, (long)secretMetaData.getInternalColumnType(2));
        Assert.assertTrue((boolean)Pattern.matches("[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}", secretMetaData.getQueryID()));
        Assert.assertEquals((Object)secretMetaData.getQueryID(), (Object)resultSet.unwrap(SnowflakeResultSet.class).getQueryID());
        statement.execute("drop table if exists test_rsmd");
        statement.close();
        connection.close();
    }

    @Test
    public void testOrderAndClosureFunctions() throws SQLException {
        Connection connection = ResultSetAsyncIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_rsmd(colA number(20, 5), colB string)");
        statement.execute("insert into test_rsmd values(1.00, 'str'),(2.00, 'str2')");
        ResultSet resultSet = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from test_rsmd");
        Assert.assertTrue((String)"should be before the first", (boolean)resultSet.isBeforeFirst());
        Assert.assertFalse((String)"should not be the first", (boolean)resultSet.isFirst());
        resultSet.next();
        Assert.assertFalse((String)"should not be before the first", (boolean)resultSet.isBeforeFirst());
        Assert.assertTrue((String)"should be the first", (boolean)resultSet.isFirst());
        String queryID = resultSet.unwrap(SnowflakeResultSet.class).getQueryID();
        Assert.assertFalse((boolean)resultSet.isClosed());
        resultSet.close();
        Assert.assertTrue((boolean)resultSet.isClosed());
        statement.execute("drop table if exists test_rsmd");
        statement.close();
        connection.close();
        connection = ResultSetAsyncIT.getConnection();
        resultSet = connection.unwrap(SnowflakeConnection.class).createResultSet(queryID);
        Assert.assertFalse((boolean)resultSet.isClosed());
        resultSet.next();
        resultSet.next();
        Assert.assertTrue((boolean)resultSet.isLast());
        resultSet.next();
        Assert.assertTrue((boolean)resultSet.isAfterLast());
        resultSet.close();
        Assert.assertTrue((boolean)resultSet.isClosed());
        statement.close();
        connection.close();
    }

    @Test
    public void testWasNull() throws SQLException {
        Connection connection = ResultSetAsyncIT.getConnection();
        Statement statement = connection.createStatement();
        Clob emptyClob = connection.createClob();
        emptyClob.setString(1L, "");
        statement.execute("create or replace table test_null(colA number, colB string, colNull string, emptyClob string)");
        PreparedStatement prepst = connection.prepareStatement("insert into test_null values (?, ?, ?, ?)");
        prepst.setNull(1, 4);
        prepst.setString(2, "hello");
        prepst.setString(3, null);
        prepst.setClob(4, emptyClob);
        prepst.execute();
        ResultSet resultSet = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from test_null");
        resultSet.next();
        resultSet.getInt(1);
        Assert.assertTrue((boolean)resultSet.wasNull());
        resultSet.getString(2);
        Assert.assertFalse((boolean)resultSet.wasNull());
        Assert.assertNull((Object)resultSet.getClob(3));
        Assert.assertNull((Object)resultSet.getClob("COLNULL"));
        Assert.assertEquals((Object)"", (Object)resultSet.getClob("EMPTYCLOB").toString());
    }

    @Test
    public void testGetMethods() throws Throwable {
        String prepInsertString = "insert into test_get values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        int bigInt = Integer.MAX_VALUE;
        long bigLong = Long.MAX_VALUE;
        int bigShort = Short.MAX_VALUE;
        String str = "hello";
        double bigDouble = Double.MAX_VALUE;
        float bigFloat = Float.MAX_VALUE;
        byte[] bytes = new byte[]{-85, -51, 18};
        BigDecimal bigDecimal = new BigDecimal("10000000000");
        byte oneByte = 1;
        Date date = new Date(44L);
        Time time = new Time(500L);
        Timestamp ts = new Timestamp(333L);
        Connection connection = ResultSetAsyncIT.getConnection();
        Clob clob = connection.createClob();
        clob.setString(1L, "hello world");
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_get(colA integer, colB number, colC number, colD string, colE double, colF float, colG boolean, colH text, colI binary(3), colJ number(38,9), colK int, colL date, colM time, colN timestamp_ltz)");
        PreparedStatement prepStatement = connection.prepareStatement(prepInsertString);
        prepStatement.setInt(1, bigInt);
        prepStatement.setLong(2, bigLong);
        prepStatement.setLong(3, bigShort);
        prepStatement.setString(4, str);
        prepStatement.setDouble(5, bigDouble);
        prepStatement.setFloat(6, bigFloat);
        prepStatement.setBoolean(7, true);
        prepStatement.setClob(8, clob);
        prepStatement.setBytes(9, bytes);
        prepStatement.setBigDecimal(10, bigDecimal);
        prepStatement.setByte(11, oneByte);
        prepStatement.setDate(12, date);
        prepStatement.setTime(13, time);
        prepStatement.setTimestamp(14, ts);
        prepStatement.execute();
        ResultSet resultSet = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from test_get");
        resultSet.next();
        Assert.assertEquals((long)bigInt, (long)resultSet.getInt(1));
        Assert.assertEquals((long)bigInt, (long)resultSet.getInt("COLA"));
        Assert.assertEquals((long)bigLong, (long)resultSet.getLong(2));
        Assert.assertEquals((long)bigLong, (long)resultSet.getLong("COLB"));
        Assert.assertEquals((long)bigShort, (long)resultSet.getShort(3));
        Assert.assertEquals((long)bigShort, (long)resultSet.getShort("COLC"));
        Assert.assertEquals((Object)str, (Object)resultSet.getString(4));
        Assert.assertEquals((Object)str, (Object)resultSet.getString("COLD"));
        Reader reader = resultSet.getCharacterStream("COLD");
        char[] sample = new char[str.length()];
        Assert.assertEquals((long)str.length(), (long)reader.read(sample));
        Assert.assertEquals((long)str.charAt(0), (long)sample[0]);
        Assert.assertEquals((Object)str, (Object)new String(sample));
        Assert.assertEquals((double)bigDouble, (double)resultSet.getDouble(5), (double)0.0);
        Assert.assertEquals((double)bigDouble, (double)resultSet.getDouble("COLE"), (double)0.0);
        Assert.assertEquals((float)bigFloat, (float)resultSet.getFloat(6), (float)0.0f);
        Assert.assertEquals((float)bigFloat, (float)resultSet.getFloat("COLF"), (float)0.0f);
        Assert.assertTrue((boolean)resultSet.getBoolean(7));
        Assert.assertTrue((boolean)resultSet.getBoolean("COLG"));
        Assert.assertEquals((Object)"hello world", (Object)resultSet.getClob("COLH").toString());
        DecimalFormat df = new DecimalFormat("#.00");
        Assert.assertEquals((Object)df.format(bigDecimal), (Object)df.format(resultSet.getBigDecimal(10)));
        Assert.assertEquals((Object)df.format(bigDecimal), (Object)df.format(resultSet.getBigDecimal("COLJ")));
        Assert.assertEquals((long)oneByte, (long)resultSet.getByte(11));
        Assert.assertEquals((long)oneByte, (long)resultSet.getByte("COLK"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Assert.assertEquals((Object)sdf.format(date), (Object)sdf.format(resultSet.getDate(12)));
        Assert.assertEquals((Object)sdf.format(date), (Object)sdf.format(resultSet.getDate("COLL")));
        Assert.assertEquals((Object)time, (Object)resultSet.getTime(13));
        Assert.assertEquals((Object)time, (Object)resultSet.getTime("COLM"));
        Assert.assertEquals((Object)ts, (Object)resultSet.getTimestamp(14));
        Assert.assertEquals((Object)ts, (Object)resultSet.getTimestamp("COLN"));
        Assert.assertEquals((Object)str, (Object)resultSet.getObject(4).toString());
        Assert.assertEquals((Object)str, (Object)resultSet.getObject("COLD").toString());
        Assert.assertEquals((Object)statement, (Object)resultSet.getStatement());
        prepStatement.close();
        statement.execute("drop table if exists table_get");
        statement.close();
        resultSet.close();
        connection.close();
    }

    @Test
    public void testEmptyResultSet() throws SQLException {
        Connection connection = ResultSetAsyncIT.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from empty_table");
        Assert.assertFalse((boolean)rs.isClosed());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        try {
            rs.getInt("col1");
            Assert.fail((String)"Fetching from a column name that does not exist should return a SQLException");
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"42703", (Object)e.getSQLState());
        }
        rs.close();
        Assert.assertTrue((boolean)rs.isClosed());
        connection.close();
    }
}

