/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.category.TestCategoryResultSet;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.jdbc.SnowflakeStatement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryResultSet.class})
public class ResultSetAsyncLatestIT
extends BaseJDBCTest {
    @Test
    public void testAsyncResultSet() throws SQLException {
        String queryID;
        Connection connection = ResultSetAsyncLatestIT.getConnection();
        try (Statement statement = connection.createStatement();){
            statement.execute("create or replace table test_rsmd(colA number(20, 5), colB string)");
            statement.execute("insert into test_rsmd values(1.00, 'str'),(2.00, 'str2')");
            String createTableSql = "select * from test_rsmd";
            ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(createTableSql);
            queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
            statement.execute("drop table if exists test_rsmd");
            rs.close();
        }
        connection.close();
        connection = ResultSetAsyncLatestIT.getConnection();
        ResultSet resultSet = connection.unwrap(SnowflakeConnection.class).createResultSet(queryID);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        SnowflakeResultSetMetaData secretMetaData = resultSetMetaData.unwrap(SnowflakeResultSetMetaData.class);
        Assert.assertEquals((Object)secretMetaData.getQueryID(), (Object)resultSet.unwrap(SnowflakeResultSet.class).getQueryID());
        resultSet.getStatement().close();
        resultSet.close();
        connection.close();
    }
}

