/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import net.snowflake.client.category.TestCategoryResultSet;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeClob;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryResultSet.class})
public class ResultSetFeatureNotSupportedIT
extends BaseJDBCTest {
    @Test
    public void testQueryResultSetNotSupportedException() throws Throwable {
        try (Connection connection = ResultSetFeatureNotSupportedIT.getConnection();
             Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("select 1");
            this.checkFeatureNotSupportedException(resultSet);
        }
    }

    @Test
    public void testMetadataResultSetNotSupportedException() throws Throwable {
        try (Connection connection = ResultSetFeatureNotSupportedIT.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            this.checkFeatureNotSupportedException(metaData.getCatalogs());
            this.checkFeatureNotSupportedException(metaData.getSchemas());
            this.checkFeatureNotSupportedException(metaData.getSchemas(database, null));
            this.checkFeatureNotSupportedException(metaData.getTables(database, schema, null, null));
            this.checkFeatureNotSupportedException(metaData.getColumns(database, schema, null, null));
        }
    }

    private void checkFeatureNotSupportedException(ResultSet resultSet) throws SQLException {
        this.expectFeatureNotSupportedException(() -> resultSet.getAsciiStream(1));
        this.expectFeatureNotSupportedException(() -> resultSet.getBinaryStream(1));
        this.expectFeatureNotSupportedException(() -> resultSet.getAsciiStream("col1"));
        this.expectFeatureNotSupportedException(() -> resultSet.getBinaryStream("col2"));
        this.expectFeatureNotSupportedException(resultSet::getCursorName);
        this.expectFeatureNotSupportedException(resultSet::beforeFirst);
        this.expectFeatureNotSupportedException(resultSet::afterLast);
        this.expectFeatureNotSupportedException(resultSet::first);
        this.expectFeatureNotSupportedException(resultSet::last);
        this.expectFeatureNotSupportedException(resultSet::previous);
        this.expectFeatureNotSupportedException(() -> resultSet.absolute(0));
        this.expectFeatureNotSupportedException(() -> resultSet.relative(0));
        this.expectFeatureNotSupportedException(() -> resultSet.relative(0));
        this.expectFeatureNotSupportedException(resultSet::rowUpdated);
        this.expectFeatureNotSupportedException(resultSet::rowInserted);
        this.expectFeatureNotSupportedException(resultSet::rowDeleted);
        this.expectFeatureNotSupportedException(resultSet::rowUpdated);
        this.expectFeatureNotSupportedException(() -> resultSet.updateNull(1));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBoolean(1, true));
        this.expectFeatureNotSupportedException(() -> resultSet.updateByte(1, (byte)1));
        this.expectFeatureNotSupportedException(() -> resultSet.updateShort(1, (short)2));
        this.expectFeatureNotSupportedException(() -> resultSet.updateInt(1, 3));
        this.expectFeatureNotSupportedException(() -> resultSet.updateLong(1, 4L));
        this.expectFeatureNotSupportedException(() -> resultSet.updateFloat(1, 5.0f));
        this.expectFeatureNotSupportedException(() -> resultSet.updateDouble(1, 6.0));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBigDecimal(1, new BigDecimal(7)));
        this.expectFeatureNotSupportedException(() -> resultSet.updateString(1, "test1"));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBytes(1, new byte[0]));
        this.expectFeatureNotSupportedException(() -> resultSet.updateDate(1, new Date(1L)));
        this.expectFeatureNotSupportedException(() -> resultSet.updateTime(1, new Time(0L)));
        this.expectFeatureNotSupportedException(() -> resultSet.updateTimestamp(1, new Timestamp(3L)));
        this.expectFeatureNotSupportedException(() -> resultSet.updateAsciiStream(1, null));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBinaryStream(1, null));
        this.expectFeatureNotSupportedException(() -> resultSet.updateCharacterStream(1, null));
        this.expectFeatureNotSupportedException(() -> resultSet.updateAsciiStream(1, null));
        this.expectFeatureNotSupportedException(() -> resultSet.updateObject(1, new Object(), 124));
        this.expectFeatureNotSupportedException(() -> resultSet.updateObject(1, new Object()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNull("col1"));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBoolean("col1", true));
        this.expectFeatureNotSupportedException(() -> resultSet.updateByte("col1", (byte)1));
        this.expectFeatureNotSupportedException(() -> resultSet.updateShort("col1", (short)2));
        this.expectFeatureNotSupportedException(() -> resultSet.updateInt("col1", 3));
        this.expectFeatureNotSupportedException(() -> resultSet.updateLong("col1", 4L));
        this.expectFeatureNotSupportedException(() -> resultSet.updateFloat("col1", 5.0f));
        this.expectFeatureNotSupportedException(() -> resultSet.updateDouble("col1", 6.0));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBigDecimal("col1", new BigDecimal(7)));
        this.expectFeatureNotSupportedException(() -> resultSet.updateString("col1", "test1"));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBytes("col1", new byte[0]));
        this.expectFeatureNotSupportedException(() -> resultSet.updateDate("col1", new Date(0L)));
        this.expectFeatureNotSupportedException(() -> resultSet.updateTime("col1", new Time(0L)));
        this.expectFeatureNotSupportedException(() -> resultSet.updateTimestamp("col1", new Timestamp(3L)));
        this.expectFeatureNotSupportedException(() -> resultSet.updateAsciiStream("col1", null));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBinaryStream("col1", null));
        this.expectFeatureNotSupportedException(() -> resultSet.updateCharacterStream("col1", null));
        this.expectFeatureNotSupportedException(() -> resultSet.updateAsciiStream("col1", null));
        this.expectFeatureNotSupportedException(() -> resultSet.updateObject("col1", new Object(), 124));
        this.expectFeatureNotSupportedException(() -> resultSet.updateObject("col1", new Object()));
        this.expectFeatureNotSupportedException(resultSet::insertRow);
        this.expectFeatureNotSupportedException(resultSet::updateRow);
        this.expectFeatureNotSupportedException(resultSet::deleteRow);
        this.expectFeatureNotSupportedException(resultSet::refreshRow);
        this.expectFeatureNotSupportedException(resultSet::cancelRowUpdates);
        this.expectFeatureNotSupportedException(resultSet::moveToInsertRow);
        this.expectFeatureNotSupportedException(resultSet::moveToCurrentRow);
        this.expectFeatureNotSupportedException(() -> resultSet.getObject(1, Collections.emptyMap()));
        this.expectFeatureNotSupportedException(() -> resultSet.getRef(1));
        this.expectFeatureNotSupportedException(() -> resultSet.getBlob(1));
        this.expectFeatureNotSupportedException(() -> resultSet.getArray(1));
        this.expectFeatureNotSupportedException(() -> resultSet.getURL(1));
        this.expectFeatureNotSupportedException(() -> resultSet.getRowId(1));
        this.expectFeatureNotSupportedException(() -> resultSet.getNClob(1));
        this.expectFeatureNotSupportedException(() -> resultSet.getSQLXML(1));
        this.expectFeatureNotSupportedException(() -> resultSet.getNString(1));
        this.expectFeatureNotSupportedException(() -> resultSet.getNCharacterStream(1));
        this.expectFeatureNotSupportedException(() -> resultSet.getNClob(1));
        this.expectFeatureNotSupportedException(() -> resultSet.getObject(1, String.class));
        this.expectFeatureNotSupportedException(() -> resultSet.updateRef(1, (Ref)new BaseJDBCTest.FakeRef()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBlob(1, (Blob)new BaseJDBCTest.FakeBlob()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateClob(1, (Clob)new SnowflakeClob()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateArray(1, (Array)new BaseJDBCTest.FakeArray()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateRowId(1, (RowId)new BaseJDBCTest.FakeRowId()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNString(1, "testN"));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNClob(1, (NClob)new BaseJDBCTest.FakeNClob()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateSQLXML(1, (SQLXML)new BaseJDBCTest.FakeSQLXML()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNCharacterStream(1, (Reader)new BaseJDBCTest.FakeReader(), 100L));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNCharacterStream(1, (Reader)new BaseJDBCTest.FakeReader()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateAsciiStream(1, (InputStream)new BaseJDBCTest.FakeInputStream(), 100));
        this.expectFeatureNotSupportedException(() -> resultSet.updateAsciiStream(1, (InputStream)new BaseJDBCTest.FakeInputStream()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBinaryStream(1, (InputStream)new BaseJDBCTest.FakeInputStream(), 100));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBinaryStream(1, (InputStream)new BaseJDBCTest.FakeInputStream()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateCharacterStream(1, (Reader)new BaseJDBCTest.FakeReader(), 100));
        this.expectFeatureNotSupportedException(() -> resultSet.updateCharacterStream(1, (Reader)new BaseJDBCTest.FakeReader()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBlob(1, (InputStream)new BaseJDBCTest.FakeInputStream(), 100L));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBlob(1, (InputStream)new BaseJDBCTest.FakeInputStream()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateClob(1, (Reader)new BaseJDBCTest.FakeReader(), 100L));
        this.expectFeatureNotSupportedException(() -> resultSet.updateClob(1, (Reader)new BaseJDBCTest.FakeReader()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNClob(1, (Reader)new BaseJDBCTest.FakeReader(), 100L));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNClob(1, (Reader)new BaseJDBCTest.FakeReader()));
        this.expectFeatureNotSupportedException(() -> resultSet.getObject("col1", Collections.emptyMap()));
        this.expectFeatureNotSupportedException(() -> resultSet.getRef("col1"));
        this.expectFeatureNotSupportedException(() -> resultSet.getBlob("col1"));
        this.expectFeatureNotSupportedException(() -> resultSet.getArray("col2"));
        this.expectFeatureNotSupportedException(() -> resultSet.getURL("col2"));
        this.expectFeatureNotSupportedException(() -> resultSet.getRowId("col2"));
        this.expectFeatureNotSupportedException(() -> resultSet.getNClob("col2"));
        this.expectFeatureNotSupportedException(() -> resultSet.getSQLXML("col2"));
        this.expectFeatureNotSupportedException(() -> resultSet.getNString("col2"));
        this.expectFeatureNotSupportedException(() -> resultSet.getNCharacterStream("col2"));
        this.expectFeatureNotSupportedException(() -> resultSet.getNClob("col2"));
        this.expectFeatureNotSupportedException(() -> resultSet.getObject("col2", String.class));
        this.expectFeatureNotSupportedException(() -> resultSet.updateRef("col2", (Ref)new BaseJDBCTest.FakeRef()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBlob("col2", (Blob)new BaseJDBCTest.FakeBlob()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateClob("col2", (Clob)new SnowflakeClob()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateArray("col2", (Array)new BaseJDBCTest.FakeArray()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateRowId("col2", (RowId)new BaseJDBCTest.FakeRowId()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNString("col2", "testN"));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNClob("col2", (NClob)new BaseJDBCTest.FakeNClob()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateSQLXML("col2", (SQLXML)new BaseJDBCTest.FakeSQLXML()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNCharacterStream("col2", (Reader)new BaseJDBCTest.FakeReader(), 100L));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNCharacterStream("col2", (Reader)new BaseJDBCTest.FakeReader()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateAsciiStream("col2", (InputStream)new BaseJDBCTest.FakeInputStream(), 100));
        this.expectFeatureNotSupportedException(() -> resultSet.updateAsciiStream("col2", (InputStream)new BaseJDBCTest.FakeInputStream()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBinaryStream("col2", (InputStream)new BaseJDBCTest.FakeInputStream(), 100));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBinaryStream("col2", (InputStream)new BaseJDBCTest.FakeInputStream()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateCharacterStream("col2", (Reader)new BaseJDBCTest.FakeReader(), 100));
        this.expectFeatureNotSupportedException(() -> resultSet.updateCharacterStream("col2", (Reader)new BaseJDBCTest.FakeReader()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBlob("col2", (InputStream)new BaseJDBCTest.FakeInputStream(), 100L));
        this.expectFeatureNotSupportedException(() -> resultSet.updateBlob("col2", (InputStream)new BaseJDBCTest.FakeInputStream()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateClob("col2", (Reader)new BaseJDBCTest.FakeReader(), 100L));
        this.expectFeatureNotSupportedException(() -> resultSet.updateClob("col2", (Reader)new BaseJDBCTest.FakeReader()));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNClob("col2", (Reader)new BaseJDBCTest.FakeReader(), 100L));
        this.expectFeatureNotSupportedException(() -> resultSet.updateNClob("col2", (Reader)new BaseJDBCTest.FakeReader()));
    }
}

