/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.Properties;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryResultSet;
import net.snowflake.client.jdbc.ResultSet0IT;
import net.snowflake.client.jdbc.SnowflakeChunkDownloader;
import net.snowflake.client.jdbc.SnowflakeType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryResultSet.class})
public class ResultSetIT
extends ResultSet0IT {
    private final String selectAllSQL = "select * from test_rs";
    private static final byte[] byteArrayTestCase1 = new byte[0];
    private static final byte[] byteArrayTestCase2 = new byte[]{-85, -51, 18};
    private static final byte[] byteArrayTestCase3 = new byte[]{0, -1, 66, 1};

    public ResultSetIT() {
        this("json");
    }

    ResultSetIT(String queryResultFormat) {
        super(queryResultFormat);
    }

    @Test
    public void testFindColumn() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from test_rs");
        Assert.assertEquals((long)1L, (long)resultSet.findColumn("COLA"));
        statement.close();
        connection.close();
    }

    @Test
    public void testGetColumnClassNameForBinary() throws Throwable {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table bintable (b binary)");
        statement.execute("insert into bintable values ('00f1f2')");
        ResultSet resultSet = statement.executeQuery("select * from bintable");
        ResultSetMetaData metaData = resultSet.getMetaData();
        Assert.assertEquals((Object)SnowflakeType.BINARY_CLASS_NAME, (Object)metaData.getColumnClassName(1));
        Assert.assertTrue((boolean)resultSet.next());
        Class<?> klass = Class.forName(SnowflakeType.BINARY_CLASS_NAME);
        Object ret0 = resultSet.getObject(1);
        Assert.assertEquals(ret0.getClass(), klass);
        byte[] ret = (byte[])ret0;
        Assert.assertEquals((long)3L, (long)ret.length);
        Assert.assertEquals((long)ret[0], (long)0L);
        Assert.assertEquals((long)ret[1], (long)-15L);
        Assert.assertEquals((long)ret[2], (long)-14L);
        statement.execute("drop table if exists bintable");
        statement.close();
        connection.close();
    }

    @Test
    public void testGetMethod() throws Throwable {
        String prepInsertString = "insert into test_get values(?, ?, ?, ?, ?, ?, ?, ?)";
        int bigInt = Integer.MAX_VALUE;
        long bigLong = Long.MAX_VALUE;
        int bigShort = Short.MAX_VALUE;
        String str = "hello";
        double bigDouble = Double.MAX_VALUE;
        float bigFloat = Float.MAX_VALUE;
        Connection connection = this.init();
        Clob clob = connection.createClob();
        clob.setString(1L, "hello world");
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_get(colA integer, colB number, colC number, colD string, colE double, colF float, colG boolean, colH text)");
        PreparedStatement prepStatement = connection.prepareStatement(prepInsertString);
        prepStatement.setInt(1, bigInt);
        prepStatement.setLong(2, bigLong);
        prepStatement.setLong(3, bigShort);
        prepStatement.setString(4, str);
        prepStatement.setDouble(5, bigDouble);
        prepStatement.setFloat(6, bigFloat);
        prepStatement.setBoolean(7, true);
        prepStatement.setClob(8, clob);
        prepStatement.execute();
        statement.execute("select * from test_get");
        ResultSet resultSet = statement.getResultSet();
        resultSet.next();
        Assert.assertEquals((long)bigInt, (long)resultSet.getInt(1));
        Assert.assertEquals((long)bigInt, (long)resultSet.getInt("COLA"));
        Assert.assertEquals((long)bigLong, (long)resultSet.getLong(2));
        Assert.assertEquals((long)bigLong, (long)resultSet.getLong("COLB"));
        Assert.assertEquals((long)bigShort, (long)resultSet.getShort(3));
        Assert.assertEquals((long)bigShort, (long)resultSet.getShort("COLC"));
        Assert.assertEquals((Object)str, (Object)resultSet.getString(4));
        Assert.assertEquals((Object)str, (Object)resultSet.getString("COLD"));
        Reader reader = resultSet.getCharacterStream("COLD");
        char[] sample = new char[str.length()];
        Assert.assertEquals((long)str.length(), (long)reader.read(sample));
        Assert.assertEquals((long)str.charAt(0), (long)sample[0]);
        Assert.assertEquals((Object)str, (Object)new String(sample));
        Assert.assertEquals((float)bigFloat, (float)resultSet.getFloat(6), (float)0.0f);
        Assert.assertEquals((float)bigFloat, (float)resultSet.getFloat("COLF"), (float)0.0f);
        Assert.assertTrue((boolean)resultSet.getBoolean(7));
        Assert.assertTrue((boolean)resultSet.getBoolean("COLG"));
        Assert.assertEquals((Object)"hello world", (Object)resultSet.getClob("COLH").toString());
        Assert.assertEquals((Object)statement, (Object)resultSet.getStatement());
        prepStatement.close();
        statement.execute("drop table if exists table_get");
        statement.close();
        resultSet.close();
        connection.close();
    }

    @Test
    public void testGetObjectOnDatabaseMetadataResultSet() throws SQLException {
        Connection connection = this.init();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTypeInfo();
        resultSet.next();
        Assert.assertEquals((Object)1, (Object)resultSet.getObject("NULLABLE"));
        resultSet.close();
        connection.close();
    }

    @Test
    public void testGetShort() throws SQLException {
        int i;
        ResultSet resultSet = this.numberCrossTesting();
        resultSet.next();
        for (i = 1; i < 13; ++i) {
            Assert.assertEquals((long)0L, (long)resultSet.getShort(i));
        }
        resultSet.next();
        Assert.assertEquals((long)2L, (long)resultSet.getShort(1));
        Assert.assertEquals((long)5L, (long)resultSet.getShort(2));
        Assert.assertEquals((long)3L, (long)resultSet.getShort(3));
        Assert.assertEquals((long)1L, (long)resultSet.getShort(4));
        Assert.assertEquals((long)1L, (long)resultSet.getShort(5));
        Assert.assertEquals((long)1L, (long)resultSet.getShort(6));
        Assert.assertEquals((long)9126L, (long)resultSet.getShort(7));
        for (i = 8; i < 13; ++i) {
            try {
                resultSet.getShort(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
        resultSet.next();
        for (i = 5; i < 7; ++i) {
            try {
                resultSet.getShort(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testGetInt() throws SQLException {
        int i;
        ResultSet resultSet = this.numberCrossTesting();
        resultSet.next();
        for (i = 1; i < 13; ++i) {
            Assert.assertEquals((long)0L, (long)resultSet.getInt(i));
        }
        resultSet.next();
        Assert.assertEquals((long)2L, (long)resultSet.getInt(1));
        Assert.assertEquals((long)5L, (long)resultSet.getInt(2));
        Assert.assertEquals((long)3L, (long)resultSet.getInt(3));
        Assert.assertEquals((long)1L, (long)resultSet.getInt(4));
        Assert.assertEquals((long)1L, (long)resultSet.getInt(5));
        Assert.assertEquals((long)1L, (long)resultSet.getInt(6));
        Assert.assertEquals((long)9126L, (long)resultSet.getInt(7));
        for (i = 8; i < 13; ++i) {
            try {
                resultSet.getInt(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
        resultSet.next();
        for (i = 5; i < 7; ++i) {
            try {
                resultSet.getInt(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testGetLong() throws SQLException {
        int i;
        ResultSet resultSet = this.numberCrossTesting();
        resultSet.next();
        for (i = 1; i < 13; ++i) {
            Assert.assertEquals((long)0L, (long)resultSet.getLong(i));
        }
        resultSet.next();
        Assert.assertEquals((long)2L, (long)resultSet.getLong(1));
        Assert.assertEquals((long)5L, (long)resultSet.getLong(2));
        Assert.assertEquals((long)3L, (long)resultSet.getLong(3));
        Assert.assertEquals((long)1L, (long)resultSet.getLong(4));
        Assert.assertEquals((long)1L, (long)resultSet.getLong(5));
        Assert.assertEquals((long)1L, (long)resultSet.getLong(6));
        Assert.assertEquals((long)9126L, (long)resultSet.getLong(7));
        for (i = 8; i < 13; ++i) {
            try {
                resultSet.getLong(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
        resultSet.next();
        for (i = 5; i < 7; ++i) {
            try {
                resultSet.getLong(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testGetFloat() throws SQLException {
        int i;
        ResultSet resultSet = this.numberCrossTesting();
        resultSet.next();
        for (i = 1; i < 13; ++i) {
            Assert.assertEquals((double)0.0, (double)resultSet.getFloat(i), (double)0.1);
        }
        resultSet.next();
        Assert.assertEquals((double)2.0, (double)resultSet.getFloat(1), (double)0.1);
        Assert.assertEquals((double)5.0, (double)resultSet.getFloat(2), (double)0.1);
        Assert.assertEquals((double)3.5, (double)resultSet.getFloat(3), (double)0.1);
        Assert.assertEquals((double)1.0, (double)resultSet.getFloat(4), (double)0.1);
        Assert.assertEquals((double)1.0, (double)resultSet.getFloat(5), (double)0.1);
        Assert.assertEquals((double)1.0, (double)resultSet.getFloat(6), (double)0.1);
        Assert.assertEquals((double)9126.0, (double)resultSet.getFloat(7), (double)0.1);
        for (i = 8; i < 13; ++i) {
            try {
                resultSet.getFloat(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
        resultSet.next();
        for (i = 5; i < 7; ++i) {
            try {
                resultSet.getFloat(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testGetDouble() throws SQLException {
        int i;
        ResultSet resultSet = this.numberCrossTesting();
        resultSet.next();
        for (i = 1; i < 13; ++i) {
            Assert.assertEquals((double)0.0, (double)resultSet.getDouble(i), (double)0.1);
        }
        resultSet.next();
        Assert.assertEquals((double)2.0, (double)resultSet.getDouble(1), (double)0.1);
        Assert.assertEquals((double)5.0, (double)resultSet.getDouble(2), (double)0.1);
        Assert.assertEquals((double)3.5, (double)resultSet.getDouble(3), (double)0.1);
        Assert.assertEquals((double)1.0, (double)resultSet.getDouble(4), (double)0.1);
        Assert.assertEquals((double)1.0, (double)resultSet.getDouble(5), (double)0.1);
        Assert.assertEquals((double)1.0, (double)resultSet.getDouble(6), (double)0.1);
        Assert.assertEquals((double)9126.0, (double)resultSet.getDouble(7), (double)0.1);
        for (i = 8; i < 13; ++i) {
            try {
                resultSet.getDouble(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
        resultSet.next();
        for (i = 5; i < 7; ++i) {
            try {
                resultSet.getDouble(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testGetBigDecimal() throws SQLException {
        int i;
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_get(colA number(38,9))");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into test_get values(?)");
        BigDecimal bigDecimal1 = new BigDecimal("10000000000");
        preparedStatement.setBigDecimal(1, bigDecimal1);
        preparedStatement.executeUpdate();
        BigDecimal bigDecimal2 = new BigDecimal("100000000.123456789");
        preparedStatement.setBigDecimal(1, bigDecimal2);
        preparedStatement.execute();
        statement.execute("select * from test_get order by 1");
        ResultSet resultSet = statement.getResultSet();
        resultSet.next();
        Assert.assertEquals((Object)bigDecimal2, (Object)resultSet.getBigDecimal(1));
        Assert.assertEquals((Object)bigDecimal2, (Object)resultSet.getBigDecimal("COLA"));
        preparedStatement.close();
        statement.execute("drop table if exists test_get");
        statement.close();
        resultSet.close();
        connection.close();
        resultSet = this.numberCrossTesting();
        resultSet.next();
        for (i = 1; i < 13; ++i) {
            Assert.assertNull((Object)resultSet.getBigDecimal(i));
        }
        resultSet.next();
        Assert.assertEquals((Object)new BigDecimal(2), (Object)resultSet.getBigDecimal(1));
        Assert.assertEquals((Object)new BigDecimal(5), (Object)resultSet.getBigDecimal(2));
        Assert.assertEquals((Object)new BigDecimal(3.5), (Object)resultSet.getBigDecimal(3));
        Assert.assertEquals((Object)new BigDecimal(1), (Object)resultSet.getBigDecimal(4));
        Assert.assertEquals((Object)new BigDecimal(1), (Object)resultSet.getBigDecimal(5));
        Assert.assertEquals((Object)new BigDecimal(1), (Object)resultSet.getBigDecimal(6));
        Assert.assertEquals((Object)new BigDecimal(9126), (Object)resultSet.getBigDecimal(7));
        for (i = 8; i < 13; ++i) {
            try {
                resultSet.getBigDecimal(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
        resultSet.next();
        for (i = 5; i < 7; ++i) {
            try {
                resultSet.getBigDecimal(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testGetBigDecimalNegative() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_dec(colA time)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into test_dec values(?)");
        Time time = new Time(System.currentTimeMillis());
        preparedStatement.setTime(1, time);
        preparedStatement.executeUpdate();
        statement.execute("select * from test_dec order by 1");
        ResultSet resultSet = statement.getResultSet();
        resultSet.next();
        try {
            resultSet.getBigDecimal(2, 38);
            Assert.fail();
        }
        catch (SQLException ex) {
            Assert.assertEquals((long)200032L, (long)ex.getErrorCode());
        }
        statement.execute("drop table if exists test_dec");
        statement.close();
        resultSet.close();
        connection.close();
    }

    @Test
    public void testCursorPosition() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("select * from test_rs");
        ResultSet resultSet = statement.getResultSet();
        resultSet.next();
        Assert.assertTrue((boolean)resultSet.isFirst());
        Assert.assertEquals((long)1L, (long)resultSet.getRow());
        resultSet.next();
        Assert.assertFalse((boolean)resultSet.isFirst());
        Assert.assertEquals((long)2L, (long)resultSet.getRow());
        Assert.assertFalse((boolean)resultSet.isLast());
        resultSet.next();
        Assert.assertEquals((long)3L, (long)resultSet.getRow());
        Assert.assertTrue((boolean)resultSet.isLast());
        resultSet.next();
        Assert.assertTrue((boolean)resultSet.isAfterLast());
        statement.close();
        connection.close();
    }

    @Test
    public void testGetBytes() throws SQLException {
        Properties props = new Properties();
        Connection connection = this.init(props);
        this.ingestBinaryTestData(connection);
        ResultSet resultSet = connection.createStatement().executeQuery("select * from bin");
        resultSet.next();
        Assert.assertArrayEquals((byte[])byteArrayTestCase1, (byte[])resultSet.getBytes(1));
        Assert.assertEquals((Object)"", (Object)resultSet.getString(1));
        resultSet.next();
        Assert.assertArrayEquals((byte[])byteArrayTestCase2, (byte[])resultSet.getBytes(1));
        Assert.assertEquals((Object)"ABCD12", (Object)resultSet.getString(1));
        resultSet.next();
        Assert.assertArrayEquals((byte[])byteArrayTestCase3, (byte[])resultSet.getBytes(1));
        Assert.assertEquals((Object)"00FF4201", (Object)resultSet.getString(1));
        connection.createStatement().execute("drop table if exists bin");
        connection.close();
    }

    private void ingestBinaryTestData(Connection connection) throws SQLException {
        connection.createStatement().execute("create or replace table bin (b Binary)");
        PreparedStatement prepStatement = connection.prepareStatement("insert into bin values (?), (?), (?)");
        prepStatement.setBytes(1, byteArrayTestCase1);
        prepStatement.setBytes(2, byteArrayTestCase2);
        prepStatement.setBytes(3, byteArrayTestCase3);
        prepStatement.execute();
    }

    @Test
    public void testGetBytesInBase64() throws Exception {
        Properties props = new Properties();
        props.setProperty("binary_output_format", "BAse64");
        Connection connection = this.init(props);
        this.ingestBinaryTestData(connection);
        ResultSet resultSet = connection.createStatement().executeQuery("select * from bin");
        resultSet.next();
        Assert.assertArrayEquals((byte[])byteArrayTestCase1, (byte[])resultSet.getBytes(1));
        Assert.assertEquals((Object)"", (Object)resultSet.getString(1));
        resultSet.next();
        Assert.assertArrayEquals((byte[])byteArrayTestCase2, (byte[])resultSet.getBytes(1));
        Assert.assertEquals((Object)"q80S", (Object)resultSet.getString(1));
        resultSet.next();
        Assert.assertArrayEquals((byte[])byteArrayTestCase3, (byte[])resultSet.getBytes(1));
        Assert.assertEquals((Object)"AP9CAQ==", (Object)resultSet.getString(1));
        connection.createStatement().execute("drop table if exists bin");
        connection.close();
    }

    @Test
    public void testColumnMetaWithZeroPrecision() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table testColDecimal(cola number(38, 0), colb number(17, 5))");
        ResultSet resultSet = statement.executeQuery("select * from testColDecimal");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        MatcherAssert.assertThat((Object)resultSetMetaData.getColumnType(1), (Matcher)CoreMatchers.is((Object)-5));
        MatcherAssert.assertThat((Object)resultSetMetaData.getColumnType(2), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)resultSetMetaData.isSigned(1), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)resultSetMetaData.isSigned(2), (Matcher)CoreMatchers.is((Object)true));
        statement.execute("drop table if exists testColDecimal");
        connection.close();
    }

    @Test
    public void testGetObjectOnFixedView() throws Exception {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table testFixedView(C1 STRING NOT NULL COMMENT 'JDBC', C2 STRING, C3 STRING, C4 STRING, C5 STRING, C6 STRING, C7 STRING, C8 STRING, C9 STRING) stage_file_format = (field_delimiter='|' error_on_column_count_mismatch=false)");
        Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + ResultSetIT.getFullPathFileInResource("orders_100.csv") + " @%testFixedView"));
        ResultSet resultSet = statement.executeQuery("PUT file://" + ResultSetIT.getFullPathFileInResource("orders_101.csv") + " @%testFixedView");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        while (resultSet.next()) {
            for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                Assert.assertNotNull((Object)resultSet.getObject(i + 1));
            }
        }
        resultSet.close();
        statement.execute("drop table if exists testFixedView");
        statement.close();
        connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetColumnDisplaySizeAndPrecision() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select cast(1 as char)");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnDisplaySize(1));
        Assert.assertEquals((long)1L, (long)resultSetMetaData.getPrecision(1));
        resultSet = statement.executeQuery("select cast(1 as number(38, 0))");
        resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((long)39L, (long)resultSetMetaData.getColumnDisplaySize(1));
        Assert.assertEquals((long)38L, (long)resultSetMetaData.getPrecision(1));
        resultSet = statement.executeQuery("select cast(1 as decimal(25, 15))");
        resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((long)27L, (long)resultSetMetaData.getColumnDisplaySize(1));
        Assert.assertEquals((long)25L, (long)resultSetMetaData.getPrecision(1));
        resultSet = statement.executeQuery("select cast(1 as string)");
        resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnDisplaySize(1));
        Assert.assertEquals((long)1L, (long)resultSetMetaData.getPrecision(1));
        resultSet = statement.executeQuery("select cast(1 as string(30))");
        resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnDisplaySize(1));
        Assert.assertEquals((long)1L, (long)resultSetMetaData.getPrecision(1));
        resultSet = statement.executeQuery("select to_date('2016-12-13', 'YYYY-MM-DD')");
        resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((long)10L, (long)resultSetMetaData.getColumnDisplaySize(1));
        Assert.assertEquals((long)10L, (long)resultSetMetaData.getPrecision(1));
        resultSet = statement.executeQuery("select to_time('12:34:56', 'HH24:MI:SS')");
        resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((long)8L, (long)resultSetMetaData.getColumnDisplaySize(1));
        Assert.assertEquals((long)8L, (long)resultSetMetaData.getPrecision(1));
        statement.close();
        connection.close();
    }

    @Test
    public void testGetBoolean() throws SQLException {
        int i;
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table testBoolean(cola boolean)");
        statement.execute("insert into testBoolean values(false)");
        ResultSet resultSet = statement.executeQuery("select * from testBoolean");
        resultSet.next();
        Assert.assertFalse((boolean)resultSet.getBoolean(1));
        statement.execute("insert into testBoolean values(true)");
        resultSet = statement.executeQuery("select * from testBoolean");
        resultSet.next();
        Assert.assertFalse((boolean)resultSet.getBoolean(1));
        resultSet.next();
        Assert.assertTrue((boolean)resultSet.getBoolean(1));
        statement.execute("drop table if exists testBoolean");
        statement.execute("create or replace table test_types(c1 number, c2 integer,  c3 varchar, c4 char, c5 boolean, c6 float, c7 binary, c8 date, c9 datetime, c10 time, c11 timestamp_ltz, c12 timestamp_tz)");
        statement.execute("insert into test_types values (null, null, null, null, null, null, null, null, null, null, null, null)");
        statement.execute("insert into test_types (c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12) values(1, 1, '1','1', true, 1.0, '48454C4C4F', '1994-12-27', '1994-12-27 05:05:05', '05:05:05', '1994-12-27 05:05:05 +00:05', '1994-12-27 05:05:05')");
        statement.execute("insert into test_types (c1, c2, c3, c4) values(2, 3, '4', '5')");
        resultSet = statement.executeQuery("select * from test_types");
        resultSet.next();
        for (i = 1; i < 13; ++i) {
            Assert.assertFalse((boolean)resultSet.getBoolean(i));
        }
        resultSet.next();
        Assert.assertTrue((boolean)resultSet.getBoolean(1));
        Assert.assertTrue((boolean)resultSet.getBoolean(2));
        Assert.assertTrue((boolean)resultSet.getBoolean(3));
        Assert.assertTrue((boolean)resultSet.getBoolean(4));
        Assert.assertTrue((boolean)resultSet.getBoolean(5));
        for (i = 6; i < 13; ++i) {
            try {
                resultSet.getBoolean(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
        resultSet.next();
        for (i = 1; i < 5; ++i) {
            try {
                resultSet.getBoolean(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
        statement.close();
        connection.close();
    }

    @Test
    public void testGetClob() throws Throwable {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table testClob(cola text)");
        statement.execute("insert into testClob values('hello world')");
        statement.execute("insert into testClob values('hello world1')");
        statement.execute("insert into testClob values('hello world2')");
        statement.execute("insert into testClob values('hello world3')");
        ResultSet resultSet = statement.executeQuery("select * from testClob");
        resultSet.next();
        char[] chars = new char[100];
        Reader reader = resultSet.getClob(1).getCharacterStream();
        int charRead = reader.read(chars, 0, chars.length);
        Assert.assertEquals((long)charRead, (long)11L);
        Assert.assertEquals((Object)"hello world", (Object)resultSet.getClob(1).toString());
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        Assert.assertEquals((long)clob.length(), (long)12L);
        clob.truncate(5L);
        reader = clob.getCharacterStream();
        charRead = reader.read(chars, 0, chars.length);
        Assert.assertEquals((long)charRead, (long)5L);
        resultSet.next();
        InputStream input = resultSet.getClob(1).getAsciiStream();
        InputStreamReader in = new InputStreamReader(input, StandardCharsets.UTF_8);
        charRead = ((Reader)in).read(chars, 0, chars.length);
        Assert.assertEquals((long)charRead, (long)12L);
        statement.close();
        connection.close();
    }

    @Test
    public void testFetchOnClosedResultSet() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from test_rs");
        Assert.assertFalse((boolean)resultSet.isClosed());
        resultSet.close();
        Assert.assertTrue((boolean)resultSet.isClosed());
        Assert.assertFalse((boolean)resultSet.next());
    }

    @Test
    public void testReleaseDownloaderCurrentMemoryUsage() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        long initialMemoryUsage = SnowflakeChunkDownloader.getCurrentMemoryUsage();
        statement.executeQuery("select current_date(), true,2345234, 2343.0, 'testrgint\\n\\t' from table(generator(rowcount=>1000000))");
        MatcherAssert.assertThat((String)"hold memory usage for the resultSet before close", (SnowflakeChunkDownloader.getCurrentMemoryUsage() - initialMemoryUsage >= 0L ? 1 : 0) != 0);
        statement.close();
        MatcherAssert.assertThat((String)"closing statement didn't release memory allocated for result", (Object)SnowflakeChunkDownloader.getCurrentMemoryUsage(), (Matcher)CoreMatchers.equalTo((Object)initialMemoryUsage));
        connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testResultColumnSearchCaseSensitiveOld() throws Exception {
        this.subTestResultColumnSearchCaseSensitive("JDBC_RS_COLUMN_CASE_INSENSITIVE");
    }

    @Test
    public void testResultColumnSearchCaseSensitive() throws Exception {
        this.subTestResultColumnSearchCaseSensitive("CLIENT_RESULT_COLUMN_CASE_INSENSITIVE");
    }

    private void subTestResultColumnSearchCaseSensitive(String parameterName) throws Exception {
        Properties prop = new Properties();
        prop.put("tracing", "FINEST");
        Connection connection = this.init(prop);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select 1 AS TESTCOL");
        resultSet.next();
        Assert.assertEquals((Object)"1", (Object)resultSet.getString("TESTCOL"));
        Assert.assertEquals((Object)"1", (Object)resultSet.getString("TESTCOL"));
        try {
            resultSet.getString("testcol");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"Column not found: testcol", (Object)e.getMessage());
        }
        statement.executeQuery(String.format("alter session set %s=true", parameterName));
        resultSet = statement.executeQuery("select 1 AS TESTCOL");
        resultSet.next();
        Assert.assertEquals((Object)"1", (Object)resultSet.getString("TESTCOL"));
        Assert.assertEquals((Object)"1", (Object)resultSet.getString("TESTCOL"));
        Assert.assertEquals((Object)"1", (Object)resultSet.getString("testcol"));
        Assert.assertEquals((Object)"1", (Object)resultSet.getString("testcol"));
    }

    @Test
    public void testInvalidColumnIndex() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from test_rs");
        resultSet.next();
        try {
            resultSet.getString(0);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)200032L, (long)e.getErrorCode());
        }
        try {
            resultSet.getString(2);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)200032L, (long)e.getErrorCode());
        }
        resultSet.close();
        statement.close();
        connection.close();
    }

    @Test
    public void testWasNull() throws Exception {
        Connection con = this.init();
        ResultSet ret = con.createStatement().executeQuery("select cast(1/nullif(0,0) as double),cast(1/nullif(0,0) as int), 100, cast(1/nullif(0,0) as number(8,2))");
        ret.next();
        MatcherAssert.assertThat((String)"Double value cannot be null", (Object)ret.getDouble(1), (Matcher)CoreMatchers.equalTo((Object)0.0));
        MatcherAssert.assertThat((String)"wasNull should be true", (boolean)ret.wasNull());
        MatcherAssert.assertThat((String)"Integer value cannot be null", (Object)ret.getInt(2), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((String)"wasNull should be true", (boolean)ret.wasNull());
        MatcherAssert.assertThat((String)"Non null column", (Object)ret.getInt(3), (Matcher)CoreMatchers.equalTo((Object)100));
        MatcherAssert.assertThat((String)"wasNull should be false", (!ret.wasNull() ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"BigDecimal value must be null", (Object)ret.getBigDecimal(4), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"wasNull should be true", (boolean)ret.wasNull());
    }

    @Test
    public void testParseInfAndNaNNumber() throws Exception {
        Connection con = this.init();
        ResultSet ret = con.createStatement().executeQuery("select to_double('inf'), to_double('-inf')");
        ret.next();
        MatcherAssert.assertThat((String)"Positive Infinite Number", (Object)ret.getDouble(1), (Matcher)CoreMatchers.equalTo((Object)Double.POSITIVE_INFINITY));
        MatcherAssert.assertThat((String)"Negative Infinite Number", (Object)ret.getDouble(2), (Matcher)CoreMatchers.equalTo((Object)Double.NEGATIVE_INFINITY));
        MatcherAssert.assertThat((String)"Positive Infinite Number", (Object)Float.valueOf(ret.getFloat(1)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        MatcherAssert.assertThat((String)"Negative Infinite Number", (Object)Float.valueOf(ret.getFloat(2)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
        ret = con.createStatement().executeQuery("select to_double('nan')");
        ret.next();
        MatcherAssert.assertThat((String)"Parse NaN", (Object)ret.getDouble(1), (Matcher)CoreMatchers.equalTo((Object)Double.NaN));
        MatcherAssert.assertThat((String)"Parse NaN", (Object)Float.valueOf(ret.getFloat(1)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(Float.NaN)));
    }

    @Test
    public void testTreatDecimalAsInt() throws Exception {
        Connection con = this.init();
        ResultSet ret = con.createStatement().executeQuery("select 1");
        ResultSetMetaData metaData = ret.getMetaData();
        MatcherAssert.assertThat((Object)metaData.getColumnType(1), (Matcher)CoreMatchers.equalTo((Object)-5));
        con.createStatement().execute("alter session set jdbc_treat_decimal_as_int = false");
        ret = con.createStatement().executeQuery("select 1");
        metaData = ret.getMetaData();
        MatcherAssert.assertThat((Object)metaData.getColumnType(1), (Matcher)CoreMatchers.equalTo((Object)3));
        con.close();
    }

    @Test
    public void testIsLast() throws Exception {
        Connection con = this.init();
        ResultSet ret = con.createStatement().executeQuery("select * from orders_jdbc");
        Assert.assertTrue((String)"should be before the first", (boolean)ret.isBeforeFirst());
        Assert.assertFalse((String)"should not be the first", (boolean)ret.isFirst());
        ret.next();
        Assert.assertFalse((String)"should not be before the first", (boolean)ret.isBeforeFirst());
        Assert.assertTrue((String)"should be the first", (boolean)ret.isFirst());
        int cnt = 0;
        while (ret.next()) {
            if (++cnt != 72) continue;
            Assert.assertTrue((String)"should be the last", (boolean)ret.isLast());
            Assert.assertFalse((String)"should not be after the last", (boolean)ret.isAfterLast());
        }
        Assert.assertEquals((long)72L, (long)cnt);
        ret.next();
        Assert.assertFalse((String)"should not be the last", (boolean)ret.isLast());
        Assert.assertTrue((String)"should be afterthe last", (boolean)ret.isAfterLast());
        ret = con.createStatement().executeQuery("PUT file://" + ResultSetIT.getFullPathFileInResource("orders_100.csv") + " @~");
        Assert.assertTrue((String)"should be before the first", (boolean)ret.isBeforeFirst());
        Assert.assertFalse((String)"should not be the first", (boolean)ret.isFirst());
        ret.next();
        Assert.assertFalse((String)"should not be before the first", (boolean)ret.isBeforeFirst());
        Assert.assertTrue((String)"should be the first", (boolean)ret.isFirst());
        Assert.assertTrue((String)"should be the last", (boolean)ret.isLast());
        Assert.assertFalse((String)"should not be after the last", (boolean)ret.isAfterLast());
        ret.next();
        Assert.assertFalse((String)"should not be the last", (boolean)ret.isLast());
        Assert.assertTrue((String)"should be after the last", (boolean)ret.isAfterLast());
    }

    @Test
    public void testUpdateCountOnCopyCmd() throws Exception {
        Connection con = this.init();
        Statement statement = con.createStatement();
        statement.execute("create or replace table testcopy(cola string)");
        int rowCount = statement.executeUpdate("copy into testcopy");
        MatcherAssert.assertThat((Object)rowCount, (Matcher)CoreMatchers.is((Object)0));
        statement.execute("copy into @%testcopy from (select 'test_string')");
        rowCount = statement.executeUpdate("copy into testcopy");
        MatcherAssert.assertThat((Object)rowCount, (Matcher)CoreMatchers.is((Object)1));
        statement.execute("drop table if exists testcopy");
        con.close();
    }

    @Test
    public void testGetTimeNullTimestampAndTimestampNullTime() throws Throwable {
        try (Connection con = this.init();){
            con.createStatement().execute("create or replace table testnullts(c1 timestamp, c2 time)");
            try {
                con.createStatement().execute("insert into testnullts(c1, c2) values(null, null)");
                ResultSet rs = con.createStatement().executeQuery("select * from testnullts");
                Assert.assertTrue((String)"should return result", (boolean)rs.next());
                Assert.assertNull((String)"return value must be null", (Object)rs.getTime(1));
                Assert.assertNull((String)"return value must be null", (Object)rs.getTimestamp(2));
                rs.close();
            }
            finally {
                con.createStatement().execute("drop table if exists testnullts");
            }
        }
    }

    @Test
    public void testNextNegative() throws SQLException {
        try (Connection con = this.init();){
            ResultSet rs = con.createStatement().executeQuery("select 1");
            rs.next();
            System.setProperty("snowflake.enable_incident_test2", "true");
            try {
                rs.next();
                Assert.fail();
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200014L, (long)ex.getErrorCode());
            }
            System.setProperty("snowflake.enable_incident_test2", "false");
            rs.close();
        }
    }
}

