/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryArrow;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={TestCategoryArrow.class})
public class ResultSetJsonVsArrowIT
extends BaseJDBCTest {
    protected String queryResultFormat;

    @Parameterized.Parameters(name="format={0}")
    public static Object[][] data() {
        return new Object[][]{{"JSON"}, {"Arrow"}};
    }

    public ResultSetJsonVsArrowIT(String queryResultFormat) {
        this.queryResultFormat = queryResultFormat;
    }

    public Connection init() throws SQLException {
        Connection conn = ResultSetJsonVsArrowIT.getConnection(0);
        Statement stmt = conn.createStatement();
        stmt.execute("alter session set jdbc_query_result_format = '" + this.queryResultFormat + "'");
        stmt.close();
        return conn;
    }

    @Test
    public void testGSResult() throws SQLException {
        Connection con = this.init();
        Statement statement = con.createStatement();
        ResultSet rs = statement.executeQuery("select 1, 128, 65500, 10000000000000, 1000000000000000000000000000000000000, NULL, current_timestamp, current_timestamp(0), current_timestamp(5),current_date, current_time, current_time(0), current_time(5);");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getByte(1));
        Assert.assertEquals((long)128L, (long)rs.getShort(2));
        Assert.assertEquals((long)65500L, (long)rs.getInt(3));
        Assert.assertEquals((long)10000000000000L, (long)rs.getLong(4));
        Assert.assertEquals((Object)new BigDecimal("1000000000000000000000000000000000000"), (Object)rs.getBigDecimal(5));
        Assert.assertNull((Object)rs.getString(6));
        Assert.assertNotNull((Object)rs.getTimestamp(7));
        Assert.assertNotNull((Object)rs.getTimestamp(8));
        Assert.assertNotNull((Object)rs.getTimestamp(9));
        Assert.assertNotNull((Object)rs.getDate(10));
        Assert.assertNotNull((Object)rs.getTime(11));
        Assert.assertNotNull((Object)rs.getTime(12));
        Assert.assertNotNull((Object)rs.getTime(13));
    }

    @Test
    public void testGSResultReal() throws SQLException {
        Connection con = this.init();
        Statement statement = con.createStatement();
        statement.execute("create or replace table t (a real)");
        statement.execute("insert into t values (123.456)");
        ResultSet rs = statement.executeQuery("select * from t;");
        rs.next();
        Assert.assertEquals((double)123.456, (double)rs.getFloat(1), (double)0.001);
        this.finish("t", con);
    }

    @Test
    public void testGSResultScan() throws SQLException {
        Connection con = this.init();
        Statement statement = con.createStatement();
        statement.execute("create or replace table t (a text)");
        statement.execute("insert into t values ('test')");
        ResultSet rs = statement.executeQuery("select count(*) from t;");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        String queryId = rs.unwrap(SnowflakeResultSet.class).getQueryID();
        rs = con.createStatement().executeQuery("select * from table(result_scan('" + queryId + "'))");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        this.finish("t", con);
    }

    @Test
    public void testGSResultForEmptyAndSmallTable() throws SQLException {
        Connection con = this.init();
        Statement statement = con.createStatement();
        statement.execute("create or replace table t (a int)");
        ResultSet rs = statement.executeQuery("select * from t;");
        Assert.assertFalse((boolean)rs.next());
        statement.execute("insert into t values (1)");
        rs = statement.executeQuery("select * from t;");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        this.finish("t", con);
    }

    @Test
    public void testSNOW89737() throws SQLException {
        Connection con = this.init();
        Statement statement = con.createStatement();
        statement.execute("create or replace table test_types(c1 number, c2 integer, c3 float, c4 varchar, c5 char, c6 binary, c7 boolean, c8 date, c9 datetime, c10 time, c11 timestamp_ltz, c12 timestamp_tz, c13 variant, c14 object, c15 array)");
        statement.execute("insert into test_types values (null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)");
        statement.execute("insert into test_types (c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12) values(5, 5, 5.0,'hello', 'h', '48454C4C4F', true, '1994-12-27', '1994-12-27 05:05:05', '05:05:05', '1994-12-27 05:05:05 +00:05', '1994-12-27 05:05:05')");
        statement.execute("insert into test_types(c13) select parse_json(' { \"key1\\x00\":\"value1\" } ')");
        statement.execute("insert into test_types(c14) select parse_json(' { \"key1\\x00\":\"value1\" } ')");
        statement.execute("insert into test_types(c15) select parse_json('{\"fruits\" : [\"apples\", \"pears\", \"oranges\"]}')");
        ResultSet resultSet = statement.executeQuery("select * from test_types");
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals(null, (Object)resultSet.getString(1));
        Assert.assertEquals(null, (Object)resultSet.getString(2));
        Assert.assertEquals(null, (Object)resultSet.getString(3));
        Assert.assertEquals(null, (Object)resultSet.getString(4));
        Assert.assertEquals(null, (Object)resultSet.getString(5));
        Assert.assertEquals(null, (Object)resultSet.getString(6));
        Assert.assertEquals(null, (Object)resultSet.getString(7));
        Assert.assertEquals(null, (Object)resultSet.getString(8));
        Assert.assertEquals(null, (Object)resultSet.getString(9));
        Assert.assertEquals(null, (Object)resultSet.getString(10));
        Assert.assertEquals(null, (Object)resultSet.getString(11));
        Assert.assertEquals(null, (Object)resultSet.getString(12));
        Assert.assertEquals(null, (Object)resultSet.getString(13));
        Assert.assertEquals(null, (Object)resultSet.getString(14));
        Assert.assertEquals(null, (Object)resultSet.getString(15));
        this.finish("test_types", con);
    }

    @Test
    public void testSemiStructuredData() throws SQLException {
        Connection con = this.init();
        ResultSet rs = con.createStatement().executeQuery("select array_construct(10, 20, 30), array_construct(null, 'hello', 3::double, 4, 5), array_construct(), object_construct('a',1,'b','BBBB', 'c',null),object_construct('Key_One', parse_json('NULL'), 'Key_Two', null, 'Key_Three', 'null'),to_variant(3.2),parse_json('{ \"a\": null}'), 100::variant;");
        while (rs.next()) {
            Assert.assertEquals((Object)"[\n  10,\n  20,\n  30\n]", (Object)rs.getString(1));
            Assert.assertEquals((Object)"[\n  undefined,\n  \"hello\",\n  3.000000000000000e+00,\n  4,\n  5\n]", (Object)rs.getString(2));
            Assert.assertEquals((Object)"{\n  \"a\": 1,\n  \"b\": \"BBBB\"\n}", (Object)rs.getString(4));
            Assert.assertEquals((Object)"{\n  \"Key_One\": null,\n  \"Key_Three\": \"null\"\n}", (Object)rs.getString(5));
            Assert.assertEquals((Object)"{\n  \"a\": null\n}", (Object)rs.getString(7));
            Assert.assertEquals((Object)"[]", (Object)rs.getString(3));
            Assert.assertEquals((Object)"3.2", (Object)rs.getString(6));
            Assert.assertEquals((Object)"100", (Object)rs.getString(8));
        }
        con.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testStructuredTypes() throws SQLException {
        Connection con = this.init();
        Statement stmt = con.createStatement();
        stmt.execute("alter session set feature_structured_types = 'ENABLED';");
        stmt.close();
        ResultSet rs = con.createStatement().executeQuery("select array_construct(10, 20, 30)::array(int), object_construct_keep_null('a', 1, 'b', 'BBBB', 'c', null)::object(a int, b varchar, c int), object_construct_keep_null('k1', 'v1', 'k2', null)::map(varchar, varchar);");
        while (rs.next()) {
            Assert.assertEquals((Object)"[\n  10,\n  20,\n  30\n]", (Object)rs.getString(1));
            Assert.assertEquals((Object)"{\n  \"a\": 1,\n  \"b\": \"BBBB\",\n  \"c\": null\n}", (Object)rs.getString(2));
            Assert.assertEquals((Object)"{\n  \"k1\": \"v1\",\n  \"k2\": null\n}", (Object)rs.getString(3));
        }
        con.close();
    }

    private Connection init(String table, String column, String values) throws SQLException {
        Connection con = this.init();
        con.createStatement().execute("create or replace table " + table + " " + column);
        con.createStatement().execute("insert into " + table + " values " + values);
        return con;
    }

    private boolean isJSON() {
        return this.queryResultFormat.equalsIgnoreCase("json");
    }

    private void finish(String table, Connection con) throws SQLException {
        con.createStatement().execute("drop table " + table);
        con.close();
    }

    @Test
    public void testTinyInt() throws SQLException {
        int[] cases = new int[]{0, 1, -1, 127, -128};
        String table = "test_arrow_tiny_int";
        String column = "(a int)";
        String values = "(" + StringUtils.join((Object[])ArrayUtils.toObject((int[])cases), (String)"),(") + "), (NULL)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from " + table);
        double delta = 0.1;
        int columnType = rs.getMetaData().getColumnType(1);
        Assert.assertEquals((long)-5L, (long)columnType);
        for (int i = 0; i < cases.length; ++i) {
            rs.next();
            Assert.assertEquals((long)cases[i], (long)rs.getInt(1));
            Assert.assertEquals((long)((short)cases[i]), (long)rs.getShort(1));
            Assert.assertEquals((long)cases[i], (long)rs.getLong(1));
            Assert.assertEquals((Object)Integer.toString(cases[i]), (Object)rs.getString(1));
            Assert.assertEquals((double)cases[i], (double)rs.getFloat(1), (double)delta);
            double val = cases[i];
            Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
            Assert.assertEquals((Object)new BigDecimal(Integer.toString(cases[i])), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)rs.getLong(1), (Object)rs.getObject(1));
            Assert.assertEquals((long)cases[i], (long)rs.getByte(1));
            byte[] bytes = new byte[]{(byte)cases[i]};
            Assert.assertArrayEquals((byte[])bytes, (byte[])rs.getBytes(1));
        }
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getShort(1));
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
        double val = 0.0;
        Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
        Assert.assertNull((Object)rs.getBigDecimal(1));
        Assert.assertNull((Object)rs.getObject(1));
        Assert.assertEquals((long)0L, (long)rs.getByte(1));
        Assert.assertNull((Object)rs.getBytes(1));
        Assert.assertTrue((boolean)rs.wasNull());
        this.finish(table, con);
    }

    @Test
    public void testScaledTinyInt() throws SQLException {
        float[] cases = new float[]{0.0f, 0.11f, -0.11f, 1.27f, -1.28f};
        String table = "test_arrow_tiny_int";
        String column = "(a number(3,2))";
        String values = "(" + StringUtils.join((Object[])ArrayUtils.toObject((float[])cases), (String)"),(") + "), (null)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from test_arrow_tiny_int");
        double delta = 0.001;
        int columnType = rs.getMetaData().getColumnType(1);
        Assert.assertEquals((long)3L, (long)columnType);
        for (int i = 0; i < cases.length; ++i) {
            SQLException se;
            rs.next();
            try {
                rs.getInt(1);
                Assert.fail();
            }
            catch (Exception e) {
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
            try {
                rs.getShort(1);
                Assert.fail();
            }
            catch (Exception e) {
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
            try {
                rs.getLong(1);
                Assert.fail();
            }
            catch (Exception e) {
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
            Assert.assertEquals((Object)String.format("%.2f", Float.valueOf(cases[i])), (Object)rs.getString(1));
            Assert.assertEquals((double)cases[i], (double)rs.getFloat(1), (double)delta);
            double val = cases[i];
            Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
            Assert.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
            if (this.isJSON()) {
                try {
                    rs.getByte(1);
                    Assert.fail();
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                }
            } else {
                Assert.assertEquals((long)((byte)(cases[i] * 100.0f)), (long)rs.getByte(1));
            }
            if (this.isJSON()) continue;
            byte[] bytes = new byte[]{rs.getByte(1)};
            Assert.assertArrayEquals((byte[])bytes, (byte[])rs.getBytes(1));
        }
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getShort(1));
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
        double val = 0.0;
        Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
        Assert.assertNull((Object)rs.getBigDecimal(1));
        Assert.assertNull((Object)rs.getObject(1));
        Assert.assertEquals((long)0L, (long)rs.getByte(1));
        Assert.assertNull((Object)rs.getBytes(1));
        Assert.assertTrue((boolean)rs.wasNull());
        this.finish(table, con);
    }

    @Test
    public void testSmallInt() throws SQLException {
        short[] cases = new short[]{0, 1, -1, 127, -128, 128, -129, Short.MAX_VALUE, Short.MIN_VALUE};
        String table = "test_arrow_small_int";
        String column = "(a int)";
        String values = "(" + StringUtils.join((Object[])ArrayUtils.toObject((short[])cases), (String)"),(") + "), (NULL)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from " + table);
        double delta = 0.1;
        int columnType = rs.getMetaData().getColumnType(1);
        Assert.assertEquals((long)-5L, (long)columnType);
        for (int i = 0; i < cases.length; ++i) {
            rs.next();
            Assert.assertEquals((long)cases[i], (long)rs.getInt(1));
            Assert.assertEquals((long)cases[i], (long)rs.getShort(1));
            Assert.assertEquals((long)cases[i], (long)rs.getLong(1));
            Assert.assertEquals((Object)Integer.toString(cases[i]), (Object)rs.getString(1));
            Assert.assertEquals((double)cases[i], (double)rs.getFloat(1), (double)delta);
            double val = cases[i];
            Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
            Assert.assertEquals((Object)new BigDecimal(Integer.toString(cases[i])), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)rs.getLong(1), (Object)rs.getObject(1));
            if (cases[i] <= 127 && cases[i] >= -128) {
                Assert.assertEquals((long)cases[i], (long)rs.getByte(1));
            } else {
                try {
                    rs.getByte(1);
                    Assert.fail();
                }
                catch (Exception e) {
                    if (this.isJSON()) {
                        Assert.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                    }
                    SQLException se = (SQLException)e;
                    Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                    Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                }
            }
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.putShort(cases[i]);
            if (this.isJSON()) {
                byte[] res = rs.getBytes(1);
                for (int j = res.length - 1; j >= 0; --j) {
                    Assert.assertEquals((long)bb.array()[2 - res.length + j], (long)res[j]);
                }
                continue;
            }
            Assert.assertArrayEquals((byte[])bb.array(), (byte[])rs.getBytes(1));
        }
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getShort(1));
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
        double val = 0.0;
        Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
        Assert.assertNull((Object)rs.getBigDecimal(1));
        Assert.assertNull((Object)rs.getObject(1));
        Assert.assertEquals((long)0L, (long)rs.getByte(1));
        Assert.assertNull((Object)rs.getBytes(1));
        Assert.assertTrue((boolean)rs.wasNull());
        this.finish(table, con);
    }

    @Test
    public void testScaledSmallInt() throws SQLException {
        float[] cases = new float[]{0.0f, 2.0f, -2.0f, 32.767f, -32.768f};
        short[] shortCompact = new short[]{0, 2000, -2000, Short.MAX_VALUE, Short.MIN_VALUE};
        String table = "test_arrow_small_int";
        String column = "(a number(5,3))";
        String values = "(" + StringUtils.join((Object[])ArrayUtils.toObject((float[])cases), (String)"),(") + "), (null)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from test_arrow_small_int");
        double delta = 1.0E-4;
        int columnType = rs.getMetaData().getColumnType(1);
        Assert.assertEquals((long)3L, (long)columnType);
        for (int i = 0; i < cases.length; ++i) {
            SQLException se;
            SQLException se2;
            rs.next();
            try {
                rs.getInt(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            try {
                rs.getShort(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            try {
                rs.getLong(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            Assert.assertEquals((Object)String.format("%.3f", Float.valueOf(cases[i])), (Object)rs.getString(1));
            Assert.assertEquals((double)cases[i], (double)rs.getFloat(1), (double)delta);
            double val = cases[i];
            Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
            Assert.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
            try {
                rs.getByte(1);
                Assert.fail();
            }
            catch (Exception e) {
                if (this.isJSON()) {
                    Assert.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                }
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocate(2);
                byteBuffer.putShort(shortCompact[i]);
                Assert.assertArrayEquals((byte[])byteBuffer.array(), (byte[])rs.getBytes(1));
                continue;
            }
            catch (Exception e) {
                if (!this.isJSON()) continue;
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
        }
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getShort(1));
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
        double val = 0.0;
        Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
        Assert.assertNull((Object)rs.getBigDecimal(1));
        Assert.assertEquals(null, (Object)rs.getObject(1));
        Assert.assertEquals((long)0L, (long)rs.getByte(1));
        Assert.assertNull((Object)rs.getBytes(1));
        Assert.assertTrue((boolean)rs.wasNull());
        this.finish(table, con);
    }

    @Test
    public void testInt() throws SQLException {
        int[] cases = new int[]{0, 1, -1, 127, -128, 128, -129, Short.MAX_VALUE, Short.MIN_VALUE, 32768, -32769, Integer.MAX_VALUE, Integer.MIN_VALUE};
        String table = "test_arrow_int";
        String column = "(a int)";
        String values = "(" + StringUtils.join((Object[])ArrayUtils.toObject((int[])cases), (String)"),(") + "), (NULL)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from " + table);
        double delta = 0.1;
        int columnType = rs.getMetaData().getColumnType(1);
        Assert.assertEquals((long)-5L, (long)columnType);
        for (int i = 0; i < cases.length; ++i) {
            rs.next();
            Assert.assertEquals((long)cases[i], (long)rs.getInt(1));
            if (cases[i] >= Short.MIN_VALUE && cases[i] <= Short.MAX_VALUE) {
                Assert.assertEquals((long)((short)cases[i]), (long)rs.getShort(1));
            } else {
                try {
                    Assert.assertEquals((long)((short)cases[i]), (long)rs.getShort(1));
                    Assert.fail();
                }
                catch (Exception e) {
                    SQLException se = (SQLException)e;
                    Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                    Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                }
            }
            Assert.assertEquals((long)cases[i], (long)rs.getLong(1));
            Assert.assertEquals((Object)Integer.toString(cases[i]), (Object)rs.getString(1));
            Assert.assertEquals((double)cases[i], (double)rs.getFloat(1), (double)delta);
            double val = cases[i];
            Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
            Assert.assertEquals((Object)new BigDecimal(Integer.toString(cases[i])), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)rs.getLong(1), (Object)rs.getObject(1));
            if (cases[i] <= 127 && cases[i] >= -128) {
                Assert.assertEquals((long)cases[i], (long)rs.getByte(1));
            } else {
                try {
                    rs.getByte(1);
                    Assert.fail();
                }
                catch (Exception e) {
                    if (this.isJSON()) {
                        Assert.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                    }
                    SQLException se = (SQLException)e;
                    Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                    Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                }
            }
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(cases[i]);
            if (this.isJSON()) {
                byte[] res = rs.getBytes(1);
                for (int j = res.length - 1; j >= 0; --j) {
                    Assert.assertEquals((long)bb.array()[4 - res.length + j], (long)res[j]);
                }
                continue;
            }
            Assert.assertArrayEquals((byte[])bb.array(), (byte[])rs.getBytes(1));
        }
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getShort(1));
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
        double val = 0.0;
        Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
        Assert.assertNull((Object)rs.getBigDecimal(1));
        Assert.assertNull((Object)rs.getObject(1));
        Assert.assertEquals((long)0L, (long)rs.getByte(1));
        Assert.assertNull((Object)rs.getBytes(1));
        Assert.assertTrue((boolean)rs.wasNull());
        this.finish(table, con);
    }

    @Test
    public void testScaledInt() throws SQLException {
        int scale = 9;
        int[] intCompacts = new int[]{0, 123456789, -123456789, Integer.MAX_VALUE, -2147483647};
        List caseList = Arrays.stream(intCompacts).mapToObj(x -> BigDecimal.valueOf(x, scale)).collect(Collectors.toList());
        Object[] cases = (BigDecimal[])caseList.stream().toArray(BigDecimal[]::new);
        String table = "test_arrow_int";
        String column = String.format("(a number(10,%d))", scale);
        String values = "(" + StringUtils.join((Object[])cases, (String)"),(") + "), (null)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from test_arrow_int");
        double delta = 1.0E-10;
        int columnType = rs.getMetaData().getColumnType(1);
        Assert.assertEquals((long)3L, (long)columnType);
        for (int i = 0; i < cases.length; ++i) {
            SQLException se;
            SQLException se2;
            rs.next();
            try {
                rs.getInt(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            try {
                rs.getShort(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            try {
                rs.getLong(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            Assert.assertEquals((Object)((BigDecimal)cases[i]).toPlainString(), (Object)rs.getString(1));
            Assert.assertEquals((double)Float.parseFloat(((BigDecimal)cases[i]).toString()), (double)rs.getFloat(1), (double)delta);
            double val = Double.parseDouble(((BigDecimal)cases[i]).toString());
            Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
            Assert.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
            try {
                rs.getByte(1);
                Assert.fail();
            }
            catch (Exception e) {
                if (this.isJSON()) {
                    Assert.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                }
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                byteBuffer.putInt(intCompacts[i]);
                Assert.assertArrayEquals((byte[])byteBuffer.array(), (byte[])rs.getBytes(1));
                continue;
            }
            catch (Exception e) {
                if (!this.isJSON()) continue;
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
        }
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getShort(1));
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
        double val = 0.0;
        Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
        Assert.assertNull((Object)rs.getBigDecimal(1));
        Assert.assertEquals(null, (Object)rs.getObject(1));
        Assert.assertEquals((long)0L, (long)rs.getByte(1));
        Assert.assertNull((Object)rs.getBytes(1));
        Assert.assertTrue((boolean)rs.wasNull());
        this.finish(table, con);
    }

    @Test
    public void testBigInt() throws SQLException {
        long[] cases = new long[]{0L, 1L, -1L, 127L, -128L, 128L, -129L, 32767L, -32768L, 32768L, -32769L, Integer.MAX_VALUE, Integer.MIN_VALUE, 0x80000000L, -2147483649L, Long.MAX_VALUE, Long.MIN_VALUE};
        String table = "test_arrow_big_int";
        String column = "(a int)";
        String values = "(" + StringUtils.join((Object[])ArrayUtils.toObject((long[])cases), (String)"),(") + "), (NULL)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from " + table);
        double delta = 0.1;
        int columnType = rs.getMetaData().getColumnType(1);
        Assert.assertEquals((long)-5L, (long)columnType);
        for (int i = 0; i < cases.length; ++i) {
            SQLException se;
            rs.next();
            if (cases[i] >= Integer.MIN_VALUE && cases[i] <= Integer.MAX_VALUE) {
                Assert.assertEquals((long)cases[i], (long)rs.getInt(1));
            } else {
                try {
                    Assert.assertEquals((long)cases[i], (long)rs.getInt(1));
                    Assert.fail();
                }
                catch (Exception e) {
                    se = (SQLException)e;
                    Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                    Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                }
            }
            if (cases[i] >= -32768L && cases[i] <= 32767L) {
                Assert.assertEquals((long)((short)cases[i]), (long)rs.getShort(1));
            } else {
                try {
                    Assert.assertEquals((long)((short)cases[i]), (long)rs.getShort(1));
                    Assert.fail();
                }
                catch (Exception e) {
                    se = (SQLException)e;
                    Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                    Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                }
            }
            Assert.assertEquals((long)cases[i], (long)rs.getLong(1));
            Assert.assertEquals((Object)Long.toString(cases[i]), (Object)rs.getString(1));
            Assert.assertEquals((double)cases[i], (double)rs.getFloat(1), (double)delta);
            double val = cases[i];
            Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
            Assert.assertEquals((Object)new BigDecimal(Long.toString(cases[i])), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)rs.getLong(1), (Object)rs.getObject(1));
            if (cases[i] <= 127L && cases[i] >= -128L) {
                Assert.assertEquals((long)cases[i], (long)rs.getByte(1));
            } else {
                try {
                    rs.getByte(1);
                    Assert.fail();
                }
                catch (Exception e) {
                    if (this.isJSON()) {
                        Assert.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                    }
                    SQLException se2 = (SQLException)e;
                    Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                    Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
                }
            }
            ByteBuffer bb = ByteBuffer.allocate(8);
            bb.putLong(cases[i]);
            byte[] res = rs.getBytes(1);
            for (int j = res.length - 1; j >= 0; --j) {
                Assert.assertEquals((long)bb.array()[8 - res.length + j], (long)res[j]);
            }
        }
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getShort(1));
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
        double val = 0.0;
        Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
        Assert.assertNull((Object)rs.getBigDecimal(1));
        Assert.assertEquals(null, (Object)rs.getObject(1));
        Assert.assertEquals((long)0L, (long)rs.getByte(1));
        Assert.assertNull((Object)rs.getBytes(1));
        Assert.assertTrue((boolean)rs.wasNull());
        this.finish(table, con);
    }

    @Test
    public void testScaledBigInt() throws SQLException {
        int scale = 18;
        long[] longCompacts = new long[]{0L, 123456789L, -123456789L, Integer.MAX_VALUE, -2147483647L, Long.MIN_VALUE, Long.MAX_VALUE};
        List caseList = Arrays.stream(longCompacts).mapToObj(x -> BigDecimal.valueOf(x, scale)).collect(Collectors.toList());
        Object[] cases = (BigDecimal[])caseList.stream().toArray(BigDecimal[]::new);
        String table = "test_arrow_big_int";
        String column = String.format("(a number(38,%d))", scale);
        String values = "(" + StringUtils.join((Object[])cases, (String)"),(") + "), (null)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from " + table);
        double delta = 1.0E-19;
        int columnType = rs.getMetaData().getColumnType(1);
        Assert.assertEquals((long)3L, (long)columnType);
        for (int i = 0; i < cases.length; ++i) {
            SQLException se;
            SQLException se2;
            rs.next();
            try {
                rs.getInt(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            try {
                rs.getShort(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            try {
                rs.getLong(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            Assert.assertEquals((Object)((BigDecimal)cases[i]).toPlainString(), (Object)rs.getString(1));
            Assert.assertEquals((double)Float.parseFloat(((BigDecimal)cases[i]).toString()), (double)rs.getFloat(1), (double)delta);
            double val = Double.parseDouble(((BigDecimal)cases[i]).toString());
            Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
            Assert.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
            try {
                rs.getByte(1);
                Assert.fail();
            }
            catch (Exception e) {
                if (this.isJSON()) {
                    Assert.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                }
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocate(8);
                byteBuffer.putLong(longCompacts[i]);
                Assert.assertArrayEquals((byte[])byteBuffer.array(), (byte[])rs.getBytes(1));
                continue;
            }
            catch (Exception e) {
                if (!this.isJSON()) continue;
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
        }
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getShort(1));
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
        double val = 0.0;
        Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
        Assert.assertNull((Object)rs.getBigDecimal(1));
        Assert.assertEquals(null, (Object)rs.getObject(1));
        Assert.assertEquals((long)0L, (long)rs.getByte(1));
        Assert.assertNull((Object)rs.getBytes(1));
        Assert.assertTrue((boolean)rs.wasNull());
        this.finish(table, con);
    }

    @Test
    public void testDecimalNoScale() throws SQLException {
        int scale = 0;
        String[] longCompacts = new String[]{"10000000000000000000000000000000000000", "12345678901234567890123456789012345678", "99999999999999999999999999999999999999"};
        List caseList = Arrays.stream(longCompacts).map(x -> new BigDecimal((String)x)).collect(Collectors.toList());
        Object[] cases = (BigDecimal[])caseList.stream().toArray(BigDecimal[]::new);
        String table = "test_arrow_decimal";
        String column = String.format("(a number(38,%d))", scale);
        String values = "(" + StringUtils.join((Object[])cases, (String)"),(") + "), (null)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from " + table);
        double delta = 0.1;
        int columnType = rs.getMetaData().getColumnType(1);
        Assert.assertEquals((long)-5L, (long)columnType);
        for (int i = 0; i < cases.length; ++i) {
            SQLException se;
            rs.next();
            try {
                rs.getInt(1);
                Assert.fail();
            }
            catch (Exception e) {
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
            try {
                rs.getShort(1);
                Assert.fail();
            }
            catch (Exception e) {
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
            try {
                rs.getLong(1);
                Assert.fail();
            }
            catch (Exception e) {
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
            Assert.assertEquals((Object)((BigDecimal)cases[i]).toPlainString(), (Object)rs.getString(1));
            Assert.assertEquals((double)Float.parseFloat(((BigDecimal)cases[i]).toString()), (double)rs.getFloat(1), (double)delta);
            double val = Double.parseDouble(((BigDecimal)cases[i]).toString());
            Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
            Assert.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
            try {
                rs.getByte(1);
                Assert.fail();
            }
            catch (Exception e) {
                if (this.isJSON()) {
                    Assert.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                }
                SQLException se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            Assert.assertArrayEquals((byte[])((BigDecimal)cases[i]).toBigInteger().toByteArray(), (byte[])rs.getBytes(1));
        }
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getShort(1));
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
        double val = 0.0;
        Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
        Assert.assertNull((Object)rs.getBigDecimal(1));
        Assert.assertEquals(null, (Object)rs.getObject(1));
        Assert.assertEquals((long)0L, (long)rs.getByte(1));
        Assert.assertNull((Object)rs.getBytes(1));
        Assert.assertTrue((boolean)rs.wasNull());
        this.finish(table, con);
    }

    @Test
    public void testDecimalWithLargeScale() throws SQLException {
        int scale = 37;
        String[] longCompacts = new String[]{"1.0000000000000000000000000000000000000", "1.2345678901234567890123456789012345678", "9.9999999999999999999999999999999999999"};
        List caseList = Arrays.stream(longCompacts).map(x -> new BigDecimal((String)x)).collect(Collectors.toList());
        Object[] cases = (BigDecimal[])caseList.stream().toArray(BigDecimal[]::new);
        String table = "test_arrow_decimal";
        String column = String.format("(a number(38,%d))", scale);
        String values = "(" + StringUtils.join((Object[])cases, (String)"),(") + "), (null)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from " + table);
        double delta = 1.0E-38;
        int columnType = rs.getMetaData().getColumnType(1);
        Assert.assertEquals((long)3L, (long)columnType);
        for (int i = 0; i < cases.length; ++i) {
            SQLException se;
            SQLException se2;
            rs.next();
            try {
                rs.getInt(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            try {
                rs.getShort(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            try {
                rs.getLong(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            Assert.assertEquals((Object)((BigDecimal)cases[i]).toPlainString(), (Object)rs.getString(1));
            Assert.assertEquals((double)Float.parseFloat(((BigDecimal)cases[i]).toString()), (double)rs.getFloat(1), (double)delta);
            double val = Double.parseDouble(((BigDecimal)cases[i]).toString());
            Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
            Assert.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
            try {
                rs.getByte(1);
                Assert.fail();
            }
            catch (Exception e) {
                if (this.isJSON()) {
                    Assert.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                }
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
            try {
                Assert.assertArrayEquals((byte[])((BigDecimal)cases[i]).toBigInteger().toByteArray(), (byte[])rs.getBytes(1));
                continue;
            }
            catch (Exception e) {
                if (!this.isJSON()) continue;
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
        }
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getShort(1));
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
        double val = 0.0;
        Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
        Assert.assertNull((Object)rs.getBigDecimal(1));
        Assert.assertEquals(null, (Object)rs.getObject(1));
        Assert.assertEquals((long)0L, (long)rs.getByte(1));
        Assert.assertNull((Object)rs.getBytes(1));
        Assert.assertTrue((boolean)rs.wasNull());
        this.finish(table, con);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDecimal() throws SQLException {
        int scale = 37;
        long[] longCompacts = new long[]{0L, 123456789L, -123456789L, Integer.MAX_VALUE, -2147483647L, Long.MIN_VALUE, Long.MAX_VALUE};
        List caseList = Arrays.stream(longCompacts).mapToObj(x -> BigDecimal.valueOf(x, scale)).collect(Collectors.toList());
        Object[] cases = (BigDecimal[])caseList.stream().toArray(BigDecimal[]::new);
        String table = "test_arrow_big_int";
        String column = String.format("(a number(38,%d))", scale);
        String values = "(" + StringUtils.join((Object[])cases, (String)"),(") + "), (null)";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from " + table);
        double delta = 1.0E-38;
        ByteBuffer byteBuf = ByteBuffer.allocate(8);
        int columnType = rs.getMetaData().getColumnType(1);
        Assert.assertEquals((long)3L, (long)columnType);
        for (int i = 0; i < cases.length; ++i) {
            SQLException se;
            SQLException se2;
            rs.next();
            try {
                rs.getInt(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            try {
                rs.getShort(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            try {
                rs.getLong(1);
                Assert.fail();
            }
            catch (Exception e) {
                se2 = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se2.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
            }
            Assert.assertEquals((Object)((BigDecimal)cases[i]).toPlainString(), (Object)rs.getString(1));
            Assert.assertEquals((double)Float.parseFloat(((BigDecimal)cases[i]).toString()), (double)rs.getFloat(1), (double)delta);
            double val = Double.parseDouble(((BigDecimal)cases[i]).toString());
            Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
            Assert.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
            try {
                rs.getByte(1);
                Assert.fail();
            }
            catch (Exception e) {
                if (this.isJSON()) {
                    Assert.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                }
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
            try {
                Assert.assertArrayEquals((byte[])byteBuf.putLong(0, longCompacts[i]).array(), (byte[])rs.getBytes(1));
                continue;
            }
            catch (Exception e) {
                if (!this.isJSON()) continue;
                se = (SQLException)e;
                Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)se.getErrorCode());
                Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
            }
        }
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getShort(1));
        Assert.assertEquals((long)0L, (long)rs.getLong(1));
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
        double val = 0.0;
        Assert.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
        Assert.assertNull((Object)rs.getBigDecimal(1));
        Assert.assertEquals(null, (Object)rs.getObject(1));
        Assert.assertEquals((long)0L, (long)rs.getByte(1));
        Assert.assertNull((Object)rs.getBytes(1));
        Assert.assertTrue((boolean)rs.wasNull());
        this.finish(table, con);
    }

    @Test
    public void testDoublePrecision() throws SQLException {
        Object[] cases = new String[]{"-86.6426540296895", "3.14159265359", "1.7976931348623157E308", "1.7E308", "1.7976931348623151E308", "-1.7976931348623151E308", "-1.7E308", "-1.7976931348623157E308"};
        String[] json_results = new String[]{"-86.64265403", "3.141592654", "Infinity", "1.7E308", "Infinity", "-Infinity", "-1.7E308", "-Infinity"};
        String table = "test_arrow_double";
        String column = "(a double)";
        String values = "(" + StringUtils.join((Object[])cases, (String)"),(") + ")";
        Connection con = this.init(table, column, values);
        ResultSet rs = con.createStatement().executeQuery("select * from " + table);
        int i = 0;
        if (this.isJSON()) {
            while (rs.next()) {
                Assert.assertEquals((Object)json_results[i++], (Object)Double.toString(rs.getDouble(1)));
            }
        } else {
            while (rs.next()) {
                Assert.assertEquals((Object)cases[i++], (Object)Double.toString(rs.getDouble(1)));
            }
        }
        this.finish(table, con);
    }

    @Test
    public void testBoolean() throws SQLException {
        String table = "test_arrow_boolean";
        String column = "(a boolean)";
        String values = "(true),(null),(false)";
        Connection conn = this.init(table, column, values);
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery("select * from " + table);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.getBoolean(1));
        Assert.assertEquals((Object)"TRUE", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.getBoolean(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.getBoolean(1));
        Assert.assertEquals((Object)"FALSE", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        this.finish(table, conn);
    }

    @Test
    public void testClientSideSorting() throws SQLException {
        String table = "test_arrow_sort_on";
        String column = "( a int, b double, c string)";
        String values = "(1,2.0,'test'),(0,2.0, 'test'),(1,2.0,'abc')";
        Connection conn = this.init(table, column, values);
        Statement statement = conn.createStatement();
        statement.execute("set-sf-property sort on");
        ResultSet rs = statement.executeQuery("select * from " + table);
        rs.next();
        Assert.assertEquals((Object)"0", (Object)rs.getString(1));
        rs.next();
        Assert.assertEquals((Object)"1", (Object)rs.getString(1));
        rs.next();
        Assert.assertEquals((Object)"test", (Object)rs.getString(3));
        this.finish(table, conn);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testClientSideSortingOnBatchedChunk() throws SQLException {
        String[] queries = new String[]{"set-sf-property sort on", "alter session set populate_change_tracking_columns = true;", "alter session set create_change_tracking_columns = true;", "alter session set enable_stream = true;", "alter session set qa_mode=true;  -- used for row_id", "create or replace schema stream_get_table_timestamp;", "create or replace  table T(id int);", "create stream S on table T;", "select system$stream_get_table_timestamp('S');", "select system$last_change_commit_time('T');", "insert into T values (1);", "insert into T values (2);", "insert into T values (3);"};
        try (Connection conn = this.init();){
            Statement stat = conn.createStatement();
            for (String q : queries) {
                stat.execute(q);
            }
            ResultSet rs = stat.executeQuery("select * from S");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            stat.execute("drop stream S");
            stat.execute("drop table T");
        }
    }

    @Test
    public void testTimestampNTZAreAllNulls() throws SQLException {
        try (Connection con = this.init();){
            Statement statement = con.createStatement();
            statement.executeQuery("create or replace table test_null_ts_ntz (a timestampntz(9)) as select null from table(generator(rowcount => 1000000)) v order by 1;");
            ResultSet rs = statement.executeQuery("select * from test_null_ts_ntz");
            while (rs.next()) {
                rs.getObject(1);
            }
            statement.executeQuery("drop table if exists test_null_ts_ntz");
            statement.close();
        }
    }

    @Test
    public void TestArrowStringRoundTrip() throws SQLException {
        String big_number = "11111111112222222222333333333344444444";
        try (Connection con = this.init();){
            Statement st = con.createStatement();
            for (int i = 0; i < 38; ++i) {
                StringBuilder to_insert = new StringBuilder(big_number);
                if (i != 0) {
                    int insert_to = 38 - i;
                    to_insert.insert(insert_to, ".");
                }
                st.execute("create or replace table test_arrow_string (a NUMBER(38, " + i + ") )");
                st.execute("insert into test_arrow_string values (" + to_insert + ")");
                ResultSet rs = st.executeQuery("select * from test_arrow_string");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)to_insert.toString(), (Object)rs.getString(1));
                st.execute("drop table if exists test_arrow_string");
            }
        }
    }

    @Test
    public void TestArrowFloatRoundTrip() throws SQLException {
        float[] cases = new float[]{Float.MAX_VALUE, Float.MIN_VALUE};
        try (Connection con = this.init();){
            Statement st = con.createStatement();
            for (float f : cases) {
                st.executeQuery("create or replace table test_arrow_float (a FLOAT)");
                st.executeQuery("insert into test_arrow_float values (" + f + ")");
                ResultSet rs = st.executeQuery("select * from test_arrow_float");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((float)f, (float)rs.getFloat(1), (float)Float.MIN_VALUE);
                st.executeQuery("drop table if exists test_arrow_float");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void TestTimestampNTZWithDLS() throws SQLException {
        TimeZone origTz = TimeZone.getDefault();
        String[] timeZones = new String[]{"America/New_York", "America/Los_Angeles"};
        try (Connection con = this.init();){
            Statement st = con.createStatement();
            for (String timeZone : timeZones) {
                TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
                st.execute("alter session set JDBC_USE_SESSION_TIMEZONE=false");
                st.execute("alter session set JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC=true");
                st.execute("alter session set TIMEZONE='" + timeZone + "'");
                st.execute("create or replace table src_ts(col1 TIMESTAMP_NTZ, col2 TIMESTAMP_LTZ, col3 TIMESTAMP_TZ)");
                List<String> testTimestampNTZValues = Arrays.asList("2018-03-11 01:10:34.0123456", "2018-03-11 02:10:34.0", "2018-03-11 03:10:34.0", "2018-11-04 01:10:34.0", "2018-11-04 02:10:34.0", "2018-11-04 03:10:34.0", "2020-03-11 01:10:34.0", "2020-03-11 02:10:34.0", "2020-03-11 03:10:34.0", "2020-11-01 01:10:34.0", "2020-11-01 02:10:34.0", "2020-11-01 03:10:34.0");
                List testTimestampLTZValues = Arrays.asList({"2018-03-11 01:10:34.0123456", "2018-03-11 01:10:34.0123456"}, {"2018-03-11 02:10:34.0", "2018-03-11 01:10:34.0"}, {"2018-03-11 03:10:34.0", "2018-03-11 03:10:34.0"}, {"2018-11-04 01:10:34.0", "2018-11-04 01:10:34.0"}, {"2018-11-04 02:10:34.0", "2018-11-04 02:10:34.0"}, {"2018-11-04 03:10:34.0", "2018-11-04 03:10:34.0"}, {"2020-03-11 01:10:34.0", "2020-03-11 01:10:34.0"}, {"2020-03-11 02:10:34.0", "2020-03-11 02:10:34.0"}, {"2020-03-11 03:10:34.0", "2020-03-11 03:10:34.0"}, {"2020-11-01 01:10:34.0", "2020-11-01 01:10:34.0"}, {"2020-11-01 02:10:34.0", "2020-11-01 02:10:34.0"}, {"2020-11-01 03:10:34.0", "2020-11-01 03:10:34.0"});
                List<String> testTimestampTZValues = Arrays.asList("2018-03-11 01:10:34.0 +0200", "2018-03-11 02:10:34.0 +0200", "2018-03-11 03:10:34.0 +0200", "2018-11-04 01:10:34.0 +0200", "2018-11-04 02:10:34.0 +0200", "2018-11-04 03:10:34.0 +0200", "2020-03-11 01:10:34.0 +0200", "2020-03-11 02:10:34.0 +0200", "2020-03-11 03:10:34.0 +0200", "2020-11-01 01:10:34.0 +0200", "2020-11-01 02:10:34.0 +0200", "2020-11-01 03:10:34.0 +0200");
                for (int i = 0; i < testTimestampNTZValues.size(); ++i) {
                    st.execute("insert into src_ts(col1,col2,col3) values('" + testTimestampNTZValues.get(i) + "', '" + ((String[])testTimestampLTZValues.get(i))[0] + "', '" + testTimestampTZValues.get(i) + "')");
                }
                ResultSet resultSet = st.executeQuery("select col1, col2, col3 from src_ts");
                int j = 0;
                while (resultSet.next()) {
                    Object data1 = resultSet.getObject(1);
                    Assert.assertEquals((Object)testTimestampNTZValues.get(j), (Object)data1.toString());
                    Object data2 = resultSet.getObject(2);
                    Assert.assertEquals((Object)((String[])testTimestampLTZValues.get(j))[1], (Object)data2.toString());
                    Object data3 = resultSet.getObject(3);
                    Assert.assertThat((Object)data3, (Matcher)IsInstanceOf.instanceOf(Timestamp.class));
                    Assert.assertEquals((long)this.parseTimestampTZ(testTimestampTZValues.get(j)).toEpochSecond(), (long)(((Timestamp)data3).getTime() / 1000L));
                    ++j;
                }
            }
        }
        finally {
            TimeZone.setDefault(origTz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestTimestampNTZBinding() throws SQLException {
        TimeZone origTz = TimeZone.getDefault();
        try (Connection con = this.init();){
            TimeZone.setDefault(TimeZone.getTimeZone("PST"));
            Statement st = con.createStatement();
            st.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_NTZ");
            st.execute("alter session set JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC=true");
            st.execute("create or replace table src_ts(col1 TIMESTAMP_NTZ)");
            PreparedStatement prepst = con.prepareStatement("insert into src_ts values(?)");
            Timestamp tz = Timestamp.valueOf("2018-03-11 01:10:34.0");
            prepst.setTimestamp(1, tz);
            prepst.execute();
            ResultSet resultSet = st.executeQuery("SELECT COL1 FROM SRC_TS");
            int i = 1;
            while (resultSet.next()) {
                Object data = resultSet.getObject(i);
                System.out.println(data.toString());
            }
        }
        finally {
            TimeZone.setDefault(origTz);
        }
    }
}

