/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Pattern;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.ResultSet0IT;
import net.snowflake.client.jdbc.SnowflakeChunkDownloader;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.jdbc.SnowflakeResultSetV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.jdbc.telemetry.TelemetryField;
import net.snowflake.common.core.SFBinary;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryResultSet.class})
public class ResultSetLatestIT
extends ResultSet0IT {
    public ResultSetLatestIT() {
        this("json");
    }

    ResultSetLatestIT(String queryResultFormat) {
        super(queryResultFormat);
    }

    @Test
    public void testMemoryClearingAfterInterrupt() throws Throwable {
        ResultSet resultSet = null;
        Connection connection = ResultSetLatestIT.getConnection();
        Statement statement = connection.createStatement();
        long initialMemoryUsage = SnowflakeChunkDownloader.getCurrentMemoryUsage();
        try {
            SnowflakeChunkDownloader.setInjectedDownloaderException((Throwable)new InterruptedException());
            resultSet = statement.executeQuery("select seq8(), randstr(1000, random()) from table(generator(rowcount => 10000))");
            MatcherAssert.assertThat((String)"hold memory usage for the resultSet before close", (SnowflakeChunkDownloader.getCurrentMemoryUsage() - initialMemoryUsage >= 0L ? 1 : 0) != 0);
            resultSet.close();
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (SQLException ex) {
            Assert.assertEquals((long)ErrorCode.INTERRUPTED.getMessageCode().intValue(), (long)ex.getErrorCode());
            MatcherAssert.assertThat((String)"closing statement didn't release memory allocated for result", (Object)SnowflakeChunkDownloader.getCurrentMemoryUsage(), (Matcher)CoreMatchers.equalTo((Object)initialMemoryUsage));
        }
        SnowflakeChunkDownloader.setInjectedDownloaderException(null);
        this.closeSQLObjects(resultSet, statement, connection);
    }

    @Test
    public void testChunkDownloaderNoHang() throws SQLException {
        int i;
        int stmtCount = 30;
        int rowCount = 170000;
        Connection connection = ResultSetLatestIT.getConnection();
        ArrayList<ResultSet> rsList = new ArrayList<ResultSet>();
        connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().setMemoryLimitForTesting(2000000L);
        for (i = 0; i < stmtCount; ++i) {
            Statement stmt = connection.createStatement();
            ResultSet resultSet = stmt.executeQuery("select randstr(100, random()) from table(generator(rowcount => " + rowCount + "))");
            rsList.add(resultSet);
        }
        for (i = 0; i < stmtCount; ++i) {
            ((ResultSet)rsList.get(i)).next();
            Assert.assertTrue((boolean)Pattern.matches("[a-zA-Z0-9]{100}", ((ResultSet)rsList.get(i)).getString(1)));
            ((ResultSet)rsList.get(i)).close();
        }
        connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().setMemoryLimitForTesting(SFBaseSession.MEMORY_LIMIT_UNSET);
        connection.close();
    }

    @Test
    public void testChunkDownloaderSetRetry() throws SQLException {
        int stmtCount = 3;
        int rowCount = 170000;
        Connection connection = ResultSetLatestIT.getConnection();
        connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().setMemoryLimitForTesting(0x100000L);
        connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().setOtherParameter("JDBC_CHUNK_DOWNLOADER_MAX_RETRY", (Object)1);
        for (int i = 0; i < stmtCount; ++i) {
            Statement stmt = connection.createStatement();
            ResultSet resultSet = stmt.executeQuery("select randstr(100, random()) from table(generator(rowcount => " + rowCount + "))");
            for (int j = 0; j < rowCount / 2; ++j) {
                resultSet.next();
            }
            Assert.assertTrue((boolean)Pattern.matches("[a-zA-Z0-9]{100}", resultSet.getString(1)));
        }
        connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().setOtherParameter("JDBC_CHUNK_DOWNLOADER_MAX_RETRY", (Object)10);
        connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().setMemoryLimitForTesting(SFBaseSession.MEMORY_LIMIT_UNSET);
        connection.close();
    }

    @Test
    public void testMetadataAPIMetricCollection() throws SQLException {
        Connection con = this.init();
        Telemetry telemetry = con.unwrap(SnowflakeConnectionV1.class).getSfSession().getTelemetryClient();
        DatabaseMetaData metadata = con.getMetaData();
        metadata.getColumns("fakecatalog", "fakeschema", null, null);
        LinkedList logs = ((TelemetryClient)telemetry).logBuffer();
        Assert.assertEquals((long)logs.size(), (long)1L);
        Assert.assertEquals((Object)((TelemetryData)logs.get(0)).getMessage().get("type").textValue(), (Object)TelemetryField.METADATA_METRICS.toString());
        Assert.assertEquals((Object)((TelemetryData)logs.get(0)).getMessage().get("function_name").textValue(), (Object)"getColumns");
        Assert.assertTrue((boolean)Pattern.matches("[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}", ((TelemetryData)logs.get(0)).getMessage().get("query_id").textValue()));
        JsonNode parameterValues = ((TelemetryData)logs.get(0)).getMessage().get("function_parameters");
        Assert.assertEquals((Object)parameterValues.get("catalog").textValue(), (Object)"fakecatalog");
        Assert.assertEquals((Object)parameterValues.get("schema").textValue(), (Object)"fakeschema");
        Assert.assertNull((Object)parameterValues.get("general_name_pattern").textValue());
        Assert.assertNull((Object)parameterValues.get("specific_name_pattern").textValue());
        telemetry.sendBatchAsync();
        String catalog = con.getCatalog();
        String schema = con.getSchema();
        metadata.getColumns(catalog, schema, null, null);
        logs = ((TelemetryClient)telemetry).logBuffer();
        Assert.assertEquals((long)logs.size(), (long)2L);
        Assert.assertEquals((Object)((TelemetryData)logs.get(0)).getMessage().get("type").textValue(), (Object)TelemetryField.TIME_CONSUME_FIRST_RESULT.toString());
        Assert.assertEquals((Object)((TelemetryData)logs.get(1)).getMessage().get("type").textValue(), (Object)TelemetryField.METADATA_METRICS.toString());
        Assert.assertEquals((Object)((TelemetryData)logs.get(1)).getMessage().get("function_name").textValue(), (Object)"getColumns");
        Assert.assertTrue((boolean)Pattern.matches("[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}", ((TelemetryData)logs.get(1)).getMessage().get("query_id").textValue()));
        parameterValues = ((TelemetryData)logs.get(1)).getMessage().get("function_parameters");
        Assert.assertEquals((Object)parameterValues.get("catalog").textValue(), (Object)catalog);
        Assert.assertEquals((Object)parameterValues.get("schema").textValue(), (Object)schema);
        Assert.assertNull((Object)parameterValues.get("general_name_pattern").textValue());
        Assert.assertNull((Object)parameterValues.get("specific_name_pattern").textValue());
    }

    @Test
    public void testGetCharacterStreamNull() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table JDBC_NULL_CHARSTREAM (col1 varchar(16))");
        statement.execute("insert into JDBC_NULL_CHARSTREAM values(NULL)");
        ResultSet rs = statement.executeQuery("select * from JDBC_NULL_CHARSTREAM");
        rs.next();
        Assert.assertNull((Object)rs.getCharacterStream(1));
        rs.close();
        connection.close();
    }

    @Test
    public void testMultipleChunks() throws Exception {
        int i;
        Connection con = this.init();
        Statement statement = con.createStatement();
        ResultSet resultSet = statement.executeQuery("select seq8(), randstr(1000, random()) from table(generator(rowcount => 10000))");
        int cnt = 0;
        while (resultSet.next()) {
            ++cnt;
        }
        Assert.assertTrue((cnt >= 0 ? 1 : 0) != 0);
        Telemetry telemetry = con.unwrap(SnowflakeConnectionV1.class).getSfSession().getTelemetryClient();
        LinkedList logs = ((TelemetryClient)telemetry).logBuffer();
        TelemetryField[] expectedFields = new TelemetryField[]{TelemetryField.TIME_CONSUME_FIRST_RESULT, TelemetryField.TIME_CONSUME_LAST_RESULT, TelemetryField.TIME_WAITING_FOR_CHUNKS, TelemetryField.TIME_DOWNLOADING_CHUNKS, TelemetryField.TIME_PARSING_CHUNKS};
        boolean[] succeeded = new boolean[expectedFields.length];
        block1: for (i = 0; i < expectedFields.length; ++i) {
            succeeded[i] = false;
            for (TelemetryData log : logs) {
                if (!log.getMessage().get("type").textValue().equals(expectedFields[i].field)) continue;
                succeeded[i] = true;
                continue block1;
            }
        }
        for (i = 0; i < expectedFields.length; ++i) {
            MatcherAssert.assertThat((String)String.format("%s field not found in telemetry logs\n", expectedFields[i].field), (boolean)succeeded[i]);
        }
        telemetry.sendBatchAsync();
    }

    @Test
    public void testResultSetMetadata() throws SQLException {
        Connection connection = this.init();
        Map<String, String> params = ResultSetLatestIT.getConnectionParameters();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_rsmd(colA number(20, 5), colB string)");
        statement.execute("insert into test_rsmd values(1.00, 'str'),(2.00, 'str2')");
        ResultSet resultSet = statement.executeQuery("select * from test_rsmd");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((Object)params.get("database").toUpperCase(), (Object)resultSetMetaData.getCatalogName(1).toUpperCase());
        Assert.assertEquals((Object)params.get("schema").toUpperCase(), (Object)resultSetMetaData.getSchemaName(1).toUpperCase());
        Assert.assertEquals((Object)"TEST_RSMD", (Object)resultSetMetaData.getTableName(1));
        Assert.assertEquals((Object)String.class.getName(), (Object)resultSetMetaData.getColumnClassName(2));
        Assert.assertEquals((long)2L, (long)resultSetMetaData.getColumnCount());
        Assert.assertEquals((long)22L, (long)resultSetMetaData.getColumnDisplaySize(1));
        Assert.assertEquals((Object)"COLA", (Object)resultSetMetaData.getColumnLabel(1));
        Assert.assertEquals((Object)"COLA", (Object)resultSetMetaData.getColumnName(1));
        Assert.assertEquals((long)3L, (long)resultSetMetaData.getColumnType(1));
        Assert.assertEquals((Object)"NUMBER", (Object)resultSetMetaData.getColumnTypeName(1));
        Assert.assertEquals((long)20L, (long)resultSetMetaData.getPrecision(1));
        Assert.assertEquals((long)5L, (long)resultSetMetaData.getScale(1));
        Assert.assertFalse((boolean)resultSetMetaData.isAutoIncrement(1));
        Assert.assertFalse((boolean)resultSetMetaData.isCaseSensitive(1));
        Assert.assertFalse((boolean)resultSetMetaData.isCurrency(1));
        Assert.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(1));
        Assert.assertEquals((long)1L, (long)resultSetMetaData.isNullable(1));
        Assert.assertTrue((boolean)resultSetMetaData.isReadOnly(1));
        Assert.assertTrue((boolean)resultSetMetaData.isSearchable(1));
        Assert.assertTrue((boolean)resultSetMetaData.isSigned(1));
        SnowflakeResultSetMetaData secretMetaData = resultSetMetaData.unwrap(SnowflakeResultSetMetaData.class);
        List colNames = secretMetaData.getColumnNames();
        Assert.assertEquals((Object)"COLA", colNames.get(0));
        Assert.assertEquals((Object)"COLB", colNames.get(1));
        Assert.assertEquals((long)3L, (long)secretMetaData.getInternalColumnType(1));
        Assert.assertEquals((long)12L, (long)secretMetaData.getInternalColumnType(2));
        Assert.assertTrue((boolean)Pattern.matches("[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}", secretMetaData.getQueryID()));
        statement.execute("drop table if exists test_rsmd");
        statement.close();
        connection.close();
    }

    @Test
    public void testEmptyResultSet() throws SQLException {
        Connection con = this.init();
        Statement statement = con.createStatement();
        ResultSet rs = statement.getGeneratedKeys();
        Assert.assertFalse((boolean)rs.next());
        Assert.assertFalse((boolean)rs.isClosed());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertEquals((long)0L, (long)rs.getInt("col1"));
        Assert.assertEquals((long)0L, (long)rs.getLong(2));
        Assert.assertEquals((long)0L, (long)rs.getLong("col2"));
        Assert.assertEquals((long)0L, (long)rs.getShort(3));
        Assert.assertEquals((long)0L, (long)rs.getShort("col3"));
        Assert.assertEquals((Object)"", (Object)rs.getString(4));
        Assert.assertEquals((Object)"", (Object)rs.getString("col4"));
        Assert.assertEquals((double)0.0, (double)rs.getDouble(5), (double)0.0);
        Assert.assertEquals((double)0.0, (double)rs.getDouble("col5"), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)rs.getFloat(6), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)rs.getFloat("col6"), (float)0.0f);
        Assert.assertEquals((Object)false, (Object)rs.getBoolean(7));
        Assert.assertEquals((Object)false, (Object)rs.getBoolean("col7"));
        Assert.assertEquals((long)0L, (long)rs.getByte(8));
        Assert.assertEquals((long)0L, (long)rs.getByte("col8"));
        Assert.assertEquals(null, (Object)rs.getBinaryStream(9));
        Assert.assertEquals(null, (Object)rs.getBinaryStream("col9"));
        Assert.assertEquals(null, (Object)rs.getDate(10));
        Assert.assertEquals(null, (Object)rs.getDate(10, (Calendar)new BaseJDBCTest.FakeCalendar()));
        Assert.assertEquals(null, (Object)rs.getDate("col10"));
        Assert.assertEquals(null, (Object)rs.getDate("col10", (Calendar)new BaseJDBCTest.FakeCalendar()));
        Assert.assertEquals(null, (Object)rs.getTime(11));
        Assert.assertEquals(null, (Object)rs.getTime(11, (Calendar)new BaseJDBCTest.FakeCalendar()));
        Assert.assertEquals(null, (Object)rs.getTime("col11"));
        Assert.assertEquals(null, (Object)rs.getTime("col11", (Calendar)new BaseJDBCTest.FakeCalendar()));
        Assert.assertEquals(null, (Object)rs.getTimestamp(12));
        Assert.assertEquals(null, (Object)rs.getTimestamp(12, (Calendar)new BaseJDBCTest.FakeCalendar()));
        Assert.assertEquals(null, (Object)rs.getTimestamp("col12"));
        Assert.assertEquals(null, (Object)rs.getTimestamp("col12", (Calendar)new BaseJDBCTest.FakeCalendar()));
        Assert.assertEquals(null, (Object)rs.getDate(13));
        Assert.assertEquals(null, (Object)rs.getDate("col13"));
        Assert.assertEquals(null, (Object)rs.getAsciiStream(14));
        Assert.assertEquals(null, (Object)rs.getAsciiStream("col14"));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])rs.getBytes(15));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])rs.getBytes("col15"));
        Assert.assertNull((Object)rs.getBigDecimal(16));
        Assert.assertNull((Object)rs.getBigDecimal(16, 38));
        Assert.assertNull((Object)rs.getBigDecimal("col16"));
        Assert.assertNull((Object)rs.getBigDecimal("col16", 38));
        Assert.assertNull((Object)rs.getRef(17));
        Assert.assertNull((Object)rs.getRef("col17"));
        Assert.assertNull((Object)rs.getArray(18));
        Assert.assertNull((Object)rs.getArray("col18"));
        Assert.assertNull((Object)rs.getBlob(19));
        Assert.assertNull((Object)rs.getBlob("col19"));
        Assert.assertNull((Object)rs.getClob(20));
        Assert.assertNull((Object)rs.getClob("col20"));
        Assert.assertEquals((long)0L, (long)rs.findColumn("col1"));
        Assert.assertNull((Object)rs.getUnicodeStream(21));
        Assert.assertNull((Object)rs.getUnicodeStream("col21"));
        Assert.assertNull((Object)rs.getURL(22));
        Assert.assertNull((Object)rs.getURL("col22"));
        Assert.assertNull((Object)rs.getObject(23));
        Assert.assertNull((Object)rs.getObject("col24"));
        Assert.assertNull((Object)rs.getObject(23, SnowflakeResultSetV1.class));
        Assert.assertNull((Object)rs.getObject("col23", SnowflakeResultSetV1.class));
        Assert.assertNull((Object)rs.getNString(25));
        Assert.assertNull((Object)rs.getNString("col25"));
        Assert.assertNull((Object)rs.getNClob(26));
        Assert.assertNull((Object)rs.getNClob("col26"));
        Assert.assertNull((Object)rs.getNCharacterStream(27));
        Assert.assertNull((Object)rs.getNCharacterStream("col27"));
        Assert.assertNull((Object)rs.getCharacterStream(28));
        Assert.assertNull((Object)rs.getCharacterStream("col28"));
        Assert.assertNull((Object)rs.getSQLXML(29));
        Assert.assertNull((Object)rs.getSQLXML("col29"));
        Assert.assertNull((Object)rs.getStatement());
        Assert.assertNull((Object)rs.getWarnings());
        Assert.assertNull((Object)rs.getCursorName());
        Assert.assertNull((Object)rs.getMetaData());
        Assert.assertNull((Object)rs.getRowId(1));
        Assert.assertNull((Object)rs.getRowId("col1"));
        Assert.assertEquals((long)0L, (long)rs.getRow());
        Assert.assertEquals((long)0L, (long)rs.getFetchDirection());
        Assert.assertEquals((long)0L, (long)rs.getFetchSize());
        Assert.assertEquals((long)0L, (long)rs.getType());
        Assert.assertEquals((long)0L, (long)rs.getConcurrency());
        Assert.assertEquals((long)0L, (long)rs.getHoldability());
        Assert.assertNull((Object)rs.unwrap(SnowflakeResultSetV1.class));
        Assert.assertFalse((boolean)rs.isWrapperFor(SnowflakeResultSetV1.class));
        Assert.assertFalse((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.isFirst());
        Assert.assertFalse((boolean)rs.isBeforeFirst());
        Assert.assertFalse((boolean)rs.isLast());
        Assert.assertFalse((boolean)rs.isAfterLast());
        Assert.assertFalse((boolean)rs.first());
        Assert.assertFalse((boolean)rs.last());
        Assert.assertFalse((boolean)rs.previous());
        Assert.assertFalse((boolean)rs.rowUpdated());
        Assert.assertFalse((boolean)rs.rowInserted());
        Assert.assertFalse((boolean)rs.rowDeleted());
        Assert.assertFalse((boolean)rs.absolute(1));
        Assert.assertFalse((boolean)rs.relative(1));
        rs.close();
        Assert.assertTrue((boolean)rs.isClosed());
        statement.close();
        con.close();
    }

    @Test
    public void testBytesCrossTypeTests() throws Exception {
        int i;
        ResultSet resultSet = this.numberCrossTesting();
        resultSet.next();
        for (i = 1; i < 13; ++i) {
            Assert.assertArrayEquals(null, (byte[])resultSet.getBytes(i));
        }
        resultSet.next();
        Assert.assertArrayEquals((byte[])this.intToByteArray(2), (byte[])resultSet.getBytes(1));
        Assert.assertArrayEquals((byte[])this.intToByteArray(5), (byte[])resultSet.getBytes(2));
        Assert.assertArrayEquals((byte[])this.floatToByteArray(3.5f), (byte[])resultSet.getBytes(3));
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])resultSet.getBytes(4));
        Assert.assertArrayEquals((byte[])new byte[]{49}, (byte[])resultSet.getBytes(5));
        Assert.assertArrayEquals((byte[])"1".getBytes(), (byte[])resultSet.getBytes(6));
        for (i = 7; i < 12; ++i) {
            try {
                resultSet.getBytes(i);
                Assert.fail((String)("Failing on " + i));
                continue;
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)200038L, (long)ex.getErrorCode());
            }
        }
        byte[] decoded = SFBinary.fromHex((String)"48454C4C4F").getBytes();
        Assert.assertArrayEquals((byte[])decoded, (byte[])resultSet.getBytes(12));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testResultChunkDownloaderException() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        String query = "select current_date(), true,2345234, 2343.0, 'testrgint\\n\\t' from table(generator(rowcount=>10000))";
        ResultSet resultSet = statement.executeQuery(query);
        resultSet.next();
        try {
            SnowflakeChunkDownloader.setInjectedDownloaderException((Throwable)new OutOfMemoryError("Fake OOM error for testing"));
            resultSet = statement.executeQuery(query);
            try {
                while (resultSet.next()) {
                }
                Assert.fail((String)"Should not reach here. Last next() command is supposed to throw an exception");
            }
            catch (SnowflakeSQLException snowflakeSQLException) {
                // empty catch block
            }
        }
        finally {
            SnowflakeChunkDownloader.setInjectedDownloaderException(null);
        }
        statement.close();
        connection.close();
    }

    @Test
    public void testGetObjectWithBigInt() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("alter session set jdbc_query_result_format ='json'");
        String[] extremeNumbers = new String[]{"99999999999999999999999999999999999999", "-99999999999999999999999999999999999999"};
        for (int i = 0; i < extremeNumbers.length; ++i) {
            ResultSet resultSet = statement.executeQuery("select " + extremeNumbers[i]);
            resultSet.next();
            Assert.assertEquals((long)-5L, (long)resultSet.getMetaData().getColumnType(1));
            Assert.assertEquals((Object)new BigDecimal(extremeNumbers[i]), (Object)resultSet.getObject(1));
        }
        statement.close();
        connection.close();
    }

    private byte[] intToByteArray(int i) {
        return BigInteger.valueOf(i).toByteArray();
    }

    private byte[] floatToByteArray(float i) {
        return ByteBuffer.allocate(8).putDouble(0, i).array();
    }

    @Test
    public void testGetBigDecimalWithScale() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_get(colA number(38,9))");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into test_get values(?)");
        preparedStatement.setBigDecimal(1, null);
        preparedStatement.addBatch();
        BigDecimal bigDecimal = new BigDecimal("100000000.123456789");
        preparedStatement.setBigDecimal(1, bigDecimal);
        preparedStatement.addBatch();
        preparedStatement.executeBatch();
        ResultSet resultSet = statement.executeQuery("select * from test_get");
        resultSet.next();
        Assert.assertEquals(null, (Object)resultSet.getBigDecimal(1, 5));
        Assert.assertEquals(null, (Object)resultSet.getBigDecimal("COLA", 5));
        resultSet.next();
        Assert.assertEquals((Object)bigDecimal.setScale(5, RoundingMode.HALF_UP), (Object)resultSet.getBigDecimal(1, 5));
        Assert.assertEquals((Object)bigDecimal.setScale(5, RoundingMode.HALF_UP), (Object)resultSet.getBigDecimal("COLA", 5));
    }

    @Test
    public void testGetDataTypeWithTimestampTz() throws Exception {
        try (Connection connection = ResultSetLatestIT.getConnection();){
            Statement statement = connection.createStatement();
            statement.executeQuery("create or replace table ts_test(ts timestamp_tz)");
            ResultSet resultSet = statement.executeQuery("select * from ts_test");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((long)resultSetMetaData.getColumnType(1), (long)2014L);
            Assert.assertEquals((Object)resultSetMetaData.getColumnClassName(1), (Object)Timestamp.class.getName());
            SFBaseSession baseSession = connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession();
            Field field = SFBaseSession.class.getDeclaredField("enableReturnTimestampWithTimeZone");
            field.setAccessible(true);
            field.set(baseSession, false);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select * from ts_test");
            resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((long)resultSetMetaData.getColumnType(1), (long)93L);
        }
    }

    @Test
    public void testGetEmptyOrNullClob() throws SQLException {
        Connection connection = this.init();
        Clob clob = connection.createClob();
        clob.setString(1L, "hello world");
        Clob emptyClob = connection.createClob();
        emptyClob.setString(1L, "");
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_get_clob(colA varchar, colNull varchar, colEmpty text)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into test_get_clob values(?, ?, ?)");
        preparedStatement.setClob(1, clob);
        preparedStatement.setString(2, null);
        preparedStatement.setClob(3, emptyClob);
        preparedStatement.execute();
        ResultSet resultSet = statement.executeQuery("select * from test_get_clob");
        resultSet.next();
        Assert.assertEquals((Object)"hello world", (Object)resultSet.getClob(1).toString());
        Assert.assertEquals((Object)"hello world", (Object)resultSet.getClob("COLA").toString());
        Assert.assertNull((Object)resultSet.getClob(2));
        Assert.assertNull((Object)resultSet.getClob("COLNULL"));
        Assert.assertEquals((Object)"", (Object)resultSet.getClob(3).toString());
        Assert.assertEquals((Object)"", (Object)resultSet.getClob("COLEMPTY").toString());
    }

    @Test
    public void testSetNullClob() throws SQLException {
        Connection connection = this.init();
        Clob clob = null;
        Statement statement = connection.createStatement();
        statement.execute("create or replace table test_set_clob(colNull varchar)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into test_set_clob values(?)");
        preparedStatement.setClob(1, clob);
        preparedStatement.execute();
        ResultSet resultSet = statement.executeQuery("select * from test_set_clob");
        resultSet.next();
        Assert.assertNull((Object)resultSet.getClob(1));
        Assert.assertNull((Object)resultSet.getClob("COLNULL"));
    }

    @Test
    public void testCallStatementType() throws SQLException {
        Properties props = new Properties();
        props.put("USE_STATEMENT_TYPE_CALL_FOR_STORED_PROC_CALLS", "true");
        try (Connection connection = ResultSetLatestIT.getConnection(props);
             Statement statement = connection.createStatement();){
            String sp = "CREATE OR REPLACE PROCEDURE \"SP_ZSDLEADTIME_ARCHIVE_DAILY\"()\nRETURNS VARCHAR(16777216)\nLANGUAGE SQL\nEXECUTE AS CALLER\nAS \n'\ndeclare\nresult varchar;\n \n    begin\n        BEGIN TRANSACTION;\n      \n        --Delete records older than 1 year\n        DELETE FROM MYTABLE1 WHERE ID < 5;\n       \n        --Insert new records\n        INSERT INTO MYTABLE1\n            (ID,\n            NAME\n            )\n            SELECT   \n            SEQ,FIRST_NAME\n            FROM MYCSVTABLE;\n        \nCOMMIT;\nresult := ''SUCCESS'';\nreturn result;\nexception\n    when other then\n        begin\n        ROLLBACK;\n            --Insert record about error\n            let line := ''sp-sql-msg: '' || SQLERRM || '' code : '' || SQLCODE;\n\n            let sp_name := ''SP_ZSDLEADTIME_ARCHIVE_DAILY'';\n            INSERT into MYTABLE1 values (1000, :line);\n        raise;\n    end;\nend;\n';";
            statement.execute("create or replace table MYCSVTABLE (SEQ int, FIRST_NAME string)");
            statement.execute("create or replace table MYTABLE1 (ID int, NAME string)");
            statement.execute(sp);
            CallableStatement cs = connection.prepareCall("CALL SP_ZSDLEADTIME_ARCHIVE_DAILY()");
            cs.execute();
            ResultSetMetaData resultSetMetaData = cs.getMetaData();
            Assert.assertEquals((Object)"SP_ZSDLEADTIME_ARCHIVE_DAILY", (Object)resultSetMetaData.getColumnName(1));
            Assert.assertEquals((Object)"VARCHAR", (Object)resultSetMetaData.getColumnTypeName(1));
            Assert.assertEquals((long)0L, (long)resultSetMetaData.getScale(1));
            Assert.assertEquals((long)0x1000000L, (long)resultSetMetaData.getPrecision(1));
            cs.close();
            statement.execute("drop procedure if exists SP_ZSDLEADTIME_ARCHIVE_DAILY()");
            statement.execute("drop table if exists MYTABLE1");
            statement.execute("drop table if exists MYCSVTABLE");
        }
    }

    @Test
    public void testNewFeaturesNotSupported() throws SQLException {
        Connection con = this.init();
        ResultSet rs = con.createStatement().executeQuery("select 1");
        try {
            rs.unwrap(SnowflakeResultSet.class).getQueryErrorMessage();
        }
        catch (SQLFeatureNotSupportedException ex) {
            Assert.assertEquals((Object)"This function is only supported for asynchronous queries.", (Object)ex.getMessage());
        }
        rs.close();
        con.close();
    }

    @Test
    public void testGetObjectJsonResult() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("alter session set jdbc_query_result_format ='json'");
        statement.execute("create or replace table testObj (colA double, colB boolean)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into testObj values(?, ?)");
        preparedStatement.setDouble(1, 22.2);
        preparedStatement.setBoolean(2, true);
        preparedStatement.executeQuery();
        ResultSet resultSet = statement.executeQuery("select * from testObj");
        resultSet.next();
        Assert.assertEquals((Object)22.2, (Object)resultSet.getObject(1));
        Assert.assertEquals((Object)true, (Object)resultSet.getObject(2));
        statement.execute("drop table if exists testObj");
        statement.close();
        connection.close();
    }

    @Test
    public void testMetadataIsCaseSensitive() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        String sampleCreateTableWithAllColTypes = "CREATE or replace TABLE case_sensitive (  boolean_col BOOLEAN,  date_col DATE,  time_col TIME,  timestamp_col TIMESTAMP,  timestamp_ltz_col TIMESTAMP_LTZ,  timestamp_ntz_col TIMESTAMP_NTZ,  number_col NUMBER,  float_col FLOAT,  double_col DOUBLE,  binary_col BINARY,  geography_col GEOGRAPHY,  variant_col VARIANT,  object_col1 OBJECT,  array_col1 ARRAY,  text_col1 TEXT,  varchar_col VARCHAR(16777216),  char_col CHAR(16777216));";
        statement.execute(sampleCreateTableWithAllColTypes);
        ResultSet rs = statement.executeQuery("select * from case_sensitive");
        ResultSetMetaData metaData = rs.getMetaData();
        Assert.assertFalse((boolean)metaData.isCaseSensitive(1));
        Assert.assertFalse((boolean)metaData.isCaseSensitive(2));
        Assert.assertFalse((boolean)metaData.isCaseSensitive(3));
        Assert.assertFalse((boolean)metaData.isCaseSensitive(4));
        Assert.assertFalse((boolean)metaData.isCaseSensitive(5));
        Assert.assertFalse((boolean)metaData.isCaseSensitive(6));
        Assert.assertFalse((boolean)metaData.isCaseSensitive(7));
        Assert.assertFalse((boolean)metaData.isCaseSensitive(8));
        Assert.assertFalse((boolean)metaData.isCaseSensitive(9));
        Assert.assertFalse((boolean)metaData.isCaseSensitive(10));
        Assert.assertTrue((boolean)metaData.isCaseSensitive(11));
        Assert.assertTrue((boolean)metaData.isCaseSensitive(12));
        Assert.assertTrue((boolean)metaData.isCaseSensitive(13));
        Assert.assertTrue((boolean)metaData.isCaseSensitive(14));
        Assert.assertTrue((boolean)metaData.isCaseSensitive(15));
        Assert.assertTrue((boolean)metaData.isCaseSensitive(16));
        Assert.assertTrue((boolean)metaData.isCaseSensitive(17));
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testAutoIncrementJsonResult() throws SQLException {
        Properties paramProperties = new Properties();
        paramProperties.put("ENABLE_FIX_759900", (Object)true);
        Connection connection = this.init(paramProperties);
        Statement statement = connection.createStatement();
        statement.execute("alter session set jdbc_query_result_format ='json'");
        statement.execute("create or replace table auto_inc(id int autoincrement, name varchar(10), another_col int autoincrement)");
        statement.execute("insert into auto_inc(name) values('test1')");
        ResultSet resultSet = statement.executeQuery("select * from auto_inc");
        resultSet.next();
        ResultSetMetaData metaData = resultSet.getMetaData();
        Assert.assertTrue((boolean)metaData.isAutoIncrement(1));
        Assert.assertFalse((boolean)metaData.isAutoIncrement(2));
        Assert.assertTrue((boolean)metaData.isAutoIncrement(3));
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testAutoIncrementArrowResult() throws SQLException {
        Properties paramProperties = new Properties();
        paramProperties.put("ENABLE_FIX_759900", (Object)true);
        Connection connection = this.init(paramProperties);
        Statement statement = connection.createStatement();
        statement.execute("alter session set jdbc_query_result_format ='arrow'");
        statement.execute("create or replace table auto_inc(id int autoincrement, name varchar(10), another_col int autoincrement)");
        statement.execute("insert into auto_inc(name) values('test1')");
        ResultSet resultSet = statement.executeQuery("select * from auto_inc");
        resultSet.next();
        ResultSetMetaData metaData = resultSet.getMetaData();
        Assert.assertTrue((boolean)metaData.isAutoIncrement(1));
        Assert.assertFalse((boolean)metaData.isAutoIncrement(2));
        Assert.assertTrue((boolean)metaData.isAutoIncrement(3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGranularTimeFunctionsInSessionTimezone() throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = ResultSetLatestIT.getConnection();
            statement = connection.createStatement();
            statement.execute("create or replace table testGranularTime(t time)");
            statement.execute("insert into testGranularTime values ('10:10:10')");
            ResultSet resultSet = statement.executeQuery("select * from testGranularTime");
            resultSet.next();
            Assert.assertEquals((Object)Time.valueOf("10:10:10"), (Object)resultSet.getTime(1));
            Assert.assertEquals((long)10L, (long)resultSet.getTime(1).getHours());
            Assert.assertEquals((long)10L, (long)resultSet.getTime(1).getMinutes());
            Assert.assertEquals((long)10L, (long)resultSet.getTime(1).getSeconds());
            resultSet.close();
        }
        finally {
            statement.execute("drop table if exists testGranularTime");
            statement.close();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGranularTimeFunctionsInUTC() throws SQLException {
        Connection connection = null;
        Statement statement = null;
        TimeZone origTz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
        try {
            connection = ResultSetLatestIT.getConnection();
            statement = connection.createStatement();
            statement.execute("alter session set JDBC_USE_SESSION_TIMEZONE=false");
            statement.execute("create or replace table testGranularTime(t time)");
            statement.execute("insert into testGranularTime values ('10:10:10')");
            ResultSet resultSet = statement.executeQuery("select * from testGranularTime");
            resultSet.next();
            Assert.assertEquals((Object)Time.valueOf("02:10:10"), (Object)resultSet.getTime(1));
            Assert.assertEquals((long)2L, (long)resultSet.getTime(1).getHours());
            Assert.assertEquals((long)10L, (long)resultSet.getTime(1).getMinutes());
            Assert.assertEquals((long)10L, (long)resultSet.getTime(1).getSeconds());
            resultSet.close();
        }
        finally {
            TimeZone.setDefault(origTz);
            statement.execute("drop table if exists testGranularTime");
            statement.close();
            connection.close();
        }
    }
}

