/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Properties;
import java.util.TimeZone;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryResultSet;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={TestCategoryResultSet.class})
public class ResultSetMultiTimeZoneIT
extends BaseJDBCTest {
    private final String queryResultFormat;

    @Parameterized.Parameters(name="format={0}, tz={1}")
    public static Collection<Object[]> data() {
        String[] timeZones = new String[]{"UTC", "Asia/Singapore", "MEZ"};
        String[] queryFormats = new String[]{"json", "arrow"};
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (String queryFormat : queryFormats) {
            for (String timeZone : timeZones) {
                ret.add(new Object[]{queryFormat, timeZone});
            }
        }
        return ret;
    }

    public ResultSetMultiTimeZoneIT(String queryResultFormat, String timeZone) {
        this.queryResultFormat = queryResultFormat;
        System.setProperty("user.timezone", timeZone);
    }

    public Connection init() throws SQLException {
        Connection connection = BaseJDBCTest.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("alter session set TIMEZONE='America/Los_Angeles',TIMESTAMP_TYPE_MAPPING='TIMESTAMP_LTZ',TIMESTAMP_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_TZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_LTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_NTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM'");
        statement.close();
        connection.createStatement().execute("alter session set jdbc_query_result_format = '" + this.queryResultFormat + "'");
        return connection;
    }

    public Connection init(Properties paramProperties) throws SQLException {
        Connection conn = ResultSetMultiTimeZoneIT.getConnection(0, paramProperties, false, false);
        Statement stmt = conn.createStatement();
        stmt.execute("alter session set jdbc_query_result_format = '" + this.queryResultFormat + "'");
        stmt.close();
        return conn;
    }

    @Before
    public void setUp() throws SQLException {
        Connection con = this.init();
        con.createStatement().execute("create or replace table test_rs (colA string)");
        con.createStatement().execute("insert into test_rs values('rowOne')");
        con.createStatement().execute("insert into test_rs values('rowTwo')");
        con.createStatement().execute("insert into test_rs values('rowThree')");
        Statement statement = con.createStatement();
        statement.execute("create or replace table orders_jdbc(C1 STRING NOT NULL COMMENT 'JDBC', C2 STRING, C3 STRING, C4 STRING, C5 STRING, C6 STRING, C7 STRING, C8 STRING, C9 STRING) stage_file_format = (field_delimiter='|' error_on_column_count_mismatch=false)");
        Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + ResultSetMultiTimeZoneIT.getFullPathFileInResource("orders_100.csv") + " @%orders_jdbc"));
        Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + ResultSetMultiTimeZoneIT.getFullPathFileInResource("orders_101.csv") + " @%orders_jdbc"));
        int numRows = statement.executeUpdate("copy into orders_jdbc");
        Assert.assertEquals((String)("Unexpected number of rows copied: " + numRows), (long)73L, (long)numRows);
        con.close();
    }

    @After
    public void tearDown() throws SQLException {
        System.clearProperty("user.timezone");
        Connection con = this.init();
        con.createStatement().execute("drop table if exists orders_jdbc");
        con.createStatement().execute("drop table if exists test_rs");
        con.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetDateAndTime() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table dateTime(colA Date, colB Timestamp, colC Time)");
        java.util.Date today = new java.util.Date();
        Date date = ResultSetMultiTimeZoneIT.buildDate(2016, 3, 20);
        Timestamp ts = new Timestamp(today.getTime());
        Time tm = new Time(12345678L);
        String insertTime = "insert into datetime values(?, ?, ?)";
        PreparedStatement prepStatement = connection.prepareStatement("insert into datetime values(?, ?, ?)");
        prepStatement.setDate(1, date);
        prepStatement.setTimestamp(2, ts);
        prepStatement.setTime(3, tm);
        prepStatement.execute();
        ResultSet resultSet = statement.executeQuery("select * from datetime");
        resultSet.next();
        Assert.assertEquals((Object)date, (Object)resultSet.getDate(1));
        Assert.assertEquals((Object)date, (Object)resultSet.getDate("COLA"));
        Assert.assertEquals((Object)ts, (Object)resultSet.getTimestamp(2));
        Assert.assertEquals((Object)ts, (Object)resultSet.getTimestamp("COLB"));
        Assert.assertEquals((Object)tm, (Object)resultSet.getTime(3));
        Assert.assertEquals((Object)tm, (Object)resultSet.getTime("COLC"));
        statement.execute("create or replace table datetime(colA timestamp_ltz, colB timestamp_ntz, colC timestamp_tz)");
        statement.execute("insert into dateTime values ('2019-01-01 17:17:17', '2019-01-01 17:17:17', '2019-01-01 17:17:17')");
        prepStatement = connection.prepareStatement("insert into datetime values(?, '2019-01-01 17:17:17', '2019-01-01 17:17:17')");
        Timestamp dateTime = new Timestamp(date.getTime());
        prepStatement.setTimestamp(1, dateTime);
        prepStatement.execute();
        resultSet = statement.executeQuery("select * from datetime");
        resultSet.next();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setTimeZone(TimeZone.getDefault());
        String d = formatter.format(resultSet.getDate("COLA"));
        Assert.assertEquals((Object)"2019-01-02 01:17:17", (Object)d);
        resultSet.next();
        Assert.assertEquals((Object)date, (Object)resultSet.getDate(1));
        Assert.assertEquals((Object)date, (Object)resultSet.getDate("COLA"));
        statement.execute("drop table if exists datetime");
        connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testTimeRange() throws SQLException {
        String insertTime = "insert into timeTest values (?), (?), (?), (?)";
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table timeTest (c1 time)");
        long ms1 = -2202968667333L;
        long ms2 = -1L;
        long ms3 = 86400000L;
        long ms4 = 1451680250123L;
        Time tm1 = new Time(ms1);
        Time tm2 = new Time(ms2);
        Time tm3 = new Time(ms3);
        Time tm4 = new Time(ms4);
        PreparedStatement prepStatement = connection.prepareStatement("insert into timeTest values (?), (?), (?), (?)");
        prepStatement.setTime(1, tm1);
        prepStatement.setTime(2, tm2);
        prepStatement.setTime(3, tm3);
        prepStatement.setTime(4, tm4);
        prepStatement.execute();
        long M = 86400000L;
        ResultSet resultSet = statement.executeQuery("select * from timeTest");
        resultSet.next();
        Assert.assertNotEquals((Object)tm1, (Object)resultSet.getTime(1));
        Assert.assertEquals((Object)new Time((ms1 % 86400000L + 86400000L) % 86400000L), (Object)resultSet.getTime(1));
        resultSet.next();
        Assert.assertNotEquals((Object)tm2, (Object)resultSet.getTime(1));
        Assert.assertEquals((Object)new Time((ms2 % 86400000L + 86400000L) % 86400000L), (Object)resultSet.getTime(1));
        resultSet.next();
        Assert.assertNotEquals((Object)tm3, (Object)resultSet.getTime(1));
        Assert.assertEquals((Object)new Time((ms3 % 86400000L + 86400000L) % 86400000L), (Object)resultSet.getTime(1));
        resultSet.next();
        Assert.assertNotEquals((Object)tm4, (Object)resultSet.getTime(1));
        Assert.assertEquals((Object)new Time((ms4 % 86400000L + 86400000L) % 86400000L), (Object)resultSet.getTime(1));
        statement.execute("drop table if exists timeTest");
        connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testCurrentTime() throws SQLException {
        String insertTime = "insert into datetime values (?, ?, ?)";
        Connection connection = this.init();
        Assert.assertFalse((boolean)connection.createStatement().execute("alter session set TIMEZONE='UTC'"));
        Statement statement = connection.createStatement();
        statement.execute("create or replace table datetime (d date, ts timestamp, tm time)");
        PreparedStatement prepStatement = connection.prepareStatement("insert into datetime values (?, ?, ?)");
        long currentMillis = System.currentTimeMillis();
        Date currentDate = new Date(currentMillis);
        Timestamp currentTS = new Timestamp(currentMillis);
        Time currentTime = new Time(currentMillis);
        prepStatement.setDate(1, currentDate);
        prepStatement.setTimestamp(2, currentTS);
        prepStatement.setTime(3, currentTime);
        prepStatement.execute();
        ResultSet resultSet = statement.executeQuery("select ts::date = d from datetime");
        resultSet.next();
        Assert.assertTrue((boolean)resultSet.getBoolean(1));
        resultSet = statement.executeQuery("select ts::time = tm from datetime");
        resultSet.next();
        Assert.assertTrue((boolean)resultSet.getBoolean(1));
        statement.execute("drop table if exists datetime");
        connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testBindTimestampTZ() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table testBindTimestampTZ(cola int, colb timestamp_tz)");
        long millSeconds = System.currentTimeMillis();
        Timestamp ts = new Timestamp(millSeconds);
        PreparedStatement prepStatement = connection.prepareStatement("insert into testBindTimestampTZ values (?, ?)");
        prepStatement.setInt(1, 123);
        prepStatement.setTimestamp(2, ts, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        prepStatement.execute();
        ResultSet resultSet = statement.executeQuery("select cola, colb from testBindTimestampTz");
        resultSet.next();
        MatcherAssert.assertThat((String)"integer", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)123));
        MatcherAssert.assertThat((String)"timestamp_tz", (Object)resultSet.getTimestamp(2), (Matcher)CoreMatchers.equalTo((Object)ts));
        statement.execute("drop table if exists testBindTimestampTZ");
        connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetOldDate() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table testOldDate(d date)");
        statement.execute("insert into testOldDate values ('0001-01-01'), (to_date('1000-01-01')), ('1300-01-01'), ('1400-02-02'), ('1500-01-01'), ('1600-02-03')");
        ResultSet resultSet = statement.executeQuery("select * from testOldDate order by d");
        resultSet.next();
        Assert.assertEquals((Object)"0001-01-01", (Object)resultSet.getString(1));
        Assert.assertEquals((Object)Date.valueOf("0001-01-01"), (Object)resultSet.getDate(1));
        resultSet.next();
        Assert.assertEquals((Object)"1000-01-01", (Object)resultSet.getString(1));
        Assert.assertEquals((Object)Date.valueOf("1000-01-01"), (Object)resultSet.getDate(1));
        resultSet.next();
        Assert.assertEquals((Object)"1300-01-01", (Object)resultSet.getString(1));
        Assert.assertEquals((Object)Date.valueOf("1300-01-01"), (Object)resultSet.getDate(1));
        resultSet.next();
        Assert.assertEquals((Object)"1400-02-02", (Object)resultSet.getString(1));
        Assert.assertEquals((Object)Date.valueOf("1400-02-02"), (Object)resultSet.getDate(1));
        resultSet.next();
        Assert.assertEquals((Object)"1500-01-01", (Object)resultSet.getString(1));
        Assert.assertEquals((Object)Date.valueOf("1500-01-01"), (Object)resultSet.getDate(1));
        resultSet.next();
        Assert.assertEquals((Object)"1600-02-03", (Object)resultSet.getString(1));
        Assert.assertEquals((Object)Date.valueOf("1600-02-03"), (Object)resultSet.getDate(1));
        resultSet.close();
        statement.execute("drop table if exists testOldDate");
        statement.close();
        connection.close();
    }

    @Test
    public void testGetStringForDates() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        String expectedDate1 = "2020-08-01";
        String expectedDate2 = "1920-11-11";
        ResultSet rs = statement.executeQuery("SELECT '" + expectedDate1 + "'::DATE as D1");
        rs.next();
        Assert.assertEquals((Object)expectedDate1, (Object)rs.getString(1));
        rs = statement.executeQuery("SELECT '" + expectedDate2 + "'::DATE as D1");
        rs.next();
        Assert.assertEquals((Object)expectedDate2, (Object)rs.getString(1));
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDateTimeRelatedTypeConversion() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table testDateTime(colDate DATE, colTS timestamp_ltz, colTime TIME, colString string)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into testDateTime values(?, ?, ?, ?)");
        Timestamp ts = ResultSetMultiTimeZoneIT.buildTimestamp(2016, 3, 20, 3, 25, 45, 67800000);
        Date date = ResultSetMultiTimeZoneIT.buildDate(2016, 3, 20);
        Time time = new Time(12345678L);
        preparedStatement.setDate(1, date);
        preparedStatement.setTimestamp(2, ts);
        preparedStatement.setTime(3, time);
        preparedStatement.setString(4, "aaa");
        preparedStatement.execute();
        ResultSet resultSet = statement.executeQuery("select * from testDateTime");
        resultSet.next();
        Assert.assertEquals((Object)date, (Object)resultSet.getDate("COLDATE"));
        try {
            resultSet.getDate("COLTIME");
            Assert.fail();
        }
        catch (SnowflakeSQLException e) {
            Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)e.getErrorCode());
            Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)e.getSQLState());
        }
        Assert.assertEquals((Object)new Timestamp(date.getTime()), (Object)resultSet.getTimestamp("COLDATE"));
        Assert.assertEquals((Object)ts, (Object)resultSet.getTimestamp("COLTS"));
        Assert.assertEquals((Object)new Timestamp(time.getTime()), (Object)resultSet.getTimestamp("COLTIME"));
        try {
            resultSet.getTimestamp("COLSTRING");
            Assert.fail();
        }
        catch (SnowflakeSQLException e) {
            Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)e.getErrorCode());
            Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)e.getSQLState());
        }
        try {
            resultSet.getTime("COLDATE");
            Assert.fail();
        }
        catch (SnowflakeSQLException e) {
            Assert.assertEquals((long)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode().intValue(), (long)e.getErrorCode());
            Assert.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)e.getSQLState());
        }
        Assert.assertEquals((Object)time, (Object)resultSet.getTime("COLTIME"));
        Assert.assertEquals((Object)new Time(ts.getTime()), (Object)resultSet.getTime("COLTS"));
        statement.execute("drop table if exists testDateTime");
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGetOldTimestamp() throws SQLException {
        Connection con = this.init();
        Statement statement = con.createStatement();
        statement.execute("create or replace table testOldTs(cola timestamp_ntz)");
        statement.execute("insert into testOldTs values ('1582-06-22 17:00:00'), ('1000-01-01 17:00:00')");
        ResultSet resultSet = statement.executeQuery("select * from testOldTs");
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getTimestamp(1).toString(), (Matcher)CoreMatchers.equalTo((Object)"1582-06-22 17:00:00.0"));
        MatcherAssert.assertThat((Object)resultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"Fri, 22 Jun 1582 17:00:00 Z"));
        resultSet.next();
        MatcherAssert.assertThat((Object)resultSet.getTimestamp(1).toString(), (Matcher)CoreMatchers.equalTo((Object)"1000-01-01 17:00:00.0"));
        MatcherAssert.assertThat((Object)resultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"Mon, 01 Jan 1000 17:00:00 Z"));
        statement.execute("drop table if exists testOldTs");
        statement.close();
        con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPrepareOldTimestamp() throws SQLException {
        TimeZone origTz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        try {
            Connection con = this.init();
            Statement statement = con.createStatement();
            statement.execute("create or replace table testPrepOldTs(cola timestamp_ntz, colb date)");
            statement.execute("alter session set client_timestamp_type_mapping=timestamp_ntz");
            PreparedStatement ps = con.prepareStatement("insert into testPrepOldTs values (?, ?)");
            ps.setTimestamp(1, Timestamp.valueOf("0001-01-01 08:00:00"));
            ps.setDate(2, Date.valueOf("0001-01-01"));
            ps.executeUpdate();
            ResultSet resultSet = statement.executeQuery("select * from testPrepOldTs");
            resultSet.next();
            MatcherAssert.assertThat((Object)resultSet.getTimestamp(1).toString(), (Matcher)CoreMatchers.equalTo((Object)"0001-01-01 08:00:00.0"));
            MatcherAssert.assertThat((Object)resultSet.getDate(2).toString(), (Matcher)CoreMatchers.equalTo((Object)"0001-01-01"));
            statement.execute("drop table if exists testPrepOldTs");
            statement.close();
            con.close();
        }
        finally {
            TimeZone.setDefault(origTz);
        }
    }
}

