/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.TimeZone;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryResultSet;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={TestCategoryResultSet.class})
public class ResultSetMultiTimeZoneLatestIT
extends BaseJDBCTest {
    private final String queryResultFormat;

    @Parameterized.Parameters(name="format={0}, tz={1}")
    public static Collection<Object[]> data() {
        String[] timeZones = new String[]{"UTC", "Asia/Singapore", "MEZ", "Europe/London"};
        String[] queryFormats = new String[]{"json", "arrow"};
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (String queryFormat : queryFormats) {
            for (String timeZone : timeZones) {
                ret.add(new Object[]{queryFormat, timeZone});
            }
        }
        return ret;
    }

    public ResultSetMultiTimeZoneLatestIT(String queryResultFormat, String timeZone) {
        this.queryResultFormat = queryResultFormat;
        System.setProperty("user.timezone", timeZone);
    }

    public Connection init() throws SQLException {
        Connection connection = BaseJDBCTest.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("alter session set TIMEZONE='America/Los_Angeles',TIMESTAMP_TYPE_MAPPING='TIMESTAMP_LTZ',TIMESTAMP_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_TZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_LTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_NTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM'");
        statement.close();
        connection.createStatement().execute("alter session set jdbc_query_result_format = '" + this.queryResultFormat + "'");
        return connection;
    }

    @Test
    public void testTimesWithGetTimestamp() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        String timeStringValue = "10:30:50.123456789";
        String timestampStringValue = "1970-01-01 " + timeStringValue;
        int length = timestampStringValue.length();
        statement.execute("create or replace table SRC_DATE_TIME (C2_TIME_3 TIME(3), C3_TIME_5 TIME(5), C4_TIME TIME(9))");
        statement.execute("insert into SRC_DATE_TIME values ('" + timeStringValue + "','" + timeStringValue + "','" + timeStringValue + "')");
        ResultSet rs = statement.executeQuery("select * from SRC_DATE_TIME");
        rs.next();
        Assert.assertEquals((Object)timestampStringValue.substring(0, length - 6), (Object)rs.getTimestamp(1).toString());
        Assert.assertEquals((Object)timestampStringValue.substring(0, length - 4), (Object)rs.getTimestamp(2).toString());
        Assert.assertEquals((Object)timestampStringValue, (Object)rs.getTimestamp(3).toString());
    }

    @Test
    public void testTimestampNTZWithDaylightSavings() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("alter session set TIMESTAMP_TYPE_MAPPING='TIMESTAMP_NTZ',TIMEZONE='Europe/London'");
        ResultSet rs = statement.executeQuery("select TIMESTAMP '2011-09-04 00:00:00'");
        rs.next();
        Timestamp expected = Timestamp.valueOf("2011-09-04 00:00:00");
        Assert.assertEquals((Object)expected, (Object)rs.getTimestamp(1));
        rs.close();
        statement.close();
        connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testDateAndTimestampWithTimezone() throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("alter session set JDBC_FORMAT_DATE_WITH_TIMEZONE=true");
        ResultSet rs = statement.executeQuery("SELECT DATE '1970-01-02 00:00:00' as datefield, TIMESTAMP '1970-01-02 00:00:00' as timestampfield");
        rs.next();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(cal.getTimeZone());
        Date dateWithZone = rs.getDate(1, cal);
        Timestamp timestampWithZone = rs.getTimestamp(2, cal);
        Assert.assertEquals((Object)sdf.format(dateWithZone), (Object)sdf.format(timestampWithZone));
        Assert.assertEquals((Object)rs.getTimestamp(1, cal), (Object)rs.getTimestamp(2, cal));
        Assert.assertEquals((Object)rs.getDate(1, cal), (Object)rs.getDate(2, cal));
        Assert.assertEquals((Object)"1970-01-02 00:00:00", (Object)sdf.format(rs.getDate(1)));
        Assert.assertEquals((Object)"1970-01-02 08:00:00", (Object)sdf.format(rs.getDate(2)));
        Assert.assertEquals((Object)"1970-01-02 08:00:00", (Object)sdf.format(rs.getTimestamp(2)));
        Assert.assertEquals((Object)"1970-01-02 00:00:00", (Object)sdf.format(rs.getTimestamp(1)));
        statement.execute("alter session set JDBC_FORMAT_DATE_WITH_TIMEZONE=false");
        rs = statement.executeQuery("SELECT DATE '1945-05-10 00:00:00' as datefield");
        rs.next();
        Assert.assertEquals((Object)rs.getDate(1, cal), (Object)rs.getDate(1));
        Assert.assertEquals((Object)"1945-05-10 00:00:00", (Object)sdf.format(rs.getDate(1, cal)));
        rs.close();
        statement.close();
        connection.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testSessionTimezoneUsage() throws SQLException {
        this.testUseSessionTimeZoneHelper(true);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testUseSessionTimeZoneOverrides() throws SQLException {
        this.testUseSessionTimeZoneHelper(false);
    }

    private void testUseSessionTimeZoneHelper(boolean useDefaultParamSettings) throws SQLException {
        Connection connection = this.init();
        Statement statement = connection.createStatement();
        statement.execute("create or replace table datetimetypes(colA timestamp_ltz, colB timestamp_ntz, colC timestamp_tz, colD time, colE date)");
        statement.execute("alter session set JDBC_USE_SESSION_TIMEZONE=true");
        if (!useDefaultParamSettings) {
            statement.execute("alter session set JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC=true");
            statement.execute("alter session set CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ=false");
            statement.execute("alter session set JDBC_FORMAT_DATE_WITH_TIMEZONE=true");
        }
        String expectedTimestamp = "2019-01-01 17:17:17.6";
        String expectedTime = "17:17:17";
        String expectedDate = "2019-01-01";
        String expectedTimestamp2 = "1943-12-31 01:01:33.0";
        String expectedTime2 = "01:01:33";
        String expectedDate2 = "1943-12-31";
        PreparedStatement prepSt = connection.prepareStatement("insert into datetimetypes values(?, ?, ?, ?, ?)");
        prepSt.setString(1, expectedTimestamp);
        prepSt.setString(2, expectedTimestamp);
        prepSt.setString(3, expectedTimestamp);
        prepSt.setString(4, expectedTime);
        prepSt.setString(5, expectedDate);
        prepSt.execute();
        prepSt.setString(1, expectedTimestamp2);
        prepSt.setString(2, expectedTimestamp2);
        prepSt.setString(3, expectedTimestamp2);
        prepSt.setString(4, expectedTime2);
        prepSt.setString(5, expectedDate2);
        prepSt.execute();
        ResultSet rs = statement.executeQuery("select * from datetimetypes");
        rs.next();
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate("COLA").toString());
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate("COLB").toString());
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate("COLC").toString());
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate("COLE").toString());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp("COLA").toString());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp("COLB").toString());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp("COLC").toString());
        Assert.assertEquals((Object)"1970-01-01 17:17:17.0", (Object)rs.getTimestamp("COLD").toString());
        Assert.assertEquals((Object)"2019-01-01 00:00:00.0", (Object)rs.getTimestamp("COLE").toString());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime("COLA").toString());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime("COLB").toString());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime("COLC").toString());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime("COLD").toString());
        rs.next();
        Assert.assertEquals((Object)expectedDate2, (Object)rs.getDate("COLA").toString());
        Assert.assertEquals((Object)expectedDate2, (Object)rs.getDate("COLB").toString());
        Assert.assertEquals((Object)expectedDate2, (Object)rs.getDate("COLC").toString());
        Assert.assertEquals((Object)expectedDate2, (Object)rs.getDate("COLE").toString());
        Assert.assertEquals((Object)expectedTimestamp2, (Object)rs.getTimestamp("COLA").toString());
        Assert.assertEquals((Object)expectedTimestamp2, (Object)rs.getTimestamp("COLB").toString());
        Assert.assertEquals((Object)expectedTimestamp2, (Object)rs.getTimestamp("COLC").toString());
        Assert.assertEquals((Object)"1970-01-01 01:01:33.0", (Object)rs.getTimestamp("COLD").toString());
        Assert.assertEquals((Object)"1943-12-31 00:00:00.0", (Object)rs.getTimestamp("COLE").toString());
        Assert.assertEquals((Object)expectedTime2, (Object)rs.getTime("COLA").toString());
        Assert.assertEquals((Object)expectedTime2, (Object)rs.getTime("COLB").toString());
        Assert.assertEquals((Object)expectedTime2, (Object)rs.getTime("COLC").toString());
        Assert.assertEquals((Object)expectedTime2, (Object)rs.getTime("COLD").toString());
        statement.execute("create or replace table tabletz (colA timestamp_tz)");
        prepSt = connection.prepareStatement("insert into tabletz values(?), (?)");
        prepSt.setString(1, expectedTimestamp + " +0500");
        prepSt.setString(2, expectedTimestamp2 + " -0200");
        prepSt.execute();
        rs = statement.executeQuery("select * from tabletz");
        rs.next();
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp("COLA").toString());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime("COLA").toString());
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate("COLA").toString());
        rs.next();
        Assert.assertEquals((Object)expectedTimestamp2, (Object)rs.getTimestamp("COLA").toString());
        Assert.assertEquals((Object)expectedTime2, (Object)rs.getTime("COLA").toString());
        Assert.assertEquals((Object)expectedDate2, (Object)rs.getDate("COLA").toString());
        statement.execute("alter session unset JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC");
        statement.execute("alter session unset CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ");
        statement.execute("alter session unset JDBC_FORMAT_DATE_WITH_TIMEZONE");
        statement.execute("alter session unset JDBC_USE_SESSION_TIMEZONE");
        rs.close();
        statement.close();
        connection.close();
    }
}

