/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Properties;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.SessionUtilExternalBrowser;
import net.snowflake.client.jdbc.FakeSessionUtilExternalBrowser;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.common.core.ClientAuthnDTO;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class SSOConnectionTest {
    private static final String MOCK_PROOF_KEY = "specialkey";
    private static final String MOCK_SSO_URL = "https://sso.someidp.net/";
    private static final String MOCK_MASTER_TOKEN = "MOCK_MASTER_TOKEN";
    private static final String MOCK_SESSION_TOKEN = "MOCK_SESSION_TOKEN";
    private static final String MOCK_ID_TOKEN = "MOCK_ID_TOKEN";
    private static final String MOCK_NEW_SESSION_TOKEN = "MOCK_NEW_SESSION_TOKEN";
    private static final String MOCK_NEW_MASTER_TOKEN = "MOCK_NEW_MASTER_TOKEN";
    private static final String ID_TOKEN_AUTHENTICATOR = "ID_TOKEN";
    private static ObjectMapper mapper = new ObjectMapper();

    private void initMock(MockedStatic<HttpUtil> mockedHttpUtil, MockedStatic<SessionUtilExternalBrowser> mockedSessionUtilExternalBrowser) throws Throwable {
        this.initMockHttpUtil(mockedHttpUtil);
        SFLoginInput loginInput = this.initMockLoginInput();
        this.initMockSessionUtilExternalBrowser(mockedSessionUtilExternalBrowser, loginInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode parseRequest(HttpPost post) throws IOException {
        String theString;
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            try (InputStream ins = post.getEntity().getContent();){
                IOUtils.copy((InputStream)ins, (Writer)writer, (String)"UTF-8");
            }
            theString = writer.toString();
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        JsonNode jsonNode = mapper.readTree(theString);
        return jsonNode;
    }

    private void initMockHttpUtil(MockedStatic<HttpUtil> mockedHttpUtil) throws IOException {
        final String retInitialSSO = mapper.writeValueAsString((Object)new HttpUtilResponseDTO(true, null, new HttpUtilResponseDataSSODTO(MOCK_PROOF_KEY, MOCK_SSO_URL)));
        final String retInitialAuthentication = mapper.writeValueAsString((Object)new HttpUtilResponseDTO(true, null, new HttpUtilResponseDataAuthDTO(MOCK_SESSION_TOKEN, MOCK_MASTER_TOKEN, MOCK_ID_TOKEN)));
        final String retSecondAuthentication = mapper.writeValueAsString((Object)new HttpUtilResponseDTO(true, null, new HttpUtilResponseDataAuthDTO(MOCK_NEW_SESSION_TOKEN, MOCK_NEW_MASTER_TOKEN, "")));
        mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)Mockito.any(HttpPost.class)), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (int)Mockito.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)Mockito.nullable(HttpClientSettingsKey.class)))).thenAnswer((Answer)new Answer<String>(){
            int callCount = 0;

            public String answer(InvocationOnMock invocation) throws IOException {
                String resp = "";
                Object[] args = invocation.getArguments();
                if (this.callCount == 0) {
                    resp = retInitialSSO;
                } else if (this.callCount == 1) {
                    JsonNode jsonNode = SSOConnectionTest.this.parseRequest((HttpPost)args[0]);
                    Assert.assertTrue((boolean)jsonNode.path("data").path("SESSION_PARAMETERS").path("CLIENT_STORE_TEMPORARY_CREDENTIAL").asBoolean());
                    MatcherAssert.assertThat((String)"authenticator", (Object)jsonNode.path("data").path("AUTHENTICATOR").asText(), (Matcher)CoreMatchers.equalTo((Object)ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER.name()));
                    resp = retInitialAuthentication;
                } else if (this.callCount == 2) {
                    JsonNode jsonNode = SSOConnectionTest.this.parseRequest((HttpPost)args[0]);
                    Assert.assertTrue((boolean)jsonNode.path("data").path("SESSION_PARAMETERS").path("CLIENT_STORE_TEMPORARY_CREDENTIAL").asBoolean());
                    MatcherAssert.assertThat((String)"authenticator", (Object)jsonNode.path("data").path("AUTHENTICATOR").asText(), (Matcher)CoreMatchers.equalTo((Object)SSOConnectionTest.ID_TOKEN_AUTHENTICATOR));
                    MatcherAssert.assertThat((String)"idToken", (Object)jsonNode.path("data").path("TOKEN").asText(), (Matcher)CoreMatchers.equalTo((Object)SSOConnectionTest.MOCK_ID_TOKEN));
                    resp = retSecondAuthentication;
                }
                ++this.callCount;
                return resp;
            }
        });
    }

    private void initMockSessionUtilExternalBrowser(MockedStatic<SessionUtilExternalBrowser> mockedSessionUtilExternalBrowser, SFLoginInput loginInput) {
        FakeSessionUtilExternalBrowser fakeExternalBrowser = new FakeSessionUtilExternalBrowser(loginInput);
        mockedSessionUtilExternalBrowser.when(() -> SessionUtilExternalBrowser.createInstance((SFLoginInput)((SFLoginInput)Mockito.any(SFLoginInput.class)))).thenReturn((Object)fakeExternalBrowser);
    }

    private SFLoginInput initMockLoginInput() {
        SFLoginInput loginInput = (SFLoginInput)Mockito.mock(SFLoginInput.class);
        Mockito.when((Object)loginInput.getServerUrl()).thenReturn((Object)"https://testaccount.snowflakecomputing.com/");
        Mockito.when((Object)loginInput.getAuthenticator()).thenReturn((Object)ClientAuthnDTO.AuthenticatorType.EXTERNALBROWSER.name());
        Mockito.when((Object)loginInput.getAccountName()).thenReturn((Object)"testaccount");
        Mockito.when((Object)loginInput.getUserName()).thenReturn((Object)"testuser");
        return loginInput;
    }

    @Test
    public void testIdTokenInSSO() throws Throwable {
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);
             MockedStatic mockedSessionUtilExternalBrowser = Mockito.mockStatic(SessionUtilExternalBrowser.class);){
            this.initMock((MockedStatic<HttpUtil>)mockedHttpUtil, (MockedStatic<SessionUtilExternalBrowser>)mockedSessionUtilExternalBrowser);
            SessionUtil.deleteIdTokenCache((String)"testaccount.snowflakecomputing.com", (String)"testuser");
            Properties properties = new Properties();
            properties.put("user", "testuser");
            properties.put("password", "testpassword");
            properties.put("account", "testaccount");
            properties.put("insecureMode", (Object)true);
            properties.put("authenticator", "externalbrowser");
            properties.put("CLIENT_STORE_TEMPORARY_CREDENTIAL", (Object)true);
            String url = "jdbc:snowflake://testaccount.snowflakecomputing.com";
            Connection con = DriverManager.getConnection(url, properties);
            SnowflakeConnectionV1 sfcon = (SnowflakeConnectionV1)con;
            MatcherAssert.assertThat((String)"token", (Object)sfcon.getSfSession().getSessionToken(), (Matcher)CoreMatchers.equalTo((Object)MOCK_SESSION_TOKEN));
            MatcherAssert.assertThat((String)"idToken", (Object)sfcon.getSfSession().getIdToken(), (Matcher)CoreMatchers.equalTo((Object)MOCK_ID_TOKEN));
            Connection conSecond = DriverManager.getConnection(url, properties);
            SnowflakeConnectionV1 sfconSecond = (SnowflakeConnectionV1)conSecond;
            MatcherAssert.assertThat((String)"token", (Object)sfconSecond.getSfSession().getSessionToken(), (Matcher)CoreMatchers.equalTo((Object)MOCK_NEW_SESSION_TOKEN));
            MatcherAssert.assertThat((String)"idToken", (Object)sfcon.getSfSession().getIdToken(), (Matcher)CoreMatchers.equalTo((Object)MOCK_ID_TOKEN));
        }
    }

    class HttpUtilResponseDTO {
        public boolean success;
        public String message;
        public Object data;

        HttpUtilResponseDTO(boolean success, String message, Object data) {
            this.success = success;
            this.message = message;
            this.data = data;
        }
    }

    class HttpUtilResponseDataAuthDTO {
        public String token;
        public String masterToken;
        public String idToken;
        public ArrayList<HttpUtilResponseDataParaDTO> parameters = new ArrayList();

        HttpUtilResponseDataAuthDTO(String token, String masterToken, String idToken) {
            this.token = token;
            this.masterToken = masterToken;
            this.idToken = idToken;
            this.parameters.add(new HttpUtilResponseDataParaDTO("AUTOCOMMIT", "true"));
        }
    }

    class HttpUtilResponseDataParaDTO {
        public String name;
        public String value;

        HttpUtilResponseDataParaDTO(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    class HttpUtilResponseDataSSODTO {
        public String proofKey;
        public String ssoUrl;

        public HttpUtilResponseDataSSODTO(String proofKey, String ssoUrl) {
            this.proofKey = proofKey;
            this.ssoUrl = ssoUrl;
        }
    }
}

