/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SessionUtil;
import org.junit.Assert;
import org.junit.Test;

public class SessionUtilTest {
    @Test
    public void testGetCommonParams() throws Exception {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        Map result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": true}]"));
        Assert.assertTrue((boolean)((Boolean)result.get("testParam")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": false}]"));
        Assert.assertFalse((boolean)((Boolean)result.get("testParam")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": 0}]"));
        Assert.assertEquals((long)0L, (long)((Integer)result.get("testParam")).intValue());
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": 1000}]"));
        Assert.assertEquals((long)1000L, (long)((Integer)result.get("testParam")).intValue());
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": \"\"}]"));
        Assert.assertEquals((Object)"", result.get("testParam"));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": \"value\"}]"));
        Assert.assertEquals((Object)"value", result.get("testParam"));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"CLIENT_DISABLE_INCIDENTS\", \"value\": true}]"));
        Assert.assertTrue((boolean)((Boolean)result.get("CLIENT_DISABLE_INCIDENTS")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"CLIENT_DISABLE_INCIDENTS\", \"value\": false}]"));
        Assert.assertFalse((boolean)((Boolean)result.get("CLIENT_DISABLE_INCIDENTS")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"CLIENT_STAGE_ARRAY_BINDING_THRESHOLD\", \"value\": 0}]"));
        Assert.assertEquals((long)0L, (long)((Integer)result.get("CLIENT_STAGE_ARRAY_BINDING_THRESHOLD")).intValue());
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"CLIENT_STAGE_ARRAY_BINDING_THRESHOLD\", \"value\": 1000}]"));
        Assert.assertEquals((long)1000L, (long)((Integer)result.get("CLIENT_STAGE_ARRAY_BINDING_THRESHOLD")).intValue());
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"TIMEZONE\", \"value\": \"\"}]"));
        Assert.assertEquals((Object)"", result.get("TIMEZONE"));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"TIMEZONE\", \"value\": \"value\"}]"));
        Assert.assertEquals((Object)"value", result.get("TIMEZONE"));
    }
}

