/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryOthers.class})
public final class SessionVariablesIT
extends AbstractDriverIT {
    private static Logger logger = Logger.getLogger(BaseJDBCTest.class.getName());

    private static void sql(Connection connection, String sqlText) throws SQLException {
        Statement stmt = connection.createStatement();
        stmt.setMaxRows(1);
        boolean hasResultSet = stmt.execute(sqlText);
        if (hasResultSet) {
            Assert.assertTrue((boolean)stmt.getResultSet().next());
        }
        stmt.close();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testSessionVariables() throws SQLException, IOException {
        Properties properties = new Properties();
        properties.put("var1", "some example");
        properties.put("var2", "1");
        properties.put("$var3", "some example");
        properties.put("$var4", "1");
        Connection con = SessionVariablesIT.getSnowflakeAdminConnection(properties);
        SessionVariablesIT.sql(con, "alter system set enable_assignment_scalar=true, enable_assignment_statement=true");
        con.close();
        properties.put("$var1", "some example");
        properties.put("$var2", (Object)10L);
        properties.put("var1", "ignored");
        properties.put("var2", "ignored");
        con = SessionVariablesIT.getConnection(properties);
        Statement statement = con.createStatement();
        ResultSet resultSet = statement.executeQuery("show variables");
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertTrue((boolean)resultSet.next());
        statement.close();
        con.close();
        con = SessionVariablesIT.getSnowflakeAdminConnection(properties);
        SessionVariablesIT.sql(con, "alter system unset enable_assignment_scalar, enable_assignment_statement");
        con.close();
    }
}

