/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageExtendedErrorInformation;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.InvalidKeyException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeAzureClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={TestCategoryOthers.class})
public class SnowflakeAzureClientHandleExceptionLatestIT
extends AbstractDriverIT {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private Connection connection;
    private SFStatement sfStatement;
    private SFSession sfSession;
    private String command;
    private SnowflakeAzureClient spyingClient;
    private int overMaxRetry;
    private int maxRetry;

    @Before
    public void setup() throws SQLException {
        this.connection = SnowflakeAzureClientHandleExceptionLatestIT.getConnection("azureaccount");
        this.sfSession = this.connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
        Statement statement = this.connection.createStatement();
        this.sfStatement = statement.unwrap(SnowflakeStatementV1.class).getSfStatement();
        statement.execute("CREATE OR REPLACE STAGE testPutGet_stage");
        this.command = "PUT file://" + SnowflakeAzureClientHandleExceptionLatestIT.getFullPathFileInResource("orders_100.csv") + " @testPutGet_stage";
        SnowflakeFileTransferAgent agent = new SnowflakeFileTransferAgent(this.command, this.sfSession, this.sfStatement);
        SnowflakeAzureClient client = SnowflakeAzureClient.createSnowflakeAzureClient((StageInfo)agent.getStageInfo(), (RemoteStoreFileEncryptionMaterial)((RemoteStoreFileEncryptionMaterial)agent.getEncryptionMaterial().get(0)), (SFBaseSession)this.sfSession);
        this.maxRetry = client.getMaxRetries();
        this.overMaxRetry = this.maxRetry + 1;
        this.spyingClient = (SnowflakeAzureClient)Mockito.spy((Object)client);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void error403RenewExpired() throws SQLException, InterruptedException {
        this.spyingClient.handleStorageException((Exception)new StorageException("403", "Unauthenticated", 403, new StorageExtendedErrorInformation(), new Exception()), 0, "upload", this.sfSession, this.command);
        ((SnowflakeAzureClient)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.times((int)2))).renew(Mockito.anyMap());
        final Exception[] exceptionContainer = new Exception[1];
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SnowflakeAzureClientHandleExceptionLatestIT.this.spyingClient.handleStorageException((Exception)new StorageException("403", "Unauthenticated", 403, new StorageExtendedErrorInformation(), new Exception()), SnowflakeAzureClientHandleExceptionLatestIT.this.maxRetry, "upload", SnowflakeAzureClientHandleExceptionLatestIT.this.sfSession, SnowflakeAzureClientHandleExceptionLatestIT.this.command);
                }
                catch (SnowflakeSQLException e) {
                    exceptionContainer[0] = e;
                }
            }
        });
        thread.start();
        thread.interrupt();
        thread.join();
        Assert.assertNull((String)"Exception must not have been thrown in here", (Object)exceptionContainer[0]);
        ((SnowflakeAzureClient)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.times((int)4))).renew(Mockito.anyMap());
    }

    @Test(expected=SnowflakeSQLException.class)
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void error403OverMaxRetryThrow() throws SQLException {
        this.spyingClient.handleStorageException((Exception)new StorageException("403", "Unauthenticated", 403, new StorageExtendedErrorInformation(), new Exception()), this.overMaxRetry, "upload", this.sfSession, this.command);
    }

    @Test(expected=SnowflakeSQLException.class)
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void error403NullSession() throws SQLException {
        this.spyingClient.handleStorageException((Exception)new StorageException("403", "Unauthenticated", 403, new StorageExtendedErrorInformation(), new Exception()), 0, "upload", null, this.command);
    }

    @Test(expected=SnowflakeSQLException.class)
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void errorInvalidKey() throws SQLException {
        this.spyingClient.handleStorageException(new Exception(new InvalidKeyException()), 0, "upload", this.sfSession, this.command);
    }

    @Test(expected=SnowflakeSQLException.class)
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void errorInterruptedException() throws SQLException {
        try {
            this.spyingClient.handleStorageException((Exception)new InterruptedException(), 0, "upload", this.sfSession, this.command);
        }
        catch (Exception e) {
            Assert.fail((String)"Should not have exception here");
        }
        ((SnowflakeAzureClient)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.never())).renew(Mockito.anyMap());
        this.spyingClient.handleStorageException((Exception)new InterruptedException(), 26, "upload", this.sfSession, this.command);
    }

    @Test(expected=SnowflakeSQLException.class)
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void errorSocketTimeoutException() throws SQLException {
        try {
            this.spyingClient.handleStorageException((Exception)new SocketTimeoutException(), 0, "upload", this.sfSession, this.command);
        }
        catch (Exception e) {
            Assert.fail((String)"Should not have exception here");
        }
        ((SnowflakeAzureClient)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.never())).renew(Mockito.anyMap());
        this.spyingClient.handleStorageException((Exception)new SocketTimeoutException(), 26, "upload", this.sfSession, this.command);
    }

    @Test(expected=SnowflakeSQLException.class)
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void errorUnknownException() throws SQLException {
        this.spyingClient.handleStorageException(new Exception(), 0, "upload", this.sfSession, this.command);
    }

    @Test(expected=SnowflakeSQLException.class)
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void errorNoSpaceLeftOnDevice() throws SQLException, IOException {
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        String getCommand = "get @testPutGet_stage/orders_100.csv 'file://" + destFolderCanonicalPath + "'";
        this.spyingClient.handleStorageException((Exception)new StorageException("", "No space left on device", (Exception)new IOException("No space left on device")), 0, "download", null, getCommand);
    }

    @After
    public void cleanUp() throws SQLException {
        this.sfStatement.close();
        this.connection.close();
    }
}

