/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeChunkDownloader;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializable;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SnowflakeChunkDownloaderLatestIT
extends BaseJDBCTest {
    @Test
    public void testChunkDownloaderRetry() throws SQLException, InterruptedException {
        System.setProperty("https.proxyHost", "127.0.0.1");
        System.setProperty("https.proxyPort", "8080");
        System.setProperty("http.nonProxyHosts", "*snowflakecomputing.com");
        Properties properties = new Properties();
        properties.put("maxHttpRetries", (Object)2);
        SnowflakeChunkDownloader snowflakeChunkDownloaderSpy = null;
        try (Connection connection = SnowflakeChunkDownloaderLatestIT.getConnection(properties);){
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select seq8(), randstr(1000, random()) from table(generator(rowcount => 10000))");
            List resultSetSerializables = ((SnowflakeResultSet)resultSet).getResultSetSerializables(0x6400000L);
            SnowflakeResultSetSerializable resultSetSerializable = (SnowflakeResultSetSerializable)resultSetSerializables.get(0);
            SnowflakeChunkDownloader downloader = new SnowflakeChunkDownloader((SnowflakeResultSetSerializableV1)resultSetSerializable);
            snowflakeChunkDownloaderSpy = (SnowflakeChunkDownloader)Mockito.spy((Object)downloader);
            snowflakeChunkDownloaderSpy.getNextChunkToConsume();
        }
        catch (SnowflakeSQLException exception) {
            ((SnowflakeChunkDownloader)Mockito.verify(snowflakeChunkDownloaderSpy, (VerificationMode)Mockito.times((int)2))).getResultStreamProvider();
            Assert.assertTrue((boolean)exception.getMessage().contains("Max retry reached for the download of #chunk0"));
            Assert.assertTrue((boolean)exception.getMessage().contains("retry=2"));
        }
    }
}

