/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.SQLException;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeClob;
import org.junit.Assert;
import org.junit.Test;

public class SnowflakeClobTest
extends BaseJDBCTest {
    @Test
    public void testReadCharacterStream() throws SQLException, IOException {
        SnowflakeClob clob = new SnowflakeClob("hello world");
        char[] chars = new char[100];
        Reader reader = clob.getCharacterStream(1L, clob.length());
        int charRead = reader.read(chars, 0, chars.length);
        Assert.assertEquals((long)charRead, (long)11L);
        Assert.assertEquals((Object)"hello world", (Object)clob.toString());
    }

    @Test
    public void testReadWriteAsciiStream() throws SQLException, IOException {
        SnowflakeClob clob = new SnowflakeClob("hello world");
        clob.setAsciiStream(1L);
        char[] chars = new char[100];
        InputStream input = clob.getAsciiStream();
        InputStreamReader in = new InputStreamReader(input, StandardCharsets.UTF_8);
        int charRead = ((Reader)in).read(chars, 0, chars.length);
        Assert.assertEquals((long)charRead, (long)11L);
    }

    @Test
    public void testFreeBuffer() throws SQLException, IOException {
        SnowflakeClob clob = new SnowflakeClob("hello world");
        clob.setCharacterStream(1L).close();
        Assert.assertEquals((long)11L, (long)clob.length());
        clob.free();
        Assert.assertEquals((long)0L, (long)clob.length());
    }

    @Test
    public void testGetSubString() throws SQLException {
        SnowflakeClob clob = new SnowflakeClob();
        clob.setString(1L, "hello world", 0, 11);
        Assert.assertEquals((Object)"world", (Object)clob.getSubString(6L, 5));
        Assert.assertEquals((long)0L, (long)clob.position("hello", 1L));
        Assert.assertEquals((long)0L, (long)clob.position((Clob)new SnowflakeClob("hello world"), 1L));
    }

    @Test
    public void testInvalidPositionExceptions() {
        SnowflakeClob clob = new SnowflakeClob();
        try {
            clob.setString(0L, "this should throw an exception");
            Assert.fail();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof SQLException));
        }
        try {
            clob.setString(0L, "this should throw an exception", 0, 5);
            Assert.fail();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof SQLException));
        }
        try {
            clob.getSubString(0L, 1);
            Assert.fail();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof SQLException));
        }
        try {
            clob.position("this should throw an exception", 0L);
            Assert.fail();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof SQLException));
        }
        try {
            clob.position((Clob)new SnowflakeClob("this should throw an exception"), 0L);
            Assert.fail();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof SQLException));
        }
    }
}

