/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.util.Map;
import java.util.Properties;
import net.snowflake.client.jdbc.DefaultSFConnectionHandler;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class SnowflakeConnectionV1Test {
    @Test
    public void testMergeProperties() {
        Properties prop = new Properties();
        prop.put("account", "s3testaccount");
        prop.put("user", "snowman");
        SnowflakeConnectString conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://testaccount.localhost:8080", (Properties)prop);
        Map result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat(result.get("ACCOUNT"), (Matcher)CoreMatchers.is((Object)"s3testaccount"));
        MatcherAssert.assertThat(result.get("USER"), (Matcher)CoreMatchers.is((Object)"snowman"));
        MatcherAssert.assertThat(result.get("SERVERURL"), (Matcher)CoreMatchers.is((Object)"https://testaccount.localhost:8080/"));
        prop = new Properties();
        prop.put("account", "s3testaccount");
        prop.put("user", "snowman");
        conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://testaccount.localhost:8080/?", (Properties)prop);
        result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat(result.get("ACCOUNT"), (Matcher)CoreMatchers.is((Object)"s3testaccount"));
        MatcherAssert.assertThat(result.get("USER"), (Matcher)CoreMatchers.is((Object)"snowman"));
        MatcherAssert.assertThat(result.get("SERVERURL"), (Matcher)CoreMatchers.is((Object)"https://testaccount.localhost:8080/"));
        prop = new Properties();
        prop.put("account", "s3testaccount");
        prop.put("user", "snowman");
        conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://testaccount.localhost:8080/?aaaa", (Properties)prop);
        result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat(result.get("ACCOUNT"), (Matcher)CoreMatchers.is((Object)"s3testaccount"));
        MatcherAssert.assertThat(result.get("USER"), (Matcher)CoreMatchers.is((Object)"snowman"));
        MatcherAssert.assertThat(result.get("SERVERURL"), (Matcher)CoreMatchers.is((Object)"https://testaccount.localhost:8080/"));
        prop = new Properties();
        prop.put("account", "s3testaccount");
        prop.put("user", "snowman");
        conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://testaccount.localhost:8080/?prop1=value1", (Properties)prop);
        result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(result.get("ACCOUNT"), (Matcher)CoreMatchers.is((Object)"s3testaccount"));
        MatcherAssert.assertThat(result.get("USER"), (Matcher)CoreMatchers.is((Object)"snowman"));
        MatcherAssert.assertThat(result.get("SERVERURL"), (Matcher)CoreMatchers.is((Object)"https://testaccount.localhost:8080/"));
        MatcherAssert.assertThat(result.get("PROP1"), (Matcher)CoreMatchers.is((Object)"value1"));
        prop = new Properties();
        prop.put("account", "s3testaccount");
        prop.put("user", "snowman");
        conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://testaccount.localhost:8080/?prop1=value1&ssl=off", (Properties)prop);
        result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(result.get("ACCOUNT"), (Matcher)CoreMatchers.is((Object)"s3testaccount"));
        MatcherAssert.assertThat(result.get("USER"), (Matcher)CoreMatchers.is((Object)"snowman"));
        MatcherAssert.assertThat(result.get("SERVERURL"), (Matcher)CoreMatchers.is((Object)"http://testaccount.localhost:8080/"));
        MatcherAssert.assertThat(result.get("PROP1"), (Matcher)CoreMatchers.is((Object)"value1"));
        prop = new Properties();
        prop.put("account", "s3testaccount");
        prop.put("user", "snowman");
        prop.put("ssl", Boolean.FALSE.toString());
        conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://testaccount.localhost:8080/?prop1=value1", (Properties)prop);
        result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(result.get("ACCOUNT"), (Matcher)CoreMatchers.is((Object)"s3testaccount"));
        MatcherAssert.assertThat(result.get("USER"), (Matcher)CoreMatchers.is((Object)"snowman"));
        MatcherAssert.assertThat(result.get("SERVERURL"), (Matcher)CoreMatchers.is((Object)"http://testaccount.localhost:8080/"));
        MatcherAssert.assertThat(result.get("PROP1"), (Matcher)CoreMatchers.is((Object)"value1"));
        prop = new Properties();
        prop.put("user", "snowman");
        prop.put("ssl", Boolean.FALSE.toString());
        prop.put("prop1", "value2");
        conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://testaccount.localhost:8080/?prop1=value1", (Properties)prop);
        result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(result.get("ACCOUNT"), (Matcher)CoreMatchers.is((Object)"testaccount"));
        MatcherAssert.assertThat(result.get("USER"), (Matcher)CoreMatchers.is((Object)"snowman"));
        MatcherAssert.assertThat(result.get("SERVERURL"), (Matcher)CoreMatchers.is((Object)"http://testaccount.localhost:8080/"));
        MatcherAssert.assertThat(result.get("PROP1"), (Matcher)CoreMatchers.is((Object)"value2"));
        prop = new Properties();
        prop.put("user", "snowman");
        conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://testaccount-1234567890qwertyupalsjhfg.global.snowflakecomputing.com:8080/?prop1=value", (Properties)prop);
        result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(result.get("ACCOUNT"), (Matcher)CoreMatchers.is((Object)"testaccount"));
        MatcherAssert.assertThat(result.get("USER"), (Matcher)CoreMatchers.is((Object)"snowman"));
        MatcherAssert.assertThat(result.get("SERVERURL"), (Matcher)CoreMatchers.is((Object)"https://testaccount-1234567890qwertyupalsjhfg.global.snowflakecomputing.com:8080/"));
        MatcherAssert.assertThat(result.get("PROP1"), (Matcher)CoreMatchers.is((Object)"value"));
        prop = new Properties();
        prop.put("user", "snowman");
        prop.put("account", "s3testaccount");
        conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://testaccount-1234567890qwertyupalsjhfg.global.snowflakecomputing.com:8080/?prop1=value", (Properties)prop);
        result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(result.get("ACCOUNT"), (Matcher)CoreMatchers.is((Object)"s3testaccount"));
        MatcherAssert.assertThat(result.get("USER"), (Matcher)CoreMatchers.is((Object)"snowman"));
        MatcherAssert.assertThat(result.get("SERVERURL"), (Matcher)CoreMatchers.is((Object)"https://testaccount-1234567890qwertyupalsjhfg.global.snowflakecomputing.com:8080/"));
        MatcherAssert.assertThat(result.get("PROP1"), (Matcher)CoreMatchers.is((Object)"value"));
        prop = new Properties();
        prop.put("user", "snowman");
        conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://test-account-1234567890qwertyupalsjhfg.global.snowflakecomputing.com:8080/?prop1=value", (Properties)prop);
        result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(result.get("ACCOUNT"), (Matcher)CoreMatchers.is((Object)"test-account"));
        MatcherAssert.assertThat(result.get("USER"), (Matcher)CoreMatchers.is((Object)"snowman"));
        MatcherAssert.assertThat(result.get("SERVERURL"), (Matcher)CoreMatchers.is((Object)"https://test-account-1234567890qwertyupalsjhfg.global.snowflakecomputing.com:8080/"));
        MatcherAssert.assertThat(result.get("PROP1"), (Matcher)CoreMatchers.is((Object)"value"));
        prop = new Properties();
        conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://http://testaccount.localhost:8080/?prop1=value1", (Properties)prop);
        result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat(result.get("SERVERURL"), (Matcher)CoreMatchers.is((Object)"http://testaccount.localhost:8080/"));
        prop = new Properties();
        conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://https://testaccount.localhost:8080/?prop1=value1", (Properties)prop);
        result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat(result.get("SERVERURL"), (Matcher)CoreMatchers.is((Object)"https://testaccount.localhost:8080/"));
        prop = new Properties();
        conStr = SnowflakeConnectString.parse((String)"jdbc:snowflake://http://testaccount.localhost:8080/?prop1=value1%7Cvalue2&prop2=carrot%5E", (Properties)prop);
        result = DefaultSFConnectionHandler.mergeProperties((SnowflakeConnectString)conStr);
        MatcherAssert.assertThat(result.get("PROP1"), (Matcher)CoreMatchers.is((Object)"value1|value2"));
        MatcherAssert.assertThat(result.get("PROP2"), (Matcher)CoreMatchers.is((Object)"carrot^"));
    }
}

