/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.RunningOnTestaccount;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.common.core.ClientAuthnDTO;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={TestCategoryOthers.class})
public class SnowflakeDriverIT
extends BaseJDBCTest {
    private static final int MAX_CONCURRENT_QUERIES_PER_USER = 50;
    private static final String getCurrenTransactionStmt = "SELECT CURRENT_TRANSACTION()";
    private static Logger logger = Logger.getLogger(SnowflakeDriverIT.class.getName());
    private static String ORDERS_JDBC = "ORDERS_JDBC";
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private ObjectMapper mapper = new ObjectMapper();
    @Rule
    public TemporaryFolder tmpFolder2 = new TemporaryFolder();
    public String testStageName = String.format("test_stage_%s", UUID.randomUUID().toString()).replaceAll("-", "_");

    @BeforeClass
    public static void setUp() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("create or replace table orders_jdbc(C1 STRING NOT NULL COMMENT 'JDBC', C2 STRING, C3 STRING, C4 STRING, C5 STRING, C6 STRING, C7 STRING, C8 STRING, C9 STRING) stage_file_format = (field_delimiter='|' error_on_column_count_mismatch=false)");
            statement.execute("create or replace table clustered_jdbc (c1 number, c2 number) cluster by (c1)");
            Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + SnowflakeDriverIT.getFullPathFileInResource("orders_100.csv") + " @%orders_jdbc"));
            Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + SnowflakeDriverIT.getFullPathFileInResource("orders_101.csv") + " @%orders_jdbc"));
            int numRows = statement.executeUpdate("copy into orders_jdbc");
            Assert.assertEquals((String)("Unexpected number of rows copied: " + numRows), (long)73L, (long)numRows);
        }
    }

    @AfterClass
    public static void tearDown() throws SQLException {
        try (Connection connection = SnowflakeDriverIT.getConnection();){
            Statement statement = connection.createStatement();
            statement.execute("drop table if exists clustered_jdbc");
            statement.execute("drop table if exists orders_jdbc");
            statement.close();
        }
    }

    public static Connection getConnection(int injectSocketTimeout) throws SQLException {
        Connection connection = AbstractDriverIT.getConnection(injectSocketTimeout);
        Statement statement = connection.createStatement();
        statement.execute("alter session set TIMEZONE='America/Los_Angeles',TIMESTAMP_TYPE_MAPPING='TIMESTAMP_LTZ',TIMESTAMP_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_TZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_LTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_NTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM'");
        statement.close();
        return connection;
    }

    public static Connection getConnection() throws SQLException {
        return SnowflakeDriverIT.getConnection(0);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testOauthConnection() throws SQLException {
        Map<String, String> params = SnowflakeDriverIT.getConnectionParameters();
        Connection con = SnowflakeDriverIT.getConnection("s3testaccount");
        Statement statement = con.createStatement();
        statement.execute("use role accountadmin");
        statement.execute("create or replace security integration jdbc_oauth_integration\n  type=oauth\n  oauth_client=CUSTOM\n  oauth_client_type=CONFIDENTIAL\n  oauth_redirect_uri='https://localhost.com/oauth'\n  oauth_issue_refresh_tokens=true\n  enabled=true oauth_refresh_token_validity=86400;");
        String role = params.get("role");
        ResultSet rs = statement.executeQuery("select system$it('create_oauth_access_token', 'JDBC_OAUTH_INTEGRATION', '" + role + "')");
        rs.next();
        String token = rs.getString(1);
        con.close();
        Properties props = new Properties();
        props.put("authenticator", ClientAuthnDTO.AuthenticatorType.OAUTH.name());
        props.put("token", token);
        props.put("role", role);
        con = SnowflakeDriverIT.getConnection("s3testaccount", props);
        con.createStatement().execute("select 1");
        con.close();
    }

    @Ignore
    @Test
    public void testConnections() throws Throwable {
        ExecutorService executorService = Executors.newFixedThreadPool(50);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        int idx = 0;
        while (idx < 50) {
            logger.info("open a new connection and submit query " + idx);
            int queryIdx = idx++;
            futures.add(executorService.submit(() -> {
                Connection connection = null;
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    connection = SnowflakeDriverIT.getConnection();
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery("SELECT system$sleep(10) % 1");
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnCount());
                    for (int i = 0; i < 1; ++i) {
                        Assert.assertTrue((boolean)resultSet.next());
                        for (int j = 1; j < 2; ++j) {
                            Assert.assertEquals((long)0L, (long)resultSet.getInt(j));
                        }
                    }
                    logger.info("Query " + queryIdx + " passed ");
                    statement.close();
                }
                catch (Throwable throwable) {
                    this.closeSQLObjects(resultSet, statement, connection);
                    throw throwable;
                }
                this.closeSQLObjects(resultSet, statement, connection);
                return true;
            }));
        }
        executorService.shutdown();
        for (idx = 0; idx < 50; ++idx) {
            ((Future)futures.get(idx)).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShowColumns() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Properties paramProperties = new Properties();
            connection = SnowflakeDriverIT.getConnection(paramProperties);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("show columns in clustered_jdbc");
            Assert.assertEquals((String)"number of columns", (long)2L, (long)this.countRows(resultSet));
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, statement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    private int countRows(ResultSet rset) throws Throwable {
        int cnt = 0;
        while (rset.next()) {
            ++cnt;
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowsPerResultset() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            connection.createStatement().execute("alter session set rows_per_resultset=2048");
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM orders_jdbc");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int numColumns = resultSetMetaData.getColumnCount();
            Assert.assertEquals((long)9L, (long)numColumns);
            Assert.assertEquals((String)"number of columns", (long)73L, (long)this.countRows(resultSet));
            statement.close();
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, statement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    @Test
    public void testDDLs() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE TABLE testDDLs(version number, name string)");
        }
        finally {
            if (statement != null) {
                statement.execute("DROP TABLE testDDLs");
            }
            this.closeSQLObjects(statement, connection);
        }
    }

    private long getCurrentTransaction(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute(getCurrenTransactionStmt);
            ResultSet rs = statement.getResultSet();
            if (rs.next()) {
                String txnId = rs.getString(1);
                long l = txnId != null ? Long.valueOf(txnId) : 0L;
                return l;
            }
        }
        throw new SQLException("SELECT CURRENT_TRANSACTION() didn't return a result.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testAutocommit() throws Throwable {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block3: {
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = SnowflakeDriverIT.getConnection();
                statement = connection.createStatement();
                connection.setTransactionIsolation(2);
                Assert.assertEquals((long)2L, (long)connection.getTransactionIsolation());
                connection.setAutoCommit(false);
                Assert.assertFalse((boolean)connection.getAutoCommit());
                Assert.assertEquals((long)0L, (long)this.getCurrentTransaction(connection));
                statement.executeUpdate("CREATE OR REPLACE TABLE AUTOCOMMIT_API_TEST (i int)");
                Assert.assertEquals((long)0L, (long)this.getCurrentTransaction(connection));
                statement.executeUpdate("INSERT INTO AUTOCOMMIT_API_TEST VALUES (1)");
                Assert.assertNotEquals((long)0L, (long)this.getCurrentTransaction(connection));
                connection.commit();
                Assert.assertFalse((boolean)connection.getAutoCommit());
                Assert.assertEquals((long)0L, (long)this.getCurrentTransaction(connection));
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM AUTOCOMMIT_API_TEST WHERE i = 1");
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getInt(1));
                resultSet.close();
                statement.executeUpdate("DELETE FROM AUTOCOMMIT_API_TEST");
                Assert.assertNotEquals((long)0L, (long)this.getCurrentTransaction(connection));
                connection.rollback();
                Assert.assertFalse((boolean)connection.getAutoCommit());
                Assert.assertEquals((long)0L, (long)this.getCurrentTransaction(connection));
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM AUTOCOMMIT_API_TEST WHERE i = 1");
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getInt(1));
                if (statement == null) break block3;
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    statement.execute("DROP TABLE AUTOCOMMIT_API_TEST");
                }
                this.closeSQLObjects(resultSet, statement, connection);
                throw throwable;
            }
            statement.execute("DROP TABLE AUTOCOMMIT_API_TEST");
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    private void assertConstraintResults(ResultSet resultSet, int numRows, int numCols, String pkTableName, String fkTableName) throws Throwable {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assert.assertEquals((long)numCols, (long)resultSetMetaData.getColumnCount());
        for (int i = 0; i < numRows; ++i) {
            Assert.assertTrue((String)"get constraint result row count", (boolean)resultSet.next());
            if (pkTableName != null) {
                Assert.assertTrue((String)"get constraint result primary table name", (boolean)pkTableName.equalsIgnoreCase(resultSet.getString(3)));
            }
            if (fkTableName == null) continue;
            Assert.assertTrue((String)"get constraint result foreign table name", (boolean)fkTableName.equalsIgnoreCase(resultSet.getString(7)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testBoolean() throws Throwable {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block3: {
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = SnowflakeDriverIT.getConnection();
                statement = connection.createStatement();
                statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
                DatabaseMetaData metadata = connection.getMetaData();
                statement.execute("create or replace table testBooleanT1(c1 boolean)");
                statement.execute("insert into testBooleanT1 values(true), (false), (null)");
                PreparedStatement preparedStatement = connection.prepareStatement("select c1 from testBooleanT1");
                resultSet = preparedStatement.executeQuery();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)16L, (long)resultSetMetaData.getColumnType(1));
                ResultSet columnMetaDataResultSet = metadata.getColumns(null, null, "TESTBOOLEANT1", null);
                resultSetMetaData = columnMetaDataResultSet.getMetaData();
                Assert.assertEquals((long)24L, (long)resultSetMetaData.getColumnCount());
                Assert.assertTrue((boolean)columnMetaDataResultSet.next());
                Assert.assertEquals((long)16L, (long)columnMetaDataResultSet.getInt(5));
                if (statement == null) break block3;
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    statement.execute("drop table testBooleanT1");
                }
                this.closeSQLObjects(resultSet, statement, connection);
                throw throwable;
            }
            statement.execute("drop table testBooleanT1");
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testConstraints() throws Throwable {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block3: {
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = SnowflakeDriverIT.getConnection();
                statement = connection.createStatement();
                statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
                DatabaseMetaData metadata = connection.getMetaData();
                statement.execute("CREATE OR REPLACE TABLE testConstraintsP1(c1 number unique, c2 number, constraint cons0 primary key (c1, c2))");
                statement.execute("CREATE OR REPLACE TABLE testConstraintsP2(c1 number constraint cons1 primary key, c2 number)");
                statement.execute("CREATE OR REPLACE TABLE testConstraintsF1(c1 number, c2 number, constraint cons3 foreign key (c1, c2) references testConstraintsP1(c1, c2))");
                statement.execute("CREATE OR REPLACE TABLE testConstraintsF2(c1 number, c2 number, constraint cons4 foreign key (c1, c2) references testConstraintsP1(c1, c2), constraint cons5 foreign key (c2) references testConstraintsP2(c1))");
                resultSet = metadata.getPrimaryKeys(null, null, "TESTCONSTRAINTSP1");
                this.assertConstraintResults(resultSet, 2, 6, "testConstraintsP1", null);
                resultSet = metadata.getPrimaryKeys(null, null, "TESTCONSTRAINTSP2");
                this.assertConstraintResults(resultSet, 1, 6, "testConstraintsP2", null);
                resultSet.close();
                resultSet.next();
                resultSet = metadata.getImportedKeys(null, null, "TESTCONSTRAINTSF1");
                this.assertConstraintResults(resultSet, 2, 14, null, "testConstraintsF1");
                resultSet = metadata.getImportedKeys(null, null, "TESTCONSTRAINTSF2");
                this.assertConstraintResults(resultSet, 3, 14, null, "testConstraintsF2");
                resultSet.close();
                resultSet.next();
                resultSet = metadata.getExportedKeys(null, null, "TESTCONSTRAINTSP1");
                this.assertConstraintResults(resultSet, 4, 14, "testConstraintsP1", null);
                resultSet = metadata.getExportedKeys(null, null, "TESTCONSTRAINTSP2");
                this.assertConstraintResults(resultSet, 1, 14, "testConstraintsP2", null);
                resultSet.close();
                resultSet.next();
                resultSet = metadata.getCrossReference(null, null, "TESTCONSTRAINTSP1", null, null, "TESTCONSTRAINTSF1");
                this.assertConstraintResults(resultSet, 2, 14, "testConstraintsP1", "testConstraintsF1");
                resultSet = metadata.getCrossReference(null, null, "TESTCONSTRAINTSP2", null, null, "TESTCONSTRAINTSF2");
                this.assertConstraintResults(resultSet, 1, 14, "testConstraintsP2", "testConstraintsF2");
                resultSet = metadata.getCrossReference(null, null, "TESTCONSTRAINTSP1", null, null, "TESTCONSTRAINTSF2");
                this.assertConstraintResults(resultSet, 2, 14, "testConstraintsP1", "testConstraintsF2");
                resultSet = metadata.getCrossReference(null, null, "TESTCONSTRAINTSP2", null, null, "TESTCONSTRAINTSF1");
                Assert.assertFalse((String)"cross reference from testConstraintsP2 to testConstraintsF2 should be empty", (boolean)resultSet.next());
                resultSet.close();
                resultSet.next();
                if (statement == null) break block3;
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    statement.execute("DROP TABLE TESTCONSTRAINTSF1");
                    statement.execute("DROP TABLE TESTCONSTRAINTSF2");
                    statement.execute("DROP TABLE TESTCONSTRAINTSP1");
                    statement.execute("DROP TABLE TESTCONSTRAINTSP2");
                }
                this.closeSQLObjects(resultSet, statement, connection);
                throw throwable;
            }
            statement.execute("DROP TABLE TESTCONSTRAINTSF1");
            statement.execute("DROP TABLE TESTCONSTRAINTSF2");
            statement.execute("DROP TABLE TESTCONSTRAINTSP1");
            statement.execute("DROP TABLE TESTCONSTRAINTSP2");
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryWithMaxRows() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        int maxRows = 30;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            statement.setMaxRows(30);
            resultSet = statement.executeQuery("SELECT * FROM orders_jdbc");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((long)9L, (long)resultSetMetaData.getColumnCount());
            Assert.assertEquals((long)30L, (long)this.countRows(resultSet));
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, statement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testCancelQueryBySystemFunction() throws Throwable {
        Statement statement = null;
        ResultSet resultSet = null;
        final Connection connection = SnowflakeDriverIT.getConnection();
        try {
            Statement getSessionIdStmt = connection.createStatement();
            getSessionIdStmt.setMaxRows(30);
            resultSet = getSessionIdStmt.executeQuery("SELECT current_session()");
            Assert.assertTrue((boolean)resultSet.next());
            final long sessionId = resultSet.getLong(1);
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        PreparedStatement cancelAll = connection.prepareStatement("call system$cancel_all_queries(?)");
                        cancelAll.setLong(1, sessionId);
                        cancelAll.executeQuery();
                    }
                    catch (SQLException ex) {
                        logger.log(Level.SEVERE, "Cancel failed with exception {}", ex);
                    }
                }
            }, 5000L);
            statement = connection.createStatement();
            statement.setMaxRows(30);
            resultSet = statement.executeQuery("SELECT count(*) FROM TABLE(generator(timeLimit => 120))");
            Assert.fail((String)"should raise an exception");
        }
        catch (SQLException ex) {
            try {
                Assert.assertEquals((String)"sqlstate mismatch", (Object)"57014", (Object)ex.getSQLState());
            }
            catch (Throwable throwable) {
                this.closeSQLObjects(resultSet, statement, connection);
                throw throwable;
            }
            this.closeSQLObjects(resultSet, statement, connection);
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDBMetadata() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet databaseSet = metaData.getCatalogs();
            Assert.assertTrue((String)"databases shouldn't be empty", (boolean)databaseSet.next());
            ResultSet schemaSet = metaData.getSchemas(connection.getCatalog(), connection.getSchema());
            Assert.assertTrue((String)"schemas shouldn't be empty", (boolean)schemaSet.next());
            Assert.assertTrue((String)("database should be " + connection.getCatalog()), (boolean)connection.getCatalog().equalsIgnoreCase(schemaSet.getString(2)));
            Assert.assertTrue((String)("schema should be " + connection.getSchema()), (boolean)connection.getSchema().equalsIgnoreCase(schemaSet.getString(1)));
            ResultSet tableSet = metaData.getTables(connection.getCatalog(), connection.getSchema(), ORDERS_JDBC, null);
            Assert.assertTrue((String)String.format("table %s should exists in db: %s, schema: %s", ORDERS_JDBC, connection.getCatalog(), connection.getSchema()), (boolean)tableSet.next());
            Assert.assertTrue((String)("database should be " + connection.getCatalog()), (boolean)connection.getCatalog().equalsIgnoreCase(schemaSet.getString(2)));
            Assert.assertTrue((String)("schema should be " + connection.getSchema()), (boolean)connection.getSchema().equalsIgnoreCase(schemaSet.getString(1)));
            Assert.assertTrue((String)"table should be orders_jdbc", (boolean)ORDERS_JDBC.equalsIgnoreCase(tableSet.getString(3)));
            ResultSet tableMetaDataResultSet = metaData.getTables(null, null, ORDERS_JDBC, null);
            ResultSetMetaData resultSetMetaData = tableMetaDataResultSet.getMetaData();
            Assert.assertEquals((long)10L, (long)resultSetMetaData.getColumnCount());
            int cnt = 0;
            while (tableMetaDataResultSet.next()) {
                Assert.assertTrue((boolean)ORDERS_JDBC.equalsIgnoreCase(tableMetaDataResultSet.getString(3)));
                ++cnt;
            }
            Assert.assertEquals((String)"number of tables", (long)1L, (long)cnt);
            tableMetaDataResultSet.close();
            tableMetaDataResultSet = metaData.getTables(null, null, "%", null);
            resultSetMetaData = tableMetaDataResultSet.getMetaData();
            Assert.assertEquals((long)10L, (long)resultSetMetaData.getColumnCount());
            boolean found = false;
            while (tableMetaDataResultSet.next()) {
                if (!ORDERS_JDBC.equalsIgnoreCase(tableMetaDataResultSet.getString(3))) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)"orders_jdbc not found", (boolean)found);
            tableMetaDataResultSet.close();
            ResultSet columnMetaDataResultSet = metaData.getColumns(null, null, ORDERS_JDBC, null);
            resultSetMetaData = columnMetaDataResultSet.getMetaData();
            Assert.assertEquals((long)24L, (long)resultSetMetaData.getColumnCount());
            cnt = 0;
            while (columnMetaDataResultSet.next()) {
                Assert.assertTrue((boolean)connection.getCatalog().equalsIgnoreCase(columnMetaDataResultSet.getString(1)));
                Assert.assertTrue((boolean)ORDERS_JDBC.equalsIgnoreCase(columnMetaDataResultSet.getString(3)));
                Assert.assertTrue((boolean)columnMetaDataResultSet.getString(4).startsWith("C"));
                Assert.assertEquals((long)12L, (long)columnMetaDataResultSet.getInt(5));
                Assert.assertTrue((boolean)"VARCHAR".equalsIgnoreCase(columnMetaDataResultSet.getString(6)));
                if (cnt == 0) {
                    Assert.assertEquals((Object)"JDBC", (Object)columnMetaDataResultSet.getString(12));
                    Assert.assertEquals((long)0L, (long)columnMetaDataResultSet.getInt(11));
                    Assert.assertEquals((Object)"NO", (Object)columnMetaDataResultSet.getString(18));
                }
                ++cnt;
            }
            Assert.assertEquals((long)9L, (long)cnt);
            columnMetaDataResultSet.close();
            statement = connection.createStatement();
            statement.execute("create or replace table \"testDBMetadata\" (a timestamp_ltz)");
            columnMetaDataResultSet = metaData.getColumns(null, null, "testDBMetadata", null);
            cnt = 0;
            while (columnMetaDataResultSet.next()) {
                Assert.assertTrue((boolean)"testDBMetadata".equalsIgnoreCase(columnMetaDataResultSet.getString(3)));
                Assert.assertEquals((long)93L, (long)columnMetaDataResultSet.getInt(5));
                Assert.assertTrue((boolean)columnMetaDataResultSet.getString(4).equalsIgnoreCase("a"));
                ++cnt;
            }
            Assert.assertEquals((long)1L, (long)cnt);
        }
        finally {
            if (statement != null) {
                statement.execute("DROP TABLE IF EXISTS \"testDBMetadata\"");
            }
            this.closeSQLObjects(statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPutWithWildcardGCP() throws Throwable {
        Properties _connectionProperties = new Properties();
        _connectionProperties.put("inject_wait_in_put", (Object)5);
        _connectionProperties.put("ssl", "off");
        Connection connection = SnowflakeDriverIT.getConnection(0, _connectionProperties, false, false, "gcpaccount");
        Statement statement = connection.createStatement();
        String sourceFilePath = SnowflakeDriverIT.getFullPathFileInResource("orders_100.csv");
        sourceFilePath = sourceFilePath.replace("orders_100.csv", "orders_10*.csv");
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
        try {
            statement.execute("alter session set ENABLE_GCP_PUT_EXCEPTION_FOR_OLD_DRIVERS=false");
            statement.execute("CREATE OR REPLACE STAGE wildcard_stage");
            Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + sourceFilePath + " @wildcard_stage"));
            SnowflakeDriverIT.findFile(statement, "ls @wildcard_stage/");
            Assert.assertTrue((String)"Failed to get files", (boolean)statement.execute("GET @wildcard_stage 'file://" + destFolderCanonicalPath + "' parallel=8"));
            for (int i = 0; i < fileNames.length; ++i) {
                File downloaded = new File(destFolderCanonicalPathWithSeparator + fileNames[i] + ".gz");
                assert (downloaded.exists());
                Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + fileNames[i] + ".gz");
                p.waitFor();
                String individualFilePath = sourceFilePath.replace("orders_10*.csv", fileNames[i]);
                File original = new File(individualFilePath);
                File unzipped = new File(destFolderCanonicalPathWithSeparator + fileNames[i]);
                assert (original.length() == unzipped.length());
                assert (FileUtils.contentEquals((File)original, (File)unzipped));
            }
        }
        finally {
            statement.execute("DROP STAGE IF EXISTS wildcard_stage");
            statement.close();
            connection.close();
        }
    }

    private void copyContentFrom(File file1, File file2) throws Exception {
        FileInputStream inputStream = new FileInputStream(file1);
        FileOutputStream outputStream = new FileOutputStream(file2);
        FileChannel fIn = inputStream.getChannel();
        FileChannel fOut = outputStream.getChannel();
        fOut.transferFrom(fIn, 0L, fIn.size());
        fIn.position(0L);
        fOut.transferFrom(fIn, fIn.size(), fIn.size());
        fOut.close();
        fIn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPutGetLargeFileGCP() throws Throwable {
        Connection connection = SnowflakeDriverIT.getConnection("gcpaccount");
        Statement statement = connection.createStatement();
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
        File largeTempFile = this.tmpFolder.newFile("largeFile.csv");
        BufferedWriter bw = new BufferedWriter(new FileWriter(largeTempFile));
        bw.write("Creating large test file for GCP PUT/GET test");
        bw.write(System.lineSeparator());
        bw.write("Creating large test file for GCP PUT/GET test");
        bw.write(System.lineSeparator());
        bw.close();
        File largeTempFile2 = this.tmpFolder.newFile("largeFile2.csv");
        String sourceFilePath = largeTempFile.getCanonicalPath();
        try {
            for (int i = 0; i < 12; ++i) {
                this.copyContentFrom(largeTempFile, largeTempFile2);
                this.copyContentFrom(largeTempFile2, largeTempFile);
            }
            statement.execute("alter session set ENABLE_GCP_PUT_EXCEPTION_FOR_OLD_DRIVERS=false");
            statement.execute("CREATE OR REPLACE STAGE largefile_stage");
            Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + sourceFilePath + " @largefile_stage"));
            SnowflakeDriverIT.findFile(statement, "ls @largefile_stage/");
            statement.execute("create or replace table large_table (colA string)");
            statement.execute("copy into large_table from @largefile_stage/largeFile.csv.gz");
            statement.execute("create or replace stage extra_stage");
            statement.execute("copy into @extra_stage/bigFile.csv.gz from large_table single=true");
            Assert.assertTrue((String)"Failed to get files", (boolean)statement.execute("GET @extra_stage 'file://" + destFolderCanonicalPath + "' parallel=8"));
            File downloaded = new File(destFolderCanonicalPathWithSeparator + "bigFile.csv.gz");
            assert (downloaded.exists());
            Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "bigFile.csv.gz");
            p.waitFor();
            File unzipped = new File(destFolderCanonicalPathWithSeparator + "bigFile.csv");
            assert (largeTempFile.length() == unzipped.length());
            assert (FileUtils.contentEquals((File)largeTempFile, (File)unzipped));
        }
        finally {
            statement.execute("DROP STAGE IF EXISTS largefile_stage");
            statement.execute("DROP STAGE IF EXISTS extra_stage");
            statement.execute("DROP TABLE IF EXISTS large_table");
            statement.close();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPutOverwrite() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        File file1 = this.tmpFolder.newFile("testfile.csv");
        BufferedWriter bw = new BufferedWriter(new FileWriter(file1));
        bw.write("Writing original file content. This should get overwritten.");
        bw.close();
        File file2 = this.tmpFolder2.newFile("testfile.csv");
        bw = new BufferedWriter(new FileWriter(file2));
        bw.write("This is all new! This should be the result of the overwriting.");
        bw.close();
        String sourceFilePathOriginal = file1.getCanonicalPath();
        String sourceFilePathOverwrite = file2.getCanonicalPath();
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            try {
                connection = SnowflakeDriverIT.getConnection(accounts.get(i));
                statement = connection.createStatement();
                statement.execute("alter session set ENABLE_GCP_PUT_EXCEPTION_FOR_OLD_DRIVERS=false");
                statement.execute("CREATE OR REPLACE STAGE testing_stage");
                Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + sourceFilePathOriginal + " @testing_stage"));
                SnowflakeDriverIT.findFile(statement, "ls @testing_stage/");
                Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + sourceFilePathOverwrite + " @testing_stage overwrite=true"));
                SnowflakeDriverIT.findFile(statement, "ls @testing_stage/");
                Assert.assertTrue((String)"Failed to get files", (boolean)statement.execute("GET @testing_stage 'file://" + destFolderCanonicalPath + "' parallel=8"));
                File downloaded = new File(destFolderCanonicalPathWithSeparator + "testfile.csv.gz");
                assert (downloaded.exists());
                Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "testfile.csv.gz");
                p.waitFor();
                File unzipped = new File(destFolderCanonicalPathWithSeparator + "testfile.csv");
                if ($assertionsDisabled || FileUtils.contentEqualsIgnoreEOL((File)file2, (File)unzipped, null)) continue;
                throw new AssertionError();
            }
            finally {
                statement.execute("DROP TABLE IF EXISTS testLoadToLocalFS");
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPut() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            try {
                connection = SnowflakeDriverIT.getConnection(accounts.get(i));
                statement = connection.createStatement();
                try {
                    statement.execute("alter session set ENABLE_GCP_PUT_EXCEPTION_FOR_OLD_DRIVERS=false");
                    statement.execute("CREATE OR REPLACE TABLE testLoadToLocalFS(a number)");
                    Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + SnowflakeDriverIT.getFullPathFileInResource("orders_100.csv") + " @%testLoadToLocalFS/orders parallel=10"));
                    resultSet = statement.getResultSet();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    Assert.assertTrue((resultSetMetaData.getColumnCount() > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertFalse((boolean)resultSet.next());
                    SnowflakeDriverIT.findFile(statement, "ls @%testLoadToLocalFS/ pattern='.*orders/orders_100.csv.g.*'");
                    resultSet = statement.executeQuery("rm @%testLoadToLocalFS/ pattern='.*orders/orders_100.csv.g.*'");
                    resultSetMetaData = resultSet.getMetaData();
                    Assert.assertTrue((resultSetMetaData.getColumnCount() >= 1 ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertNotNull((Object)resultSet.getString(1));
                    Assert.assertFalse((boolean)resultSet.next());
                    try {
                        resultSet.getString(1);
                        Assert.fail((String)"must fail");
                    }
                    catch (SQLException ex) {
                        Assert.assertEquals((long)ErrorCode.COLUMN_DOES_NOT_EXIST.getMessageCode().intValue(), (long)ex.getErrorCode());
                    }
                    Thread.sleep(100L);
                    resultSet = statement.executeQuery("ls @%testLoadToLocalFS/ pattern='.*orders/orders.*'");
                    Assert.assertFalse((boolean)resultSet.next());
                }
                finally {
                    statement.execute("DROP TABLE IF EXISTS testLoadToLocalFS");
                    statement.close();
                }
            }
            catch (Throwable throwable) {
                this.closeSQLObjects(resultSet, statement, connection);
                throw throwable;
            }
            this.closeSQLObjects(resultSet, statement, connection);
        }
    }

    static void findFile(Statement statement, String checkSQL) throws Throwable {
        boolean fileFound = false;
        ResultSet resultSet = null;
        for (int numSecs = 0; numSecs <= 60; ++numSecs) {
            resultSet = statement.executeQuery(checkSQL);
            if (resultSet.next()) {
                fileFound = true;
                break;
            }
            Thread.sleep(1000L);
        }
        Assert.assertTrue((String)"Could not find a file", (boolean)fileFound);
        Assert.assertNotNull((String)"Null result", (Object)resultSet.getString(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testSQLError42S02() throws SQLException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            try {
                resultSet = statement.executeQuery("SELECT * FROM nonexistence");
                Assert.fail((String)"SQL exception not raised");
            }
            catch (SQLException ex1) {
                Assert.assertEquals((String)"sqlstate mismatch", (Object)"42S02", (Object)ex1.getSQLState());
            }
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, statement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testExplainPlan() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("EXPLAIN PLAN FOR SELECT c1 FROM orders_jdbc");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Assert.assertTrue((String)"must return more than 4 columns", (resultSetMetaData.getColumnCount() >= 4 ? 1 : 0) != 0);
            Assert.assertTrue((String)"must return more than 3 rows", (this.countRows(resultSet) > 3 ? 1 : 0) != 0);
            statement.close();
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, statement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestampParsing() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select to_timestamp('2013-05-08T15:39:20.123-07:00') from orders_jdbc");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"Wed, 08 May 2013 15:39:20 -0700", (Object)resultSet.getString(1));
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, statement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateParsing() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select to_date('0001-01-01')");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"0001-01-01", (Object)resultSet.getString(1));
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, statement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeParsing() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select to_time('15:39:20.123') from orders_jdbc");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"15:39:20", (Object)resultSet.getString(1));
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, statement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientSideSorting() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int i;
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            statement.execute("set-sf-property sort on");
            resultSet = statement.executeQuery("SELECT c3 FROM orders_jdbc");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnCount());
            for (i = 0; i < 5; ++i) {
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((Object)"F", (Object)resultSet.getString(1));
            }
            statement.execute("set-sf-property sort off");
            resultSet = statement.executeQuery("SELECT c3 FROM orders_jdbc order by c3 desc");
            resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnCount());
            for (i = 0; i < 4; ++i) {
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((Object)"P", (Object)resultSet.getString(1));
            }
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, statement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateCount() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE TABLE testUpdateCount(version number, name string)");
            int numRows = statement.executeUpdate("INSERT INTO testUpdateCount values (1, 'a'), (2, 'b')");
            Assert.assertEquals((String)("Unexpected number of rows inserted: " + numRows), (long)2L, (long)numRows);
        }
        finally {
            if (statement != null) {
                statement.execute("DROP TABLE if exists testUpdateCount");
            }
            this.closeSQLObjects(null, statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testSnow4245() throws Throwable {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block8: {
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = SnowflakeDriverIT.getConnection();
                statement = connection.createStatement();
                statement.execute("alter session set timestamp_input_format = 'YYYY-MM-DD HH24:MI:SS';");
                String createSQL = "create or replace table testSnow4245(t timestamp with local time zone,ntz timestamp without time zone,tz  timestamp with time zone)";
                statement.execute(createSQL);
                int numRows = statement.executeUpdate("insert into testSnow4245 values(NULL,NULL,NULL),('2013-06-04 01:00:04','2013-06-04 01:00:04','2013-06-04 01:00:04'),('2013-06-05 23:00:05','2013-06-05 23:00:05','2013-06-05 23:00:05')");
                Assert.assertEquals((String)("Unexpected number of rows inserted: " + numRows), (long)3L, (long)numRows);
                resultSet = statement.executeQuery("SELECT * FROM testSnow4245 order by 1 nulls first, 2 nulls first, 3 nulls first");
                int i = 0;
                while (resultSet.next()) {
                    int j;
                    if (i == 0) {
                        for (j = 1; j < 4; ++j) {
                            Assert.assertNull((String)resultSet.getString(j), (Object)resultSet.getString(j));
                        }
                    } else {
                        for (j = 1; j < 4; ++j) {
                            Assert.assertNotNull((String)resultSet.getString(j), (Object)resultSet.getString(j));
                        }
                    }
                    ++i;
                }
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    statement.execute("drop table testSnow4245");
                }
                this.closeSQLObjects(resultSet, statement, connection);
                throw throwable;
            }
            statement.execute("drop table testSnow4245");
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testSnow4394() throws Throwable {
        Statement statement;
        Connection connection;
        block4: {
            connection = null;
            statement = null;
            String tableName = String.format("snow4394_%s", UUID.randomUUID().toString()).replaceAll("-", "_");
            try {
                connection = SnowflakeDriverIT.getConnection();
                statement = connection.createStatement();
                statement.execute(String.format("CREATE OR REPLACE TABLE %s(str string)", tableName));
                String data = "What is \ud83d\ude12?";
                int numRows = statement.executeUpdate(String.format("INSERT INTO %s(str) values('%s')", tableName, data));
                Assert.assertEquals((String)("Unexpected number of rows inserted: " + numRows), (long)1L, (long)numRows);
                ResultSet rset = statement.executeQuery(String.format("SELECT str FROM %s", tableName));
                String ret = null;
                while (rset.next()) {
                    ret = rset.getString(1);
                }
                rset.close();
                Assert.assertEquals((String)("Unexpected string value: " + ret), (Object)data, (Object)ret);
                if (statement == null) break block4;
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    statement.execute(String.format("DROP TABLE if exists %s", tableName));
                    statement.close();
                }
                this.closeSQLObjects(null, statement, connection);
                throw throwable;
            }
            statement.execute(String.format("DROP TABLE if exists %s", tableName));
            statement.close();
        }
        this.closeSQLObjects(null, statement, connection);
    }

    private void addBindBatch(PreparedStatement preparedStatement, Date sqlDate) throws SQLException {
        preparedStatement.setDouble(1, 1.2);
        preparedStatement.setString(2, "hello");
        preparedStatement.setDate(3, sqlDate);
        preparedStatement.setDate(4, sqlDate);
        preparedStatement.setString(5, "h");
        preparedStatement.setDate(6, sqlDate);
        preparedStatement.setString(7, "h");
        preparedStatement.setString(8, "h");
        preparedStatement.setString(9, "h");
        preparedStatement.setString(10, "h");
        preparedStatement.setString(11, "h");
        preparedStatement.setDate(12, sqlDate);
        preparedStatement.setString(13, "h");
        preparedStatement.setDouble(14, 1.2);
        preparedStatement.setString(15, "h");
        preparedStatement.setString(16, "h");
        preparedStatement.setString(17, "h");
        preparedStatement.setString(18, "h");
        preparedStatement.setString(19, "h");
        preparedStatement.setDate(20, sqlDate);
        preparedStatement.setString(21, "h");
        preparedStatement.addBatch();
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void test31448() throws Throwable {
        Connection connection = SnowflakeDriverIT.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("alter session set enable_fix_31448_2=2, error_on_generic_pruner=true;");
        statement.execute("alter session set timestamp_type_mapping=timestamp_ntz");
        statement.execute("create or replace table bug56658(iv number, tsv timestamp_ntz)");
        statement.execute("insert into bug56658 select seq8(), timestampadd(day, seq8(), '1970-01-13 00:00:00'::timestamp_ntz)\nfrom table(generator(rowcount=>20))");
        connection.unwrap(SnowflakeConnectionV1.class).getSfSession().setTimestampMappedType(SnowflakeType.TIMESTAMP_NTZ);
        Timestamp ts = SnowflakeDriverIT.buildTimestamp(1970, 0, 15, 10, 14, 30, 0);
        PreparedStatement preparedStatement = connection.prepareStatement("select iv, tsv from bug56658 where tsv >= ? and tsv <= ? order by iv;");
        statement.execute("alter session set timestamp_type_mapping=timestamp_ntz");
        Timestamp ts2 = SnowflakeDriverIT.buildTimestamp(1970, 0, 18, 10, 14, 30, 0);
        preparedStatement.setTimestamp(1, ts);
        preparedStatement.setTimestamp(2, ts2);
        preparedStatement.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testBind() throws Throwable {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block5: {
            connection = null;
            preparedStatement = null;
            Statement regularStatement = null;
            resultSet = null;
            try {
                int idx;
                connection = SnowflakeDriverIT.getConnection();
                preparedStatement = connection.prepareStatement("SELECT ?, ?");
                preparedStatement.setInt(1, 1);
                preparedStatement.setString(2, "hello");
                resultSet = preparedStatement.executeQuery();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)2L, (long)resultSetMetaData.getColumnCount());
                Assert.assertEquals((long)-5L, (long)resultSetMetaData.getColumnType(1));
                Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(2));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)"integer", (long)1L, (long)resultSet.getInt(1));
                Assert.assertEquals((String)"string", (Object)"hello", (Object)resultSet.getString(2));
                preparedStatement.setDouble(1, 1.2);
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)2L, (long)resultSetMetaData.getColumnCount());
                Assert.assertEquals((long)8L, (long)resultSetMetaData.getColumnType(1));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)"double", (double)1.2, (double)resultSet.getDouble(1), (double)0.0);
                Assert.assertEquals((String)"string", (Object)"hello", (Object)resultSet.getString(2));
                preparedStatement.setString(1, "hello");
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)2L, (long)resultSetMetaData.getColumnCount());
                Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(1));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)"string1", (Object)"hello", (Object)resultSet.getString(1));
                Assert.assertEquals((String)"string2", (Object)"hello", (Object)resultSet.getString(2));
                Date sqlDate = Date.valueOf("2014-08-26");
                preparedStatement.setDate(1, sqlDate);
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)2L, (long)resultSetMetaData.getColumnCount());
                Assert.assertEquals((long)91L, (long)resultSetMetaData.getColumnType(1));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)"string", (Object)"2014-08-26", (Object)resultSet.getString(1));
                Assert.assertEquals((String)"string", (Object)"hello", (Object)resultSet.getString(2));
                Timestamp ts = SnowflakeDriverIT.buildTimestamp(2014, 7, 26, 3, 52, 0, 0);
                preparedStatement.setTimestamp(1, ts);
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)2L, (long)resultSetMetaData.getColumnCount());
                Assert.assertEquals((long)93L, (long)resultSetMetaData.getColumnType(1));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)"Incorrect timestamp", (Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(1));
                Assert.assertEquals((String)"string", (Object)"hello", (Object)resultSet.getString(2));
                Time tm = new Time(12345678L);
                preparedStatement.setTime(1, tm);
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)2L, (long)resultSetMetaData.getColumnCount());
                Assert.assertEquals((long)92L, (long)resultSetMetaData.getColumnType(1));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)"Incorrect time", (Object)"03:25:45", (Object)resultSet.getString(1));
                Assert.assertEquals((String)"string", (Object)"hello", (Object)resultSet.getString(2));
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("SELECT * FROM orders_jdbc WHERE to_number(c1) = ?");
                preparedStatement.setInt(1, 100);
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)9L, (long)resultSetMetaData.getColumnCount());
                Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(1));
                Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(2));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)"c1", (Object)"100", (Object)resultSet.getString(1));
                Assert.assertEquals((String)"c2", (Object)"147004", (Object)resultSet.getString(2));
                preparedStatement.close();
                regularStatement = connection.createStatement();
                regularStatement.executeUpdate("create or replace table testBind(a int, b string, c double, d date, e timestamp, f time, g date)");
                preparedStatement = connection.prepareStatement("insert into testBind(a, b, c, d, e, f) values(?, ?, ?, ?, ?, ?)");
                preparedStatement.setInt(1, 1);
                preparedStatement.setString(2, "hello");
                preparedStatement.setDouble(3, 1.2);
                preparedStatement.setDate(4, sqlDate);
                preparedStatement.setTimestamp(5, ts);
                preparedStatement.setTime(6, tm);
                int rowCount = preparedStatement.executeUpdate();
                Assert.assertEquals((String)"update count", (long)1L, (long)rowCount);
                resultSet = regularStatement.executeQuery("select * from testBind");
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)"int", (long)1L, (long)resultSet.getInt(1));
                Assert.assertEquals((String)"string", (Object)"hello", (Object)resultSet.getString(2));
                Assert.assertEquals((String)"double", (double)1.2, (double)resultSet.getDouble(3), (double)0.0);
                Assert.assertEquals((String)"date", (Object)"2014-08-26", (Object)resultSet.getString(4));
                Assert.assertEquals((String)"timestamp", (Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(5));
                Assert.assertEquals((String)"time", (Object)"03:25:45", (Object)resultSet.getString(6));
                Assert.assertNull((String)"date", (Object)resultSet.getString(7));
                preparedStatement = connection.prepareStatement("update testBind set b=? where a=?");
                preparedStatement.setString(1, "world");
                preparedStatement.setInt(2, 1);
                preparedStatement.execute();
                preparedStatement.close();
                resultSet = regularStatement.executeQuery("select * from testBind");
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)"int", (long)1L, (long)resultSet.getInt(1));
                Assert.assertEquals((String)"string", (Object)"world", (Object)resultSet.getString(2));
                Assert.assertEquals((String)"double", (double)1.2, (double)resultSet.getDouble(3), (double)0.0);
                Assert.assertEquals((String)"date", (Object)"2014-08-26", (Object)resultSet.getString(4));
                Assert.assertEquals((String)"timestamp", (Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(5));
                Assert.assertEquals((String)"time", (Object)"03:25:45", (Object)resultSet.getString(6));
                Assert.assertNull((String)"date", (Object)resultSet.getString(7));
                preparedStatement = connection.prepareStatement("insert into testBind (a, b, c, d, e, f, g) values(?, ?, ?, ?, ?, ?, current_date())");
                preparedStatement.setInt(1, 2);
                preparedStatement.setString(2, "hello");
                preparedStatement.setDouble(3, 1.2);
                preparedStatement.setDate(4, sqlDate);
                preparedStatement.setTimestamp(5, ts);
                preparedStatement.setTime(6, tm);
                preparedStatement.addBatch();
                preparedStatement.setInt(1, 3);
                preparedStatement.setString(2, "hello");
                preparedStatement.setDouble(3, 1.2);
                preparedStatement.setDate(4, sqlDate);
                preparedStatement.setTimestamp(5, ts);
                preparedStatement.setTime(6, tm);
                preparedStatement.addBatch();
                int[] updateCounts = preparedStatement.executeBatch();
                Assert.assertEquals((String)"Number of update counts", (long)2L, (long)updateCounts.length);
                Assert.assertEquals((String)"update count", (long)1L, (long)updateCounts[0]);
                Assert.assertEquals((String)"update count", (long)1L, (long)updateCounts[1]);
                resultSet = regularStatement.executeQuery("select * from testBind where a = 2");
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)"int", (long)2L, (long)resultSet.getInt(1));
                Assert.assertEquals((String)"string", (Object)"hello", (Object)resultSet.getString(2));
                Assert.assertEquals((String)"double", (double)1.2, (double)resultSet.getDouble(3), (double)0.0);
                Assert.assertEquals((String)"date", (Object)"2014-08-26", (Object)resultSet.getString(4));
                Assert.assertEquals((String)"timestamp", (Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(5));
                Assert.assertEquals((String)"time", (Object)"03:25:45", (Object)resultSet.getString(6));
                resultSet = regularStatement.executeQuery("select * from testBind where a = 3");
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)"int", (long)3L, (long)resultSet.getInt(1));
                Assert.assertEquals((String)"string", (Object)"hello", (Object)resultSet.getString(2));
                Assert.assertEquals((String)"double", (double)1.2, (double)resultSet.getDouble(3), (double)0.0);
                Assert.assertEquals((String)"date", (Object)"2014-08-26", (Object)resultSet.getString(4));
                Assert.assertEquals((String)"timestamp", (Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(5));
                Assert.assertEquals((String)"time", (Object)"03:25:45", (Object)resultSet.getString(6));
                preparedStatement = connection.prepareStatement("select * from testBind WHERE to_number(a) = ?");
                resultSetMetaData = preparedStatement.getMetaData();
                Assert.assertEquals((long)7L, (long)resultSetMetaData.getColumnCount());
                Assert.assertEquals((long)-5L, (long)resultSetMetaData.getColumnType(1));
                Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(2));
                Assert.assertEquals((long)8L, (long)resultSetMetaData.getColumnType(3));
                Assert.assertEquals((long)91L, (long)resultSetMetaData.getColumnType(4));
                Assert.assertEquals((long)93L, (long)resultSetMetaData.getColumnType(5));
                Assert.assertEquals((long)92L, (long)resultSetMetaData.getColumnType(6));
                Assert.assertEquals((long)91L, (long)resultSetMetaData.getColumnType(7));
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("select ?, ?");
                resultSetMetaData = preparedStatement.getMetaData();
                Assert.assertEquals((long)2L, (long)resultSetMetaData.getColumnCount());
                Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(1));
                Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(2));
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("select ?, ?");
                preparedStatement.setInt(1, 1);
                preparedStatement.setString(2, "hello");
                ResultSet result = preparedStatement.executeQuery();
                resultSetMetaData = result.getMetaData();
                Assert.assertEquals((long)2L, (long)resultSetMetaData.getColumnCount());
                Assert.assertEquals((long)-5L, (long)resultSetMetaData.getColumnType(1));
                Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(2));
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("select ?");
                preparedStatement.setNull(1, 12);
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnCount());
                Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(1));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertNull((Object)resultSet.getObject(1));
                preparedStatement.setNull(1, 4);
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnCount());
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertNull((Object)resultSet.getObject(1));
                preparedStatement.close();
                regularStatement = connection.createStatement();
                regularStatement.executeUpdate("create or replace table testBind1(c1 double, c2 string, c3 date, c4 date, c5 string, c6 date, c7 string, c8 string, c9 string, c10 string, c11 string, c12 date, c13 string, c14 float, c15 string, c16 string, c17 string, c18 string,c19 string, c20 date, c21 string)");
                preparedStatement = connection.prepareStatement("insert into testBind1 (c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                for (idx = 0; idx < 16; ++idx) {
                    this.addBindBatch(preparedStatement, sqlDate);
                }
                updateCounts = preparedStatement.executeBatch();
                Assert.assertEquals((String)"Number of update counts", (long)16L, (long)updateCounts.length);
                for (idx = 0; idx < 16; ++idx) {
                    Assert.assertEquals((String)"update count", (long)1L, (long)updateCounts[idx]);
                }
                if (regularStatement == null) break block5;
            }
            catch (Throwable throwable) {
                if (regularStatement != null) {
                    regularStatement.execute("DROP TABLE testBind");
                    regularStatement.close();
                }
                this.closeSQLObjects(resultSet, preparedStatement, connection);
                throw throwable;
            }
            regularStatement.execute("DROP TABLE testBind");
            regularStatement.close();
        }
        this.closeSQLObjects(resultSet, preparedStatement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testTableBind() throws Throwable {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block8: {
            connection = null;
            preparedStatement = null;
            Statement regularStatement = null;
            resultSet = null;
            try {
                int i;
                connection = SnowflakeDriverIT.getConnection();
                preparedStatement = connection.prepareStatement("SELECT * from table(?)");
                ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
                Assert.assertEquals((long)0L, (long)resultSetMetaData.getColumnCount());
                preparedStatement.setString(1, ORDERS_JDBC);
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)9L, (long)resultSetMetaData.getColumnCount());
                for (i = 0; i < 73; ++i) {
                    Assert.assertTrue((boolean)resultSet.next());
                }
                Assert.assertFalse((boolean)resultSet.next());
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("SELECT * from table(?) where c1 = 1");
                preparedStatement.setString(1, ORDERS_JDBC);
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)9L, (long)resultSetMetaData.getColumnCount());
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertFalse((boolean)resultSet.next());
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("SELECT * from table(?) order by c3");
                preparedStatement.setString(1, ORDERS_JDBC);
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)9L, (long)resultSetMetaData.getColumnCount());
                for (i = 0; i < 73; ++i) {
                    Assert.assertTrue((boolean)resultSet.next());
                }
                Assert.assertFalse((boolean)resultSet.next());
                preparedStatement.close();
                regularStatement = connection.createStatement();
                regularStatement.execute("create or replace table testTableBind(c integer, d string)");
                regularStatement = connection.createStatement();
                regularStatement.executeUpdate("insert into testTableBind (c, d) values (1, 'one')");
                preparedStatement = connection.prepareStatement("SELECT * from table(?), testTableBind");
                preparedStatement.setString(1, ORDERS_JDBC);
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)11L, (long)resultSetMetaData.getColumnCount());
                for (i = 0; i < 73; ++i) {
                    Assert.assertTrue((boolean)resultSet.next());
                }
                Assert.assertFalse((boolean)resultSet.next());
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("SELECT * from table(?), table(?)");
                preparedStatement.setString(1, ORDERS_JDBC);
                preparedStatement.setString(2, "testTableBind");
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)11L, (long)resultSetMetaData.getColumnCount());
                for (i = 0; i < 73; ++i) {
                    Assert.assertTrue((boolean)resultSet.next());
                }
                Assert.assertFalse((boolean)resultSet.next());
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("SELECT a.c1, b.c from table(?) as a, table(?) as b");
                preparedStatement.setString(1, ORDERS_JDBC);
                preparedStatement.setString(2, "testTableBind");
                resultSet = preparedStatement.executeQuery();
                resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)2L, (long)resultSetMetaData.getColumnCount());
                for (i = 0; i < 73; ++i) {
                    Assert.assertTrue((boolean)resultSet.next());
                }
                Assert.assertFalse((boolean)resultSet.next());
                preparedStatement.close();
                if (regularStatement == null) break block8;
            }
            catch (Throwable throwable) {
                if (regularStatement != null) {
                    regularStatement.execute("DROP TABLE testTableBind");
                }
                this.closeSQLObjects(resultSet, preparedStatement, connection);
                throw throwable;
            }
            regularStatement.execute("DROP TABLE testTableBind");
        }
        this.closeSQLObjects(resultSet, preparedStatement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testBindInWithClause() throws Throwable {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block3: {
            connection = null;
            preparedStatement = null;
            Statement regularStatement = null;
            resultSet = null;
            try {
                connection = SnowflakeDriverIT.getConnection();
                regularStatement = connection.createStatement();
                regularStatement.execute("create or replace table testBind2(a int, b string, c double, d date, e timestamp, f time, g date)");
                preparedStatement = connection.prepareStatement("WITH V AS (SELECT * FROM testBind2 WHERE a = ?) SELECT count(*) FROM V");
                preparedStatement.setInt(1, 100);
                resultSet = preparedStatement.executeQuery();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnCount());
                Assert.assertTrue((boolean)resultSet.next());
                preparedStatement.close();
                if (regularStatement == null) break block3;
            }
            catch (Throwable throwable) {
                if (regularStatement != null) {
                    regularStatement.execute("DROP TABLE testBind2");
                    regularStatement.close();
                }
                this.closeSQLObjects(resultSet, preparedStatement, connection);
                throw throwable;
            }
            regularStatement.execute("DROP TABLE testBind2");
            regularStatement.close();
        }
        this.closeSQLObjects(resultSet, preparedStatement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testBindTimestampNTZ() throws Throwable {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block3: {
            connection = null;
            preparedStatement = null;
            Statement regularStatement = null;
            resultSet = null;
            try {
                connection = SnowflakeDriverIT.getConnection();
                regularStatement = connection.createStatement();
                regularStatement.executeUpdate("create or replace table testBindTimestampNTZ(a timestamp_ntz)");
                regularStatement.execute("alter session set client_timestamp_type_mapping='timestamp_ntz'");
                preparedStatement = connection.prepareStatement("insert into testBindTimestampNTZ values(?)");
                Timestamp ts = SnowflakeDriverIT.buildTimestamp(2014, 7, 26, 3, 52, 0, 0);
                preparedStatement.setTimestamp(1, ts);
                int updateCount = preparedStatement.executeUpdate();
                Assert.assertEquals((String)"update count", (long)1L, (long)updateCount);
                resultSet = regularStatement.executeQuery("select * from testBindTimestampNTZ");
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((String)"timestamp", (Object)"Tue, 26 Aug 2014 03:52:00 Z", (Object)resultSet.getString(1));
                regularStatement.executeUpdate("truncate table testBindTimestampNTZ");
                preparedStatement.setTimestamp(1, ts, Calendar.getInstance(TimeZone.getTimeZone("America/Los_Angeles")));
                updateCount = preparedStatement.executeUpdate();
                Assert.assertEquals((String)"update count", (long)1L, (long)updateCount);
                resultSet = regularStatement.executeQuery("select * from testBindTimestampNTZ");
                Assert.assertTrue((boolean)resultSet.next());
                preparedStatement.close();
                if (regularStatement == null) break block3;
            }
            catch (Throwable throwable) {
                if (regularStatement != null) {
                    regularStatement.execute("DROP TABLE testBindTimestampNTZ");
                    regularStatement.close();
                }
                this.closeSQLObjects(resultSet, preparedStatement, connection);
                throw throwable;
            }
            regularStatement.execute("DROP TABLE testBindTimestampNTZ");
            regularStatement.close();
        }
        this.closeSQLObjects(resultSet, preparedStatement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testNullBind() throws Throwable {
        PreparedStatement preparedStatement;
        Connection connection;
        block7: {
            connection = null;
            preparedStatement = null;
            Statement regularStatement = null;
            try {
                connection = SnowflakeDriverIT.getConnection();
                regularStatement = connection.createStatement();
                regularStatement.execute("create or replace table testNullBind(a double)");
                preparedStatement = connection.prepareStatement("insert into testNullBind (a) values(?)");
                preparedStatement.setDouble(1, 1.2);
                preparedStatement.addBatch();
                preparedStatement.setObject(1, null);
                preparedStatement.addBatch();
                int[] updateCounts = preparedStatement.executeBatch();
                Assert.assertEquals((String)"Number of update counts", (long)2L, (long)updateCounts.length);
                Assert.assertEquals((String)"update count", (long)1L, (long)updateCounts[0]);
                Assert.assertEquals((String)"update count", (long)1L, (long)updateCounts[1]);
                preparedStatement.clearBatch();
                preparedStatement.setObject(1, null);
                preparedStatement.addBatch();
                preparedStatement.setDouble(1, 1.2);
                preparedStatement.addBatch();
                updateCounts = preparedStatement.executeBatch();
                Assert.assertEquals((String)"Number of update counts", (long)2L, (long)updateCounts.length);
                Assert.assertEquals((String)"update count", (long)1L, (long)updateCounts[0]);
                Assert.assertEquals((String)"update count", (long)1L, (long)updateCounts[1]);
                preparedStatement.clearBatch();
                preparedStatement.setObject(1, null);
                preparedStatement.addBatch();
                updateCounts = preparedStatement.executeBatch();
                Assert.assertEquals((String)"Number of update counts", (long)1L, (long)updateCounts.length);
                Assert.assertEquals((String)"update count", (long)1L, (long)updateCounts[0]);
                preparedStatement.clearBatch();
                try {
                    preparedStatement.setObject(1, (Object)"Null", 8);
                    preparedStatement.addBatch();
                    preparedStatement.executeBatch();
                    Assert.fail((String)"must fail in executeBatch()");
                }
                catch (SnowflakeSQLException ex) {
                    Assert.assertEquals((long)2086L, (long)ex.getErrorCode());
                }
                preparedStatement.clearBatch();
                try {
                    preparedStatement.setString(1, "hello");
                    preparedStatement.addBatch();
                    preparedStatement.setDouble(1, 1.2);
                    preparedStatement.addBatch();
                    Assert.fail((String)"must fail");
                }
                catch (SnowflakeSQLException ex) {
                    Assert.assertEquals((long)ErrorCode.ARRAY_BIND_MIXED_TYPES_NOT_SUPPORTED.getMessageCode().intValue(), (long)ex.getErrorCode());
                }
                if (regularStatement == null) break block7;
            }
            catch (Throwable throwable) {
                if (regularStatement != null) {
                    regularStatement.execute("DROP TABLE testNullBind");
                    regularStatement.close();
                }
                this.closeSQLObjects(preparedStatement, connection);
                throw throwable;
            }
            regularStatement.execute("DROP TABLE testNullBind");
            regularStatement.close();
        }
        this.closeSQLObjects(preparedStatement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnow12603() throws Throwable {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            preparedStatement = connection.prepareStatement("SELECT ?, ?, ?, ?, ?, ?");
            Date sqlDate = Date.valueOf("2014-08-26");
            Timestamp ts = SnowflakeDriverIT.buildTimestamp(2014, 7, 26, 3, 52, 0, 0);
            preparedStatement.setObject(1, 1);
            preparedStatement.setObject(2, "hello");
            preparedStatement.setObject(3, new BigDecimal("1.3"));
            preparedStatement.setObject(4, Float.valueOf("1.3"));
            preparedStatement.setObject(5, sqlDate);
            preparedStatement.setObject(6, ts);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((long)6L, (long)resultSetMetaData.getColumnCount());
            Assert.assertEquals((long)-5L, (long)resultSetMetaData.getColumnType(1));
            Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(2));
            Assert.assertEquals((long)3L, (long)resultSetMetaData.getColumnType(3));
            Assert.assertEquals((long)8L, (long)resultSetMetaData.getColumnType(4));
            Assert.assertEquals((long)91L, (long)resultSetMetaData.getColumnType(5));
            Assert.assertEquals((long)93L, (long)resultSetMetaData.getColumnType(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((String)"integer", (long)1L, (long)resultSet.getInt(1));
            Assert.assertEquals((String)"string", (Object)"hello", (Object)resultSet.getString(2));
            Assert.assertEquals((String)"decimal", (Object)new BigDecimal("1.3"), (Object)resultSet.getBigDecimal(3));
            Assert.assertEquals((String)"double", (double)1.3, (double)resultSet.getDouble(4), (double)0.0);
            Assert.assertEquals((String)"date", (Object)"2014-08-26", (Object)resultSet.getString(5));
            Assert.assertEquals((String)"timestamp", (Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(6));
            preparedStatement.setObject(1, (Object)1, 4);
            preparedStatement.setObject(2, (Object)"hello", 12);
            preparedStatement.setObject(3, (Object)new BigDecimal("1.3"), 3);
            preparedStatement.setObject(4, (Object)Float.valueOf("1.3"), 8);
            preparedStatement.setObject(5, (Object)sqlDate, 91);
            preparedStatement.setObject(6, (Object)ts, 93);
            resultSet = preparedStatement.executeQuery();
            resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((long)6L, (long)resultSetMetaData.getColumnCount());
            Assert.assertEquals((long)-5L, (long)resultSetMetaData.getColumnType(1));
            Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(2));
            Assert.assertEquals((long)3L, (long)resultSetMetaData.getColumnType(3));
            Assert.assertEquals((long)8L, (long)resultSetMetaData.getColumnType(4));
            Assert.assertEquals((long)91L, (long)resultSetMetaData.getColumnType(5));
            Assert.assertEquals((long)93L, (long)resultSetMetaData.getColumnType(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((String)"integer", (long)1L, (long)resultSet.getInt(1));
            Assert.assertEquals((String)"string", (Object)"hello", (Object)resultSet.getString(2));
            Assert.assertEquals((String)"decimal", (Object)new BigDecimal("1.3"), (Object)resultSet.getBigDecimal(3));
            Assert.assertEquals((String)"double", (double)1.3, (double)resultSet.getDouble(4), (double)0.0);
            Assert.assertEquals((String)"date", (Object)"2014-08-26", (Object)resultSet.getString(5));
            Assert.assertEquals((String)"timestamp", (Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(6));
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, preparedStatement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, preparedStatement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnow6290() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE TABLE testSnow6290(ts timestamp)");
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO testSnow6290(ts) values(?)");
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            preparedStatement.setTimestamp(1, ts);
            preparedStatement.executeUpdate();
            ResultSet res = statement.executeQuery("select ts from testSnow6290");
            Assert.assertTrue((String)"expect a row", (boolean)res.next());
            Timestamp tsFromDB = res.getTimestamp(1);
            Assert.assertEquals((String)"timestamp mismatch", (long)ts.getTime(), (long)tsFromDB.getTime());
        }
        finally {
            if (statement != null) {
                statement.execute("DROP TABLE if exists testSnow6290");
                statement.close();
            }
            this.closeSQLObjects(statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidSQL() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            statement.executeQuery(null);
            statement.close();
            Assert.fail((String)"expected exception, but no exception");
        }
        catch (SnowflakeSQLException ex) {
            Assert.assertEquals((long)ErrorCode.INVALID_SQL.getMessageCode().intValue(), (long)ex.getErrorCode());
        }
        finally {
            this.closeSQLObjects(statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetObject() throws Throwable {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            preparedStatement = connection.prepareStatement("SELECT ?");
            preparedStatement.setInt(1, 1);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((String)"column class name=BigDecimal", (Object)Long.class.getName(), (Object)resultSetMetaData.getColumnClassName(1));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertTrue((String)"integer", (boolean)(resultSet.getObject(1) instanceof Long));
            preparedStatement.setString(1, "hello");
            resultSet = preparedStatement.executeQuery();
            resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((String)"column class name=String", (Object)String.class.getName(), (Object)resultSetMetaData.getColumnClassName(1));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertTrue((String)"string", (boolean)(resultSet.getObject(1) instanceof String));
            preparedStatement.setDouble(1, 1.2);
            resultSet = preparedStatement.executeQuery();
            resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((String)"column class name=Double", (Object)Double.class.getName(), (Object)resultSetMetaData.getColumnClassName(1));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertTrue((String)"double", (boolean)(resultSet.getObject(1) instanceof Double));
            preparedStatement.setTimestamp(1, new Timestamp(0L));
            resultSet = preparedStatement.executeQuery();
            resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((String)"column class name=Timestamp", (Object)Timestamp.class.getName(), (Object)resultSetMetaData.getColumnClassName(1));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertTrue((String)"timestamp", (boolean)(resultSet.getObject(1) instanceof Timestamp));
            preparedStatement.setDate(1, new Date(0L));
            resultSet = preparedStatement.executeQuery();
            resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((String)"column class name=Date", (Object)Date.class.getName(), (Object)resultSetMetaData.getColumnClassName(1));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertTrue((String)"date", (boolean)(resultSet.getObject(1) instanceof Date));
            preparedStatement.close();
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, preparedStatement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, preparedStatement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDoubleForNull() throws Throwable {
        Connection connection = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            stmt = connection.createStatement();
            resultSet = stmt.executeQuery("select cast(null as int) as null_int");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((String)"0 for null", (double)0.0, (double)resultSet.getDouble(1), (double)1.0E-4);
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, stmt, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, stmt, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDoubleForNaN() throws Throwable {
        Connection connection = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            stmt = connection.createStatement();
            resultSet = stmt.executeQuery("select 'nan'::float");
            Assert.assertTrue((boolean)resultSet.next());
            MatcherAssert.assertThat((String)"NaN for NaN", (Object)resultSet.getDouble(1), (Matcher)CoreMatchers.equalTo((Object)Double.NaN));
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, stmt, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, stmt, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutViaExecuteQuery() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            try {
                statement.execute("CREATE OR REPLACE TABLE testPutViaExecuteQuery(a number)");
                resultSet = statement.executeQuery("PUT file://" + SnowflakeDriverIT.getFullPathFileInResource("orders_100.csv") + " @%testPutViaExecuteQuery/orders parallel=10");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Assert.assertTrue((resultSetMetaData.getColumnCount() > 0 ? 1 : 0) != 0);
                for (int i = 0; i < 1; ++i) {
                    Assert.assertTrue((boolean)resultSet.next());
                }
            }
            finally {
                statement.execute("DROP TABLE IF EXISTS testPutViaExecuteQuery");
                statement.close();
            }
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, statement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Ignore(value="takes 7 min. enable this for long running tests")
    @Test
    public void testSnow16332() throws Throwable {
        Statement stmtWithNwError;
        Statement stmt;
        Connection connWithNwError;
        Connection conn;
        block4: {
            conn = null;
            connWithNwError = null;
            stmt = null;
            stmtWithNwError = null;
            try {
                conn = SnowflakeDriverIT.getConnection();
                stmt = conn.createStatement();
                stmt.execute("CREATE OR REPLACE TABLE SNOW16332 (i int)");
                for (int stmtCounter = 2000; stmtCounter > 0; --stmtCounter) {
                    stmt.executeUpdate("INSERT INTO SNOW16332 VALUES (" + stmtCounter + ")");
                }
                connWithNwError = SnowflakeDriverIT.getConnection(500);
                stmtWithNwError = connWithNwError.createStatement();
                stmtWithNwError.executeUpdate("INSERT INTO SNOW16332 SELECT seq8() FROM table(generator(timeLimit => 1))");
                stmtWithNwError.executeUpdate("INSERT INTO SNOW16332 SELECT seq8() FROM table(generator(timeLimit => 1))");
                if (stmt == null) break block4;
            }
            catch (Throwable throwable) {
                if (stmt != null) {
                    stmt.executeQuery("DROP TABLE SNOW16332");
                }
                this.closeSQLObjects(stmt, conn);
                this.closeSQLObjects(stmtWithNwError, connWithNwError);
                throw throwable;
            }
            stmt.executeQuery("DROP TABLE SNOW16332");
        }
        this.closeSQLObjects(stmt, conn);
        this.closeSQLObjects(stmtWithNwError, connWithNwError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testV1Query() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int i;
            connection = SnowflakeDriverIT.getConnection(200);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT count(*) FROM table(generator(rowCount => 100000000))");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnCount());
            for (i = 0; i < 1; ++i) {
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertTrue((resultSet.getInt(1) > 0 ? 1 : 0) != 0);
            }
            resultSet = statement.executeQuery("SELECT 'Fri, 23 Oct 2015 12:35:38 -0700'::timestamp_tz");
            resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnCount());
            for (i = 0; i < 1; ++i) {
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((Object)"Fri, 23 Oct 2015 12:35:38 -0700", (Object)resultSet.getString(1));
            }
        }
        catch (Throwable throwable) {
            this.closeSQLObjects(resultSet, statement, connection);
            throw throwable;
        }
        this.closeSQLObjects(resultSet, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelQuery() throws Throwable {
        ResultSet resultSet = null;
        Connection connection = SnowflakeDriverIT.getConnection();
        final Statement statement = connection.createStatement();
        try {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        statement.cancel();
                    }
                    catch (SQLException ex) {
                        logger.log(Level.SEVERE, "Cancel failed with exception {}", ex);
                    }
                }
            }, 5000L);
            resultSet = statement.executeQuery("SELECT count(*) FROM TABLE(generator(timeLimit => 120))");
            Assert.fail((String)"should be canceled");
            this.closeSQLObjects(resultSet, statement, connection);
        }
        catch (SQLException ex) {
            Assert.assertEquals((String)"sqlstate mismatch", (Object)"57014", (Object)ex.getSQLState());
        }
        finally {
            this.closeSQLObjects(resultSet, statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnow14774() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            ResultSet res = statement.executeQuery("select '2015-03-08 03:30:00'::timestamp_ntz");
            res.next();
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            Timestamp tsInUTC = res.getTimestamp(1, calendar);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String tsStrInUTC = sdf.format(tsInUTC);
            calendar.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
            Timestamp tsInLA = res.getTimestamp(1, calendar);
            sdf.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
            String tsStrInLA = sdf.format(tsInLA);
            Assert.assertEquals((String)"timestamp values not equal", (Object)tsStrInUTC, (Object)tsStrInLA);
            res = statement.executeQuery("select '2015-03-08 01:30:00'::timestamp_ntz");
            res.next();
            calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
            tsInUTC = res.getTimestamp(1, calendar);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            tsStrInUTC = sdf.format(tsInUTC);
            calendar.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
            tsInLA = res.getTimestamp(1, calendar);
            sdf.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
            tsStrInLA = sdf.format(tsInLA);
            Assert.assertEquals((String)"timestamp values not equal", (Object)tsStrInUTC, (Object)tsStrInLA);
        }
        finally {
            this.closeSQLObjects(null, statement, connection);
        }
    }

    @Test
    public void testSnow19172() throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            statement.executeQuery("select 1");
            Assert.assertTrue((!statement.getMoreResults() ? 1 : 0) != 0);
        }
        finally {
            this.closeSQLObjects(statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testSnow19819() throws Throwable {
        Connection connection;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block3: {
            preparedStatement = null;
            Statement regularStatement = null;
            resultSet = null;
            connection = SnowflakeDriverIT.getConnection();
            try {
                regularStatement = connection.createStatement();
                regularStatement.execute("create or replace table testSnow19819(\ns string,\nv variant,\nt timestamp_ltz)\n");
                preparedStatement = connection.prepareStatement("insert into testSnow19819 (s, v, t)\nselect ?, parse_json(?), to_timestamp(?)");
                preparedStatement.setString(1, "foo");
                preparedStatement.setString(2, "{ }");
                preparedStatement.setString(3, "2016-05-12 12:15:00");
                preparedStatement.addBatch();
                preparedStatement.setString(1, "foo2");
                preparedStatement.setString(2, "{ \"a\": 1 }");
                preparedStatement.setString(3, "2016-05-12 12:16:00");
                preparedStatement.addBatch();
                preparedStatement.executeBatch();
                resultSet = connection.createStatement().executeQuery("SELECT s, v, t FROM testSnow19819 ORDER BY 1");
                MatcherAssert.assertThat((String)"next result", (boolean)resultSet.next());
                MatcherAssert.assertThat((String)"String", (Object)resultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"foo"));
                MatcherAssert.assertThat((String)"Variant", (Object)resultSet.getString(2), (Matcher)CoreMatchers.equalTo((Object)"{}"));
                MatcherAssert.assertThat((String)"next result", (boolean)resultSet.next());
                MatcherAssert.assertThat((String)"String", (Object)resultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"foo2"));
                MatcherAssert.assertThat((String)"Variant", (Object)resultSet.getString(2), (Matcher)CoreMatchers.equalTo((Object)"{\n  \"a\": 1\n}"));
                MatcherAssert.assertThat((String)"no more result", (!resultSet.next() ? 1 : 0) != 0);
                if (regularStatement == null) break block3;
            }
            catch (Throwable throwable) {
                if (regularStatement != null) {
                    regularStatement.execute("DROP TABLE testSnow19819");
                }
                this.closeSQLObjects(resultSet, preparedStatement, connection);
                throw throwable;
            }
            regularStatement.execute("DROP TABLE testSnow19819");
        }
        this.closeSQLObjects(resultSet, preparedStatement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnTestaccount.class)
    public void testClientInfo() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet res = null;
        try {
            System.setProperty("snowflake.client.info", "{\"spark.version\":\"3.0.0\", \"spark.snowflakedb.version\":\"2.8.5\", \"spark.app.name\":\"SnowflakeSourceSuite\", \"scala.version\":\"2.12.11\", \"java.version\":\"1.8.0_221\", \"snowflakedb.jdbc.version\":\"3.13.2\"}");
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            res = statement.executeQuery("select current_session_client_info()");
            Assert.assertTrue((String)"result expected", (boolean)res.next());
            String clientInfoJSONStr = res.getString(1);
            JsonNode clientInfoJSON = this.mapper.readTree(clientInfoJSONStr);
            Assert.assertEquals((String)"spark version mismatch", (Object)"3.0.0", (Object)clientInfoJSON.get("spark.version").asText());
            Assert.assertEquals((String)"snowflakedb version mismatch", (Object)"2.8.5", (Object)clientInfoJSON.get("spark.snowflakedb.version").asText());
            Assert.assertEquals((String)"spark app mismatch", (Object)"SnowflakeSourceSuite", (Object)clientInfoJSON.get("spark.app.name").asText());
        }
        catch (Throwable throwable) {
            System.clearProperty("snowflake.client.info");
            this.closeSQLObjects(res, statement, connection);
            throw throwable;
        }
        System.clearProperty("snowflake.client.info");
        this.closeSQLObjects(res, statement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeResultSet() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            statement = connection.createStatement();
            String sql = "SELECT random()||random(), randstr(1000, random()) FROM table(generator(rowcount => 10000))";
            ResultSet result = statement.executeQuery(sql);
            int cnt = 0;
            while (result.next()) {
                ++cnt;
            }
            Assert.assertEquals((long)10000L, (long)cnt);
        }
        finally {
            this.closeSQLObjects(null, statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testSnow26503() throws Throwable {
        ResultSet resultSet;
        Statement regularStatementSF;
        PreparedStatement preparedStatement;
        Connection snowflakeConnection;
        Connection connection;
        block7: {
            connection = null;
            snowflakeConnection = null;
            preparedStatement = null;
            Statement regularStatement = null;
            regularStatementSF = null;
            resultSet = null;
            try {
                connection = SnowflakeDriverIT.getConnection();
                regularStatement = connection.createStatement();
                regularStatement.execute("create or replace table testBind2(a int) as select * from values(1),(2),(8),(10)");
                preparedStatement = connection.prepareStatement("SELECT * FROM testBind2 WHERE a between ? and ?");
                preparedStatement.setInt(1, 3);
                preparedStatement.setInt(2, 9);
                resultSet = preparedStatement.executeQuery();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnCount());
                Assert.assertTrue((boolean)resultSet.next());
                resultSet.close();
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("SELECT last_query_id()");
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                String queryId = resultSet.getString(1);
                resultSet.close();
                preparedStatement.close();
                snowflakeConnection = SnowflakeDriverIT.getSnowflakeAdminConnection();
                regularStatementSF = snowflakeConnection.createStatement();
                regularStatementSF.execute("create or replace warehouse wh26503 warehouse_size=xsmall");
                preparedStatement = snowflakeConnection.prepareStatement("select bv:\"1\":\"value\"::string, bv:\"2\":\"value\"::string from (select parse_json(system$get_bind_values(?)) bv)");
                preparedStatement.setString(1, queryId);
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                Assert.assertEquals((long)3L, (long)resultSet.getInt(1));
                Assert.assertEquals((long)9L, (long)resultSet.getInt(2));
                if (regularStatement == null) break block7;
            }
            catch (Throwable throwable) {
                if (regularStatement != null) {
                    regularStatement.execute("DROP TABLE testBind2");
                    regularStatement.close();
                }
                if (regularStatementSF != null) {
                    regularStatementSF.execute("DROP warehouse wh26503");
                    regularStatementSF.close();
                }
                this.closeSQLObjects(resultSet, preparedStatement, connection);
                if (snowflakeConnection != null) {
                    snowflakeConnection.close();
                }
                throw throwable;
            }
            regularStatement.execute("DROP TABLE testBind2");
            regularStatement.close();
        }
        if (regularStatementSF != null) {
            regularStatementSF.execute("DROP warehouse wh26503");
            regularStatementSF.close();
        }
        this.closeSQLObjects(resultSet, preparedStatement, connection);
        if (snowflakeConnection != null) {
            snowflakeConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testSnow28530() throws Throwable {
        PreparedStatement preparedStatement;
        Connection connection;
        block9: {
            connection = null;
            preparedStatement = null;
            Statement regularStatement = null;
            try {
                connection = SnowflakeDriverIT.getConnection();
                regularStatement = connection.createStatement();
                regularStatement.execute("create or replace table t(a number, b number)");
                try {
                    preparedStatement = connection.prepareStatement("create or replace view v as select * from t where a=?");
                    preparedStatement.setInt(1, 1);
                    preparedStatement.execute();
                    Assert.fail((String)"Bind variable in view definition did not cause a user error");
                }
                catch (SnowflakeSQLException e) {
                    Assert.assertEquals((long)2210L, (long)e.getErrorCode());
                }
                try {
                    preparedStatement = connection.prepareStatement("create or replace function f(n number) returns number as 'n + ?'");
                    preparedStatement.execute();
                    Assert.fail((String)"Bind variable in scalar UDF definition did not cause a user error");
                }
                catch (SnowflakeSQLException e) {
                    Assert.assertEquals((long)2210L, (long)e.getErrorCode());
                }
                try {
                    preparedStatement = connection.prepareStatement("create or replace function tf(n number) returns table(b number) as 'select b from t where a=?'");
                    preparedStatement.execute();
                    Assert.fail((String)"Bind variable in table UDF definition did not cause a user error");
                }
                catch (SnowflakeSQLException e) {
                    Assert.assertEquals((long)2210L, (long)e.getErrorCode());
                }
                if (regularStatement == null) break block9;
            }
            catch (Throwable throwable) {
                if (regularStatement != null) {
                    regularStatement.execute("drop table t");
                    regularStatement.close();
                }
                this.closeSQLObjects(null, preparedStatement, connection);
                throw throwable;
            }
            regularStatement.execute("drop table t");
            regularStatement.close();
        }
        this.closeSQLObjects(null, preparedStatement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testSnow31104() throws Throwable {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block3: {
            connection = null;
            preparedStatement = null;
            Statement regularStatement = null;
            resultSet = null;
            try {
                Properties paramProperties = new Properties();
                paramProperties.put("TYPESYSTEM_WIDEN_CONSTANTS_EXACTLY", Boolean.TRUE.toString());
                connection = SnowflakeDriverIT.getConnection(paramProperties);
                regularStatement = connection.createStatement();
                regularStatement.execute("create or replace table t(n number)");
                regularStatement.executeUpdate("insert into t values (1), (90000000000000000000000000000000000000)");
                preparedStatement = connection.prepareStatement("select n, n > ? from t order by 1");
                preparedStatement.setString(1, "1");
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                Assert.assertFalse((boolean)resultSet.getBoolean(2));
                resultSet.next();
                Assert.assertTrue((boolean)resultSet.getBoolean(2));
                preparedStatement = connection.prepareStatement("select n, '1' in (?, '256', n, 10) from t order by 1");
                preparedStatement.setString(1, null);
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                Assert.assertTrue((boolean)resultSet.getBoolean(2));
                resultSet.next();
                Assert.assertNull((Object)resultSet.getObject(2));
                if (regularStatement == null) break block3;
            }
            catch (Throwable throwable) {
                if (regularStatement != null) {
                    regularStatement.execute("drop table t");
                    regularStatement.close();
                }
                this.closeSQLObjects(resultSet, preparedStatement, connection);
                throw throwable;
            }
            regularStatement.execute("drop table t");
            regularStatement.close();
        }
        this.closeSQLObjects(resultSet, preparedStatement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPutGet() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            try {
                connection = SnowflakeDriverIT.getConnection(accounts.get(i));
                statement = connection.createStatement();
                String sourceFilePath = SnowflakeDriverIT.getFullPathFileInResource("orders_100.csv");
                File destFolder = this.tmpFolder.newFolder();
                String destFolderCanonicalPath = destFolder.getCanonicalPath();
                String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
                try {
                    statement.execute("alter session set ENABLE_GCP_PUT_EXCEPTION_FOR_OLD_DRIVERS=false");
                    statement.execute("CREATE OR REPLACE STAGE testPutGet_stage");
                    Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + sourceFilePath + " @testPutGet_stage"));
                    SnowflakeDriverIT.findFile(statement, "ls @testPutGet_stage/");
                    Assert.assertTrue((String)"Failed to get a file", (boolean)statement.execute("GET @testPutGet_stage 'file://" + destFolderCanonicalPath + "' parallel=8"));
                    File downloaded = new File(destFolderCanonicalPathWithSeparator + "orders_100.csv" + ".gz");
                    assert (downloaded.exists());
                    Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "orders_100.csv" + ".gz");
                    p.waitFor();
                    File original = new File(sourceFilePath);
                    File unzipped = new File(destFolderCanonicalPathWithSeparator + "orders_100.csv");
                    assert (original.length() == unzipped.length());
                }
                finally {
                    statement.execute("DROP STAGE IF EXISTS testGetPut_stage");
                    statement.close();
                }
            }
            catch (Throwable throwable) {
                this.closeSQLObjects(null, statement, connection);
                throw throwable;
            }
            this.closeSQLObjects(null, statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPutGetToUnencryptedStage() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            try {
                connection = SnowflakeDriverIT.getConnection(accounts.get(i));
                statement = connection.createStatement();
                String sourceFilePath = SnowflakeDriverIT.getFullPathFileInResource("orders_100.csv");
                File destFolder = this.tmpFolder.newFolder();
                String destFolderCanonicalPath = destFolder.getCanonicalPath();
                String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
                try {
                    statement.execute("alter session set ENABLE_UNENCRYPTED_INTERNAL_STAGES=true");
                    statement.execute("alter session set ENABLE_GCP_PUT_EXCEPTION_FOR_OLD_DRIVERS=false");
                    statement.execute("CREATE OR REPLACE STAGE testPutGet_unencstage encryption=(TYPE='SNOWFLAKE_SSE')");
                    Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + sourceFilePath + " @testPutGet_unencstage"));
                    SnowflakeDriverIT.findFile(statement, "ls @testPutGet_unencstage/");
                    Assert.assertTrue((String)"Failed to get a file", (boolean)statement.execute("GET @testPutGet_unencstage 'file://" + destFolderCanonicalPath + "' parallel=8"));
                    File downloaded = new File(destFolderCanonicalPathWithSeparator + "orders_100.csv" + ".gz");
                    assert (downloaded.exists());
                    Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "orders_100.csv" + ".gz");
                    p.waitFor();
                    File original = new File(sourceFilePath);
                    File unzipped = new File(destFolderCanonicalPathWithSeparator + "orders_100.csv");
                    assert (original.length() == unzipped.length());
                }
                finally {
                    statement.execute("DROP STAGE IF EXISTS testPutGet_unencstage");
                    statement.close();
                }
            }
            catch (Throwable throwable) {
                this.closeSQLObjects(null, statement, connection);
                throw throwable;
            }
            this.closeSQLObjects(null, statement, connection);
        }
    }

    @Test(expected=SQLException.class)
    public void testNotClosedSession() throws Throwable {
        Connection connection = SnowflakeDriverIT.getConnection();
        connection.close();
        connection.prepareStatement("select 1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testToTimestampNullBind() throws Throwable {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = SnowflakeDriverIT.getConnection();
            preparedStatement = connection.prepareStatement("select 3 where to_timestamp_ltz(?, 3) = '1970-01-01 00:00:12.345 +000'::timestamp_ltz");
            preparedStatement.setInt(1, 12345);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Assert.assertEquals((long)1L, (long)resultSetMetaData.getColumnCount());
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)3L, (long)resultSet.getInt(1));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement.setNull(1, 4);
            resultSet = preparedStatement.executeQuery();
            Assert.assertFalse((boolean)resultSet.next());
        }
        finally {
            this.closeSQLObjects(preparedStatement, connection);
        }
    }
}

