/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.cloud.storage.StorageException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import net.snowflake.client.ConditionalIgnoreRule;
import net.snowflake.client.RunningOnGithubAction;
import net.snowflake.client.RunningOnTestaccount;
import net.snowflake.client.TestUtil;
import net.snowflake.client.category.TestCategoryOthers;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeDriverIT;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferConfig;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadataV1;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatement;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageClientFactory;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={TestCategoryOthers.class})
public class SnowflakeDriverLatestIT
extends BaseJDBCTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public TemporaryFolder tmpFolder2 = new TemporaryFolder();
    public String testStageName = String.format("test_stage_%s", UUID.randomUUID().toString()).replaceAll("-", "_");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFileContentEqual(String fileFullPath1, boolean compressedFile1, String fileFullPath2, boolean compressedFile2) throws Throwable {
        InputStream inputStream1 = new FileInputStream(fileFullPath1);
        InputStream inputStream2 = new FileInputStream(fileFullPath2);
        try {
            if (compressedFile1) {
                inputStream1 = new GZIPInputStream(inputStream1);
            }
            if (compressedFile2) {
                inputStream2 = new GZIPInputStream(inputStream2);
            }
            boolean bl = Arrays.equals(IOUtils.toByteArray((InputStream)inputStream1), IOUtils.toByteArray((InputStream)inputStream2));
            return bl;
        }
        finally {
            inputStream1.close();
            inputStream2.close();
        }
    }

    @Test
    public void testStaticVersionMatchesManifest() {
        Assert.assertEquals((Object)SnowflakeDriver.implementVersion, (Object)SnowflakeDriver.getClientVersionStringFromManifest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnTestaccount.class)
    public void testClientInfoConnectionProperty() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet res = null;
        try {
            Properties props = new Properties();
            props.put("snowflakeClientInfo", "{\"spark.version\":\"3.0.0\", \"spark.snowflakedb.version\":\"2.8.5\", \"spark.app.name\":\"SnowflakeSourceSuite\", \"scala.version\":\"2.12.11\", \"java.version\":\"1.8.0_221\", \"snowflakedb.jdbc.version\":\"3.13.2\"}");
            connection = SnowflakeDriverLatestIT.getConnection(0, props, false, false);
            statement = connection.createStatement();
            res = statement.executeQuery("select current_session_client_info()");
            Assert.assertTrue((boolean)res.next());
            String clientInfoJSONStr = res.getString(1);
            JsonNode clientInfoJSON = SnowflakeResultSetSerializableV1.mapper.readTree(clientInfoJSONStr);
            Assert.assertEquals((String)"spark version mismatch", (Object)"3.0.0", (Object)clientInfoJSON.get("spark.version").asText());
            Assert.assertEquals((String)"spark app mismatch", (Object)"SnowflakeSourceSuite", (Object)clientInfoJSON.get("spark.app.name").asText());
            connection.close();
            System.setProperty("snowflake.client.info", "{\"spark.version\":\"fake\", \"spark.snowflakedb.version\":\"fake\", \"spark.app.name\":\"fake\", \"scala.version\":\"fake\", \"java.version\":\"fake\", \"snowflakedb.jdbc.version\":\"fake\"}");
            connection = SnowflakeDriverLatestIT.getConnection(0, props, false, false);
            statement = connection.createStatement();
            res = statement.executeQuery("select current_session_client_info()");
            Assert.assertTrue((boolean)res.next());
            clientInfoJSONStr = res.getString(1);
            clientInfoJSON = SnowflakeResultSetSerializableV1.mapper.readTree(clientInfoJSONStr);
            Assert.assertEquals((String)"spark version mismatch", (Object)"3.0.0", (Object)clientInfoJSON.get("spark.version").asText());
            Assert.assertEquals((String)"spark app mismatch", (Object)"SnowflakeSourceSuite", (Object)clientInfoJSON.get("spark.app.name").asText());
        }
        catch (Throwable throwable) {
            System.clearProperty("snowflake.client.info");
            this.closeSQLObjects(res, statement, connection);
            throw throwable;
        }
        System.clearProperty("snowflake.client.info");
        this.closeSQLObjects(res, statement, connection);
    }

    @Test
    public void testGetSessionID() throws Throwable {
        Connection con = SnowflakeDriverLatestIT.getConnection();
        String sessionID = con.unwrap(SnowflakeConnection.class).getSessionID();
        Statement statement = con.createStatement();
        ResultSet rset = statement.executeQuery("select current_session()");
        rset.next();
        Assert.assertEquals((Object)sessionID, (Object)rset.getString(1));
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPutThreshold() throws SQLException {
        try (Connection connection = SnowflakeDriverLatestIT.getConnection();){
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            Statement statement = connection.createStatement();
            SFStatement sfStatement = statement.unwrap(SnowflakeStatementV1.class).getSfStatement();
            statement.execute("CREATE OR REPLACE STAGE PUTTHRESHOLDSTAGE");
            String command = "PUT file://" + SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv") + " @PUTTHRESHOLDSTAGE";
            SnowflakeFileTransferAgent agent = new SnowflakeFileTransferAgent(command, sfSession, sfStatement);
            Assert.assertEquals((long)0xC800000L, (long)agent.getBigFileThreshold());
            String commandWithPut = command + " threshold=314572800";
            agent = new SnowflakeFileTransferAgent(commandWithPut, sfSession, sfStatement);
            Assert.assertEquals((long)314572800L, (long)agent.getBigFileThreshold());
            agent = new SnowflakeFileTransferAgent(command, sfSession, sfStatement);
            Assert.assertEquals((long)0xC800000L, (long)agent.getBigFileThreshold());
            String commandWithInvalidThreshold = command + " threshold=-1";
            try {
                agent = new SnowflakeFileTransferAgent(commandWithInvalidThreshold, sfSession, sfStatement);
            }
            catch (SQLException e) {
                Assert.assertEquals((Object)"22023", (Object)e.getSQLState());
            }
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testGCPFileTransferMetadataWithOneFile() throws Throwable {
        Connection connection = null;
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        try {
            connection = SnowflakeDriverLatestIT.getConnection("gcpaccount");
            Statement statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String putCommand1 = "put file:///dummy/path/file1.gz @" + this.testStageName;
            SnowflakeFileTransferAgent sfAgent1 = new SnowflakeFileTransferAgent(putCommand1, sfSession, new SFStatement(sfSession));
            List metadatas1 = sfAgent1.getFileTransferMetadatas();
            String srcPath1 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv");
            for (SnowflakeFileTransferMetadata oneMetadata : metadatas1) {
                FileInputStream inputStream = new FileInputStream(srcPath1);
                assert (oneMetadata.isForOneFile());
                SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).build());
            }
            String putCommand2 = "put file:///dummy/path/file2.gz @" + this.testStageName;
            SnowflakeFileTransferAgent sfAgent2 = new SnowflakeFileTransferAgent(putCommand2, sfSession, new SFStatement(sfSession));
            List metadatas2 = sfAgent2.getFileTransferMetadatas();
            String srcPath2 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_101.csv");
            for (SnowflakeFileTransferMetadata oneMetadata : metadatas2) {
                String gzfilePath = destFolderCanonicalPath + "/tmp_compress.gz";
                Process p = Runtime.getRuntime().exec("cp -fr " + srcPath2 + " " + destFolderCanonicalPath + "/tmp_compress");
                p.waitFor();
                p = Runtime.getRuntime().exec("gzip " + destFolderCanonicalPath + "/tmp_compress");
                p.waitFor();
                FileInputStream gzInputStream = new FileInputStream(gzfilePath);
                assert (oneMetadata.isForOneFile());
                SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)gzInputStream).setRequireCompress(false).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).build());
            }
            Assert.assertTrue((String)"Failed to get files", (boolean)statement.execute("GET @" + this.testStageName + " 'file://" + destFolderCanonicalPath + "/' parallel=8"));
            assert (this.isFileContentEqual(srcPath1, false, destFolderCanonicalPath + "/file1.gz", true));
            assert (this.isFileContentEqual(srcPath2, false, destFolderCanonicalPath + "/file2.gz", true));
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists " + this.testStageName);
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testAzureS3FileTransferMetadataWithOneFile() throws Throwable {
        Connection connection = null;
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        List<String> supportedAccounts = Arrays.asList("s3testaccount", "azureaccount");
        for (String accountName : supportedAccounts) {
            try {
                connection = SnowflakeDriverLatestIT.getConnection(accountName);
                Statement statement = connection.createStatement();
                statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
                SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
                String putCommand1 = "put file:///dummy/path/file1.gz @" + this.testStageName;
                SnowflakeFileTransferAgent sfAgent1 = new SnowflakeFileTransferAgent(putCommand1, sfSession, new SFStatement(sfSession));
                List metadatas1 = sfAgent1.getFileTransferMetadatas();
                String srcPath1 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv");
                for (SnowflakeFileTransferMetadata oneMetadata : metadatas1) {
                    FileInputStream inputStream = new FileInputStream(srcPath1);
                    SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand1).build());
                }
                String putCommand2 = "put file:///dummy/path/file2.gz @" + this.testStageName;
                SnowflakeFileTransferAgent sfAgent2 = new SnowflakeFileTransferAgent(putCommand2, sfSession, new SFStatement(sfSession));
                List metadatas2 = sfAgent2.getFileTransferMetadatas();
                String srcPath2 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_101.csv");
                for (SnowflakeFileTransferMetadata oneMetadata : metadatas2) {
                    String gzfilePath = destFolderCanonicalPath + "/tmp_compress.gz";
                    Process p = Runtime.getRuntime().exec("cp -fr " + srcPath2 + " " + destFolderCanonicalPath + "/tmp_compress");
                    p.waitFor();
                    p = Runtime.getRuntime().exec("gzip " + destFolderCanonicalPath + "/tmp_compress");
                    p.waitFor();
                    FileInputStream gzInputStream = new FileInputStream(gzfilePath);
                    SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)gzInputStream).setRequireCompress(false).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand2).build());
                }
                Assert.assertTrue((String)"Failed to get files", (boolean)statement.execute("GET @" + this.testStageName + " 'file://" + destFolderCanonicalPath + "/' parallel=8"));
                assert (this.isFileContentEqual(srcPath1, false, destFolderCanonicalPath + "/file1.gz", true));
                assert (this.isFileContentEqual(srcPath2, false, destFolderCanonicalPath + "/file2.gz", true));
            }
            finally {
                if (connection == null) continue;
                connection.createStatement().execute("DROP STAGE if exists " + this.testStageName);
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGCPFileTransferMetadataNegativeOnlySupportPut() throws Throwable {
        Connection connection = null;
        int expectExceptionCount = 1;
        int actualExceptionCount = -1;
        try {
            connection = SnowflakeDriverLatestIT.getConnection("gcpaccount");
            Statement statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
            String srcPath = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv");
            statement.execute("put file://" + srcPath + " @" + this.testStageName);
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            File destFolder = this.tmpFolder.newFolder();
            String destFolderCanonicalPath = destFolder.getCanonicalPath();
            String getCommand = "get @" + this.testStageName + " file://" + destFolderCanonicalPath;
            statement.execute(getCommand);
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(getCommand, sfSession, new SFStatement(sfSession));
            actualExceptionCount = 0;
            sfAgent.getFileTransferMetadatas();
            Assert.fail((String)"Above function should raise exception for GET");
        }
        catch (Exception ex) {
            System.out.println("Negative test to hit expected exception: " + ex.getMessage());
            ++actualExceptionCount;
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists " + this.testStageName);
                connection.close();
            }
        }
        Assert.assertEquals((long)expectExceptionCount, (long)actualExceptionCount);
    }

    @Test
    public void testGetPropertyInfo() throws SQLException {
        String url = "";
        Properties props = new Properties();
        Driver driver = DriverManager.getDriver("jdbc:snowflake://snowflake.reg.local:8082");
        DriverPropertyInfo[] info = driver.getPropertyInfo(url, props);
        Assert.assertEquals((long)1L, (long)info.length);
        Assert.assertEquals((Object)"serverURL", (Object)info[0].name);
        Assert.assertEquals((Object)"server URL in form of <protocol>://<host or domain>:<port number>/<path of resource>", (Object)info[0].description);
        url = "jdbc:snowflake://snowflake.reg.local:8082";
        info = driver.getPropertyInfo(url, props);
        Assert.assertEquals((long)2L, (long)info.length);
        Assert.assertEquals((Object)"user", (Object)info[0].name);
        Assert.assertEquals((Object)"username for account", (Object)info[0].description);
        Assert.assertEquals((Object)"password", (Object)info[1].name);
        Assert.assertEquals((Object)"password for account", (Object)info[1].description);
        props.put("user", "snowman");
        props.put("password", "test");
        info = driver.getPropertyInfo(url, props);
        Assert.assertEquals((long)0L, (long)info.length);
        props.put("useProxy", "true");
        info = driver.getPropertyInfo(url, props);
        Assert.assertEquals((long)2L, (long)info.length);
        Assert.assertEquals((Object)"proxyHost", (Object)info[0].name);
        Assert.assertEquals((Object)"proxy host name", (Object)info[0].description);
        Assert.assertEquals((Object)"proxyPort", (Object)info[1].name);
        Assert.assertEquals((Object)"proxy port; should be an integer", (Object)info[1].description);
        props.put("proxyHost", "dummyHost");
        props.put("proxyPort", "dummyPort");
        info = driver.getPropertyInfo(url, props);
        Assert.assertEquals((long)0L, (long)info.length);
        try {
            url = "snowflake.reg.local:8082";
            driver.getPropertyInfo(url, props);
        }
        catch (SQLException e) {
            Assert.assertEquals((long)ErrorCode.INVALID_CONNECT_STRING.getMessageCode().intValue(), (long)e.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPutOverwriteFalseNoDigest() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        File file1 = this.tmpFolder.newFile("testfile.csv");
        BufferedWriter bw = new BufferedWriter(new FileWriter(file1));
        bw.write("Writing original file content. This should get overwritten.");
        bw.close();
        File file2 = this.tmpFolder2.newFile("testfile.csv");
        bw = new BufferedWriter(new FileWriter(file2));
        bw.write("This is all new! This should be the result of the overwriting.");
        bw.close();
        String sourceFilePathOriginal = file1.getCanonicalPath();
        String sourceFilePathOverwrite = file2.getCanonicalPath();
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
        Properties paramProperties = new Properties();
        paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            try {
                connection = SnowflakeDriverLatestIT.getConnection(accounts.get(i), paramProperties);
                statement = connection.createStatement();
                statement.execute("CREATE OR REPLACE STAGE testing_stage");
                Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + sourceFilePathOriginal + " @testing_stage"));
                SnowflakeDriverIT.findFile(statement, "ls @testing_stage/");
                Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + sourceFilePathOverwrite + " @testing_stage overwrite=false"));
                SnowflakeDriverIT.findFile(statement, "ls @testing_stage/");
                Assert.assertTrue((String)"Failed to get files", (boolean)statement.execute("GET @testing_stage 'file://" + destFolderCanonicalPath + "' parallel=8"));
                File downloaded = new File(destFolderCanonicalPathWithSeparator + "testfile.csv.gz");
                Assert.assertTrue((boolean)downloaded.exists());
                Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "testfile.csv.gz");
                p.waitFor();
                File unzipped = new File(destFolderCanonicalPathWithSeparator + "testfile.csv");
                Assert.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)unzipped, null));
                continue;
            }
            finally {
                statement.execute("DROP TABLE IF EXISTS testLoadToLocalFS");
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testSnow76376() throws Throwable {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block21: {
            connection = null;
            preparedStatement = null;
            Statement regularStatement = null;
            resultSet = null;
            try {
                int i;
                connection = SnowflakeDriverLatestIT.getConnection();
                regularStatement = connection.createStatement();
                regularStatement.execute("create or replace table t(a int) as select * from values(1),(2),(8),(10)");
                preparedStatement = connection.prepareStatement("SELECT * FROM t ORDER BY a LIMIT ? OFFSET ?");
                preparedStatement.setNull(1, 4);
                preparedStatement.setNull(2, 4);
                if (preparedStatement.execute()) {
                    resultSet = preparedStatement.getResultSet();
                    resultSet.next();
                    Assert.assertEquals((long)1L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)2L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)8L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)10L, (long)resultSet.getInt(1));
                } else {
                    Assert.fail((String)"Could not execute preparedStatement with OFFSET and LIMIT set to NULL");
                }
                preparedStatement.setString(1, "");
                preparedStatement.setString(2, "");
                if (preparedStatement.execute()) {
                    resultSet = preparedStatement.getResultSet();
                    resultSet.next();
                    Assert.assertEquals((long)1L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)2L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)8L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)10L, (long)resultSet.getInt(1));
                } else {
                    Assert.fail((String)"Could not execute preparedStatement with OFFSET and LIMIT set to empty string");
                }
                preparedStatement.setNull(1, 4);
                preparedStatement.setInt(2, 2);
                if (preparedStatement.execute()) {
                    resultSet = preparedStatement.getResultSet();
                    resultSet.next();
                    Assert.assertEquals((long)8L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)10L, (long)resultSet.getInt(1));
                } else {
                    Assert.fail((String)"Could not execute preparedStatement with LIMIT set to NULL");
                }
                preparedStatement.setString(1, "");
                preparedStatement.setInt(2, 2);
                if (preparedStatement.execute()) {
                    resultSet = preparedStatement.getResultSet();
                    resultSet.next();
                    Assert.assertEquals((long)8L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)10L, (long)resultSet.getInt(1));
                } else {
                    Assert.fail((String)"Could not execute preparedStatement with LIMIT set to empty string");
                }
                preparedStatement.setInt(1, 3);
                preparedStatement.setNull(2, 4);
                if (preparedStatement.execute()) {
                    resultSet = preparedStatement.getResultSet();
                    resultSet.next();
                    Assert.assertEquals((long)1L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)2L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)8L, (long)resultSet.getInt(1));
                } else {
                    Assert.fail((String)"Could not execute preparedStatement with OFFSET set to NULL");
                }
                preparedStatement.setInt(1, 3);
                preparedStatement.setNull(2, 4);
                if (preparedStatement.execute()) {
                    resultSet = preparedStatement.getResultSet();
                    resultSet.next();
                    Assert.assertEquals((long)1L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)2L, (long)resultSet.getInt(1));
                    resultSet.next();
                    Assert.assertEquals((long)8L, (long)resultSet.getInt(1));
                } else {
                    Assert.fail((String)"Could not execute preparedStatement with OFFSET set to empty string");
                }
                preparedStatement = connection.prepareStatement("SELECT 1 FROM t ORDER BY a LIMIT ? OFFSET ?");
                preparedStatement.setNull(1, 4);
                preparedStatement.setNull(2, 4);
                if (preparedStatement.execute()) {
                    resultSet = preparedStatement.getResultSet();
                    for (i = 0; i < 4; ++i) {
                        resultSet.next();
                        Assert.assertEquals((long)1L, (long)resultSet.getInt(1));
                    }
                } else {
                    Assert.fail((String)"Could not execute constant preparedStatement with OFFSET and LIMIT set to NULL");
                }
                preparedStatement.setString(1, "");
                preparedStatement.setString(2, "");
                if (preparedStatement.execute()) {
                    resultSet = preparedStatement.getResultSet();
                    for (i = 0; i < 4; ++i) {
                        resultSet.next();
                        Assert.assertEquals((long)1L, (long)resultSet.getInt(1));
                    }
                } else {
                    Assert.fail((String)"Could not execute constant preparedStatement with OFFSET and LIMIT set to empty string");
                }
                if (regularStatement == null) break block21;
            }
            catch (Throwable throwable) {
                if (regularStatement != null) {
                    regularStatement.execute("drop table t");
                    regularStatement.close();
                }
                this.closeSQLObjects(resultSet, preparedStatement, connection);
                throw throwable;
            }
            regularStatement.execute("drop table t");
            regularStatement.close();
        }
        this.closeSQLObjects(resultSet, preparedStatement, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGeoOutputTypes() throws Throwable {
        Connection connection = null;
        Statement regularStatement = null;
        try {
            Properties paramProperties = new Properties();
            paramProperties.put("ENABLE_USER_DEFINED_TYPE_EXPANSION", (Object)true);
            paramProperties.put("ENABLE_GEOGRAPHY_TYPE", (Object)true);
            connection = SnowflakeDriverLatestIT.getConnection(paramProperties);
            regularStatement = connection.createStatement();
            regularStatement.execute("create or replace table t_geo(geo geography);");
            regularStatement.execute("insert into t_geo values ('POINT(0 0)'), ('LINESTRING(1 1, 2 2)')");
            this.testGeoOutputTypeSingle(regularStatement, false, "geoJson", "OBJECT", "java.lang.String", 12);
            this.testGeoOutputTypeSingle(regularStatement, true, "geoJson", "GEOGRAPHY", "java.lang.String", 12);
            this.testGeoOutputTypeSingle(regularStatement, false, "wkt", "VARCHAR", "java.lang.String", 12);
            this.testGeoOutputTypeSingle(regularStatement, true, "wkt", "GEOGRAPHY", "java.lang.String", 12);
            this.testGeoOutputTypeSingle(regularStatement, false, "wkb", "BINARY", "[B", -2);
            this.testGeoOutputTypeSingle(regularStatement, true, "wkb", "GEOGRAPHY", "[B", -2);
        }
        finally {
            if (regularStatement != null) {
                regularStatement.execute("drop table t_geo");
                regularStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGeoOutputTypeSingle(Statement regularStatement, boolean enableExternalTypeNames, String outputFormat, String expectedColumnTypeName, String expectedColumnClassName, int expectedColumnType) throws Throwable {
        try (ResultSet resultSet = null;){
            regularStatement.execute("alter session set GEOGRAPHY_OUTPUT_FORMAT='" + outputFormat + "'");
            regularStatement.execute("alter session set ENABLE_UDT_EXTERNAL_TYPE_NAMES=" + enableExternalTypeNames);
            resultSet = regularStatement.executeQuery("select * from t_geo");
            ResultSetMetaData metadata = resultSet.getMetaData();
            Assert.assertEquals((long)1L, (long)metadata.getColumnCount());
            Assert.assertEquals((Object)expectedColumnTypeName, (Object)metadata.getColumnTypeName(1));
            Assert.assertEquals((Object)expectedColumnClassName, (Object)metadata.getColumnClassName(1));
            Assert.assertEquals((long)expectedColumnType, (long)metadata.getColumnType(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGeoMetadata() throws Throwable {
        Connection connection = null;
        Statement regularStatement = null;
        try {
            Properties paramProperties = new Properties();
            paramProperties.put("ENABLE_FIX_182763", (Object)true);
            connection = SnowflakeDriverLatestIT.getConnection(paramProperties);
            regularStatement = connection.createStatement();
            regularStatement.execute("create or replace table t_geo(geo geography);");
            this.testGeoMetadataSingle(connection, regularStatement, "geoJson", 12);
            this.testGeoMetadataSingle(connection, regularStatement, "geoJson", 12);
            this.testGeoMetadataSingle(connection, regularStatement, "wkt", 12);
            this.testGeoMetadataSingle(connection, regularStatement, "wkt", 12);
            this.testGeoMetadataSingle(connection, regularStatement, "wkb", -2);
            this.testGeoMetadataSingle(connection, regularStatement, "wkb", -2);
        }
        finally {
            if (regularStatement != null) {
                regularStatement.execute("drop table t_geo");
                regularStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGeoMetadataSingle(Connection connection, Statement regularStatement, String outputFormat, int expectedColumnType) throws Throwable {
        try (ResultSet resultSet = null;){
            regularStatement.execute("alter session set GEOGRAPHY_OUTPUT_FORMAT='" + outputFormat + "'");
            DatabaseMetaData md = connection.getMetaData();
            resultSet = md.getColumns(null, null, "T_GEO", null);
            ResultSetMetaData metadata = resultSet.getMetaData();
            Assert.assertEquals((long)24L, (long)metadata.getColumnCount());
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)expectedColumnType, (long)resultSet.getInt(5));
            Assert.assertEquals((Object)"GEOGRAPHY", (Object)resultSet.getString(6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGeometryOutputTypes() throws Throwable {
        Connection connection = null;
        Statement regularStatement = null;
        try {
            Properties paramProperties = new Properties();
            paramProperties.put("ENABLE_USER_DEFINED_TYPE_EXPANSION", (Object)true);
            paramProperties.put("ENABLE_GEOMETRY_TYPE", (Object)true);
            connection = SnowflakeDriverLatestIT.getConnection(paramProperties);
            regularStatement = connection.createStatement();
            regularStatement.execute("create or replace table t_geo2(geo geometry);");
            regularStatement.execute("insert into t_geo2 values ('POINT(0 0)'), ('LINESTRING(1 1, 2 2)')");
            this.testGeometryOutputTypeSingle(regularStatement, true, "geoJson", "GEOMETRY", "java.lang.String", 12);
            this.testGeometryOutputTypeSingle(regularStatement, true, "wkt", "GEOMETRY", "java.lang.String", 12);
        }
        finally {
            if (regularStatement != null) {
                regularStatement.execute("drop table t_geo2");
                regularStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGeometryOutputTypeSingle(Statement regularStatement, boolean enableExternalTypeNames, String outputFormat, String expectedColumnTypeName, String expectedColumnClassName, int expectedColumnType) throws Throwable {
        try (ResultSet resultSet = null;){
            regularStatement.execute("alter session set GEOGRAPHY_OUTPUT_FORMAT='" + outputFormat + "'");
            regularStatement.execute("alter session set ENABLE_UDT_EXTERNAL_TYPE_NAMES=" + enableExternalTypeNames);
            resultSet = regularStatement.executeQuery("select * from t_geo2");
            ResultSetMetaData metadata = resultSet.getMetaData();
            Assert.assertEquals((long)1L, (long)metadata.getColumnCount());
            Assert.assertEquals((Object)expectedColumnTypeName, (Object)metadata.getColumnTypeName(1));
            Assert.assertEquals((Object)expectedColumnClassName, (Object)metadata.getColumnClassName(1));
            Assert.assertEquals((long)expectedColumnType, (long)metadata.getColumnType(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testGeometryMetadata() throws Throwable {
        Connection connection = null;
        Statement regularStatement = null;
        try {
            Properties paramProperties = new Properties();
            connection = SnowflakeDriverLatestIT.getConnection(paramProperties);
            regularStatement = connection.createStatement();
            regularStatement.execute("create or replace table t_geo2(geo geometry);");
            this.testGeometryMetadataSingle(connection, regularStatement, "geoJson", 12);
            this.testGeometryMetadataSingle(connection, regularStatement, "wkt", 12);
        }
        finally {
            if (regularStatement != null) {
                regularStatement.execute("drop table t_geo2");
                regularStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGeometryMetadataSingle(Connection connection, Statement regularStatement, String outputFormat, int expectedColumnType) throws Throwable {
        try (ResultSet resultSet = null;){
            regularStatement.execute("alter session set GEOGRAPHY_OUTPUT_FORMAT='" + outputFormat + "'");
            DatabaseMetaData md = connection.getMetaData();
            resultSet = md.getColumns(null, null, "T_GEO2", null);
            ResultSetMetaData metadata = resultSet.getMetaData();
            Assert.assertEquals((long)24L, (long)metadata.getColumnCount());
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)expectedColumnType, (long)resultSet.getInt(5));
            Assert.assertEquals((Object)"GEOMETRY", (Object)resultSet.getString(6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPutGetGcsDownscopedCredential() throws Throwable {
        Connection connection = null;
        Statement statement = null;
        Properties paramProperties = new Properties();
        paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
        try {
            connection = SnowflakeDriverLatestIT.getConnection("gcpaccount", paramProperties);
            statement = connection.createStatement();
            String sourceFilePath = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_101.csv");
            File destFolder = this.tmpFolder.newFolder();
            String destFolderCanonicalPath = destFolder.getCanonicalPath();
            String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
            try {
                statement.execute("CREATE OR REPLACE STAGE testPutGet_stage");
                Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + sourceFilePath + " @testPutGet_stage"));
                SnowflakeDriverIT.findFile(statement, "ls @testPutGet_stage/");
                Assert.assertTrue((String)"Failed to get a file", (boolean)statement.execute("GET @testPutGet_stage 'file://" + destFolderCanonicalPath + "' parallel=8"));
                File downloaded = new File(destFolderCanonicalPathWithSeparator + "orders_101.csv" + ".gz");
                assert (downloaded.exists());
                Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "orders_101.csv" + ".gz");
                p.waitFor();
                File original = new File(sourceFilePath);
                File unzipped = new File(destFolderCanonicalPathWithSeparator + "orders_101.csv");
                System.out.println("Original file: " + original.getAbsolutePath() + ", size: " + original.length());
                System.out.println("Unzipped file: " + unzipped.getAbsolutePath() + ", size: " + unzipped.length());
                assert (original.length() == unzipped.length());
            }
            finally {
                statement.execute("DROP STAGE IF EXISTS testGetPut_stage");
                statement.close();
            }
        }
        finally {
            this.closeSQLObjects(null, statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPutGetLargeFileGCSDownscopedCredential() throws Throwable {
        Properties paramProperties = new Properties();
        paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
        Connection connection = SnowflakeDriverLatestIT.getConnection("gcpaccount", paramProperties);
        Statement statement = connection.createStatement();
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
        File largeTempFile = this.tmpFolder.newFile("largeFile.csv");
        BufferedWriter bw = new BufferedWriter(new FileWriter(largeTempFile));
        bw.write("Creating large test file for GCP PUT/GET test");
        bw.write(System.lineSeparator());
        bw.write("Creating large test file for GCP PUT/GET test");
        bw.write(System.lineSeparator());
        bw.close();
        File largeTempFile2 = this.tmpFolder.newFile("largeFile2.csv");
        String sourceFilePath = largeTempFile.getCanonicalPath();
        try {
            for (int i = 0; i < 12; ++i) {
                this.copyContentFrom(largeTempFile, largeTempFile2);
                this.copyContentFrom(largeTempFile2, largeTempFile);
            }
            statement.execute("CREATE OR REPLACE STAGE largefile_stage");
            Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + sourceFilePath + " @largefile_stage"));
            SnowflakeDriverIT.findFile(statement, "ls @largefile_stage/");
            statement.execute("create or replace table large_table (colA string)");
            statement.execute("copy into large_table from @largefile_stage/largeFile.csv.gz");
            statement.execute("create or replace stage extra_stage");
            statement.execute("copy into @extra_stage/bigFile.csv.gz from large_table single=true");
            Assert.assertTrue((String)"Failed to get files", (boolean)statement.execute("GET @extra_stage 'file://" + destFolderCanonicalPath + "' parallel=8"));
            File downloaded = new File(destFolderCanonicalPathWithSeparator + "bigFile.csv.gz");
            assert (downloaded.exists());
            Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "bigFile.csv.gz");
            p.waitFor();
            File unzipped = new File(destFolderCanonicalPathWithSeparator + "bigFile.csv");
            assert (largeTempFile.length() == unzipped.length());
            assert (FileUtils.contentEquals((File)largeTempFile, (File)unzipped));
        }
        finally {
            statement.execute("DROP STAGE IF EXISTS largefile_stage");
            statement.execute("DROP STAGE IF EXISTS extra_stage");
            statement.execute("DROP TABLE IF EXISTS large_table");
            statement.close();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPutGetLargeFileAzure() throws Throwable {
        Properties paramProperties = new Properties();
        Connection connection = SnowflakeDriverLatestIT.getConnection("azureaccount", paramProperties);
        Statement statement = connection.createStatement();
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
        File largeTempFile = this.tmpFolder.newFile("largeFile.csv");
        BufferedWriter bw = new BufferedWriter(new FileWriter(largeTempFile));
        bw.write("Creating large test file for Azure PUT/GET test");
        bw.write(System.lineSeparator());
        bw.write("Creating large test file for Azure PUT/GET test");
        bw.write(System.lineSeparator());
        bw.close();
        File largeTempFile2 = this.tmpFolder.newFile("largeFile2.csv");
        String sourceFilePath = largeTempFile.getCanonicalPath();
        try {
            for (int i = 0; i < 12; ++i) {
                this.copyContentFrom(largeTempFile, largeTempFile2);
                this.copyContentFrom(largeTempFile2, largeTempFile);
            }
            statement.execute("CREATE OR REPLACE STAGE largefile_stage");
            Assert.assertTrue((String)"Failed to put a file", (boolean)statement.execute("PUT file://" + sourceFilePath + " @largefile_stage"));
            SnowflakeDriverIT.findFile(statement, "ls @largefile_stage/");
            statement.execute("create or replace table large_table (colA string)");
            statement.execute("copy into large_table from @largefile_stage/largeFile.csv.gz");
            statement.execute("create or replace stage extra_stage");
            statement.execute("copy into @extra_stage/bigFile.csv.gz from large_table single=true");
            Assert.assertTrue((String)"Failed to get files", (boolean)statement.execute("GET @extra_stage 'file://" + destFolderCanonicalPath + "' parallel=8"));
            File downloaded = new File(destFolderCanonicalPathWithSeparator + "bigFile.csv.gz");
            assert (downloaded.exists());
            Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "bigFile.csv.gz");
            p.waitFor();
            File unzipped = new File(destFolderCanonicalPathWithSeparator + "bigFile.csv");
            assert (largeTempFile.length() == unzipped.length());
            assert (FileUtils.contentEquals((File)largeTempFile, (File)unzipped));
        }
        finally {
            statement.execute("DROP STAGE IF EXISTS largefile_stage");
            statement.execute("DROP STAGE IF EXISTS extra_stage");
            statement.execute("DROP TABLE IF EXISTS large_table");
            statement.close();
            connection.close();
        }
    }

    private void copyContentFrom(File file1, File file2) throws Exception {
        FileInputStream inputStream = new FileInputStream(file1);
        FileOutputStream outputStream = new FileOutputStream(file2);
        FileChannel fIn = inputStream.getChannel();
        FileChannel fOut = outputStream.getChannel();
        fOut.transferFrom(fIn, 0L, fIn.size());
        fIn.position(0L);
        fOut.transferFrom(fIn, fIn.size(), fIn.size());
        fOut.close();
        fIn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testPutS3RegionalUrl() throws Throwable {
        Connection connection = null;
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        List<String> supportedAccounts = Arrays.asList("s3testaccount", "azureaccount");
        for (String accountName : supportedAccounts) {
            try {
                FileInputStream inputStream;
                connection = SnowflakeDriverLatestIT.getConnection(accountName);
                Statement statement = connection.createStatement();
                statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
                SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
                String putCommand1 = "put file:///dummy/path/file1.gz @" + this.testStageName;
                SnowflakeFileTransferAgent sfAgent1 = new SnowflakeFileTransferAgent(putCommand1, sfSession, new SFStatement(sfSession));
                List metadatas1 = sfAgent1.getFileTransferMetadatas();
                String srcPath1 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv");
                for (SnowflakeFileTransferMetadata oneMetadata : metadatas1) {
                    inputStream = new FileInputStream(srcPath1);
                    SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand1).setUseS3RegionalUrl(false).build());
                }
                for (SnowflakeFileTransferMetadata oneMetadata : metadatas1) {
                    inputStream = new FileInputStream(srcPath1);
                    SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand1).setUseS3RegionalUrl(true).build());
                }
                String putCommand2 = "put file:///dummy/path/file2.gz @" + this.testStageName;
                SnowflakeFileTransferAgent sfAgent2 = new SnowflakeFileTransferAgent(putCommand2, sfSession, new SFStatement(sfSession));
                List metadatas2 = sfAgent2.getFileTransferMetadatas();
                String srcPath2 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_101.csv");
                for (SnowflakeFileTransferMetadata oneMetadata : metadatas2) {
                    String gzfilePath = destFolderCanonicalPath + "/tmp_compress.gz";
                    Process p = Runtime.getRuntime().exec("cp -fr " + srcPath2 + " " + destFolderCanonicalPath + "/tmp_compress");
                    p.waitFor();
                    p = Runtime.getRuntime().exec("gzip " + destFolderCanonicalPath + "/tmp_compress");
                    p.waitFor();
                    FileInputStream gzInputStream = new FileInputStream(gzfilePath);
                    SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)gzInputStream).setRequireCompress(false).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand2).build());
                }
                Assert.assertTrue((String)"Failed to get files", (boolean)statement.execute("GET @" + this.testStageName + " 'file://" + destFolderCanonicalPath + "/' parallel=8"));
                assert (this.isFileContentEqual(srcPath1, false, destFolderCanonicalPath + "/file1.gz", true));
                assert (this.isFileContentEqual(srcPath2, false, destFolderCanonicalPath + "/file2.gz", true));
            }
            finally {
                if (connection == null) continue;
                connection.createStatement().execute("DROP STAGE if exists " + this.testStageName);
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testAzureS3UploadStreamingIngestFileMetadata() throws Throwable {
        Connection connection = null;
        String clientName = "clientName";
        String clientKey = "clientKey";
        List<String> supportedAccounts = Arrays.asList("s3testaccount", "azureaccount");
        for (String accountName : supportedAccounts) {
            try {
                connection = SnowflakeDriverLatestIT.getConnection(accountName);
                Statement statement = connection.createStatement();
                statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
                SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
                String putCommand = "put file:///dummy/path/file1.gz @" + this.testStageName;
                SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
                List metadata = sfAgent.getFileTransferMetadatas();
                String srcPath1 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv");
                for (SnowflakeFileTransferMetadata oneMetadata : metadata) {
                    FileInputStream inputStream = new FileInputStream(srcPath1);
                    SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand).setStreamingIngestClientName(clientName).setStreamingIngestClientKey(clientKey).build());
                    SnowflakeStorageClient client = StorageClientFactory.getFactory().createClient(((SnowflakeFileTransferMetadataV1)oneMetadata).getStageInfo(), 1, null, null);
                    String location = ((SnowflakeFileTransferMetadataV1)oneMetadata).getStageInfo().getLocation();
                    int idx = location.indexOf(47);
                    String remoteStageLocation = location.substring(0, idx);
                    String path = location.substring(idx + 1) + "file1.gz";
                    StorageObjectMetadata meta = client.getObjectMetadata(remoteStageLocation, path);
                    Assert.assertEquals((Object)clientName, (Object)client.getStreamingIngestClientName(meta));
                    Assert.assertEquals((Object)clientKey, (Object)client.getStreamingIngestClientKey(meta));
                }
            }
            finally {
                if (connection == null) continue;
                connection.createStatement().execute("DROP STAGE if exists " + this.testStageName);
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=SnowflakeSQLException.class)
    public void testNoSpaceLeftOnDeviceException() throws SQLException {
        Connection connection = null;
        List<String> supportedAccounts = Arrays.asList("gcpaccount", "s3testaccount", "azureaccount");
        for (String accountName : supportedAccounts) {
            try {
                connection = SnowflakeDriverLatestIT.getConnection(accountName);
                SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
                Statement statement = connection.createStatement();
                SFStatement sfStatement = statement.unwrap(SnowflakeStatementV1.class).getSfStatement();
                statement.execute("CREATE OR REPLACE STAGE testPutGet_stage");
                statement.execute("PUT file://" + SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv") + " @testPutGet_stage");
                String command = "get @testPutGet_stage/orders_100.csv 'file:///tmp'";
                SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(command, sfSession, sfStatement);
                StageInfo info = sfAgent.getStageInfo();
                SnowflakeStorageClient client = StorageClientFactory.getFactory().createClient(info, 1, null, null);
                client.handleStorageException((Exception)new StorageException(client.getMaxRetries(), "No space left on device", (Throwable)new IOException("No space left on device")), client.getMaxRetries(), "download", null, command);
            }
            finally {
                if (connection == null) continue;
                connection.createStatement().execute("DROP STAGE if exists testPutGet_stage");
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testUploadWithGCSPresignedUrlWithoutConnection() throws Throwable {
        Connection connection = null;
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        try {
            Properties paramProperties = new Properties();
            paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)false);
            connection = SnowflakeDriverLatestIT.getConnection("gcpaccount", paramProperties);
            Statement statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String putCommand = "put file:///dummy/path/file1.gz @" + this.testStageName;
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
            List metadata = sfAgent.getFileTransferMetadatas();
            String srcPath = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv");
            for (SnowflakeFileTransferMetadata oneMetadata : metadata) {
                FileInputStream inputStream = new FileInputStream(srcPath);
                assert (oneMetadata.isForOneFile());
                SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).build());
            }
            Assert.assertTrue((String)"Failed to get files", (boolean)statement.execute("GET @" + this.testStageName + " 'file://" + destFolderCanonicalPath + "/' parallel=8"));
            assert (this.isFileContentEqual(srcPath, false, destFolderCanonicalPath + "/file1.gz", true));
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists " + this.testStageName);
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testUploadWithGCSDownscopedCredentialWithoutConnection() throws Throwable {
        Connection connection = null;
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        try {
            String[] fileNames;
            Properties paramProperties = new Properties();
            paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
            connection = SnowflakeDriverLatestIT.getConnection("gcpaccount", paramProperties);
            Statement statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String putCommand = "put file:///dummy/path/file1.gz @" + this.testStageName;
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
            List metadataList = sfAgent.getFileTransferMetadatas();
            assert (metadataList.size() == 1);
            SnowflakeFileTransferMetadata oneMetadata = (SnowflakeFileTransferMetadata)metadataList.get(0);
            assert (!oneMetadata.isForOneFile());
            for (String fileName : fileNames = new String[]{"orders_100.csv", "orders_101.csv"}) {
                String srcPath = SnowflakeDriverLatestIT.getFullPathFileInResource(fileName);
                FileInputStream inputStream = new FileInputStream(srcPath);
                String targetFileName = fileName + ".gz";
                SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setDestFileName(targetFileName).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).build());
                Assert.assertTrue((String)"Failed to get files with down-scoped token", (boolean)statement.execute("GET @" + this.testStageName + " 'file://" + destFolderCanonicalPath + "/'"));
                assert (this.isFileContentEqual(srcPath, false, destFolderCanonicalPath + "/" + targetFileName, true));
                ((InputStream)inputStream).close();
            }
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists " + this.testStageName);
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testHTAPOptimizations() throws SQLException {
        Statement statement;
        Connection con;
        try {
            con = SnowflakeDriverLatestIT.getSnowflakeAdminConnection();
            try {
                statement = con.createStatement();
                try {
                    statement.execute("alter account " + TestUtil.systemGetEnv("SNOWFLAKE_TEST_ACCOUNT") + " set ENABLE_SNOW_654741_FOR_TESTING=true");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
            con = SnowflakeDriverLatestIT.getConnection();
            try {
                SFSession session = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
                Assert.assertTrue((boolean)TestUtil.systemGetEnv("SNOWFLAKE_TEST_SCHEMA").equalsIgnoreCase(con.getSchema()));
                Assert.assertTrue((boolean)TestUtil.systemGetEnv("SNOWFLAKE_TEST_DATABASE").equalsIgnoreCase(con.getCatalog()));
                Assert.assertTrue((boolean)TestUtil.systemGetEnv("SNOWFLAKE_TEST_WAREHOUSE").equalsIgnoreCase(session.getWarehouse()));
                try (Statement statement2 = con.createStatement();){
                    try {
                        statement2.execute("alter session set TIMESTAMP_OUTPUT_FORMAT='YYYY-MM-DD HH24:MI:SS.FFTZH'");
                        statement2.execute("create or replace table testtable1 (cola string, colb int)");
                        statement2.execute("insert into testtable1 values ('row1', 1), ('row2', 2), ('row3', 3)");
                        try (ResultSet rs = statement2.executeQuery("select * from testtable1");){
                            Assert.assertEquals((long)3L, (long)this.getSizeOfResultSet(rs));
                            Assert.assertTrue((boolean)TestUtil.systemGetEnv("SNOWFLAKE_TEST_SCHEMA").equalsIgnoreCase(con.getSchema()));
                            Assert.assertTrue((boolean)TestUtil.systemGetEnv("SNOWFLAKE_TEST_DATABASE").equalsIgnoreCase(con.getCatalog()));
                            Assert.assertTrue((boolean)TestUtil.systemGetEnv("SNOWFLAKE_TEST_WAREHOUSE").equalsIgnoreCase(session.getWarehouse()));
                            Assert.assertEquals((Object)"YYYY-MM-DD HH24:MI:SS.FFTZH", session.getCommonParameters().get("TIMESTAMP_OUTPUT_FORMAT"));
                        }
                    }
                    finally {
                        statement2.execute("alter session unset TIMESTAMP_OUTPUT_FORMAT");
                        statement2.execute("drop table if exists testtable1");
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        finally {
            con = SnowflakeDriverLatestIT.getSnowflakeAdminConnection();
            try {
                statement = con.createStatement();
                try {
                    statement.execute("alter account " + TestUtil.systemGetEnv("SNOWFLAKE_TEST_ACCOUNT") + " unset ENABLE_SNOW_654741_FOR_TESTING");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testHTAPStatementParameterCaching() throws SQLException {
        Statement statement;
        try (Connection con = SnowflakeDriverLatestIT.getSnowflakeAdminConnection();){
            statement = con.createStatement();
            statement.execute("alter account " + TestUtil.systemGetEnv("SNOWFLAKE_TEST_ACCOUNT") + " set ENABLE_SNOW_654741_FOR_TESTING=true");
        }
        con = SnowflakeDriverLatestIT.getConnection();
        statement = con.createStatement();
        statement.execute("create or replace table timetable (t1 time, t2 timestamp, t3 date)");
        statement.execute("insert into timetable values ('13:53:11', '2023-08-17 13:53:33', '2023-08-17')");
        statement.unwrap(SnowflakeStatement.class).setParameter("TIME_OUTPUT_FORMAT", (Object)"HH12:MI:SS.FF AM");
        statement.unwrap(SnowflakeStatement.class).setParameter("DATE_OUTPUT_FORMAT", (Object)"DD-MON-YYYY");
        statement.unwrap(SnowflakeStatement.class).setParameter("TIMESTAMP_OUTPUT_FORMAT", (Object)"YYYY-MM-DD\"T\"HH24:MI:SS");
        ResultSet resultSet = statement.executeQuery("select * from timetable");
        resultSet.next();
        Assert.assertEquals((Object)"01:53:11.000000000 PM", (Object)resultSet.getString(1));
        Assert.assertEquals((Object)"2023-08-17T13:53:33", (Object)resultSet.getString(2));
        Assert.assertEquals((Object)"17-Aug-2023", (Object)resultSet.getString(3));
        statement.unwrap(SnowflakeStatement.class).setParameter("DATE_OUTPUT_FORMAT", (Object)"MM/DD/YYYY");
        resultSet = statement.executeQuery("select * from timetable");
        resultSet.next();
        Assert.assertEquals((Object)"08/17/2023", (Object)resultSet.getString(3));
        statement.execute("drop table if exists timetable");
        statement.close();
        con.close();
        try (Connection con2 = SnowflakeDriverLatestIT.getSnowflakeAdminConnection();){
            statement = con2.createStatement();
            statement.execute("alter account " + TestUtil.systemGetEnv("SNOWFLAKE_TEST_ACCOUNT") + " unset ENABLE_SNOW_654741_FOR_TESTING");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=RunningOnGithubAction.class)
    public void testS3PutInGS() throws Throwable {
        Connection connection = null;
        File destFolder = this.tmpFolder.newFolder();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        try {
            Properties paramProperties = new Properties();
            connection = SnowflakeDriverLatestIT.getConnection("s3testaccount", paramProperties);
            Statement statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
            String fileName = "testFile.json";
            String content = "testName: testS3PutInGs";
            String putSystemCall = String.format("call system$it('PUT_FILE_TO_STAGE', '%s', '%s', '%s', '%s')", this.testStageName, "testFile.json", "testName: testS3PutInGs", "false");
            statement.execute(putSystemCall);
            String getCall = String.format("GET @%s 'file://%s/'", this.testStageName, destFolderCanonicalPath);
            statement.execute(getCall);
            FileInputStream downloadedFileStream = new FileInputStream(destFolderCanonicalPath + "/" + "testFile.json");
            String downloadedFile = IOUtils.toString((InputStream)downloadedFileStream, (Charset)StandardCharsets.UTF_8);
            Assert.assertTrue((String)"downloaded content does not equal uploaded content", (boolean)"testName: testS3PutInGs".equals(downloadedFile));
        }
        finally {
            if (connection != null) {
                connection.createStatement().execute("DROP STAGE if exists " + this.testStageName);
                connection.close();
            }
        }
    }
}

