/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TimeZone;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeTimestampWithTimezone;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SnowflakeTimestampWithTimezoneTest
extends BaseJDBCTest {
    private static TimeZone orgTimeZone;
    private final String timeZone;
    private final String inputTimestamp;
    private final String outputTimestamp;

    public SnowflakeTimestampWithTimezoneTest(String timeZone, String inputTimestamp, String outputTimestamp) {
        this.timeZone = timeZone;
        this.inputTimestamp = inputTimestamp;
        this.outputTimestamp = outputTimestamp;
    }

    @Parameterized.Parameters(name="tz={0}, input={1}, output={2}")
    public static Collection convert() {
        String[] timeZoneList = new String[]{"PST", "America/New_York", "UTC", "Asia/Singapore"};
        String[] dateTimeList = new String[]{"2018-03-11 01:10:34.0123456", "2018-03-11 02:10:34.0123456", "2018-03-11 03:10:34.0123456", "2018-11-04 01:10:34.123", "2018-11-04 02:10:34.123", "2018-11-04 03:10:34.123", "2020-03-11 01:10:34.456", "2020-03-11 02:10:34.456", "2020-03-11 03:10:34.456", "2020-11-01 01:10:34.123", "2020-11-01 02:10:34.123", "2020-11-01 03:10:34.123"};
        ArrayList<Object[]> testCases = new ArrayList<Object[]>();
        for (String timeZone : timeZoneList) {
            for (String dateTime : dateTimeList) {
                testCases.add(new Object[]{timeZone, dateTime, dateTime});
            }
        }
        return testCases;
    }

    @BeforeClass
    public static void keepOriginalTimeZone() {
        orgTimeZone = TimeZone.getDefault();
    }

    @AfterClass
    public static void restoreTimeZone() {
        TimeZone.setDefault(orgTimeZone);
    }

    @Test
    public void testTimestampNTZ() throws Throwable {
        TimeZone.setDefault(TimeZone.getTimeZone(this.timeZone));
        LocalDateTime dt = this.parseTimestampNTZ(this.inputTimestamp);
        SnowflakeTimestampWithTimezone stn = new SnowflakeTimestampWithTimezone(dt.toEpochSecond(ZoneOffset.UTC) * 1000L, dt.getNano(), TimeZone.getTimeZone("UTC"));
        Assert.assertEquals((Object)this.outputTimestamp, (Object)stn.toString());
    }

    @Test
    public void testGetTimezone() {
        String timezone = "Australia/Sydney";
        Long datetime = System.currentTimeMillis();
        Timestamp currentTimestamp = new Timestamp(datetime);
        SnowflakeTimestampWithTimezone ts = new SnowflakeTimestampWithTimezone(currentTimestamp, TimeZone.getTimeZone(timezone));
        Assert.assertEquals((Object)ts.getTimezone().getID(), (Object)timezone);
    }

    @Test
    public void testToZonedDateTime() {
        String timezone = "Australia/Sydney";
        String zonedDateTime = "2022-03-17T10:10:08+11:00[Australia/Sydney]";
        Long datetime = 1647472208000L;
        Timestamp timestamp = new Timestamp(datetime);
        SnowflakeTimestampWithTimezone ts = new SnowflakeTimestampWithTimezone(timestamp, TimeZone.getTimeZone(timezone));
        ZonedDateTime zd = ts.toZonedDateTime();
        Assert.assertEquals((Object)zd.toString(), (Object)zonedDateTime);
    }
}

