/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.node.ObjectNode;
import net.minidev.json.JSONObject;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import org.junit.Assert;
import org.junit.Test;

public class SqlFeatureNotSupportedTelemetryTest {
    String queryId = "test-query-idfake";
    String SQLState = "00000";
    int vendorCode = 27;
    String driverVersion = SnowflakeDriver.implementVersion;
    String comparison = "{\"type\":\"client_sql_exception\",\"DriverType\":\"JDBC\",\"DriverVersion\":\"" + this.driverVersion + "\",\"QueryID\":\"" + this.queryId + "\",\"SQLState\":\"" + this.SQLState + "\",\"ErrorNumber\":" + this.vendorCode + "}";

    @Test
    public void testCreateIBValue() {
        ObjectNode ibValue = SnowflakeSQLLoggedException.createIBValue((String)this.queryId, (String)this.SQLState, (int)this.vendorCode);
        Assert.assertEquals((Object)this.comparison, (Object)ibValue.toString());
    }

    @Test
    public void testCreateOOBValue() {
        JSONObject oobValue = SnowflakeSQLLoggedException.createOOBValue((String)this.queryId, (String)this.SQLState, (int)this.vendorCode);
        Assert.assertEquals((Object)"client_sql_exception", (Object)oobValue.get((Object)"type").toString());
        Assert.assertEquals((Object)"JDBC", (Object)oobValue.get((Object)"DriverType").toString());
        Assert.assertEquals((Object)this.driverVersion, (Object)oobValue.get((Object)"DriverVersion").toString());
        Assert.assertEquals((Object)this.queryId, (Object)oobValue.get((Object)"QueryID").toString());
        Assert.assertEquals((Object)this.SQLState, (Object)oobValue.get((Object)"SQLState").toString());
        Assert.assertEquals((Object)this.vendorCode, (Object)oobValue.get((Object)"ErrorNumber"));
    }

    @Test
    public void testMaskStacktrace() {
        String snowflakeSQLStacktrace = "net.snowflake.client.jdbc.SnowflakeSQLLoggedException: This is a test exception.\n\tat net.snowflake.client.jdbc.telemetryOOB.TelemetryServiceIT.generateDummyException(TelemetryServiceIT.java:211)\n";
        String maskedSnowflakeSQLStacktrace = "net.snowflake.client.jdbc.SnowflakeSQLLoggedException\n\tat net.snowflake.client.jdbc.telemetryOOB.TelemetryServiceIT.generateDummyException(TelemetryServiceIT.java:211)\n";
        String multipleLineReasonMessage = "net.snowflake.client.jdbc.SnowflakeSQLException: Error parsing JSON: {\"dsadas\nadsa\":12311}\n  File 'VvCSoHWHrB/0.CSV.gz', line 1, character 0\n  Row 1, column \"SPARK_TEST_TABLE_8417843441957284451\"[\"VAR\":1]\n  If you would like to continue loading when an error is encountered, use other values such as 'SKIP_FILE' or 'CONTINUE' for the ON_ERROR option. For more information on loading options, please run 'info loading_data' in a SQL client.\n\tat net.snowflake.client.jdbc.SnowflakeUtil.checkErrorAndThrowExceptionSub(SnowflakeUtil.java:124)\n";
        String maskedMultipleLineReasonMessage = "net.snowflake.client.jdbc.SnowflakeSQLException\n\tat net.snowflake.client.jdbc.SnowflakeUtil.checkErrorAndThrowExceptionSub(SnowflakeUtil.java:124)\n";
        Assert.assertEquals((Object)maskedSnowflakeSQLStacktrace, (Object)SnowflakeSQLLoggedException.maskStacktrace((String)snowflakeSQLStacktrace));
        String featureNotSupportedStacktrace = "net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException: Not supported!\n\tat net.snowflake.client.jdbc.SnowflakeStatementV1.execute(SnowflakeStatementV1.java:344)\n";
        String maskedFeatureNotSupportedStacktrace = "net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException\n\tat net.snowflake.client.jdbc.SnowflakeStatementV1.execute(SnowflakeStatementV1.java:344)\n";
        Assert.assertEquals((Object)maskedFeatureNotSupportedStacktrace, (Object)SnowflakeSQLLoggedException.maskStacktrace((String)featureNotSupportedStacktrace));
        Assert.assertEquals((Object)maskedMultipleLineReasonMessage, (Object)SnowflakeSQLLoggedException.maskStacktrace((String)multipleLineReasonMessage));
    }
}

