/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.Statement;
import net.snowflake.client.category.TestCategoryStatement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={TestCategoryStatement.class})
public class StatementAlreadyClosedIT
extends BaseJDBCTest {
    @Test
    public void testStatementAlreadyClosed() throws Throwable {
        try (Connection connection = StatementAlreadyClosedIT.getConnection();){
            Statement statement = connection.createStatement();
            Assert.assertFalse((boolean)statement.isClosed());
            statement.close();
            Assert.assertTrue((boolean)statement.isClosed());
            this.expectStatementAlreadyClosedException(() -> statement.execute("select 1", 2));
            this.expectStatementAlreadyClosedException(statement::executeBatch);
            this.expectStatementAlreadyClosedException(() -> statement.executeQuery("select 1"));
            this.expectStatementAlreadyClosedException(() -> statement.executeUpdate("update t set c1=1"));
            this.expectStatementAlreadyClosedException(() -> statement.execute("update t set c1=1"));
            this.expectStatementAlreadyClosedException(statement::getConnection);
            this.expectStatementAlreadyClosedException(statement::getFetchDirection);
            this.expectStatementAlreadyClosedException(statement::getFetchSize);
            this.expectStatementAlreadyClosedException(statement::getMoreResults);
            this.expectStatementAlreadyClosedException(() -> statement.getMoreResults(0));
            this.expectStatementAlreadyClosedException(statement::getQueryTimeout);
            this.expectStatementAlreadyClosedException(statement::getResultSet);
            this.expectStatementAlreadyClosedException(statement::getResultSetConcurrency);
            this.expectStatementAlreadyClosedException(statement::getResultSetHoldability);
            this.expectStatementAlreadyClosedException(statement::getResultSetType);
            this.expectStatementAlreadyClosedException(statement::getUpdateCount);
            this.expectStatementAlreadyClosedException(statement::getWarnings);
            this.expectStatementAlreadyClosedException(() -> statement.setEscapeProcessing(true));
            this.expectStatementAlreadyClosedException(() -> statement.setFetchDirection(1000));
            this.expectStatementAlreadyClosedException(() -> statement.setFetchSize(10));
            this.expectStatementAlreadyClosedException(() -> statement.setMaxRows(10));
            this.expectStatementAlreadyClosedException(statement::isPoolable);
            this.expectStatementAlreadyClosedException(() -> statement.setPoolable(false));
            this.expectStatementAlreadyClosedException(() -> statement.setQueryTimeout(10));
            this.expectStatementAlreadyClosedException(statement::cancel);
            this.expectStatementAlreadyClosedException(statement::clearWarnings);
            this.expectStatementAlreadyClosedException(() -> statement.addBatch("select 2"));
            this.expectStatementAlreadyClosedException(statement::clearBatch);
        }
    }
}

